/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui;

import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import serpro.ppgd.gui.ConstantesGlobaisGUI;
import serpro.ppgd.gui.EditCampo;
import serpro.ppgd.gui.FabricaGUI;
import serpro.ppgd.negocio.Informacao;

public class ContainerPPGD
extends Box {
    public static final byte NONE = 0;
    public static final byte ESQUERDA = 1;
    public static final byte ACIMA = 2;
    private float alinhamento;
    private int eixo;
    private byte posicaoRotulo;

    public ContainerPPGD() {
        super(1);
        this.eixo = 1;
        this.alinhamento = 0.0f;
        this.posicaoRotulo = 1;
    }

    public ContainerPPGD(int eixo, float alinhamento, byte posicaoRotulo) {
        super(eixo);
        this.eixo = eixo;
        this.alinhamento = alinhamento;
        if (posicaoRotulo < 0 || posicaoRotulo > 2) {
            throw new IllegalArgumentException("Posi\u00e7\u00e3o do r\u00f3tulo inv\u00e1lida");
        }
        this.posicaoRotulo = posicaoRotulo;
    }

    public void addTitulo(String titulo, float alinhamentoTitulo) {
        JLabel labelTitulo = new JLabel(titulo);
        labelTitulo.setText(titulo);
        this.configuraAlinhamento(labelTitulo, alinhamentoTitulo);
        this.add(labelTitulo);
    }

    public EditCampo addCampo(EditCampo editCampo) {
        return this.addCampo(editCampo, null);
    }

    public EditCampo addCampo(EditCampo editCampo, String idAjuda) {
        editCampo.setIdAjuda(idAjuda);
        this.adicionaCampo(editCampo);
        return editCampo;
    }

    public EditCampo addCampo(Informacao campo) {
        return this.addCampo(campo, (String)null);
    }

    public EditCampo addCampo(Informacao campo, String idAjuda) {
        Dimension[] d = new Dimension[]{new Dimension(0, 0)};
        return this.addCampo(campo, d, idAjuda);
    }

    public EditCampo addCampo(Informacao campo, int tamanho) {
        return this.addCampo(campo, tamanho, null);
    }

    public EditCampo addCampo(Informacao campo, int tamanho, String idAjuda) {
        Dimension[] d = new Dimension[]{new Dimension(tamanho, 0)};
        return this.addCampo(campo, d, idAjuda);
    }

    public EditCampo addCampo(Informacao campo, Dimension dimension, String idAjuda) {
        Dimension[] d = new Dimension[]{dimension};
        return this.addCampo(campo, d, idAjuda);
    }

    public EditCampo addCampo(Informacao campo, Dimension[] dimension) {
        return this.addCampo(campo, dimension, null);
    }

    public EditCampo addCampo(Informacao campo, Dimension[] dimension, String idAjuda) {
        EditCampo editCampo = FabricaGUI.getEditorInformacao(campo, dimension, idAjuda);
        this.adicionaCampo(editCampo);
        return editCampo;
    }

    private void adicionaCampo(EditCampo editCampo) {
        this.configuraAlinhamento(this, this.alinhamento);
        JComponent boxCampo = FabricaGUI.criaJCampo(editCampo);
        this.configuraAlinhamento(boxCampo, this.alinhamento);
        if (this.eixo == 1) {
            switch (this.posicaoRotulo) {
                case 2: {
                    this.add(Box.createRigidArea(ConstantesGlobaisGUI.VGAP5));
                    this.configuraAlinhamento(editCampo.getRotulo(), this.alinhamento);
                    this.add(editCampo.getRotulo());
                    this.add(boxCampo);
                    break;
                }
                case 1: {
                    this.add(Box.createRigidArea(ConstantesGlobaisGUI.VGAP5));
                    ContainerPPGD boxLabelCampo = new ContainerPPGD(0, 0.0f, 0);
                    boxLabelCampo.configuraAlinhamento(editCampo.getRotulo(), 0.5f);
                    this.configuraAlinhamento(boxLabelCampo, 0.0f);
                    boxLabelCampo.add(Box.createRigidArea(ConstantesGlobaisGUI.HGAP5));
                    boxLabelCampo.add(editCampo.getRotulo());
                    boxLabelCampo.add(Box.createRigidArea(ConstantesGlobaisGUI.HGAP5));
                    boxLabelCampo.add(boxCampo);
                    this.add(boxLabelCampo);
                    break;
                }
                default: {
                    this.add(Box.createRigidArea(ConstantesGlobaisGUI.VGAP5));
                    this.add(boxCampo);
                    break;
                }
            }
        } else if (this.eixo == 0) {
            switch (this.posicaoRotulo) {
                case 2: {
                    ContainerPPGD boxLabelCampo = new ContainerPPGD(1, 0.0f, 2);
                    boxLabelCampo.configuraAlinhamento(editCampo.getRotulo(), this.alinhamento);
                    boxLabelCampo.configuraAlinhamento(boxCampo, this.alinhamento);
                    boxLabelCampo.add(editCampo.getRotulo());
                    boxLabelCampo.add(boxCampo);
                    this.add(boxLabelCampo);
                    this.add(Box.createRigidArea(ConstantesGlobaisGUI.HGAP10));
                    break;
                }
                case 1: {
                    this.configuraAlinhamento(editCampo.getRotulo(), this.alinhamento);
                    this.configuraAlinhamento(boxCampo, this.alinhamento);
                    this.add(editCampo.getRotulo());
                    this.add(boxCampo);
                    this.add(Box.createRigidArea(ConstantesGlobaisGUI.HGAP10));
                    break;
                }
                default: {
                    this.add(boxCampo);
                }
            }
        }
    }

    public void addBox(ContainerPPGD box) {
        this.configuraAlinhamento(box, this.alinhamento);
        this.add(Box.createRigidArea(ConstantesGlobaisGUI.VGAP5));
        this.add(box);
    }

    private void configuraAlinhamento(JComponent componente, float alinhamento) {
        if (this.eixo == 1) {
            componente.setAlignmentX(alinhamento);
            componente.setAlignmentY(0.5f);
        } else if (this.eixo == 0) {
            componente.setAlignmentX(0.5f);
            componente.setAlignmentY(alinhamento);
        }
    }
}

