/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import net.sf.jasperreports.charts.JRAreaPlot;
import net.sf.jasperreports.charts.JRBar3DPlot;
import net.sf.jasperreports.charts.JRBarPlot;
import net.sf.jasperreports.charts.JRBubblePlot;
import net.sf.jasperreports.charts.JRCandlestickPlot;
import net.sf.jasperreports.charts.JRCategoryDataset;
import net.sf.jasperreports.charts.JRDataRange;
import net.sf.jasperreports.charts.JRHighLowDataset;
import net.sf.jasperreports.charts.JRHighLowPlot;
import net.sf.jasperreports.charts.JRLinePlot;
import net.sf.jasperreports.charts.JRMeterPlot;
import net.sf.jasperreports.charts.JRMultiAxisPlot;
import net.sf.jasperreports.charts.JRPie3DPlot;
import net.sf.jasperreports.charts.JRPieDataset;
import net.sf.jasperreports.charts.JRPiePlot;
import net.sf.jasperreports.charts.JRScatterPlot;
import net.sf.jasperreports.charts.JRThermometerPlot;
import net.sf.jasperreports.charts.JRTimePeriodDataset;
import net.sf.jasperreports.charts.JRTimeSeriesDataset;
import net.sf.jasperreports.charts.JRTimeSeriesPlot;
import net.sf.jasperreports.charts.JRValueDataset;
import net.sf.jasperreports.charts.JRValueDisplay;
import net.sf.jasperreports.charts.JRXyDataset;
import net.sf.jasperreports.charts.JRXyzDataset;
import net.sf.jasperreports.charts.fill.JRFillAreaPlot;
import net.sf.jasperreports.charts.fill.JRFillBar3DPlot;
import net.sf.jasperreports.charts.fill.JRFillBarPlot;
import net.sf.jasperreports.charts.fill.JRFillCategoryDataset;
import net.sf.jasperreports.charts.fill.JRFillChartAxis;
import net.sf.jasperreports.charts.fill.JRFillHighLowDataset;
import net.sf.jasperreports.charts.fill.JRFillLinePlot;
import net.sf.jasperreports.charts.fill.JRFillMeterPlot;
import net.sf.jasperreports.charts.fill.JRFillMultiAxisPlot;
import net.sf.jasperreports.charts.fill.JRFillPie3DPlot;
import net.sf.jasperreports.charts.fill.JRFillPieDataset;
import net.sf.jasperreports.charts.fill.JRFillPiePlot;
import net.sf.jasperreports.charts.fill.JRFillThermometerPlot;
import net.sf.jasperreports.charts.fill.JRFillTimePeriodDataset;
import net.sf.jasperreports.charts.fill.JRFillTimeSeriesDataset;
import net.sf.jasperreports.charts.fill.JRFillXyDataset;
import net.sf.jasperreports.charts.fill.JRFillXyzDataset;
import net.sf.jasperreports.charts.util.JRMeterInterval;
import net.sf.jasperreports.charts.util.PieLabelGenerator;
import net.sf.jasperreports.engine.JRAbstractChartCustomizer;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartCustomizer;
import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameters;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillChartDataset;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneable;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillHyperlinkHelper;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRTemplateImage;
import net.sf.jasperreports.engine.fill.JRTemplatePrintImage;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRFontUtil;
import net.sf.jasperreports.engine.util.JRPenUtil;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.util.LineBoxWrapper;
import net.sf.jasperreports.renderers.JFreeChartRenderer;
import net.sf.jasperreports.renderers.JRCategoryChartImageMapRenderer;
import net.sf.jasperreports.renderers.JRHighLowChartImageMapRenderer;
import net.sf.jasperreports.renderers.JRPieChartImageMapRenderer;
import net.sf.jasperreports.renderers.JRTimePeriodChartImageMapRenderer;
import net.sf.jasperreports.renderers.JRTimeSeriesChartImageMapRenderer;
import net.sf.jasperreports.renderers.JRXYChartImageMapRenderer;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DialShape;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.MeterInterval;
import org.jfree.chart.plot.MeterPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ThermometerPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer3D;
import org.jfree.chart.renderer.xy.CandlestickRenderer;
import org.jfree.chart.renderer.xy.HighLowRenderer;
import org.jfree.chart.renderer.xy.XYBubbleRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.general.ValueDataset;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.DefaultHighLowDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.OHLCDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYZDataset;
import org.jfree.ui.RectangleEdge;

public class JRFillChart
extends JRFillElement
implements JRChart {
    private static final Color TRANSPARENT_PAINT = new Color(0, 0, 0, 0);
    protected byte chartType = 0;
    protected JRFont titleFont = null;
    protected JRFont subtitleFont = null;
    protected JRFont legendFont = null;
    protected JRGroup evaluationGroup = null;
    protected JRFillChartDataset dataset = null;
    protected JRChartPlot plot = null;
    protected JRRenderable renderer = null;
    private String anchorName = null;
    private String hyperlinkReference = null;
    private String hyperlinkAnchor = null;
    private Integer hyperlinkPage = null;
    private String hyperlinkTooltip;
    private JRPrintHyperlinkParameters hyperlinkParameters;
    protected String customizerClass;
    protected JRChartCustomizer chartCustomizer;

    protected JRFillChart(JRBaseFiller filler, JRChart chart, JRFillObjectFactory factory) {
        super(filler, chart, factory);
        this.chartType = chart.getChartType();
        switch (this.chartType) {
            case 1: {
                this.dataset = (JRFillChartDataset)((Object)factory.getCategoryDataset((JRCategoryDataset)chart.getDataset()));
                this.plot = factory.getAreaPlot((JRAreaPlot)chart.getPlot());
                break;
            }
            case 3: {
                this.dataset = (JRFillChartDataset)((Object)factory.getCategoryDataset((JRCategoryDataset)chart.getDataset()));
                this.plot = factory.getBarPlot((JRBarPlot)chart.getPlot());
                break;
            }
            case 2: {
                this.dataset = (JRFillChartDataset)((Object)factory.getCategoryDataset((JRCategoryDataset)chart.getDataset()));
                this.plot = factory.getBar3DPlot((JRBar3DPlot)chart.getPlot());
                break;
            }
            case 4: {
                this.dataset = (JRFillChartDataset)((Object)factory.getXyzDataset((JRXyzDataset)chart.getDataset()));
                this.plot = factory.getBubblePlot((JRBubblePlot)chart.getPlot());
                break;
            }
            case 5: {
                this.dataset = (JRFillChartDataset)((Object)factory.getHighLowDataset((JRHighLowDataset)chart.getDataset()));
                this.plot = factory.getCandlestickPlot((JRCandlestickPlot)chart.getPlot());
                break;
            }
            case 6: {
                this.dataset = (JRFillChartDataset)((Object)factory.getHighLowDataset((JRHighLowDataset)chart.getDataset()));
                this.plot = factory.getHighLowPlot((JRHighLowPlot)chart.getPlot());
                break;
            }
            case 7: {
                this.dataset = (JRFillChartDataset)((Object)factory.getCategoryDataset((JRCategoryDataset)chart.getDataset()));
                this.plot = factory.getLinePlot((JRLinePlot)chart.getPlot());
                break;
            }
            case 17: {
                this.dataset = (JRFillChartDataset)((Object)factory.getValueDataset((JRValueDataset)chart.getDataset()));
                this.plot = factory.getMeterPlot((JRMeterPlot)chart.getPlot());
                break;
            }
            case 19: {
                this.plot = factory.getMultiAxisPlot((JRMultiAxisPlot)chart.getPlot());
                this.dataset = ((JRFillMultiAxisPlot)this.plot).getMainDataset();
                break;
            }
            case 9: {
                this.dataset = (JRFillChartDataset)((Object)factory.getPieDataset((JRPieDataset)chart.getDataset()));
                this.plot = factory.getPiePlot((JRPiePlot)chart.getPlot());
                break;
            }
            case 8: {
                this.dataset = (JRFillChartDataset)((Object)factory.getPieDataset((JRPieDataset)chart.getDataset()));
                this.plot = factory.getPie3DPlot((JRPie3DPlot)chart.getPlot());
                break;
            }
            case 10: {
                this.dataset = (JRFillChartDataset)((Object)factory.getXyDataset((JRXyDataset)chart.getDataset()));
                this.plot = factory.getScatterPlot((JRScatterPlot)chart.getPlot());
                break;
            }
            case 12: {
                this.dataset = (JRFillChartDataset)((Object)factory.getCategoryDataset((JRCategoryDataset)chart.getDataset()));
                this.plot = factory.getBarPlot((JRBarPlot)chart.getPlot());
                break;
            }
            case 11: {
                this.dataset = (JRFillChartDataset)((Object)factory.getCategoryDataset((JRCategoryDataset)chart.getDataset()));
                this.plot = factory.getBar3DPlot((JRBar3DPlot)chart.getPlot());
                break;
            }
            case 18: {
                this.dataset = (JRFillChartDataset)((Object)factory.getValueDataset((JRValueDataset)chart.getDataset()));
                this.plot = factory.getThermometerPlot((JRThermometerPlot)chart.getPlot());
                break;
            }
            case 16: {
                this.dataset = (JRFillChartDataset)((Object)factory.getTimeSeriesDataset((JRTimeSeriesDataset)chart.getDataset()));
                this.plot = factory.getTimeSeriesPlot((JRTimeSeriesPlot)chart.getPlot());
                break;
            }
            case 13: {
                this.dataset = (JRFillChartDataset)((Object)factory.getXyDataset((JRXyDataset)chart.getDataset()));
                this.plot = factory.getAreaPlot((JRAreaPlot)chart.getPlot());
                break;
            }
            case 14: {
                switch (chart.getDataset().getDatasetType()) {
                    case 6: {
                        this.dataset = (JRFillChartDataset)((Object)factory.getTimeSeriesDataset((JRTimeSeriesDataset)chart.getDataset()));
                        break;
                    }
                    case 5: {
                        this.dataset = (JRFillChartDataset)((Object)factory.getTimePeriodDataset((JRTimePeriodDataset)chart.getDataset()));
                        break;
                    }
                    case 3: {
                        this.dataset = (JRFillChartDataset)((Object)factory.getXyDataset((JRXyDataset)chart.getDataset()));
                    }
                }
                this.plot = factory.getBarPlot((JRBarPlot)chart.getPlot());
                break;
            }
            case 15: {
                this.dataset = (JRFillChartDataset)((Object)factory.getXyDataset((JRXyDataset)chart.getDataset()));
                this.plot = factory.getLinePlot((JRLinePlot)chart.getPlot());
                break;
            }
            case 20: {
                this.dataset = (JRFillChartDataset)((Object)factory.getCategoryDataset((JRCategoryDataset)chart.getDataset()));
                this.plot = factory.getAreaPlot((JRAreaPlot)chart.getPlot());
                break;
            }
            default: {
                throw new JRRuntimeException("Chart type not supported.");
            }
        }
        this.titleFont = new JRBaseFont(null, null, chart, chart.getTitleFont());
        this.subtitleFont = new JRBaseFont(null, null, chart, chart.getSubtitleFont());
        this.legendFont = new JRBaseFont(null, null, chart, chart.getLegendFont());
        this.evaluationGroup = factory.getGroup(chart.getEvaluationGroup());
        this.customizerClass = chart.getCustomizerClass();
        if (this.customizerClass != null && this.customizerClass.length() > 0) {
            try {
                Class myClass = JRClassLoader.loadClassForName(this.customizerClass);
                this.chartCustomizer = (JRChartCustomizer)myClass.newInstance();
            }
            catch (Exception e) {
                throw new JRRuntimeException("Could not create chart customizer instance.", e);
            }
            if (this.chartCustomizer instanceof JRAbstractChartCustomizer) {
                ((JRAbstractChartCustomizer)this.chartCustomizer).init(filler, this);
            }
        }
    }

    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)2);
    }

    public boolean isShowLegend() {
        return ((JRChart)this.parent).isShowLegend();
    }

    public void setShowLegend(boolean isShowLegend) {
    }

    public byte getEvaluationTime() {
        return ((JRChart)this.parent).getEvaluationTime();
    }

    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    public JRBox getBox() {
        return new LineBoxWrapper(this.getLineBox());
    }

    public JRLineBox getLineBox() {
        return ((JRBoxContainer)((Object)this.parent)).getLineBox();
    }

    public byte getBorder() {
        return JRPenUtil.getPenFromLinePen(this.getLineBox().getPen());
    }

    public Byte getOwnBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.getLineBox().getPen());
    }

    public void setBorder(byte border) {
        JRPenUtil.setLinePenFromPen(border, (JRPen)this.getLineBox().getPen());
    }

    public void setBorder(Byte border) {
        JRPenUtil.setLinePenFromPen(border, (JRPen)this.getLineBox().getPen());
    }

    public Color getBorderColor() {
        return this.getLineBox().getPen().getLineColor();
    }

    public Color getOwnBorderColor() {
        return this.getLineBox().getPen().getOwnLineColor();
    }

    public void setBorderColor(Color borderColor) {
        this.getLineBox().getPen().setLineColor(borderColor);
    }

    public int getPadding() {
        return this.getLineBox().getPadding();
    }

    public Integer getOwnPadding() {
        return this.getLineBox().getOwnPadding();
    }

    public void setPadding(int padding) {
        this.getLineBox().setPadding(padding);
    }

    public void setPadding(Integer padding) {
        this.getLineBox().setPadding(padding);
    }

    public byte getTopBorder() {
        return JRPenUtil.getPenFromLinePen(this.getLineBox().getTopPen());
    }

    public Byte getOwnTopBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.getLineBox().getTopPen());
    }

    public void setTopBorder(byte topBorder) {
        JRPenUtil.setLinePenFromPen(topBorder, (JRPen)this.getLineBox().getTopPen());
    }

    public void setTopBorder(Byte topBorder) {
        JRPenUtil.setLinePenFromPen(topBorder, (JRPen)this.getLineBox().getTopPen());
    }

    public Color getTopBorderColor() {
        return this.getLineBox().getTopPen().getLineColor();
    }

    public Color getOwnTopBorderColor() {
        return this.getLineBox().getTopPen().getOwnLineColor();
    }

    public void setTopBorderColor(Color topBorderColor) {
        this.getLineBox().getTopPen().setLineColor(topBorderColor);
    }

    public int getTopPadding() {
        return this.getLineBox().getTopPadding();
    }

    public Integer getOwnTopPadding() {
        return this.getLineBox().getOwnTopPadding();
    }

    public void setTopPadding(int topPadding) {
        this.getLineBox().setTopPadding(topPadding);
    }

    public void setTopPadding(Integer topPadding) {
        this.getLineBox().setTopPadding(topPadding);
    }

    public byte getLeftBorder() {
        return JRPenUtil.getPenFromLinePen(this.getLineBox().getLeftPen());
    }

    public Byte getOwnLeftBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.getLineBox().getLeftPen());
    }

    public void setLeftBorder(byte leftBorder) {
        JRPenUtil.setLinePenFromPen(leftBorder, (JRPen)this.getLineBox().getLeftPen());
    }

    public void setLeftBorder(Byte leftBorder) {
        JRPenUtil.setLinePenFromPen(leftBorder, (JRPen)this.getLineBox().getLeftPen());
    }

    public Color getLeftBorderColor() {
        return this.getLineBox().getLeftPen().getLineColor();
    }

    public Color getOwnLeftBorderColor() {
        return this.getLineBox().getLeftPen().getOwnLineColor();
    }

    public void setLeftBorderColor(Color leftBorderColor) {
        this.getLineBox().getLeftPen().setLineColor(leftBorderColor);
    }

    public int getLeftPadding() {
        return this.getLineBox().getLeftPadding();
    }

    public Integer getOwnLeftPadding() {
        return this.getLineBox().getOwnLeftPadding();
    }

    public void setLeftPadding(int leftPadding) {
        this.getLineBox().setLeftPadding(leftPadding);
    }

    public void setLeftPadding(Integer leftPadding) {
        this.getLineBox().setLeftPadding(leftPadding);
    }

    public byte getBottomBorder() {
        return JRPenUtil.getPenFromLinePen(this.getLineBox().getBottomPen());
    }

    public Byte getOwnBottomBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.getLineBox().getBottomPen());
    }

    public void setBottomBorder(byte bottomBorder) {
        JRPenUtil.setLinePenFromPen(bottomBorder, (JRPen)this.getLineBox().getBottomPen());
    }

    public void setBottomBorder(Byte bottomBorder) {
        JRPenUtil.setLinePenFromPen(bottomBorder, (JRPen)this.getLineBox().getBottomPen());
    }

    public Color getBottomBorderColor() {
        return this.getLineBox().getBottomPen().getLineColor();
    }

    public Color getOwnBottomBorderColor() {
        return this.getLineBox().getBottomPen().getOwnLineColor();
    }

    public void setBottomBorderColor(Color bottomBorderColor) {
        this.getLineBox().getBottomPen().setLineColor(bottomBorderColor);
    }

    public int getBottomPadding() {
        return this.getLineBox().getBottomPadding();
    }

    public Integer getOwnBottomPadding() {
        return this.getLineBox().getOwnBottomPadding();
    }

    public void setBottomPadding(int bottomPadding) {
        this.getLineBox().setBottomPadding(bottomPadding);
    }

    public void setBottomPadding(Integer bottomPadding) {
        this.getLineBox().setBottomPadding(bottomPadding);
    }

    public byte getRightBorder() {
        return JRPenUtil.getPenFromLinePen(this.getLineBox().getRightPen());
    }

    public Byte getOwnRightBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.getLineBox().getRightPen());
    }

    public void setRightBorder(byte rightBorder) {
        JRPenUtil.setLinePenFromPen(rightBorder, (JRPen)this.getLineBox().getRightPen());
    }

    public void setRightBorder(Byte rightBorder) {
        JRPenUtil.setLinePenFromPen(rightBorder, (JRPen)this.getLineBox().getRightPen());
    }

    public Color getRightBorderColor() {
        return this.getLineBox().getRightPen().getLineColor();
    }

    public Color getOwnRightBorderColor() {
        return this.getLineBox().getRightPen().getOwnLineColor();
    }

    public void setRightBorderColor(Color rightBorderColor) {
        this.getLineBox().getRightPen().setLineColor(rightBorderColor);
    }

    public int getRightPadding() {
        return this.getLineBox().getRightPadding();
    }

    public Integer getOwnRightPadding() {
        return this.getLineBox().getOwnRightPadding();
    }

    public void setRightPadding(int rightPadding) {
        this.getLineBox().setRightPadding(rightPadding);
    }

    public void setRightPadding(Integer rightPadding) {
        this.getLineBox().setRightPadding(rightPadding);
    }

    public JRFont getTitleFont() {
        return this.titleFont;
    }

    public byte getTitlePosition() {
        return ((JRChart)this.parent).getTitlePosition();
    }

    public void setTitlePosition(byte titlePosition) {
    }

    public Color getTitleColor() {
        return JRStyleResolver.getTitleColor(this);
    }

    public Color getOwnTitleColor() {
        return ((JRChart)this.parent).getOwnTitleColor();
    }

    public void setTitleColor(Color titleColor) {
    }

    public JRFont getSubtitleFont() {
        return this.subtitleFont;
    }

    public Color getOwnSubtitleColor() {
        return ((JRChart)this.parent).getOwnSubtitleColor();
    }

    public Color getSubtitleColor() {
        return JRStyleResolver.getSubtitleColor(this);
    }

    public void setSubtitleColor(Color subtitleColor) {
    }

    public Color getOwnLegendColor() {
        return ((JRChart)this.parent).getOwnLegendColor();
    }

    public Color getLegendColor() {
        return JRStyleResolver.getLegendColor(this);
    }

    public void setLegendColor(Color legendColor) {
    }

    public Color getOwnLegendBackgroundColor() {
        return ((JRChart)this.parent).getOwnLegendBackgroundColor();
    }

    public Color getLegendBackgroundColor() {
        return JRStyleResolver.getLegendBackgroundColor(this);
    }

    public void setLegendBackgroundColor(Color legendBackgroundColor) {
    }

    public JRFont getLegendFont() {
        return this.legendFont;
    }

    public byte getLegendPosition() {
        return ((JRChart)this.parent).getLegendPosition();
    }

    public void setLegendPosition(byte legendPosition) {
    }

    public JRExpression getTitleExpression() {
        return ((JRChart)this.parent).getTitleExpression();
    }

    public JRExpression getSubtitleExpression() {
        return ((JRChart)this.parent).getSubtitleExpression();
    }

    public byte getHyperlinkType() {
        return ((JRChart)this.parent).getHyperlinkType();
    }

    public byte getHyperlinkTarget() {
        return ((JRChart)this.parent).getHyperlinkTarget();
    }

    public JRExpression getAnchorNameExpression() {
        return ((JRChart)this.parent).getAnchorNameExpression();
    }

    public JRExpression getHyperlinkReferenceExpression() {
        return ((JRChart)this.parent).getHyperlinkReferenceExpression();
    }

    public JRExpression getHyperlinkAnchorExpression() {
        return ((JRChart)this.parent).getHyperlinkAnchorExpression();
    }

    public JRExpression getHyperlinkPageExpression() {
        return ((JRChart)this.parent).getHyperlinkPageExpression();
    }

    public JRChartDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(JRFillChartDataset dataset) {
        this.dataset = dataset;
    }

    public JRChartPlot getPlot() {
        return this.plot;
    }

    protected JRRenderable getRenderer() {
        return this.renderer;
    }

    protected String getAnchorName() {
        return this.anchorName;
    }

    protected String getHyperlinkReference() {
        return this.hyperlinkReference;
    }

    protected String getHyperlinkAnchor() {
        return this.hyperlinkAnchor;
    }

    protected Integer getHyperlinkPage() {
        return this.hyperlinkPage;
    }

    protected String getHyperlinkTooltip() {
        return this.hyperlinkTooltip;
    }

    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    protected JRTemplateImage getJRTemplateImage() {
        JRStyle style = this.getStyle();
        JRTemplateImage template = (JRTemplateImage)this.getTemplate(style);
        if (template == null) {
            template = new JRTemplateImage(this.band.getOrigin(), this.filler.getJasperPrint().getDefaultStyleProvider(), this);
            this.registerTemplate(style, template);
        }
        return template;
    }

    protected void rewind() {
    }

    protected void evaluate(byte evaluation) throws JRException {
        this.reset();
        this.evaluatePrintWhenExpression(evaluation);
        if ((this.isPrintWhenExpressionNull() || !this.isPrintWhenExpressionNull() && this.isPrintWhenTrue()) && this.getEvaluationTime() == 1) {
            this.evaluateImage(evaluation);
        }
    }

    protected JFreeChartRenderer evaluateImage(byte evaluation) throws JRException {
        JFreeChartRenderer chartRenderer;
        this.evaluateDatasetRun(evaluation);
        switch (this.chartType) {
            case 1: {
                chartRenderer = this.evaluateAreaImage(evaluation);
                break;
            }
            case 3: {
                chartRenderer = this.evaluateBarImage(evaluation);
                break;
            }
            case 2: {
                chartRenderer = this.evaluateBar3DImage(evaluation);
                break;
            }
            case 4: {
                chartRenderer = this.evaluateBubbleImage(evaluation);
                break;
            }
            case 5: {
                chartRenderer = this.evaluateCandlestickImage(evaluation);
                break;
            }
            case 6: {
                chartRenderer = this.evaluateHighLowImage(evaluation);
                break;
            }
            case 7: {
                chartRenderer = this.evaluateLineImage(evaluation);
                break;
            }
            case 17: {
                chartRenderer = this.evaluateMeterImage(evaluation);
                break;
            }
            case 19: {
                chartRenderer = this.evaluateMultiAxisImage(evaluation);
                break;
            }
            case 9: {
                chartRenderer = this.evaluatePieImage(evaluation);
                break;
            }
            case 8: {
                chartRenderer = this.evaluatePie3DImage(evaluation);
                break;
            }
            case 10: {
                chartRenderer = this.evaluateScatterImage(evaluation);
                break;
            }
            case 12: {
                chartRenderer = this.evaluateStackedBarImage(evaluation);
                break;
            }
            case 11: {
                chartRenderer = this.evaluateStackedBar3DImage(evaluation);
                break;
            }
            case 18: {
                chartRenderer = this.evaluateThermometerImage(evaluation);
                break;
            }
            case 16: {
                chartRenderer = this.evaluateTimeSeriesImage(evaluation);
                break;
            }
            case 13: {
                chartRenderer = this.evaluateXyAreaImage(evaluation);
                break;
            }
            case 14: {
                chartRenderer = this.evaluateXYBarImage(evaluation);
                break;
            }
            case 15: {
                chartRenderer = this.evaluateXyLineImage(evaluation);
                break;
            }
            case 20: {
                chartRenderer = this.evaluateStackedAreaImage(evaluation);
                break;
            }
            default: {
                throw new JRRuntimeException("Chart type " + this.getChartType() + " not supported.");
            }
        }
        if (this.chartCustomizer != null) {
            this.chartCustomizer.customize(chartRenderer.getChart(), this);
        }
        this.renderer = chartRenderer;
        this.anchorName = (String)this.evaluateExpression(this.getAnchorNameExpression(), evaluation);
        this.hyperlinkReference = (String)this.evaluateExpression(this.getHyperlinkReferenceExpression(), evaluation);
        this.hyperlinkAnchor = (String)this.evaluateExpression(this.getHyperlinkAnchorExpression(), evaluation);
        this.hyperlinkPage = (Integer)this.evaluateExpression(this.getHyperlinkPageExpression(), evaluation);
        this.hyperlinkTooltip = (String)this.evaluateExpression(this.getHyperlinkTooltipExpression(), evaluation);
        this.hyperlinkParameters = JRFillHyperlinkHelper.evaluateHyperlinkParameters(this, this.expressionEvaluator, evaluation);
        return chartRenderer;
    }

    protected boolean prepare(int availableStretchHeight, boolean isOverflow) {
        boolean willOverflow = false;
        if (this.isPrintWhenExpressionNull() || !this.isPrintWhenExpressionNull() && this.isPrintWhenTrue()) {
            this.setToPrint(true);
        } else {
            this.setToPrint(false);
        }
        if (!this.isToPrint()) {
            return willOverflow;
        }
        boolean isToPrint = true;
        boolean isReprinted = false;
        if (this.getEvaluationTime() == 1) {
            if (isOverflow && this.isAlreadyPrinted() && !this.isPrintWhenDetailOverflows()) {
                isToPrint = false;
            }
            if (isToPrint && availableStretchHeight < this.getRelativeY() - this.getY() - this.getBandBottomY()) {
                isToPrint = false;
                willOverflow = true;
            }
            if (isToPrint && isOverflow && this.isPrintWhenDetailOverflows() && (this.isAlreadyPrinted() || !this.isAlreadyPrinted() && !this.isPrintRepeatedValues())) {
                isReprinted = true;
            }
            if (isToPrint && this.isRemoveLineWhenBlank() && this.getRenderer() == null) {
                isToPrint = false;
            }
        } else {
            if (isOverflow && this.isAlreadyPrinted() && !this.isPrintWhenDetailOverflows()) {
                isToPrint = false;
            }
            if (isToPrint && availableStretchHeight < this.getRelativeY() - this.getY() - this.getBandBottomY()) {
                isToPrint = false;
                willOverflow = true;
            }
            if (isToPrint && isOverflow && this.isPrintWhenDetailOverflows() && (this.isAlreadyPrinted() || !this.isAlreadyPrinted() && !this.isPrintRepeatedValues())) {
                isReprinted = true;
            }
        }
        this.setToPrint(isToPrint);
        this.setReprinted(isReprinted);
        return willOverflow;
    }

    protected JRPrintElement fill() {
        JRTemplatePrintImage printImage = new JRTemplatePrintImage(this.getJRTemplateImage());
        printImage.setX(this.getX());
        printImage.setY(this.getRelativeY());
        printImage.setWidth(this.getWidth());
        printImage.setHeight(this.getStretchHeight());
        byte evaluationType = this.getEvaluationTime();
        if (evaluationType == 1) {
            this.copy(printImage);
        } else {
            this.filler.addBoundElement(this, printImage, evaluationType, this.getEvaluationGroup(), this.band);
        }
        return printImage;
    }

    protected void copy(JRPrintImage printImage) {
        printImage.setRenderer(this.getRenderer());
        printImage.setAnchorName(this.getAnchorName());
        printImage.setHyperlinkReference(this.getHyperlinkReference());
        printImage.setHyperlinkAnchor(this.getHyperlinkAnchor());
        printImage.setHyperlinkPage(this.getHyperlinkPage());
        printImage.setHyperlinkTooltip(this.getHyperlinkTooltip());
        printImage.setBookmarkLevel(this.getBookmarkLevel());
        printImage.setHyperlinkParameters(this.hyperlinkParameters);
    }

    public byte getChartType() {
        return this.chartType;
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    public void visit(JRVisitor visitor) {
        visitor.visitChart(this);
    }

    private void configureChart(JFreeChart chart, JRChartPlot jrPlot, byte evaluation) throws JRException {
        LegendTitle legend;
        String subtitleText;
        if (this.getMode() == 1) {
            chart.setBackgroundPaint((Paint)this.getBackcolor());
        } else {
            chart.setBackgroundPaint((Paint)TRANSPARENT_PAINT);
        }
        RectangleEdge titleEdge = JRFillChart.getEdge(this.getTitlePosition());
        if (chart.getTitle() != null) {
            TextTitle title = chart.getTitle();
            title.setPaint((Paint)this.getTitleColor());
            title.setFont(new Font(JRFontUtil.getAttributes(this.getTitleFont())));
            title.setPosition(titleEdge);
        }
        if ((subtitleText = (String)this.evaluateExpression(this.getSubtitleExpression(), evaluation)) != null) {
            TextTitle subtitle = new TextTitle(subtitleText);
            subtitle.setPaint((Paint)this.getSubtitleColor());
            subtitle.setFont(new Font(JRFontUtil.getAttributes(this.getSubtitleFont())));
            subtitle.setPosition(titleEdge);
            chart.addSubtitle((Title)subtitle);
        }
        if ((legend = chart.getLegend()) != null) {
            legend.setItemPaint((Paint)this.getLegendColor());
            if (this.getOwnLegendBackgroundColor() == null) {
                legend.setBackgroundPaint((Paint)TRANSPARENT_PAINT);
            } else {
                legend.setBackgroundPaint((Paint)this.getLegendBackgroundColor());
            }
            chart.getLegend().setItemFont(new Font(JRFontUtil.getAttributes(this.getLegendFont())));
            chart.getLegend().setPosition(JRFillChart.getEdge(this.getLegendPosition()));
        }
        this.configurePlot(chart.getPlot(), jrPlot);
    }

    private void configurePlot(Plot p, JRChartPlot jrPlot) {
        p.setOutlinePaint((Paint)TRANSPARENT_PAINT);
        if (this.getPlot().getOwnBackcolor() == null) {
            p.setBackgroundPaint((Paint)TRANSPARENT_PAINT);
        } else {
            p.setBackgroundPaint((Paint)this.getPlot().getBackcolor());
        }
        p.setBackgroundAlpha(this.getPlot().getBackgroundAlpha());
        p.setForegroundAlpha(this.getPlot().getForegroundAlpha());
        SortedSet seriesColors = this.getPlot().getSeriesColors();
        if (p instanceof CategoryPlot) {
            CategoryAxis axis = ((CategoryPlot)p).getDomainAxis();
            double labelRotation = this.getPlot().getLabelRotation();
            if (labelRotation == 90.0) {
                axis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_90);
            } else if (labelRotation == -90.0) {
                axis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
            } else if (labelRotation < 0.0) {
                axis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)(-labelRotation / 180.0 * Math.PI)));
            } else if (labelRotation > 0.0) {
                axis.setCategoryLabelPositions(CategoryLabelPositions.createDownRotationLabelPositions((double)(labelRotation / 180.0 * Math.PI)));
            }
        }
        if (seriesColors != null) {
            Paint[] colors;
            if (seriesColors.size() == 1) {
                colors = new Paint[DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE.length + 1];
                colors[0] = ((JRChartPlot.JRSeriesColor)seriesColors.first()).getColor();
                for (int i = 0; i < DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE.length; ++i) {
                    colors[i + 1] = DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE[i];
                }
                p.setDrawingSupplier((DrawingSupplier)new DefaultDrawingSupplier(colors, DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE));
            } else if (seriesColors.size() > 1) {
                colors = new Color[seriesColors.size()];
                JRChartPlot.JRSeriesColor[] colorSequence = new JRChartPlot.JRSeriesColor[seriesColors.size()];
                seriesColors.toArray(colorSequence);
                for (int i = 0; i < colorSequence.length; ++i) {
                    colors[i] = colorSequence[i].getColor();
                }
                p.setDrawingSupplier((DrawingSupplier)new DefaultDrawingSupplier(colors, DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE));
            }
        }
    }

    private void configureAxisSeriesColors(CategoryItemRenderer renderer, JRChartPlot jrPlot) {
        SortedSet seriesColors = jrPlot.getSeriesColors();
        if (seriesColors != null) {
            Iterator iter = seriesColors.iterator();
            while (iter.hasNext()) {
                JRChartPlot.JRSeriesColor seriesColor = (JRChartPlot.JRSeriesColor)iter.next();
                renderer.setSeriesPaint(seriesColor.getSeriesOrder(), (Paint)seriesColor.getColor());
            }
        }
    }

    private void configureAxisSeriesColors(XYItemRenderer renderer, JRChartPlot jrPlot) {
        SortedSet seriesColors = jrPlot.getSeriesColors();
        if (seriesColors != null) {
            Iterator iter = seriesColors.iterator();
            while (iter.hasNext()) {
                JRChartPlot.JRSeriesColor seriesColor = (JRChartPlot.JRSeriesColor)iter.next();
                renderer.setSeriesPaint(seriesColor.getSeriesOrder(), (Paint)seriesColor.getColor());
            }
        }
    }

    private void configureAxis(Axis axis, JRFont labelFont, Color labelColor, JRFont tickLabelFont, Color tickLabelColor, String tickLabelMask, Color lineColor) {
        axis.setLabelFont(new Font(JRFontUtil.getAttributes(labelFont)));
        axis.setTickLabelFont(new Font(JRFontUtil.getAttributes(tickLabelFont)));
        if (labelColor != null) {
            axis.setLabelPaint((Paint)labelColor);
        }
        if (tickLabelColor != null) {
            axis.setTickLabelPaint((Paint)tickLabelColor);
        }
        if (lineColor != null) {
            axis.setAxisLinePaint((Paint)lineColor);
            axis.setTickMarkPaint((Paint)lineColor);
        }
        if (tickLabelMask != null) {
            if (axis instanceof NumberAxis) {
                NumberFormat fmt = NumberFormat.getInstance();
                if (fmt instanceof DecimalFormat) {
                    ((DecimalFormat)fmt).applyPattern(tickLabelMask);
                }
                ((NumberAxis)axis).setNumberFormatOverride(fmt);
            } else if (axis instanceof DateAxis) {
                DateFormat fmt = null;
                fmt = tickLabelMask.equals("SHORT") || tickLabelMask.equals("DateFormat.SHORT") ? DateFormat.getDateInstance(3) : (tickLabelMask.equals("MEDIUM") || tickLabelMask.equals("DateFormat.MEDIUM") ? DateFormat.getDateInstance(2) : (tickLabelMask.equals("LONG") || tickLabelMask.equals("DateFormat.LONG") ? DateFormat.getDateInstance(1) : (tickLabelMask.equals("FULL") || tickLabelMask.equals("DateFormat.FULL") ? DateFormat.getDateInstance(0) : new SimpleDateFormat(tickLabelMask))));
                ((DateAxis)axis).setDateFormatOverride(fmt);
            }
        }
    }

    protected JFreeChartRenderer evaluateAreaImage(byte evaluation) throws JRException {
        JFreeChart chart = ChartFactory.createAreaChart((String)((String)this.evaluateExpression(this.getTitleExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getCategoryAxisLabelExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getValueAxisLabelExpression(), evaluation)), (CategoryDataset)((CategoryDataset)this.dataset.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(chart, this.getPlot(), evaluation);
        JRFillAreaPlot areaPlot = (JRFillAreaPlot)this.getPlot();
        this.configureAxis((Axis)((CategoryPlot)chart.getPlot()).getDomainAxis(), areaPlot.getCategoryAxisLabelFont(), areaPlot.getCategoryAxisLabelColor(), areaPlot.getCategoryAxisTickLabelFont(), areaPlot.getCategoryAxisTickLabelColor(), areaPlot.getCategoryAxisTickLabelMask(), areaPlot.getCategoryAxisLineColor());
        this.configureAxis((Axis)((CategoryPlot)chart.getPlot()).getRangeAxis(), areaPlot.getValueAxisLabelFont(), areaPlot.getValueAxisLabelColor(), areaPlot.getValueAxisTickLabelFont(), areaPlot.getValueAxisTickLabelColor(), areaPlot.getCategoryAxisTickLabelMask(), areaPlot.getValueAxisLineColor());
        return this.getCategoryRenderer(chart);
    }

    protected JFreeChartRenderer evaluateBar3DImage(byte evaluation) throws JRException {
        JFreeChart chart = ChartFactory.createBarChart3D((String)((String)this.evaluateExpression(this.getTitleExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRBar3DPlot)this.getPlot()).getCategoryAxisLabelExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRBar3DPlot)this.getPlot()).getValueAxisLabelExpression(), evaluation)), (CategoryDataset)((CategoryDataset)this.dataset.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(chart, this.getPlot(), evaluation);
        CategoryPlot categoryPlot = (CategoryPlot)chart.getPlot();
        JRFillBar3DPlot bar3DPlot = (JRFillBar3DPlot)this.getPlot();
        BarRenderer3D barRenderer3D = new BarRenderer3D(bar3DPlot.getXOffset(), bar3DPlot.getYOffset());
        categoryPlot.setRenderer((CategoryItemRenderer)barRenderer3D);
        barRenderer3D.setBaseItemLabelGenerator((CategoryItemLabelGenerator)((JRFillCategoryDataset)this.getDataset()).getLabelGenerator());
        barRenderer3D.setItemLabelsVisible(bar3DPlot.isShowLabels());
        this.configureAxis((Axis)categoryPlot.getDomainAxis(), bar3DPlot.getCategoryAxisLabelFont(), bar3DPlot.getCategoryAxisLabelColor(), bar3DPlot.getCategoryAxisTickLabelFont(), bar3DPlot.getCategoryAxisTickLabelColor(), bar3DPlot.getCategoryAxisTickLabelMask(), bar3DPlot.getCategoryAxisLineColor());
        this.configureAxis((Axis)categoryPlot.getRangeAxis(), bar3DPlot.getValueAxisLabelFont(), bar3DPlot.getValueAxisLabelColor(), bar3DPlot.getValueAxisTickLabelFont(), bar3DPlot.getValueAxisTickLabelColor(), bar3DPlot.getValueAxisTickLabelMask(), bar3DPlot.getValueAxisLineColor());
        return this.getCategoryRenderer(chart);
    }

    protected JFreeChartRenderer evaluateBarImage(byte evaluation) throws JRException {
        CategoryDataset categoryDataset = (CategoryDataset)this.dataset.getDataset();
        JFreeChart chart = ChartFactory.createBarChart((String)((String)this.evaluateExpression(this.getTitleExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getCategoryAxisLabelExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getValueAxisLabelExpression(), evaluation)), (CategoryDataset)categoryDataset, (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(chart, this.getPlot(), evaluation);
        CategoryPlot categoryPlot = (CategoryPlot)chart.getPlot();
        JRFillBarPlot barPlot = (JRFillBarPlot)this.getPlot();
        categoryPlot.getDomainAxis().setTickMarksVisible(barPlot.isShowTickMarks());
        categoryPlot.getDomainAxis().setTickLabelsVisible(barPlot.isShowTickLabels());
        this.configureAxis((Axis)categoryPlot.getDomainAxis(), barPlot.getCategoryAxisLabelFont(), barPlot.getCategoryAxisLabelColor(), barPlot.getCategoryAxisTickLabelFont(), barPlot.getCategoryAxisTickLabelColor(), barPlot.getCategoryAxisTickLabelMask(), barPlot.getCategoryAxisLineColor());
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickMarksVisible(barPlot.isShowTickMarks());
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickLabelsVisible(barPlot.isShowTickLabels());
        this.configureAxis((Axis)categoryPlot.getRangeAxis(), barPlot.getValueAxisLabelFont(), barPlot.getValueAxisLabelColor(), barPlot.getValueAxisTickLabelFont(), barPlot.getValueAxisTickLabelColor(), barPlot.getValueAxisTickLabelMask(), barPlot.getValueAxisLineColor());
        CategoryItemRenderer categoryRenderer = categoryPlot.getRenderer();
        categoryRenderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)((JRFillCategoryDataset)this.getDataset()).getLabelGenerator());
        categoryRenderer.setItemLabelsVisible(barPlot.isShowLabels());
        return this.getCategoryRenderer(chart);
    }

    protected JFreeChartRenderer evaluateBubbleImage(byte evaluation) throws JRException {
        JFreeChart chart = ChartFactory.createBubbleChart((String)((String)this.evaluateExpression(this.getTitleExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRBubblePlot)this.getPlot()).getXAxisLabelExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRBubblePlot)this.getPlot()).getYAxisLabelExpression(), evaluation)), (XYZDataset)((XYZDataset)this.dataset.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(chart, this.getPlot(), evaluation);
        XYPlot xyPlot = (XYPlot)chart.getPlot();
        JRBubblePlot bubblePlot = (JRBubblePlot)this.getPlot();
        XYBubbleRenderer bubbleRenderer = new XYBubbleRenderer(bubblePlot.getScaleType());
        xyPlot.setRenderer((XYItemRenderer)bubbleRenderer);
        this.configureAxis((Axis)xyPlot.getDomainAxis(), bubblePlot.getXAxisLabelFont(), bubblePlot.getXAxisLabelColor(), bubblePlot.getXAxisTickLabelFont(), bubblePlot.getXAxisTickLabelColor(), bubblePlot.getXAxisTickLabelMask(), bubblePlot.getXAxisLineColor());
        this.configureAxis((Axis)xyPlot.getRangeAxis(), bubblePlot.getYAxisLabelFont(), bubblePlot.getYAxisLabelColor(), bubblePlot.getYAxisTickLabelFont(), bubblePlot.getYAxisTickLabelColor(), bubblePlot.getYAxisTickLabelMask(), bubblePlot.getYAxisLineColor());
        return this.getXYZRenderer(chart);
    }

    protected JFreeChartRenderer evaluateCandlestickImage(byte evaluation) throws JRException {
        JFreeChart chart = ChartFactory.createCandlestickChart((String)((String)this.evaluateExpression(this.getTitleExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRCandlestickPlot)this.getPlot()).getTimeAxisLabelExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRCandlestickPlot)this.getPlot()).getValueAxisLabelExpression(), evaluation)), (OHLCDataset)((DefaultHighLowDataset)this.dataset.getDataset()), (boolean)this.isShowLegend());
        this.configureChart(chart, this.getPlot(), evaluation);
        XYPlot xyPlot = (XYPlot)chart.getPlot();
        JRCandlestickPlot candlestickPlot = (JRCandlestickPlot)this.getPlot();
        CandlestickRenderer candlestickRenderer = (CandlestickRenderer)xyPlot.getRenderer();
        candlestickRenderer.setDrawVolume(candlestickPlot.isShowVolume());
        this.configureAxis((Axis)xyPlot.getDomainAxis(), candlestickPlot.getTimeAxisLabelFont(), candlestickPlot.getTimeAxisLabelColor(), candlestickPlot.getTimeAxisTickLabelFont(), candlestickPlot.getTimeAxisTickLabelColor(), candlestickPlot.getTimeAxisTickLabelMask(), candlestickPlot.getTimeAxisLineColor());
        this.configureAxis((Axis)xyPlot.getRangeAxis(), candlestickPlot.getValueAxisLabelFont(), candlestickPlot.getValueAxisLabelColor(), candlestickPlot.getValueAxisTickLabelFont(), candlestickPlot.getValueAxisTickLabelColor(), candlestickPlot.getValueAxisTickLabelMask(), candlestickPlot.getValueAxisLineColor());
        return this.getHighLowRenderer(chart);
    }

    protected JFreeChartRenderer evaluateHighLowImage(byte evaluation) throws JRException {
        JFreeChart chart = ChartFactory.createHighLowChart((String)((String)this.evaluateExpression(this.getTitleExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRHighLowPlot)this.getPlot()).getTimeAxisLabelExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRHighLowPlot)this.getPlot()).getValueAxisLabelExpression(), evaluation)), (OHLCDataset)((DefaultHighLowDataset)this.dataset.getDataset()), (boolean)this.isShowLegend());
        this.configureChart(chart, this.getPlot(), evaluation);
        XYPlot xyPlot = (XYPlot)chart.getPlot();
        JRHighLowPlot highLowPlot = (JRHighLowPlot)this.getPlot();
        HighLowRenderer hlRenderer = (HighLowRenderer)xyPlot.getRenderer();
        hlRenderer.setDrawOpenTicks(highLowPlot.isShowOpenTicks());
        hlRenderer.setDrawCloseTicks(highLowPlot.isShowCloseTicks());
        this.configureAxis((Axis)xyPlot.getDomainAxis(), highLowPlot.getTimeAxisLabelFont(), highLowPlot.getTimeAxisLabelColor(), highLowPlot.getTimeAxisTickLabelFont(), highLowPlot.getTimeAxisTickLabelColor(), highLowPlot.getTimeAxisTickLabelMask(), highLowPlot.getTimeAxisLineColor());
        this.configureAxis((Axis)xyPlot.getRangeAxis(), highLowPlot.getValueAxisLabelFont(), highLowPlot.getValueAxisLabelColor(), highLowPlot.getValueAxisTickLabelFont(), highLowPlot.getValueAxisTickLabelColor(), highLowPlot.getValueAxisTickLabelMask(), highLowPlot.getValueAxisLineColor());
        return this.getHighLowRenderer(chart);
    }

    protected JFreeChartRenderer evaluateLineImage(byte evaluation) throws JRException {
        JFreeChart chart = ChartFactory.createLineChart((String)((String)this.evaluateExpression(this.getTitleExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRLinePlot)this.getPlot()).getCategoryAxisLabelExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRLinePlot)this.getPlot()).getValueAxisLabelExpression(), evaluation)), (CategoryDataset)((CategoryDataset)this.dataset.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(chart, this.getPlot(), evaluation);
        CategoryPlot categoryPlot = (CategoryPlot)chart.getPlot();
        JRFillLinePlot linePlot = (JRFillLinePlot)this.getPlot();
        LineAndShapeRenderer lineRenderer = (LineAndShapeRenderer)categoryPlot.getRenderer();
        lineRenderer.setShapesVisible(linePlot.isShowShapes());
        lineRenderer.setLinesVisible(linePlot.isShowLines());
        this.configureAxis((Axis)categoryPlot.getDomainAxis(), linePlot.getCategoryAxisLabelFont(), linePlot.getCategoryAxisLabelColor(), linePlot.getCategoryAxisTickLabelFont(), linePlot.getCategoryAxisTickLabelColor(), linePlot.getCategoryAxisTickLabelMask(), linePlot.getCategoryAxisLineColor());
        this.configureAxis((Axis)categoryPlot.getRangeAxis(), linePlot.getValueAxisLabelFont(), linePlot.getValueAxisLabelColor(), linePlot.getValueAxisTickLabelFont(), linePlot.getValueAxisTickLabelColor(), linePlot.getValueAxisTickLabelMask(), linePlot.getValueAxisLineColor());
        return this.getCategoryRenderer(chart);
    }

    protected JFreeChartRenderer evaluatePie3DImage(byte evaluation) throws JRException {
        JFreeChart chart = ChartFactory.createPieChart3D((String)((String)this.evaluateExpression(this.getTitleExpression(), evaluation)), (PieDataset)((PieDataset)this.dataset.getDataset()), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(chart, this.getPlot(), evaluation);
        PiePlot3D piePlot3D = (PiePlot3D)chart.getPlot();
        piePlot3D.setDepthFactor(((JRFillPie3DPlot)this.getPlot()).getDepthFactor());
        piePlot3D.setCircular(((JRFillPie3DPlot)this.getPlot()).isCircular());
        PieLabelGenerator labelGenerator = ((JRFillPieDataset)this.getDataset()).getLabelGenerator();
        if (labelGenerator != null) {
            piePlot3D.setLabelGenerator((PieSectionLabelGenerator)labelGenerator);
        }
        piePlot3D.setLabelFont(new Font(JRFontUtil.getAttributes(new JRBaseFont(null, null, this, null))));
        piePlot3D.setLabelPaint((Paint)this.getForecolor());
        return this.getPieRenderer(chart);
    }

    protected JFreeChartRenderer evaluatePieImage(byte evaluation) throws JRException {
        JFreeChart chart = ChartFactory.createPieChart((String)((String)this.evaluateExpression(this.getTitleExpression(), evaluation)), (PieDataset)((PieDataset)this.dataset.getDataset()), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(chart, this.getPlot(), evaluation);
        PiePlot piePlot = (PiePlot)chart.getPlot();
        piePlot.setCircular(((JRFillPiePlot)this.getPlot()).isCircular());
        PieLabelGenerator labelGenerator = ((JRFillPieDataset)this.getDataset()).getLabelGenerator();
        if (labelGenerator != null) {
            piePlot.setLabelGenerator((PieSectionLabelGenerator)labelGenerator);
        }
        piePlot.setLabelFont(new Font(JRFontUtil.getAttributes(new JRBaseFont(null, null, this, null))));
        piePlot.setLabelPaint((Paint)this.getForecolor());
        return this.getPieRenderer(chart);
    }

    protected JFreeChartRenderer evaluateScatterImage(byte evaluation) throws JRException {
        JFreeChart chart = ChartFactory.createScatterPlot((String)((String)this.evaluateExpression(this.getTitleExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRScatterPlot)this.getPlot()).getXAxisLabelExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRScatterPlot)this.getPlot()).getYAxisLabelExpression(), evaluation)), (XYDataset)((XYDataset)this.dataset.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(chart, this.getPlot(), evaluation);
        XYLineAndShapeRenderer plotRenderer = (XYLineAndShapeRenderer)((XYPlot)chart.getPlot()).getRenderer();
        JRScatterPlot scatterPlot = (JRScatterPlot)this.getPlot();
        plotRenderer.setLinesVisible(scatterPlot.isShowLines());
        plotRenderer.setShapesVisible(scatterPlot.isShowShapes());
        this.configureAxis((Axis)chart.getXYPlot().getDomainAxis(), scatterPlot.getXAxisLabelFont(), scatterPlot.getXAxisLabelColor(), scatterPlot.getXAxisTickLabelFont(), scatterPlot.getXAxisTickLabelColor(), scatterPlot.getXAxisTickLabelMask(), scatterPlot.getXAxisLineColor());
        this.configureAxis((Axis)chart.getXYPlot().getRangeAxis(), scatterPlot.getYAxisLabelFont(), scatterPlot.getYAxisLabelColor(), scatterPlot.getYAxisTickLabelFont(), scatterPlot.getYAxisTickLabelColor(), scatterPlot.getYAxisTickLabelMask(), scatterPlot.getYAxisLineColor());
        return this.getXYRenderer(chart);
    }

    protected JFreeChartRenderer evaluateStackedBar3DImage(byte evaluation) throws JRException {
        JFreeChart chart = ChartFactory.createStackedBarChart3D((String)((String)this.evaluateExpression(this.getTitleExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRBar3DPlot)this.getPlot()).getCategoryAxisLabelExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRBar3DPlot)this.getPlot()).getValueAxisLabelExpression(), evaluation)), (CategoryDataset)((CategoryDataset)this.dataset.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(chart, this.getPlot(), evaluation);
        CategoryPlot categoryPlot = (CategoryPlot)chart.getPlot();
        JRFillBar3DPlot bar3DPlot = (JRFillBar3DPlot)this.getPlot();
        StackedBarRenderer3D stackedBarRenderer3D = new StackedBarRenderer3D(bar3DPlot.getXOffset(), bar3DPlot.getYOffset());
        categoryPlot.setRenderer((CategoryItemRenderer)stackedBarRenderer3D);
        stackedBarRenderer3D.setBaseItemLabelGenerator((CategoryItemLabelGenerator)((JRFillCategoryDataset)this.getDataset()).getLabelGenerator());
        stackedBarRenderer3D.setItemLabelsVisible(bar3DPlot.isShowLabels());
        this.configureAxis((Axis)categoryPlot.getDomainAxis(), bar3DPlot.getCategoryAxisLabelFont(), bar3DPlot.getCategoryAxisLabelColor(), bar3DPlot.getCategoryAxisTickLabelFont(), bar3DPlot.getCategoryAxisTickLabelColor(), bar3DPlot.getCategoryAxisTickLabelMask(), bar3DPlot.getCategoryAxisLineColor());
        this.configureAxis((Axis)categoryPlot.getRangeAxis(), bar3DPlot.getValueAxisLabelFont(), bar3DPlot.getValueAxisLabelColor(), bar3DPlot.getValueAxisTickLabelFont(), bar3DPlot.getValueAxisTickLabelColor(), bar3DPlot.getValueAxisTickLabelMask(), bar3DPlot.getValueAxisLineColor());
        return this.getCategoryRenderer(chart);
    }

    protected JFreeChartRenderer evaluateStackedBarImage(byte evaluation) throws JRException {
        JFreeChart chart = ChartFactory.createStackedBarChart((String)((String)this.evaluateExpression(this.getTitleExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getCategoryAxisLabelExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getValueAxisLabelExpression(), evaluation)), (CategoryDataset)((CategoryDataset)this.dataset.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(chart, this.getPlot(), evaluation);
        CategoryPlot categoryPlot = (CategoryPlot)chart.getPlot();
        JRFillBarPlot barPlot = (JRFillBarPlot)this.getPlot();
        categoryPlot.getDomainAxis().setTickMarksVisible(barPlot.isShowTickMarks());
        categoryPlot.getDomainAxis().setTickLabelsVisible(barPlot.isShowTickLabels());
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickMarksVisible(barPlot.isShowTickMarks());
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickLabelsVisible(barPlot.isShowTickLabels());
        CategoryItemRenderer categoryRenderer = categoryPlot.getRenderer();
        categoryRenderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)((JRFillCategoryDataset)this.getDataset()).getLabelGenerator());
        categoryRenderer.setItemLabelsVisible(((JRFillBarPlot)this.getPlot()).isShowLabels());
        this.configureAxis((Axis)categoryPlot.getDomainAxis(), barPlot.getCategoryAxisLabelFont(), barPlot.getCategoryAxisLabelColor(), barPlot.getCategoryAxisTickLabelFont(), barPlot.getCategoryAxisTickLabelColor(), barPlot.getCategoryAxisTickLabelMask(), barPlot.getCategoryAxisLineColor());
        this.configureAxis((Axis)categoryPlot.getRangeAxis(), barPlot.getValueAxisLabelFont(), barPlot.getValueAxisLabelColor(), barPlot.getValueAxisTickLabelFont(), barPlot.getValueAxisTickLabelColor(), barPlot.getValueAxisTickLabelMask(), barPlot.getValueAxisLineColor());
        return this.getCategoryRenderer(chart);
    }

    protected JFreeChartRenderer evaluateStackedAreaImage(byte evaluation) throws JRException {
        JFreeChart chart = ChartFactory.createStackedAreaChart((String)((String)this.evaluateExpression(this.getTitleExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getCategoryAxisLabelExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getValueAxisLabelExpression(), evaluation)), (CategoryDataset)((CategoryDataset)this.dataset.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(chart, this.getPlot(), evaluation);
        JRFillAreaPlot areaPlot = (JRFillAreaPlot)this.getPlot();
        this.configureAxis((Axis)((CategoryPlot)chart.getPlot()).getDomainAxis(), areaPlot.getCategoryAxisLabelFont(), areaPlot.getCategoryAxisLabelColor(), areaPlot.getCategoryAxisTickLabelFont(), areaPlot.getCategoryAxisTickLabelColor(), areaPlot.getCategoryAxisTickLabelMask(), areaPlot.getCategoryAxisLineColor());
        this.configureAxis((Axis)((CategoryPlot)chart.getPlot()).getRangeAxis(), areaPlot.getValueAxisLabelFont(), areaPlot.getValueAxisLabelColor(), areaPlot.getValueAxisTickLabelFont(), areaPlot.getValueAxisTickLabelColor(), areaPlot.getCategoryAxisTickLabelMask(), areaPlot.getValueAxisLineColor());
        return this.getCategoryRenderer(chart);
    }

    protected JFreeChartRenderer evaluateXyAreaImage(byte evaluation) throws JRException {
        JFreeChart chart = ChartFactory.createXYAreaChart((String)((String)this.evaluateExpression(this.getTitleExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getCategoryAxisLabelExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getValueAxisLabelExpression(), evaluation)), (XYDataset)((XYDataset)this.dataset.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(chart, this.getPlot(), evaluation);
        JRAreaPlot areaPlot = (JRAreaPlot)this.getPlot();
        this.configureAxis((Axis)chart.getXYPlot().getDomainAxis(), areaPlot.getCategoryAxisLabelFont(), areaPlot.getCategoryAxisLabelColor(), areaPlot.getCategoryAxisTickLabelFont(), areaPlot.getCategoryAxisTickLabelColor(), areaPlot.getCategoryAxisTickLabelMask(), areaPlot.getCategoryAxisLineColor());
        this.configureAxis((Axis)chart.getXYPlot().getRangeAxis(), areaPlot.getValueAxisLabelFont(), areaPlot.getValueAxisLabelColor(), areaPlot.getValueAxisTickLabelFont(), areaPlot.getValueAxisTickLabelColor(), areaPlot.getValueAxisTickLabelMask(), areaPlot.getValueAxisLineColor());
        return this.getXYRenderer(chart);
    }

    protected JFreeChartRenderer evaluateXYBarImage(byte evaluation) throws JRException {
        IntervalXYDataset tmpDataset = (IntervalXYDataset)this.dataset.getDataset();
        boolean isDate = true;
        if (this.dataset.getDatasetType() == 3) {
            isDate = false;
        }
        JFreeChart chart = ChartFactory.createXYBarChart((String)((String)this.evaluateExpression(this.getTitleExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getCategoryAxisLabelExpression(), evaluation)), (boolean)isDate, (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getValueAxisLabelExpression(), evaluation)), (IntervalXYDataset)tmpDataset, (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(chart, this.getPlot(), evaluation);
        XYPlot xyPlot = (XYPlot)chart.getPlot();
        XYItemRenderer itemRenderer = xyPlot.getRenderer();
        if (this.getDataset().getDatasetType() == 6) {
            itemRenderer.setBaseItemLabelGenerator((XYItemLabelGenerator)((JRFillTimeSeriesDataset)this.getDataset()).getLabelGenerator());
        } else if (this.getDataset().getDatasetType() == 5) {
            itemRenderer.setBaseItemLabelGenerator((XYItemLabelGenerator)((JRFillTimePeriodDataset)this.getDataset()).getLabelGenerator());
        } else if (this.getDataset().getDatasetType() == 3) {
            itemRenderer.setBaseItemLabelGenerator((XYItemLabelGenerator)((JRFillXyDataset)this.getDataset()).getLabelGenerator());
        }
        JRFillBarPlot barPlot = (JRFillBarPlot)this.getPlot();
        itemRenderer.setBaseItemLabelsVisible(barPlot.isShowLabels());
        this.configureAxis((Axis)xyPlot.getDomainAxis(), barPlot.getCategoryAxisLabelFont(), barPlot.getCategoryAxisLabelColor(), barPlot.getCategoryAxisTickLabelFont(), barPlot.getCategoryAxisTickLabelColor(), barPlot.getCategoryAxisTickLabelMask(), barPlot.getCategoryAxisLineColor());
        this.configureAxis((Axis)xyPlot.getRangeAxis(), barPlot.getValueAxisLabelFont(), barPlot.getValueAxisLabelColor(), barPlot.getValueAxisTickLabelFont(), barPlot.getValueAxisTickLabelColor(), barPlot.getValueAxisTickLabelMask(), barPlot.getValueAxisLineColor());
        return this.getXYBarRenderer(chart);
    }

    protected JFreeChartRenderer evaluateXyLineImage(byte evaluation) throws JRException {
        JRLinePlot linePlot = (JRLinePlot)this.getPlot();
        JFreeChart chart = ChartFactory.createXYLineChart((String)((String)this.evaluateExpression(this.getTitleExpression(), evaluation)), (String)((String)this.evaluateExpression(linePlot.getCategoryAxisLabelExpression(), evaluation)), (String)((String)this.evaluateExpression(linePlot.getValueAxisLabelExpression(), evaluation)), (XYDataset)((XYDataset)this.dataset.getDataset()), (PlotOrientation)linePlot.getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(chart, this.getPlot(), evaluation);
        this.configureAxis((Axis)chart.getXYPlot().getDomainAxis(), linePlot.getCategoryAxisLabelFont(), linePlot.getCategoryAxisLabelColor(), linePlot.getCategoryAxisTickLabelFont(), linePlot.getCategoryAxisTickLabelColor(), linePlot.getCategoryAxisTickLabelMask(), linePlot.getCategoryAxisLineColor());
        this.configureAxis((Axis)chart.getXYPlot().getRangeAxis(), linePlot.getValueAxisLabelFont(), linePlot.getValueAxisLabelColor(), linePlot.getValueAxisTickLabelFont(), linePlot.getValueAxisTickLabelColor(), linePlot.getValueAxisTickLabelMask(), linePlot.getValueAxisLineColor());
        XYLineAndShapeRenderer lineRenderer = (XYLineAndShapeRenderer)chart.getXYPlot().getRenderer();
        lineRenderer.setShapesVisible(linePlot.isShowShapes());
        lineRenderer.setLinesVisible(linePlot.isShowLines());
        return this.getXYRenderer(chart);
    }

    protected JFreeChartRenderer evaluateTimeSeriesImage(byte evaluation) throws JRException {
        String timeAxisLabel = (String)this.evaluateExpression(((JRTimeSeriesPlot)this.getPlot()).getTimeAxisLabelExpression(), evaluation);
        String valueAxisLabel = (String)this.evaluateExpression(((JRTimeSeriesPlot)this.getPlot()).getValueAxisLabelExpression(), evaluation);
        JFreeChart chart = ChartFactory.createTimeSeriesChart((String)((String)this.evaluateExpression(this.getTitleExpression(), evaluation)), (String)timeAxisLabel, (String)valueAxisLabel, (XYDataset)((TimeSeriesCollection)this.dataset.getDataset()), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(chart, this.getPlot(), evaluation);
        XYPlot xyPlot = (XYPlot)chart.getPlot();
        JRTimeSeriesPlot timeSeriesPlot = (JRTimeSeriesPlot)this.getPlot();
        XYLineAndShapeRenderer lineRenderer = (XYLineAndShapeRenderer)xyPlot.getRenderer();
        lineRenderer.setLinesVisible(((JRTimeSeriesPlot)this.getPlot()).isShowLines());
        lineRenderer.setShapesVisible(((JRTimeSeriesPlot)this.getPlot()).isShowShapes());
        this.configureAxis((Axis)xyPlot.getDomainAxis(), timeSeriesPlot.getTimeAxisLabelFont(), timeSeriesPlot.getTimeAxisLabelColor(), timeSeriesPlot.getTimeAxisTickLabelFont(), timeSeriesPlot.getTimeAxisTickLabelColor(), timeSeriesPlot.getTimeAxisTickLabelMask(), timeSeriesPlot.getTimeAxisLineColor());
        this.configureAxis((Axis)xyPlot.getRangeAxis(), timeSeriesPlot.getValueAxisLabelFont(), timeSeriesPlot.getValueAxisLabelColor(), timeSeriesPlot.getValueAxisTickLabelFont(), timeSeriesPlot.getValueAxisTickLabelColor(), timeSeriesPlot.getValueAxisTickLabelMask(), timeSeriesPlot.getValueAxisLineColor());
        return this.getTimeSeriesRenderer(chart);
    }

    protected Range convertRange(JRDataRange dataRange, byte evaluation) throws JRException {
        if (dataRange == null) {
            return null;
        }
        Number low = (Number)this.evaluateExpression(dataRange.getLowExpression(), evaluation);
        Number high = (Number)this.evaluateExpression(dataRange.getHighExpression(), evaluation);
        return new Range(low != null ? low.doubleValue() : 0.0, high != null ? high.doubleValue() : 100.0);
    }

    protected MeterInterval convertInterval(JRMeterInterval interval, byte evaluation) throws JRException {
        String label = interval.getLabel();
        if (label == null) {
            label = "";
        }
        Range range = this.convertRange(interval.getDataRange(), evaluation);
        Color color = interval.getBackgroundColor();
        float[] components = color.getRGBColorComponents(null);
        Color alphaColor = new Color(components[0], components[1], components[2], (float)interval.getAlpha());
        return new MeterInterval(label, range, (Paint)alphaColor, null, (Paint)alphaColor);
    }

    protected JFreeChartRenderer evaluateMeterImage(byte evaluation) throws JRException {
        List intervals;
        JRValueDisplay display;
        JRFillMeterPlot jrPlot = (JRFillMeterPlot)this.getPlot();
        MeterPlot chartPlot = new MeterPlot((ValueDataset)this.dataset.getDataset());
        byte shape = jrPlot.getShape();
        if (shape == 0) {
            chartPlot.setDialShape(DialShape.CHORD);
        } else if (shape == 1) {
            chartPlot.setDialShape(DialShape.CIRCLE);
        } else {
            chartPlot.setDialShape(DialShape.PIE);
        }
        chartPlot.setRange(this.convertRange(jrPlot.getDataRange(), evaluation));
        chartPlot.setMeterAngle(jrPlot.getMeterAngle());
        String units = jrPlot.getUnits();
        if (units != null && units.length() > 0) {
            chartPlot.setUnits(units);
        }
        chartPlot.setTickSize(jrPlot.getTickInterval());
        Color color = jrPlot.getMeterBackgroundColor();
        if (color != null) {
            chartPlot.setDialBackgroundPaint((Paint)color);
        }
        if ((color = jrPlot.getNeedleColor()) != null) {
            chartPlot.setNeedlePaint((Paint)color);
        }
        if ((display = jrPlot.getValueDisplay()) != null) {
            if (display.getColor() != null) {
                chartPlot.setValuePaint((Paint)display.getColor());
            }
            if (display.getMask() != null) {
                chartPlot.setTickLabelFormat((NumberFormat)new DecimalFormat(display.getMask()));
            }
            if (display.getFont() != null) {
                chartPlot.setValueFont(new Font(JRFontUtil.getAttributes(display.getFont())));
            }
        }
        if ((color = jrPlot.getTickColor()) != null) {
            chartPlot.setTickPaint((Paint)color);
        }
        if ((intervals = jrPlot.getIntervals()) != null) {
            Iterator iter = intervals.iterator();
            while (iter.hasNext()) {
                JRMeterInterval interval = (JRMeterInterval)iter.next();
                chartPlot.addInterval(this.convertInterval(interval, evaluation));
            }
        }
        JFreeChart chart = new JFreeChart((String)this.evaluateExpression(this.getTitleExpression(), evaluation), null, (Plot)chartPlot, this.isShowLegend());
        this.configureChart(chart, this.getPlot(), evaluation);
        return new JFreeChartRenderer(chart);
    }

    protected JFreeChartRenderer evaluateThermometerImage(byte evaluation) throws JRException {
        JRValueDisplay display;
        JRFillThermometerPlot jrPlot = (JRFillThermometerPlot)this.getPlot();
        ThermometerPlot chartPlot = new ThermometerPlot((ValueDataset)this.dataset.getDataset());
        Range range = this.convertRange(jrPlot.getDataRange(), evaluation);
        chartPlot.setLowerBound(range.getLowerBound());
        chartPlot.setUpperBound(range.getUpperBound());
        chartPlot.setShowValueLines(jrPlot.isShowValueLines());
        chartPlot.setUnits(0);
        Color color = jrPlot.getMercuryColor();
        if (color != null) {
            chartPlot.setMercuryPaint((Paint)color);
        }
        if ((display = jrPlot.getValueDisplay()) != null) {
            if (display.getColor() != null) {
                chartPlot.setValuePaint((Paint)display.getColor());
            }
            if (display.getMask() != null) {
                chartPlot.setValueFormat((NumberFormat)new DecimalFormat(display.getMask()));
            }
            if (display.getFont() != null) {
                chartPlot.setValueFont(new Font(JRFontUtil.getAttributes(display.getFont())));
            }
        }
        switch (jrPlot.getValueLocation()) {
            case 0: {
                chartPlot.setValueLocation(0);
                break;
            }
            case 1: {
                chartPlot.setValueLocation(2);
                break;
            }
            case 2: {
                chartPlot.setValueLocation(1);
                break;
            }
            default: {
                chartPlot.setValueLocation(3);
            }
        }
        range = this.convertRange(jrPlot.getLowRange(), evaluation);
        if (range != null) {
            chartPlot.setSubrangeInfo(2, range.getLowerBound(), range.getUpperBound());
        }
        if ((range = this.convertRange(jrPlot.getMediumRange(), evaluation)) != null) {
            chartPlot.setSubrangeInfo(1, range.getLowerBound(), range.getUpperBound());
        }
        if ((range = this.convertRange(jrPlot.getHighRange(), evaluation)) != null) {
            chartPlot.setSubrangeInfo(0, range.getLowerBound(), range.getUpperBound());
        }
        JFreeChart chart = new JFreeChart((Plot)chartPlot);
        this.configureChart(chart, this.getPlot(), evaluation);
        return new JFreeChartRenderer(chart);
    }

    protected JFreeChartRenderer evaluateMultiAxisImage(byte evaluation) throws JRException {
        JFreeChart mainChart = null;
        Plot mainPlot = null;
        JRFillMultiAxisPlot jrPlot = (JRFillMultiAxisPlot)this.getPlot();
        Iterator iter = jrPlot.getAxes().iterator();
        if (iter.hasNext()) {
            JRFillChartAxis axis = (JRFillChartAxis)iter.next();
            JRFillChart fillChart = axis.getFillChart();
            mainChart = fillChart.evaluateImage(evaluation).getChart();
            this.configureChart(mainChart, this.getPlot(), evaluation);
            mainPlot = mainChart.getPlot();
            if (axis.getPosition() == 2) {
                if (mainPlot instanceof CategoryPlot) {
                    ((CategoryPlot)mainPlot).setRangeAxisLocation(0, AxisLocation.BOTTOM_OR_RIGHT);
                }
                if (mainPlot instanceof XYPlot) {
                    ((XYPlot)mainPlot).setRangeAxisLocation(0, AxisLocation.BOTTOM_OR_RIGHT);
                }
            } else {
                if (mainPlot instanceof CategoryPlot) {
                    ((CategoryPlot)mainPlot).setRangeAxisLocation(0, AxisLocation.TOP_OR_LEFT);
                }
                if (mainPlot instanceof XYPlot) {
                    ((XYPlot)mainPlot).setRangeAxisLocation(0, AxisLocation.TOP_OR_LEFT);
                }
            }
        }
        int axisNumber = 0;
        while (iter.hasNext()) {
            CategoryPlot axisPlot;
            ++axisNumber;
            JRFillChartAxis chartAxis = (JRFillChartAxis)iter.next();
            JRFillChart fillChart = chartAxis.getFillChart();
            JFreeChart axisChart = fillChart.evaluateImage(evaluation).getChart();
            if (mainPlot instanceof CategoryPlot) {
                CategoryPlot mainCatPlot = (CategoryPlot)mainPlot;
                if (!(axisChart.getPlot() instanceof CategoryPlot)) {
                    throw new JRException("You can not mix plot types in a MultiAxisChart");
                }
                axisPlot = (CategoryPlot)axisChart.getPlot();
                mainCatPlot.setRangeAxis(axisNumber, axisPlot.getRangeAxis());
                if (chartAxis.getPosition() == 2) {
                    mainCatPlot.setRangeAxisLocation(axisNumber, AxisLocation.BOTTOM_OR_RIGHT);
                } else {
                    mainCatPlot.setRangeAxisLocation(axisNumber, AxisLocation.TOP_OR_LEFT);
                }
                mainCatPlot.setDataset(axisNumber, axisPlot.getDataset());
                mainCatPlot.mapDatasetToRangeAxis(axisNumber, axisNumber);
                mainCatPlot.setRenderer(axisNumber, axisPlot.getRenderer());
                this.configureAxisSeriesColors(axisPlot.getRenderer(), fillChart.getPlot());
                continue;
            }
            if (mainPlot instanceof XYPlot) {
                XYPlot mainXyPlot = (XYPlot)mainPlot;
                if (!(axisChart.getPlot() instanceof XYPlot)) {
                    throw new JRException("You can not mix plot types in a MultiAxisChart");
                }
                axisPlot = (XYPlot)axisChart.getPlot();
                mainXyPlot.setRangeAxis(axisNumber, axisPlot.getRangeAxis());
                if (chartAxis.getPosition() == 2) {
                    mainXyPlot.setRangeAxisLocation(axisNumber, AxisLocation.BOTTOM_OR_RIGHT);
                } else {
                    mainXyPlot.setRangeAxisLocation(axisNumber, AxisLocation.TOP_OR_LEFT);
                }
                mainXyPlot.setDataset(axisNumber, axisPlot.getDataset());
                mainXyPlot.mapDatasetToRangeAxis(axisNumber, axisNumber);
                mainXyPlot.setRenderer(axisNumber, axisPlot.getRenderer());
                this.configureAxisSeriesColors(axisPlot.getRenderer(), fillChart.getPlot());
                continue;
            }
            throw new JRException("MultiAxis charts only support Category and XY plots.");
        }
        return new JFreeChartRenderer(mainChart);
    }

    protected void resolveElement(JRPrintElement element, byte evaluation) throws JRException {
        this.evaluateImage(evaluation);
        this.copy((JRPrintImage)element);
    }

    public int getBookmarkLevel() {
        return ((JRChart)this.parent).getBookmarkLevel();
    }

    public String getCustomizerClass() {
        return this.customizerClass;
    }

    private void evaluateDatasetRun(byte evaluation) throws JRException {
        this.dataset.evaluateDatasetRun(evaluation);
    }

    public JRFillCloneable createClone(JRFillCloneFactory factory) {
        return null;
    }

    public JRHyperlinkParameter[] getHyperlinkParameters() {
        return ((JRChart)this.parent).getHyperlinkParameters();
    }

    public String getLinkType() {
        return ((JRChart)this.parent).getLinkType();
    }

    public JRExpression getHyperlinkTooltipExpression() {
        return ((JRChart)this.parent).getHyperlinkTooltipExpression();
    }

    protected JFreeChartRenderer getCategoryRenderer(JFreeChart chart) {
        JRFillCategoryDataset categoryDataset = (JRFillCategoryDataset)this.getDataset();
        JFreeChartRenderer chartRenderer = categoryDataset.hasItemHyperlinks() ? new JRCategoryChartImageMapRenderer(chart, categoryDataset.getItemHyperlinks()) : new JFreeChartRenderer(chart);
        return chartRenderer;
    }

    protected JFreeChartRenderer getPieRenderer(JFreeChart chart) {
        JRFillPieDataset pieDataset = (JRFillPieDataset)this.getDataset();
        JFreeChartRenderer chartRenderer = pieDataset.hasSectionHyperlinks() ? new JRPieChartImageMapRenderer(chart, pieDataset.getSectionHyperlinks()) : new JFreeChartRenderer(chart);
        return chartRenderer;
    }

    protected JFreeChartRenderer getXYRenderer(JFreeChart chart) {
        JRFillXyDataset xyDataset = (JRFillXyDataset)this.getDataset();
        JFreeChartRenderer chartRenderer = xyDataset.hasItemHyperlinks() ? new JRXYChartImageMapRenderer(chart, xyDataset.getItemHyperlinks()) : new JFreeChartRenderer(chart);
        return chartRenderer;
    }

    protected JFreeChartRenderer getXYBarRenderer(JFreeChart chart) {
        JFreeChartRenderer chartRenderer = this.getDataset().getDatasetType() == 6 ? this.getTimeSeriesRenderer(chart) : (this.getDataset().getDatasetType() == 5 ? this.getTimePeriodRenderer(chart) : (this.getDataset().getDatasetType() == 3 ? this.getXYRenderer(chart) : new JFreeChartRenderer(chart)));
        return chartRenderer;
    }

    protected JFreeChartRenderer getXYZRenderer(JFreeChart chart) {
        JRFillXyzDataset xyDataset = (JRFillXyzDataset)this.getDataset();
        JFreeChartRenderer chartRenderer = xyDataset.hasItemHyperlinks() ? new JRXYChartImageMapRenderer(chart, xyDataset.getItemHyperlinks()) : new JFreeChartRenderer(chart);
        return chartRenderer;
    }

    protected JFreeChartRenderer getHighLowRenderer(JFreeChart chart) {
        JRFillHighLowDataset hlDataset = (JRFillHighLowDataset)this.getDataset();
        JFreeChartRenderer chartRenderer = hlDataset.hasItemHyperlink() ? new JRHighLowChartImageMapRenderer(chart, hlDataset.getItemHyperlinks()) : new JFreeChartRenderer(chart);
        return chartRenderer;
    }

    protected JFreeChartRenderer getTimeSeriesRenderer(JFreeChart chart) {
        JRFillTimeSeriesDataset tsDataset = (JRFillTimeSeriesDataset)this.getDataset();
        JFreeChartRenderer chartRenderer = tsDataset.hasItemHyperlinks() ? new JRTimeSeriesChartImageMapRenderer(chart, tsDataset.getItemHyperlinks()) : new JFreeChartRenderer(chart);
        return chartRenderer;
    }

    protected JFreeChartRenderer getTimePeriodRenderer(JFreeChart chart) {
        JRFillTimePeriodDataset tpDataset = (JRFillTimePeriodDataset)this.getDataset();
        JFreeChartRenderer chartRenderer = tpDataset.hasItemHyperlinks() ? new JRTimePeriodChartImageMapRenderer(chart, tpDataset.getItemHyperlinks()) : new JFreeChartRenderer(chart);
        return chartRenderer;
    }

    private static RectangleEdge getEdge(byte position) {
        RectangleEdge edge = RectangleEdge.TOP;
        switch (position) {
            case 1: {
                edge = RectangleEdge.TOP;
                break;
            }
            case 2: {
                edge = RectangleEdge.BOTTOM;
                break;
            }
            case 3: {
                edge = RectangleEdge.LEFT;
                break;
            }
            case 4: {
                edge = RectangleEdge.RIGHT;
            }
        }
        return edge;
    }
}

