/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.pagamentos;

import classes.hL;
import classes.hk;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.pagamentos.Pagamento;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;

public class Pagamentos
extends Colecao {
    private static final String VALOR_PAGO_ALTO = "50.000,00";
    public transient IdentificadorDeclaracao identificadorDeclaracao;
    private Valor totalDeducoesInstrucao;
    private Valor totalContribuicaoFAPI;
    private Valor totalDespesasMedicas;
    private Valor totalPensao;
    private Valor totalPensaoCartoral;
    private Valor totalDeducaoIncentivo;
    private Valor totalContribEmpregadoDomestico;
    private Alfa ultimoIndiceGerado;
    private static long geradorIndices;
    private WeakReference declaracaoRef;
    public static Class a;

    public Pagamentos(DeclaracaoIRPF declaracaoIRPF) {
        Class<?> clazz = a;
        if (clazz == null) {
            try {
                clazz = a = Class.forName("serpro.ppgd.irpf.pagamentos.Pagamento");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(clazz.getName());
        this.identificadorDeclaracao = null;
        this.totalDeducoesInstrucao = new Valor((ObjetoNegocio)this, "");
        this.totalContribuicaoFAPI = new Valor((ObjetoNegocio)this, "");
        this.totalDespesasMedicas = new Valor((ObjetoNegocio)this, "");
        this.totalPensao = new Valor((ObjetoNegocio)this, "");
        this.totalPensaoCartoral = new Valor((ObjetoNegocio)this, "");
        this.totalDeducaoIncentivo = new Valor((ObjetoNegocio)this, "");
        this.totalContribEmpregadoDomestico = new Valor((ObjetoNegocio)this, "");
        this.ultimoIndiceGerado = new Alfa();
        this.declaracaoRef = null;
        this.declaracaoRef = new WeakReference<DeclaracaoIRPF>(declaracaoIRPF);
        this.identificadorDeclaracao = declaracaoIRPF.getIdentificadorDeclaracao();
        this.setFicha("Pagamentos e Doa\u00e7\u00f5es Efetuados");
        this.inicializaGeradorIndices();
    }

    public void inicializaGeradorIndices() {
        geradorIndices = this.ultimoIndiceGerado.asString().trim().equals("") ? 0L : Long.parseLong(this.ultimoIndiceGerado.asString());
    }

    private String proximoIndice() {
        this.ultimoIndiceGerado.setConteudo("" + geradorIndices++);
        return this.ultimoIndiceGerado.asString();
    }

    public void objetoInserido(Object object) {
        ((ObjetoNegocio)object).setFicha(this.getFicha());
    }

    public ObjetoNegocio instanciaNovoObjeto() {
        Pagamento pagamento = new Pagamento((DeclaracaoIRPF)((Object)this.declaracaoRef.get()));
        pagamento.getIndice().setConteudo(this.proximoIndice());
        return pagamento;
    }

    public Valor getTotalDeducoesInstrucao() {
        return this.totalDeducoesInstrucao;
    }

    public Valor getTotalContribuicaoFAPI() {
        return this.totalContribuicaoFAPI;
    }

    public Valor getTotalDespesasMedicas() {
        return this.totalDespesasMedicas;
    }

    public Valor getTotalPensao() {
        return this.totalPensao;
    }

    public Valor getTotalPensaoCartoral() {
        return this.totalPensaoCartoral;
    }

    public Valor getTotalDeducaoIncentivo() {
        return this.totalDeducaoIncentivo;
    }

    public boolean existeValorPagoAlto() {
        Iterator iterator = this.recuperarLista().iterator();
        while (iterator.hasNext()) {
            Pagamento pagamento = (Pagamento)iterator.next();
            if (!pagamento.getValorPago().comparacao(">", VALOR_PAGO_ALTO)) continue;
            return true;
        }
        return false;
    }

    public String recuperarCpfMaiorPensaoAlimenticia() {
        Iterator iterator = this.recuperarLista().iterator();
        String string = "";
        Valor valor = null;
        while (iterator.hasNext()) {
            Pagamento pagamento = (Pagamento)iterator.next();
            if (!pagamento.getCodigo().asString().equals("30") && (!pagamento.getCodigo().asString().equals("33") || pagamento.getNiBeneficiario().asString().trim().length() < 11)) continue;
            if (valor == null) {
                valor = pagamento.getValorPago();
                string = pagamento.getNiBeneficiario().asString().substring(0, 11);
                continue;
            }
            if (!pagamento.getValorPago().comparacao(">", valor)) continue;
            valor = pagamento.getValorPago();
            string = pagamento.getNiBeneficiario().asString().substring(0, 11);
        }
        return string;
    }

    public String recuperarCpfMaiorEmpregadaDomestica() {
        Iterator iterator = this.recuperarLista().iterator();
        String string = "";
        Valor valor = null;
        while (iterator.hasNext()) {
            Pagamento pagamento = (Pagamento)iterator.next();
            if (!pagamento.getCodigo().asString().equals("50") || pagamento.getNiBeneficiario().asString().trim().length() < 11) continue;
            if (valor == null) {
                valor = pagamento.getValorPago();
                string = pagamento.getNiBeneficiario().asString().substring(0, 11);
                continue;
            }
            if (!pagamento.getValorPago().comparacao(">", valor)) continue;
            valor = pagamento.getValorPago();
            string = pagamento.getNiBeneficiario().asString().substring(0, 11);
        }
        return string;
    }

    public NI recuperarNIMaiorDespMedicas() {
        hk hk2;
        hk hk3;
        Hashtable<String, hk> hashtable = new Hashtable<String, hk>();
        List list = this.recuperarLista();
        int n2 = 0;
        while (n2 < this.recuperarLista().size()) {
            Pagamento pagamento = (Pagamento)list.get(n2);
            if (pagamento.getCodigo().toString().equals("10") || pagamento.getCodigo().toString().equals("20") || pagamento.getCodigo().toString().equals("26")) {
                hk3 = new Valor();
                if (pagamento.getValorPago().comparacao(">=", pagamento.getParcelaNaoDedutivel())) {
                    hk3.append('+', pagamento.getValorPago());
                    hk3.append('-', pagamento.getParcelaNaoDedutivel());
                }
                if ((hk2 = (hk)hashtable.get(pagamento.getNiBeneficiario())) == null) {
                    hk2 = new hk(this);
                    hk2.a = hk3;
                    hk2.c = pagamento.getNiBeneficiario();
                    hashtable.put(hk2.c.asString(), hk2);
                } else {
                    hk2.a.append('+', (Valor)hk3);
                }
            }
            ++n2;
        }
        Iterator iterator = hashtable.values().iterator();
        hk3 = null;
        if (iterator.hasNext()) {
            hk3 = (hk)iterator.next();
            while (iterator.hasNext()) {
                hk2 = (hk)iterator.next();
                if (!hk2.a.comparacao(">", hk3.a)) continue;
                hk3 = hk2;
            }
        }
        if (hk3 == null) {
            return new NI((ObjetoNegocio)this, "");
        }
        return hk3.c;
    }

    public NI recuperarNISegundoMaiorDespMedicas() {
        hL hL2;
        hL hL3;
        Hashtable<String, hL> hashtable = new Hashtable<String, hL>();
        List list = this.recuperarLista();
        int n2 = 0;
        while (n2 < this.recuperarLista().size()) {
            Pagamento pagamento = (Pagamento)list.get(n2);
            if (pagamento.getCodigo().toString().equals("10") || pagamento.getCodigo().toString().equals("20") || pagamento.getCodigo().toString().equals("26")) {
                hL3 = new Valor();
                if (pagamento.getValorPago().comparacao(">=", pagamento.getParcelaNaoDedutivel())) {
                    hL3.append('+', pagamento.getValorPago());
                    hL3.append('-', pagamento.getParcelaNaoDedutivel());
                }
                if ((hL2 = (hL)hashtable.get(pagamento.getNiBeneficiario())) == null) {
                    hL2 = new hL(this);
                    hL2.a = hL3;
                    hL2.c = pagamento.getNiBeneficiario();
                    hashtable.put(hL2.c.asString(), hL2);
                } else {
                    hL2.a.append('+', (Valor)hL3);
                }
            }
            ++n2;
        }
        Iterator iterator = hashtable.values().iterator();
        hL3 = null;
        hL2 = null;
        if (iterator.hasNext()) {
            hL3 = (hL)iterator.next();
            while (iterator.hasNext()) {
                hL hL4 = (hL)iterator.next();
                if (hL4.a.comparacao(">", hL3.a)) {
                    hL2 = hL3;
                    hL3 = hL4;
                    continue;
                }
                if (hL2 != null && !hL4.a.comparacao(">", hL2.a)) continue;
                hL2 = hL4;
            }
        }
        if (hL2 == null) {
            return new NI((ObjetoNegocio)this, "");
        }
        return hL2.c;
    }

    public boolean possuiDependente(String string) {
        this.excluirRegistrosEmBranco();
        Iterator iterator = this.recuperarLista().iterator();
        while (iterator.hasNext()) {
            Pagamento pagamento = (Pagamento)iterator.next();
            if (!pagamento.getDependenteOuAlimentando().asString().equals(string) || !pagamento.getTipo().asString().equals(Pagamento.TIPO_DEPENDENTE)) continue;
            return true;
        }
        return false;
    }

    public void excluirPagamentosComDependente(String string) {
        this.excluirRegistrosEmBranco();
        Iterator iterator = this.recuperarLista().iterator();
        while (iterator.hasNext()) {
            Pagamento pagamento = (Pagamento)iterator.next();
            if (!pagamento.getDependenteOuAlimentando().asString().equals(string) || !pagamento.getTipo().asString().equals(Pagamento.TIPO_DEPENDENTE)) continue;
            iterator.remove();
        }
    }

    public void excluirPagamentosComAlimentando(String string) {
        this.excluirRegistrosEmBranco();
        Iterator iterator = this.recuperarLista().iterator();
        while (iterator.hasNext()) {
            Pagamento pagamento = (Pagamento)iterator.next();
            if (!pagamento.getDependenteOuAlimentando().asString().equals(string) || !pagamento.getTipo().asString().equals(Pagamento.TIPO_ALIMENTANDO)) continue;
            iterator.remove();
        }
    }

    public boolean existePagamentosComAlimentando(String string) {
        this.excluirRegistrosEmBranco();
        Iterator iterator = this.recuperarLista().iterator();
        while (iterator.hasNext()) {
            Pagamento pagamento = (Pagamento)iterator.next();
            if (!pagamento.getDependenteOuAlimentando().asString().equals(string) || !pagamento.getTipo().asString().equals(Pagamento.TIPO_ALIMENTANDO)) continue;
            return true;
        }
        return false;
    }

    public int obterTotalDependentesEnvolvidos() {
        HashSet<String> hashSet = new HashSet<String>();
        this.excluirRegistrosEmBranco();
        Iterator iterator = this.recuperarLista().iterator();
        while (iterator.hasNext()) {
            Pagamento pagamento = (Pagamento)iterator.next();
            if (pagamento.getDependenteOuAlimentando().isVazio() || pagamento.getCodigo().isVazio() || !pagamento.ehDependenteBrasil() && !pagamento.ehDependenteExterior()) continue;
            hashSet.add(pagamento.getDependenteOuAlimentando().getConteudoFormatado());
        }
        int n2 = 0;
        if (!hashSet.isEmpty()) {
            n2 = hashSet.size();
        }
        return n2;
    }

    public int obterTotalAlimentandosEnvolvidos() {
        HashSet<String> hashSet = new HashSet<String>();
        this.excluirRegistrosEmBranco();
        Iterator iterator = this.recuperarLista().iterator();
        while (iterator.hasNext()) {
            Pagamento pagamento = (Pagamento)iterator.next();
            if (pagamento.getDependenteOuAlimentando().isVazio() || pagamento.getCodigo().isVazio() || !pagamento.ehAlimentandoBrasil() && !pagamento.ehAlimentandoExterior()) continue;
            hashSet.add(pagamento.getDependenteOuAlimentando().getConteudoFormatado());
        }
        int n2 = 0;
        if (!hashSet.isEmpty()) {
            n2 = hashSet.size();
        }
        return n2;
    }

    public void setTotalContribEmpregadoDomestico(Valor valor) {
        this.totalContribEmpregadoDomestico = valor;
    }

    public Valor getTotalContribEmpregadoDomestico() {
        return this.totalContribEmpregadoDomestico;
    }
}

