/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.pagamentos;

import classes.aQ;
import classes.ag;
import classes.cE;
import classes.dL;
import classes.dX;
import classes.hC;
import classes.hN;
import classes.jo;
import classes.ky;
import classes.le;
import classes.lf;
import classes.ls;
import classes.mI;
import classes.s;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.List;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;

public class Pagamento
extends ObjetoNegocio
implements jo {
    public static final String PAGAMENTO_PROPRIAINSTRUCAO_BR = "01";
    public static final String PAGAMENTO_PROPRIAINSTRUCAO_EX = "02";
    public static final String PAGAMENTO_INSTRUCAODEPEND_BR = "01";
    public static final String PAGAMENTO_INSTRUCAODEPEND_EX = "02";
    public static final String PAGAMENTO_INSTRUCAOALIMENT_BR = "01";
    public static final String PAGAMENTO_INSTRUCAOALIMENT_EX = "02";
    public static final String PAGAMENTO_MEDICO_BR = "10";
    public static final String PAGAMENTO_MEDICO_EX = "11";
    public static final String PAGAMENTO_HOSPITAL_BR = "20";
    public static final String PAGAMENTO_HOSPITAL_EX = "21";
    public static final String PAGAMENTO_PLANOSAUDE_BR = "26";
    public static final String PAGAMENTO_PENSAOALIMENTICIA = "30";
    public static final String PAGAMENTO_PENSAODIVORCIO = "33";
    public static final String PAGAMENTO_PREVIPRIVADA = "36";
    public static final String PAGAMENTO_FAPI = "38";
    public static final String PAGAMENTO_ESTATCRIANCA = "40";
    public static final String PAGAMENTO_CULTURA = "41";
    public static final String PAGAMENTO_AUDIOVISUAIS = "42";
    public static final String PAGAMENTO_DESPORTO = "43";
    public static final String PAGAMENTO_CONTRIBUICAO_PATRONAL = "50";
    public static final String PAGAMENTO_ADVOGADOS = "60";
    public static final String PAGAMENTO_ADVOGADOS_TRAB = "61";
    public static final String PAGAMENTO_ADVOGADOS_HONORARIOS = "62";
    public static final String PAGAMENTO_PROFLIBERAL = "66";
    public static final String PAGAMENTO_ALUGUEIS = "70";
    public static final String PAGAMENTO_ARRENDRURAL = "76";
    public static final String PAGAMENTO_DOACOES_ESPECIE = "80";
    public static final String PAGAMENTO_DOACOES_BENS = "81";
    public static final String PAGAMENTO_OUTROS = "99";
    public static final String PERC_LIMITE_DEDUCAO_CONTRIBUICAO_PREV_PRIV_FAPI = "0,12";
    public static final String PERC_LIMITE_DEDUCAO_INCENTIVO = "0,06";
    public static final String LIMITE_DESPESAS_INSTRUCAO = "2.592,29";
    public static final String NOME_CODIGO = "C\u00f3digo";
    public static final String NOME_TIPO = "Tipo";
    private Codigo codigo = new Codigo((ObjetoNegocio)this, "C\u00f3digo", s.g());
    private Alfa dependenteOuAlimentando = new Alfa((ObjetoNegocio)this, "Dependente/Alimentando", 60);
    private Alfa nomeBeneficiario = new Alfa((ObjetoNegocio)this, "Nome do Benefici\u00e1rio", 60);
    private NI niBeneficiario = new NI((ObjetoNegocio)this, "Erro!");
    private mI valorPago = new mI(this, "Valor Pago");
    private mI parcelaNaoDedutivel = new mI(this, "Parcela N\u00e3o Dedut\u00edvel/Valor Reembolsado");
    private Alfa nitEmpregadoDomestico = new Alfa((ObjetoNegocio)this, "NIT do empregado dom\u00e9stico");
    private Alfa indice = new Alfa((ObjetoNegocio)this, "\u00cdndice");
    private Alfa tipo = new Alfa((ObjetoNegocio)this, "Tipo");
    public static String TIPO_TITULAR = "T";
    public static String TIPO_DEPENDENTE = "D";
    public static String TIPO_ALIMENTANDO = "A";
    public static String TIPO_PADRAO = TIPO_TITULAR;
    public transient IdentificadorDeclaracao identificadorDeclaracao = null;
    private WeakReference declaracaoRef = null;

    public Pagamento(DeclaracaoIRPF declaracaoIRPF) {
        this.identificadorDeclaracao = declaracaoIRPF.getIdentificadorDeclaracao();
        this.declaracaoRef = new WeakReference<DeclaracaoIRPF>(declaracaoIRPF);
        this.tipo.addObservador((Observador)new ky(this));
        this.getCodigo().setColunaFiltro(1);
        this.nitEmpregadoDomestico.setHabilitado(false);
        this.getDependenteOuAlimentando().addValidador((ValidadorIf)new dX(this, 3));
        this.getNitEmpregadoDomestico().addValidador((ValidadorIf)new ag(this, 3, this.tab.msg("pagamento_NIT_branco")));
        this.getNitEmpregadoDomestico().addValidador((ValidadorIf)new le(this, 3, this.tab.msg("pagamento_NIT")));
        this.getCodigo().addValidador((ValidadorIf)new hC(this, 3, this.tab.msg("pagamento_codigo")));
        this.getNomeBeneficiario().addValidador((ValidadorIf)new dL(this, 3, ""));
        this.getNiBeneficiario().addValidador((ValidadorIf)new aQ(this, 3));
        this.getParcelaNaoDedutivel().addValidador((ValidadorIf)new ls(this, 3));
        this.getValorPago().addValidador((ValidadorIf)new hN(this, 3));
        this.getDependenteOuAlimentando().addValidador((ValidadorIf)new cE(this, 3, this.tab.msg("pagamento_dependente_alimentando")));
        this.getNiBeneficiario().addValidador((ValidadorIf)new lf(this, 3));
    }

    public Codigo getCodigo() {
        return this.codigo;
    }

    public NI getNiBeneficiario() {
        return this.niBeneficiario;
    }

    public Alfa getNomeBeneficiario() {
        return this.nomeBeneficiario;
    }

    public Valor getParcelaNaoDedutivel() {
        return this.parcelaNaoDedutivel;
    }

    public Valor getValorPago() {
        return this.valorPago;
    }

    public Alfa getDependenteOuAlimentando() {
        return this.dependenteOuAlimentando;
    }

    public List recuperarListaCamposPendencia() {
        List list = super.recuperarListaCamposPendencia();
        list.add(this.codigo);
        list.add(this.dependenteOuAlimentando);
        list.add(this.nomeBeneficiario);
        list.add(this.niBeneficiario);
        list.add(this.nitEmpregadoDomestico);
        list.add(this.valorPago);
        list.add(this.parcelaNaoDedutivel);
        return list;
    }

    public void setNitEmpregadoDomestico(Alfa alfa) {
        this.nitEmpregadoDomestico = alfa;
    }

    public Alfa getNitEmpregadoDomestico() {
        return this.nitEmpregadoDomestico;
    }

    public boolean isVazio() {
        Iterator iterator = this.recuperarCamposInformacao().iterator();
        while (iterator.hasNext()) {
            Informacao informacao = (Informacao)iterator.next();
            if (informacao.isVazio() || informacao.getNomeCampo().equals("\u00cdndice") || informacao.getNomeCampo().equals(NOME_TIPO)) continue;
            return false;
        }
        return true;
    }

    public int compareTo(Object object) {
        Pagamento pagamento = (Pagamento)object;
        int n2 = pagamento.getCodigo().asInteger();
        return n2 - this.getCodigo().asInteger();
    }

    public String getChave() {
        return this.getCodigo().asString();
    }

    public Alfa getIndice() {
        return this.indice;
    }

    public Alfa getTipo() {
        return this.tipo;
    }

    public boolean ehTitularBrasil() {
        return this.getTipo().asString().equals(TIPO_TITULAR) && this.getCodigo().asString().equals("01");
    }

    public boolean ehTitularExterior() {
        return this.getTipo().asString().equals(TIPO_TITULAR) && this.getCodigo().asString().equals("02");
    }

    public boolean ehDependenteBrasil() {
        return this.getTipo().asString().equals(TIPO_DEPENDENTE) && this.getCodigo().asString().equals("01");
    }

    public boolean ehDependenteExterior() {
        return this.getTipo().asString().equals(TIPO_DEPENDENTE) && this.getCodigo().asString().equals("02");
    }

    public boolean ehAlimentandoBrasil() {
        return this.getTipo().asString().equals(TIPO_ALIMENTANDO) && this.getCodigo().asString().equals("01");
    }

    public boolean ehAlimentandoExterior() {
        return this.getTipo().asString().equals(TIPO_ALIMENTANDO) && this.getCodigo().asString().equals("02");
    }

    public static WeakReference c(Pagamento pagamento) {
        return pagamento.declaracaoRef;
    }

    public static Alfa b(Pagamento pagamento) {
        return pagamento.tipo;
    }

    public static NI a(Pagamento pagamento) {
        return pagamento.niBeneficiario;
    }
}

