/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.bens;

import classes.Q;
import classes.bN;
import classes.jo;
import classes.mI;
import classes.s;
import java.util.Iterator;
import java.util.List;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class Bem
extends ObjetoNegocio
implements jo {
    public static final String NOME_CAMPO_VALOR_ANTERIOR = "Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.EXERCICIO_ANTERIOR;
    public static final String NOME_CAMPO_VALOR_ATUAL = "Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.EXERCICIO;
    public static final String NOME_CAMPO_LOCAL_PAIS = "Localiza\u00e7\u00e3o(Pa\u00eds)";
    private Codigo codigo = new Codigo((ObjetoNegocio)this, "C\u00f3digo", s.d());
    private Codigo pais = new Codigo((ObjetoNegocio)this, "Localiza\u00e7\u00e3o(Pa\u00eds)", s.j());
    private Alfa nomePais = new Alfa((ObjetoNegocio)this, "Nome Pa\u00eds", 200);
    private Alfa discriminacao = new Alfa((ObjetoNegocio)this, "Discrimina\u00e7\u00e3o", 510);
    private mI valorExercicioAnterior = new mI(this, NOME_CAMPO_VALOR_ANTERIOR);
    private mI valorExercicioAtual = new mI(this, NOME_CAMPO_VALOR_ATUAL);
    public static final String BRASIL = "0";
    public static final String EXTERIOR = "1";
    private Alfa indice = new Alfa((ObjetoNegocio)this, "Indice");

    public Bem() {
        this.getCodigo().setColunaFiltro(1);
        this.getPais().setColunaFiltro(1);
        if (this.getPais().isVazio()) {
            this.getPais().setConteudo("105");
            this.nomePais.setConteudo("Brasil");
        }
        this.getCodigo().addValidador((ValidadorIf)new ValidadorNaoNulo(3, this.tab.msg("bem_codigo")));
        this.getDiscriminacao().addValidador((ValidadorIf)new ValidadorNaoNulo(3, this.tab.msg("bem_discriminacao")));
        this.getPais().addValidador((ValidadorIf)new ValidadorNaoNulo(3, this.tab.msg("bem_pais_branco")));
        this.getPais().addValidador((ValidadorIf)new Q(this, 3));
        this.getPais().addObservador((Observador)new bN(this));
    }

    public boolean isVazio() {
        Iterator iterator = this.recuperarCamposInformacao().iterator();
        while (iterator.hasNext()) {
            Informacao informacao = (Informacao)iterator.next();
            if (informacao.isVazio() || informacao.getNomeCampo().equals("Indice") || informacao.getNomeCampo().equals(NOME_CAMPO_LOCAL_PAIS) || informacao.getNomeCampo().equals("Nome Pa\u00eds")) continue;
            return false;
        }
        return true;
    }

    public Codigo getCodigo() {
        return this.codigo;
    }

    public Alfa getDiscriminacao() {
        return this.discriminacao;
    }

    public Codigo getPais() {
        return this.pais;
    }

    public Valor getValorExercicioAnterior() {
        return this.valorExercicioAnterior;
    }

    public Valor getValorExercicioAtual() {
        return this.valorExercicioAtual;
    }

    public List recuperarListaCamposPendencia() {
        List list = super.recuperarListaCamposPendencia();
        list.add(this.codigo);
        list.add(this.pais);
        list.add(this.discriminacao);
        list.add(this.valorExercicioAtual);
        list.add(this.valorExercicioAnterior);
        return list;
    }

    public List verificarPendencias(int n2) {
        List list = super.verificarPendencias(n2);
        if (this.getValorExercicioAtual().isVazio() && this.getValorExercicioAnterior().isVazio()) {
            Pendencia pendencia = new Pendencia(2, (Informacao)this.getValorExercicioAnterior(), this.getValorExercicioAnterior().getNomeCampo(), this.tab.msg("bem_valor_nao_informado"), n2);
            list.add(pendencia);
        }
        return list;
    }

    public String getChave() {
        return this.getCodigo().asString();
    }

    public int compareTo(Object object) {
        Bem bem = (Bem)object;
        int n2 = bem.getCodigo().asInteger();
        return n2 - this.getCodigo().asInteger();
    }

    public Alfa getIndice() {
        return this.indice;
    }

    public static Codigo b(Bem bem) {
        return bem.pais;
    }

    public static Alfa a(Bem bem) {
        return bem.nomePais;
    }
}

