/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.repositorio.repositorioXML;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.IdDeclaracao;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.UtilitariosArquivo;
import serpro.ppgd.repositorio.RepositorioException;
import serpro.ppgd.repositorio.RepositorioObjetoNegocioIf;
import serpro.ppgd.repositorio.repositorioXML.HashtableIdDeclaracao;
import serpro.ppgd.repositorio.repositorioXML.MapeamentoObjetoNegocioXML;
import serpro.ppgd.repositorio.repositorioXML.RepositorioXMLException;

public class RepositorioObjetoNegocioXML
implements RepositorioObjetoNegocioIf {
    private MapeamentoObjetoNegocioXML mapeamento;
    private HashtableIdDeclaracao objetosIRPFAbertos = new HashtableIdDeclaracao();
    private String diretorioDados = FabricaUtilitarios.getPathCompletoDirDadosAplicacao();
    private Class classePrincipal = class$serpro$ppgd$negocio$impl$IdDeclaracaoImpl == null ? (class$serpro$ppgd$negocio$impl$IdDeclaracaoImpl = RepositorioObjetoNegocioXML.class$("serpro.ppgd.negocio.impl.IdDeclaracaoImpl")) : class$serpro$ppgd$negocio$impl$IdDeclaracaoImpl;
    static /* synthetic */ Class class$serpro$ppgd$negocio$impl$IdDeclaracaoImpl;
    static /* synthetic */ Class class$serpro$ppgd$negocio$IdDeclaracao;
    static /* synthetic */ Class class$serpro$ppgd$negocio$ObjetoNegocio;

    private RepositorioObjetoNegocioXML() {
    }

    public RepositorioObjetoNegocioXML(String pClassePrincipal) {
        try {
            this.classePrincipal = Class.forName(pClassePrincipal);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void descarregar(IdDeclaracao id) throws RepositorioException {
        if (this.objetosIRPFAbertos.containsKey(id)) {
            this.objetosIRPFAbertos.remove(id);
        }
    }

    public ObjetoNegocio recuperar(IdDeclaracao id) throws RepositorioException {
        if (this.objetosIRPFAbertos.containsKey(id)) {
            return (ObjetoNegocio)this.objetosIRPFAbertos.get(id);
        }
        Document arquivoDados = this.leArquivo(id.getPathArquivo(this.diretorioDados));
        if (arquivoDados == null) {
            throw new RepositorioException("Arquivo de dados n\u00e3o encontrado.");
        }
        ObjetoNegocio resultado = null;
        resultado = this.instanciaObjetoNegocio(this.classePrincipal, id);
        this.preencheObjetoNegocio(arquivoDados.getDocumentElement(), null, resultado);
        this.objetosIRPFAbertos.put(id, resultado);
        return resultado;
    }

    private void preencheObjetoNegocio(Element nodoAtual, Element nodoPai, ObjetoNegocio objetoNegocio) throws RepositorioXMLException {
        NamedNodeMap namedNodeMap = nodoAtual.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node item = namedNodeMap.item(i);
            try {
                Informacao info = (Informacao)FabricaUtilitarios.getValorFieldGenerico((String)item.getNodeName(), (Object)objetoNegocio);
                info.setConteudo(item.getNodeValue());
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (objetoNegocio instanceof Colecao) {
            this.preencheColecao(nodoAtual, (Colecao)objetoNegocio);
        } else {
            NodeList nodeList = nodoAtual.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Object valObtido;
                Node nodo = nodeList.item(i);
                if (!(nodo instanceof Element) || (valObtido = FabricaUtilitarios.getValorFieldGenerico((String)nodo.getNodeName(), (Object)objetoNegocio)) instanceof IdDeclaracao) continue;
                ObjetoNegocio obj = (ObjetoNegocio)valObtido;
                this.preencheObjetoNegocio((Element)nodo, nodoAtual, obj);
            }
        }
    }

    private void preencheColecao(Element nodoAtual, Colecao colecao) throws RepositorioXMLException {
        NamedNodeMap namedNodeMap = nodoAtual.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node item = namedNodeMap.item(i);
            try {
                Informacao info = (Informacao)FabricaUtilitarios.getValorFieldGenerico((String)item.getNodeName(), (Object)colecao);
                info.setConteudo(item.getNodeValue());
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Class tipoItens = colecao.getTipoItens();
        NodeList nodeList = nodoAtual.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node nodo = nodeList.item(i);
            if (!(nodo instanceof Element) || !nodo.getNodeName().equals("item")) continue;
            ObjetoNegocio obj = this.instanciaObjetoNegocio(tipoItens, colecao.getIdDeclaracao());
            colecao.recuperarLista().add(obj);
            this.preencheObjetoNegocio((Element)nodo, nodoAtual, obj);
        }
    }

    private ObjetoNegocio instanciaObjetoNegocio(Class classeAInstanciar, IdDeclaracao id) throws RepositorioXMLException {
        ObjetoNegocio resultado = null;
        Object[] argumentosReais = new Object[]{id};
        try {
            Class[] argumentosFormais = new Class[]{Class.forName((class$serpro$ppgd$negocio$IdDeclaracao == null ? (class$serpro$ppgd$negocio$IdDeclaracao = RepositorioObjetoNegocioXML.class$("serpro.ppgd.negocio.IdDeclaracao")) : class$serpro$ppgd$negocio$IdDeclaracao).getName())};
            if (!Class.forName((class$serpro$ppgd$negocio$ObjetoNegocio == null ? (class$serpro$ppgd$negocio$ObjetoNegocio = RepositorioObjetoNegocioXML.class$("serpro.ppgd.negocio.ObjetoNegocio")) : class$serpro$ppgd$negocio$ObjetoNegocio).getName()).isAssignableFrom(classeAInstanciar)) {
                throw new RepositorioXMLException("Mapeamento incorreto: classe n\u00e3o \u00e9 ObjetoNegocio");
            }
            Constructor construtor = classeAInstanciar.getConstructor(argumentosFormais);
            resultado = (ObjetoNegocio)construtor.newInstance(argumentosReais);
            return resultado;
        }
        catch (InvocationTargetException e) {
            LogPPGD.erro((String)("Exce\u00e7\u00e3o levantada por m\u00e9todo invocado  pela instrospec\u00e7\u00e3o: " + e.getMessage()));
            throw new RepositorioXMLException(e);
        }
        catch (Exception e) {
            LogPPGD.erro((String)"Mapeamento incorreto: classe n\u00e3o possui construtor (IdDeclaracao)");
            throw new RepositorioXMLException(e);
        }
    }

    private Document leArquivo(String pathArquivoDados) {
        Document declaracaoDOM = null;
        if (pathArquivoDados == null) {
            return null;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            declaracaoDOM = builder.parse(pathArquivoDados);
        }
        catch (SAXParseException e) {
            LogPPGD.erro((String)("Erro de parsing de " + e.getSystemId() + ". linha " + e.getLineNumber() + ": " + e.getMessage()));
        }
        catch (SAXException e) {
            Exception x = e;
            if (e.getException() != null) {
                x = e.getException();
            }
            LogPPGD.erro((String)("Erro de parsing: " + x.getMessage()));
        }
        catch (ParserConfigurationException e) {
            LogPPGD.erro((String)("Erro de configura\u00e7\u00e3o da f\u00e1brica DOM: " + e.getMessage()));
        }
        catch (IOException e) {
            LogPPGD.erro((String)("Erro de I/O: " + e.getMessage()));
        }
        return declaracaoDOM;
    }

    public ObjetoNegocio criar(IdDeclaracao id) throws RepositorioException {
        ObjetoNegocio resultado = null;
        if (id == null) {
            throw new IllegalArgumentException("RepositorioObjetoNegocioXML: argumento \u00e9 nulo.");
        }
        if (this.objetosIRPFAbertos.containsKey(id)) {
            throw new IllegalArgumentException("RepositorioObjetoNegocioXML: ObjetoNegocio solicitado j\u00e1 existe.");
        }
        resultado = this.instanciaObjetoNegocio(this.classePrincipal, id);
        this.objetosIRPFAbertos.put(id, resultado);
        return resultado;
    }

    private Document obterDOM(ObjetoNegocio objetoNegocio) throws RepositorioXMLException {
        Document declaracaoDOM = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            declaracaoDOM = builder.newDocument();
            Element root = declaracaoDOM.createElement("classe");
            declaracaoDOM.appendChild(root);
            root.setAttribute("classeJava", objetoNegocio.getClass().getName());
            root.setAttribute("xmlns", ConstantesGlobais.XMLNS);
            this.preencheElementoXML(declaracaoDOM, root, null, objetoNegocio);
            declaracaoDOM.normalize();
            return declaracaoDOM;
        }
        catch (ParserConfigurationException e) {
            LogPPGD.erro((String)("Erro de configura\u00e7\u00e3o da f\u00e1brica DOM: " + e.getMessage()));
            throw new RepositorioXMLException(e);
        }
    }

    private void preencheElementoXML(Document documentoXML, Element nodoAtual, Element nodoPai, ObjetoNegocio objetoNegocio) {
        if (nodoPai != null) {
            nodoPai.appendChild(nodoAtual);
        }
        Iterator itAtributos = FabricaUtilitarios.getAllFields(objetoNegocio.getClass()).iterator();
        while (itAtributos.hasNext()) {
            Field field = (Field)itAtributos.next();
            Object valorAtributo = FabricaUtilitarios.getValorFieldGenerico((String)field.getName(), (Object)objetoNegocio);
            if (valorAtributo instanceof IdDeclaracao) continue;
            if (valorAtributo instanceof Informacao) {
                if (valorAtributo == null || !((Informacao)valorAtributo).isAtributoPersistente()) continue;
                if (valorAtributo instanceof Codigo) {
                    nodoAtual.setAttribute(field.getName(), ((Informacao)valorAtributo).asString());
                    continue;
                }
                nodoAtual.setAttribute(field.getName(), ((Informacao)valorAtributo).getConteudoFormatado());
                continue;
            }
            if (!(valorAtributo instanceof ObjetoNegocio)) continue;
            if (!((ObjetoNegocio)valorAtributo).isPersistente()) {
                return;
            }
            Element novoNodo = documentoXML.createElement(field.getName());
            this.preencheElementoXML(documentoXML, novoNodo, nodoAtual, (ObjetoNegocio)valorAtributo);
            if (!(valorAtributo instanceof Colecao)) continue;
            novoNodo.setAttribute("tipoItens", ((Colecao)valorAtributo).getTipoItens().getName());
            this.preencheElementoXMLColecao(documentoXML, novoNodo, nodoAtual, (Colecao)valorAtributo);
        }
    }

    private void preencheElementoXMLColecao(Document documentoXML, Element nodoAtual, Element nodoPai, Colecao colecao) {
        Iterator itItems = colecao.recuperarLista().iterator();
        while (itItems.hasNext()) {
            Element novoNodo = documentoXML.createElement("item");
            ObjetoNegocio obj = (ObjetoNegocio)itItems.next();
            this.preencheElementoXML(documentoXML, novoNodo, nodoAtual, obj);
        }
    }

    public void salvar(IdDeclaracao id) throws RepositorioException {
        if (this.objetosIRPFAbertos.containsKey(id)) {
            ObjetoNegocio objetoIRPF = (ObjetoNegocio)this.objetosIRPFAbertos.get(id);
            try {
                Document cacheDados = this.obterDOM(objetoIRPF);
                File arquivoXML = new File(id.getPathArquivo(this.diretorioDados));
                FileOutputStream os = new FileOutputStream(arquivoXML);
                StreamResult result = new StreamResult(os);
                DOMSource source = new DOMSource(cacheDados);
                TransformerFactory transFactory = TransformerFactory.newInstance();
                Transformer transformer = transFactory.newTransformer();
                transformer.transform(source, result);
                os.close();
            }
            catch (TransformerConfigurationException tce) {
                LogPPGD.erro((String)"Erro de configura\u00e7\u00e3o da f\u00e1brica de transforma\u00e7\u00e3o DOM");
                throw new RepositorioXMLException(tce);
            }
            catch (TransformerException te) {
                LogPPGD.erro((String)"Erro de transforma\u00e7\u00e3o DOM-XML");
                throw new RepositorioXMLException(te);
            }
            catch (IOException ioe) {
                LogPPGD.erro((String)"Erro de IO");
                throw new RepositorioXMLException(ioe);
            }
        } else {
            throw new IllegalArgumentException("N\u00e3o h\u00e1 ObjetoNegocio correspondente a esse IdDeclaracao: " + id.getNiContribuinte());
        }
    }

    public void deletar(IdDeclaracao id) throws RepositorioException {
        String arq = id.getPathArquivo(this.diretorioDados);
        String path = UtilitariosArquivo.extraiPath((String)arq);
        File f = new File(arq);
        f.delete();
        f = new File(path);
        f.delete();
        if (this.objetosIRPFAbertos.containsKey(id)) {
            this.objetosIRPFAbertos.remove(id);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

