/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.repositorio.repositorioXML;

import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import serpro.ppgd.negocio.util.LogPPGD;

class AdaptadorXMLAtributo {
    private String elementoXML;
    private String metodoAcesso;
    private boolean marshalling = true;
    private boolean unmarshalling = true;

    public AdaptadorXMLAtributo(Element nodeXmlMapeamento) {
        if (!nodeXmlMapeamento.getNodeName().equals("Atributo")) {
            LogPPGD.erro((String)"Par\u00e2metro inv\u00e1lido - n\u00e3o \u00e9 Atributo");
            throw new IllegalArgumentException("N\u00e3o \u00e9 Atributo");
        }
        this.elementoXML = nodeXmlMapeamento.getAttribute("ElementoXML");
        if (this.elementoXML.length() == 0) {
            LogPPGD.erro((String)"Mapeamento inv\u00e1lido");
            throw new DOMException(12, "ElementoXML n\u00e3o pode ser vazio");
        }
        this.metodoAcesso = nodeXmlMapeamento.getAttribute("MetodoAcesso");
        if (this.metodoAcesso == "") {
            this.metodoAcesso = "get" + this.elementoXML;
        }
        if (nodeXmlMapeamento.getAttribute("Marshalling").toLowerCase().equals("false")) {
            this.marshalling = false;
        }
        if (nodeXmlMapeamento.getAttribute("Unmarshalling").toLowerCase().equals("false")) {
            this.unmarshalling = false;
        }
    }

    public String toString() {
        return "[Atributo: " + this.elementoXML + ", MetodoAcesso: " + this.metodoAcesso + "]";
    }

    public String getElementoXML() {
        return this.elementoXML;
    }

    public String getMetodoAcesso() {
        return this.metodoAcesso;
    }

    public boolean isMarshalling() {
        return this.marshalling;
    }

    public boolean isUnmarshalling() {
        return this.unmarshalling;
    }
}

