<?php
#
# HLstatsX - Real-time player and clan rankings and statistics for Half-Life 2
# http://www.hlstatsx.com/
# Copyright (C) 2005-2007 Tobias Oetzel (Tobi@hlstatsx.com)
#
# HlstatsX is an enhanced version of HLstats made by Simon Garner
# HLstats - Real-time player and clan rankings and statistics for Half-Life
# http://sourceforge.net/projects/hlstats/
# Copyright (C) 2001  Simon Garner
#             
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
	
	
	
	// Player Details
	
	$player = valid_request(intval($HTTP_GET_VARS["player"]), 1);
	$uniqueid  = valid_request(strval($HTTP_GET_VARS["uniqueid"]), 0);
	$game = valid_request(strval($HTTP_GET_VARS["game"]), 0);
    
    
	
	if (!$player && $uniqueid)
	{
		if (!$game)
		{
			header("Location: " . $g_options["scripturl"] . "&mode=search&st=uniqueid&q=$uniqueid");
			exit;
		}
		
		$db->query("
			SELECT
				playerId
			FROM
				hlstats_PlayerUniqueIds
			WHERE
				uniqueId='$uniqueid'
				AND game='$game'
		");
		
		if ($db->num_rows() > 1)
		{
			header("Location: " . $g_options["scripturl"] . "&mode=search&st=uniqueid&q=$uniqueid&game=$game");
			exit;
		}
		elseif ($db->num_rows() < 1)
		{
			error("No players found matching uniqueId '$uniqueid'");
		}
		else
		{
			list($player) = $db->fetch_row();
			$player = intval($player);
		}
	}
	elseif (!$player && !$uniqueid)
	{
		error("No player ID specified.");
	}
	
	$db->query("
		SELECT
			hlstats_Players.playerId,
      hlstats_Players.connection_time,
			hlstats_Players.lastName,
      hlstats_Players.country,
      hlstats_Players.flag,
			hlstats_Players.clan,
			hlstats_Players.fullName,
			hlstats_Players.email,
			hlstats_Players.homepage,
			hlstats_Players.icq,
			hlstats_Players.game,
      hlstats_Players.hideranking,
			hlstats_Players.skill,
			hlstats_Players.kills,
			hlstats_Players.deaths,
			IFNULL(kills/deaths, '-') AS kpd,
			hlstats_Players.suicides,
			hlstats_Players.headshots,
			IFNULL(headshots/kills, '-') AS hpk,
			hlstats_Players.shots,
			hlstats_Players.hits,
			IFNULL(ROUND((hits / shots * 100), 1), 0.0) AS acc,
			CONCAT(hlstats_Clans.name) AS clan_name,
      IF(".MINACTIVITY." > (UNIX_TIMESTAMP() - last_event), ((100/".MINACTIVITY.") * (".MINACTIVITY." - (UNIX_TIMESTAMP() - last_event))), 0) as activity
		FROM
			hlstats_Players
		LEFT JOIN hlstats_Clans ON
			hlstats_Clans.clanId = hlstats_Players.clan
		WHERE
			playerId='$player'
	");
	if ($db->num_rows() != 1)
		error("No such player '$player'.");
	
	$playerdata = $db->fetch_array();
	$db->free_result();
	
	$pl_name = $playerdata["lastName"];
	if (strlen($pl_name) > 10)
	{
		$pl_shortname = substr($pl_name, 0, 8) . "...";
	}
	else
	{
		$pl_shortname = $pl_name;
	}
	$pl_name = htmlentities($pl_name, ENT_COMPAT, "UTF-8");
	$pl_shortname = htmlentities($pl_shortname, ENT_COMPAT, "UTF-8");
	$pl_urlname = urlencode($playerdata["lastName"]);
	
	
	$game = $playerdata["game"];
	$db->query("SELECT name FROM hlstats_Games WHERE code='$game'");
	if ($db->num_rows() != 1)
		$gamename = ucfirst($game);
	else
		list($gamename) = $db->fetch_row();
	
	
	pageHeader(
		array($gamename, "Player Details", $pl_name),
		array(
			$gamename=>$g_options["scripturl"] . "?game=$game",
			"Player Rankings"=>$g_options["scripturl"] . "?mode=players&game=$game",
			"Player Details"=>""
		),
		$pl_name
	);
?>



<table width="100%" align="center" border=0 cellspacing=0 cellpadding=0>

<tr>
	<td width="100%" colspan=3><?php echo $g_options["font_normal"]; ?>&nbsp;<img src="<?php echo $g_options["imgdir"]; ?>/downarrow.gif" width=9 height=6 border=0 align="middle" alt="downarrow.gif"><b>&nbsp;Player Information</b><?php echo $g_options["fontend_normal"];?></td>
</tr>


<tr>
  <td width="100%" colspan=3 style="padding-left:25px;">&nbsp;<br>
  
  <table width="100%">
    <tr>
      <td width="50%" valign="top">
        <table width="90%" border=0 cellspacing=0 cellpadding=0 bgcolor="<?php echo $g_options["table_border"]; ?>">
    		<tr>
		    	<td>
                
				    <table width="100%" border=0 cellspacing=1 cellpadding=4>
            <tr valign="bottom" bgcolor="<?php echo $g_options["table_head_bgcolor"]; ?>">
              <td align="left" colspan="2"><?php
                echo $g_options["font_normal"];
                echo "<font color=\"".$g_options["table_head_text"]."\">Player Profile</font>";
                echo $g_options["fontend_normal"];
              ?></td>
            </tr>

            <tr bgcolor="<?php echo $g_options["table_bgcolor1"]; ?>">
                <td align="left"><?php
                    echo $g_options["font_normal"];
                    echo "Name:";
                    echo $g_options["fontend_normal"];
                ?></td>
                <td align="left"><?php
                    echo $g_options["font_normal"];
                    if (SHOW_FLAGS == 1) 
                      echo '<img src="'.$g_options["imgdir"].'/flags/'.flag_exists(strtolower($playerdata["flag"]).".gif").'" style="border:0px;" alt="'.strtolower($playerdata["country"]).'" title="'.strtolower($playerdata["country"]).'">&nbsp;';   
                    echo "<b>" . htmlentities($playerdata["lastName"], ENT_COMPAT, "UTF-8") . "</b>";
                    echo $g_options["fontend_normal"]; 
                ?></td>
            </tr>
    				<tr bgcolor="<?php echo $g_options["table_bgcolor2"]; ?>">
		    			<td align="left"><?php
			    			echo $g_options["font_normal"];
				    		echo "Member of Clan:";
						    echo $g_options["fontend_normal"];
    					?></td>
		    			<td align="left"><?php
				    		echo $g_options["font_normal"];
						    if ($playerdata["clan"]) {
		    					echo "&nbsp;<a href=\"" . $g_options["scripturl"]
				    				. "?mode=claninfo&clan=" . $playerdata["clan"]
						    		. "\">"
    								. htmlentities($playerdata["clan_name"], ENT_COMPAT, "UTF-8") . "</a>";
		    				}	else
							    echo "(None)";
		    				echo $g_options["fontend_normal"];
    					?></td>
    				</tr>
	
    				<tr bgcolor="<?php echo $g_options["table_bgcolor1"]; ?>">
		    			<td align="left"><?php
				    		echo $g_options["font_normal"];
    						echo "Real Name:";
		    				echo $g_options["fontend_normal"];
    					?></td>
		    			<td align="left"><?php
				    		echo $g_options["font_normal"];
						    if ($playerdata["fullName"]) {
							     echo "<b>" . htmlentities($playerdata["fullName"], ENT_COMPAT, "UTF-8") . "</b>";
						    } else
    							echo "(Unknown)";
		    				echo $g_options["fontend_normal"]; 
				    	?></td>
    				</tr>
		
    				<tr bgcolor="<?php echo $g_options["table_bgcolor2"]; ?>">
		    			<td align="left"><?php
				    		echo $g_options["font_normal"];
						    echo "E-mail Address:";
    						echo $g_options["fontend_normal"];
		    			?></td>
				    	<td align="left"><?php
    						echo $g_options["font_normal"];
		    				if ($email = getEmailLink($playerdata["email"])) {
    							echo $email;
		    				}	else
    							echo "(Unknown)";
		    				echo $g_options["fontend_normal"];
				    	?></td>
    				</tr>
				
    				<tr bgcolor="<?php echo $g_options["table_bgcolor1"]; ?>">
		    			<td align="left"><?php
				    		echo $g_options["font_normal"];
						    echo "Home Page:";
    						echo $g_options["fontend_normal"];
		    			?></td>
				    	<td align="left"><?php
						    echo $g_options["font_normal"];
    						if ($url = getLink($playerdata["homepage"])) {
    							echo $url;
		    				} else
    							echo "(Not specified)";
		    				echo $g_options["fontend_normal"];
    					?></td>
		    		</tr>
				
    				<tr bgcolor="<?php echo $g_options["table_bgcolor2"]; ?>">
		    			<td align="left"><?php
				    		echo $g_options["font_normal"];
						    echo "ICQ Number:";
    						echo $g_options["fontend_normal"];
		    			?></td>
				    	<td align="left"><?php
						    echo $g_options["font_normal"];
    						if ($playerdata["icq"]) {
    							echo "<a href=\"http://wwp.icq.com/"
		    						. urlencode($playerdata["icq"]) . "\" target=\"_blank\">"
				    				. htmlentities($playerdata["icq"], ENT_COMPAT, "UTF-8") . "</a>";
						    }	else
    							echo "(Not specified)";
		    				echo $g_options["fontend_normal"];
				    	?></td>
    				</tr>
				
    				<tr bgcolor="<?php echo $g_options["table_bgcolor1"]; ?>">
		    			<td align="left"><?php
				    		echo $g_options["font_normal"];
						    echo "Player ID:";
    						echo $g_options["fontend_normal"];
		    			?></td>
				    	<td align="left"><?php
						    echo $g_options["font_normal"];
    						echo $player;
		    				echo $g_options["fontend_normal"];
				    	?></td>
				    </tr>

    				<tr bgcolor="<?php echo $g_options["table_bgcolor2"]; ?>">
		    			<td align="left"><?php
				    		echo $g_options["font_normal"];
    						if (MODE == "LAN") {
    							echo "IP Addresses:";
		    				}	else {
    							echo "Unique IDs:";
		    				}
				    		echo $g_options["fontend_normal"];
    					?></td>
		    			<td align="left"><?php
				    		echo $g_options["font_normal"];
						    if (MODE == "NameTrack") {
    							echo "(Unknown)";
    						}	else {
    							$db->query("
		    						SELECT
				    					uniqueId
						    		FROM
								    	hlstats_PlayerUniqueIds
    								WHERE
		    							playerId='$player'
				    			");
							
    							$i=0;
		    					while (list($uqid) = $db->fetch_row()) {
    								if ($i > 0) echo ", ";
		    						echo $uqid;
				    				$i++;
    							}
		    				}
    						echo $g_options["fontend_normal"];
		    			?></td>
    				</tr>

    				<tr bgcolor="<?php echo $g_options["table_bgcolor1"]; ?>">
		    			<td align="left"><?php
				    		echo $g_options["font_normal"];
						    echo "Last Connect:*";
    						echo $g_options["fontend_normal"];
		    			?></td>
				    	<td align="left"><?php
						    echo $g_options["font_normal"];
    						$db->query("
		    					SELECT
				    				DATE_FORMAT(MAX(eventTime), '%a. %D %b. %T')
						    	FROM
    								hlstats_Events_Connects
		    					LEFT JOIN hlstats_Servers ON
				    				hlstats_Servers.serverId=hlstats_Events_Connects.serverId
						    	WHERE
								    hlstats_Servers.game='$game' AND playerId='$player'
    						");
		    				list($lastevent) = $db->fetch_row();
						
    						if ($lastevent)
		    					echo $lastevent;
				    		else
						    	echo "(Unknown)";
    				?><?php echo $g_options["fontend_normal"]; ?></td>
		    		</tr>

    				<tr bgcolor="<?php echo $g_options["table_bgcolor2"]; ?>">
		    			<td align="left"><?php
				    		echo $g_options["font_normal"];
						    echo "Total Connection Time:";
    						echo $g_options["fontend_normal"];
		    			?></td>
				    	<td align="left"><?php
						    echo $g_options["font_normal"];
                echo timestamp_to_str($playerdata['connection_time']);
    				    echo $g_options["fontend_normal"]; ?></td>
		    		</tr>

    				<tr bgcolor="<?php echo $g_options["table_bgcolor1"]; ?>">
		    			<td align="left"><?php
				    		echo $g_options["font_normal"];
    						echo "Average Ping:*";
		    				echo $g_options["fontend_normal"];
				    	?></td>
    					<td align="left"><?php
		    				echo $g_options["font_normal"];
				    		$db->query("
						    	SELECT
								    ROUND(SUM(ping) /	COUNT(ping), 0) AS av_ping,
    								ROUND(ROUND(SUM(ping) /	COUNT(ping), 0) / 2, 0) AS av_latency
		    					FROM
				    				hlstats_Events_Latency
						    	LEFT JOIN hlstats_Servers ON
								    hlstats_Servers.serverId=hlstats_Events_Latency.serverId
    							WHERE   
		    						hlstats_Servers.game='$game' AND playerId='$player'
				    		");
						    list($av_ping, $av_latency) = $db->fetch_row();
    						if ($av_ping)
		    					echo $av_ping." ms (Latency: $av_latency ms)";
				    		else
						    	echo "-";
    				?><?php echo $g_options["fontend_normal"]; ?></td>
		    		</tr>
    				</table>
          </td>
    	  </tr>
    		</table><br><?php
                echo $g_options["font_normal"];
                echo '&nbsp;&nbsp;Items marked "*" above are generated from the last '.DELETEDAYS.' days.';
                echo $g_options["fontend_normal"]; 
      ?></td>
      <td width="50%" valign="top">
		    <table width="90%" border=0 cellspacing=0 cellpadding=0 bgcolor="<?php echo $g_options["table_border"]; ?>">
        <tr>
          <td>
    				<table width="100%" border=0 cellspacing=1 cellpadding=4>
			
            <tr valign="bottom" bgcolor="<?php echo $g_options["table_head_bgcolor"]; ?>">
              <td colspan="3"><?php
                echo $g_options["font_normal"];
                echo "<font color=\"".$g_options["table_head_text"]."\">Statistics Summary</font>";
                echo $g_options["fontend_normal"];
              ?></td>
            </tr>
    				<tr bgcolor="<?php echo $g_options["table_bgcolor1"]; ?>">
		    			<td width="45%"><?php
				    		echo $g_options["font_normal"];
						    echo "Rank:";
    						echo $g_options["fontend_normal"];
		    			?></td>
				    	<td colspan="2" width="55%"><?php
    						echo $g_options["font_normal"];
                if (($playerdata['activity'] > 0) && ($playerdata['hideranking'] == 0)) {            
        						$db->query("
		      					SELECT
                      COUNT(*)
						    	  FROM
								        hlstats_Players
    							  WHERE
		    					    	game='$game' 
                        AND skill>'".$playerdata['skill']."' 
                        AND hideranking = 0
              	     		AND kills >= 1
                        AND IF(".MINACTIVITY." > (UNIX_TIMESTAMP() - last_event), UNIX_TIMESTAMP() - last_event, -1) >= 0
				        		");
                            
    						  list($rank) = $db->fetch_row();
		    				  $rank++;

        						$result = $db->query("
		          					SELECT
                    			playerId,
                  		  	IFNULL(kills / deaths, '-') AS kpd
        		     				FROM
		  	    			    	 	hlstats_Players
    			 			     	WHERE
		    		    				game='$game' 
                        AND skill='".$playerdata['skill']."' 
                        AND hideranking = 0
              	    		AND kills >= 1
                        AND IF(".MINACTIVITY." > (UNIX_TIMESTAMP() - last_event), UNIX_TIMESTAMP() - last_event, -1) >= 0
		  			     	    ORDER BY kpd DESC, lastName ASC
    				    		");
             		   while ($rowdata = $db->fetch_array($result))  {
             			   if ($rowdata['playerId'] == $playerdata['playerId'])
         		    	     break;
			              $rank++;
		               }	
                } else {
                  if ($playerdata['hideranking'] == 1)
                    $rank = "Hidden";
                  elseif ($playerdata['hideranking'] == 2)
                    $rank = "<span style=\"color:red\">Cheater</span>";
                  else                
                    $rank = "Not active";
                }      
                if (is_numeric($rank))
		    				  echo "<b>" . number_format($rank) . "</b>";
                else              
                  echo "<b>" . $rank . "</b>";
    						echo $g_options["fontend_normal"];
    					?></td>
		    		</tr>

    				<tr bgcolor="<?php echo $g_options["table_bgcolor2"]; ?>">
		    			<td width="45%"><?php
				    		echo $g_options["font_normal"];
						    echo "Points:";
    						echo $g_options["fontend_normal"];
		    			?></td>
				    	<td colspan="2" width="55%"><?php
    						echo $g_options["font_normal"];
		    				echo "<b>" . number_format($playerdata["skill"]) . "</b>";
				    		echo $g_options["fontend_normal"];
    					?></td>
		    		</tr>

            <tr bgcolor="<?php echo $g_options["table_bgcolor1"]; ?>">
              <td width="45%"><?php
                echo $g_options["font_normal"];
                echo "Activity:";
                echo $g_options["fontend_normal"];
              ?></td>
              <td width="40%"><?php
                $width = sprintf("%d%%", $playerdata['activity'] + 0.5);
                $bar_type = 1;
                if ($playerdata['activity'] > 40)
                  $bar_type = "6";
                elseif ($playerdata['activity'] > 30)
                  $bar_type = "5";
                elseif ($playerdata['activity'] > 20)
                  $bar_type = "4";
                elseif ($playerdata['activity'] > 10)
                  $bar_type = "3";
                elseif ($playerdata['activity'] > 5)
                  $bar_type = "2";
                echo "<img src=\"" . $g_options["imgdir"] . "/bar".$bar_type.".gif\" width=\"".$width."\" height=10 border=0 alt=\"".$playerdata['activity']."%\">";            
              ?></td>
              <td width="15%"><?php
                echo $g_options["font_normal"];
                echo $playerdata["activity"]."%";
                echo $g_options["fontend_normal"];
              ?></td>
           </tr>
				
    				<tr bgcolor="<?php echo $g_options["table_bgcolor2"]; ?>">
		    			<td width="45%"><?php
				    		echo $g_options["font_normal"];
						    echo "Kills:";
    						echo $g_options["fontend_normal"];
		    			?></td>
				    	<td colspan="2" width="55%"><?php
						    echo $g_options["font_normal"];
    						echo number_format($playerdata["kills"]);
		    				$db->query("
				    			SELECT
						    		COUNT(*)
    							FROM
		    						hlstats_Events_Frags
				    			LEFT JOIN hlstats_Servers ON
						    		hlstats_Servers.serverId=hlstats_Events_Frags.serverId
    							WHERE
		    						hlstats_Servers.game='$game' AND killerId='$player'
				    		");
    						list($realkills) = $db->fetch_row();
		    				echo " (".number_format($realkills).")";
				    		echo $g_options["fontend_normal"];
    					?></td>
		    		</tr>

    				<tr bgcolor="<?php echo $g_options["table_bgcolor1"]; ?>">
		    			<td width="45%"><?php
				    		echo $g_options["font_normal"];
    						echo "Deaths:";
		    				echo $g_options["fontend_normal"];
    					?></td>
		    			<td colspan="2" width="55%"><?php
				    		echo $g_options["font_normal"];
						    echo number_format($playerdata["deaths"]);
    						echo $g_options["fontend_normal"];
		    			?></td>
				    </tr>
				
    				<tr bgcolor="<?php echo $g_options["table_bgcolor2"]; ?>">
		    			<td width="45%"><?php
				    		echo $g_options["font_normal"];
						    echo "Suicides:";
    						echo $g_options["fontend_normal"];
		    			?></td>
				    	<td colspan="2" width="55%"><?php
    						echo $g_options["font_normal"];
		    				echo number_format($playerdata["suicides"]);
				    		echo $g_options["fontend_normal"];
    					?></td>
		    		</tr>
				
    				<tr bgcolor="<?php echo $g_options["table_bgcolor1"]; ?>">
		    			<td width="45%"><?php
				    		echo $g_options["font_normal"];
    						echo "Kills per Death:";
		    				echo $g_options["fontend_normal"];
				    	?></td>
    					<td colspan="2" width="55%"><?php
		    				echo $g_options["font_normal"];
				    		$db->query("
                   SELECT
                      IFNULL(SUM(killerId='$player')/SUM(victimId='$player'), '-') AS kpd
                   FROM
                      hlstats_Events_Frags,
                      hlstats_Servers
                   WHERE
                      hlstats_Servers.serverId=hlstats_Events_Frags.serverId AND
                     (hlstats_Events_Frags.killerId='$player' OR hlstats_Events_Frags.victimId='$player') AND
                     hlstats_Servers.game='$game'
    						");
		    				list($realkpd) = $db->fetch_row();
				    		echo $playerdata["kpd"];
    						echo " ($realkpd)";
		    				echo $g_options["fontend_normal"];
				    	?></td>
    				</tr>
				
    				<tr bgcolor="<?php echo $g_options["table_bgcolor2"]; ?>">
		    			<td width="45%"><?php
    						echo $g_options["font_normal"];
		    				echo "Headshots:";
				    		echo $g_options["fontend_normal"];
    					?></td>
		    			<td colspan="2" width="55%"><?php
				    		echo $g_options["font_normal"];
						    $db->query("
    							SELECT
		    						COUNT(*)
				    			FROM
						    		hlstats_Events_Frags
    							LEFT JOIN hlstats_Servers ON
		    						hlstats_Servers.serverId=hlstats_Events_Frags.serverId
				    			WHERE
						    		hlstats_Servers.game='$game' AND killerId='$player'
    								AND headshot=1		
		    				");
    						list($realheadshots) = $db->fetch_row();
		    				if ($playerdata["headshots"]==0) 
  			    			echo number_format($realheadshots);
                else
		    				  echo number_format($playerdata["headshots"]);
				    		echo " (".number_format($realheadshots).")";
    						echo $g_options["fontend_normal"];
    					?></td>
		    		</tr>
				
    				<tr bgcolor="<?php echo $g_options["table_bgcolor1"]; ?>">
		    			<td width="45%"><?php
				    		echo $g_options["font_normal"];
    						echo "Headshots per Kill:";
		    				echo $g_options["fontend_normal"];
				    	?></td>
    					<td colspan="2" width="55%"><?php
		    				echo $g_options["font_normal"];
				    		$db->query("
						    	SELECT
              			IFNULL(SUM(headshot=1)/COUNT(*), '-') AS hpk
		    					FROM
				    				hlstats_Events_Frags
						    	LEFT JOIN hlstats_Servers ON
    								hlstats_Servers.serverId=hlstats_Events_Frags.serverId
		    					WHERE
				    				hlstats_Servers.game='$game' AND killerId='$player'
    						");
		    				list($realhpk) = $db->fetch_row();
				    	  echo $playerdata["hpk"];
						    echo " ($realhpk)";
    						echo $g_options["fontend_normal"];
		    			?></td>
				    </tr>
				
    				<tr bgcolor="<?php echo $g_options["table_bgcolor2"]; ?>">
		    			<td width="45%"><?php
				    		echo $g_options["font_normal"];
    						echo "Teammate Kills:*";
		    				echo $g_options["fontend_normal"];
				    	?></td>
    					<td colspan="2" width="55%"><?php
		    				echo $g_options["font_normal"];
				    		$db->query("
    							SELECT
		    						COUNT(*)
				    			FROM
						    		hlstats_Events_Teamkills
    							LEFT JOIN hlstats_Servers ON
		    						hlstats_Servers.serverId=hlstats_Events_Teamkills.serverId
				    			WHERE
						    		hlstats_Servers.game='$game' AND killerId='$player'
    						");
		    				list($playerdata["teamkills"]) = $db->fetch_row();
    						echo $playerdata["teamkills"];
		    				echo $g_options["fontend_normal"];
				    	?></td>
    				</tr>

    				<tr bgcolor="<?php echo $g_options["table_bgcolor1"]; ?>">
		    			<td width="45%"><?php
				    		echo $g_options["font_normal"];
    						echo "Weapon Accuracy:";
		    				echo $g_options["fontend_normal"];
    					?></td>
		    			<td colspan="2" width="55%"><?php
				    		echo $g_options["font_normal"];
    						$db->query("
		    					SELECT
				    				IFNULL(ROUND((SUM(hlstats_Events_Statsme.hits)
						    			/ SUM(hlstats_Events_Statsme.shots) * 100), 1), 0.0) AS accuracy,
                    SUM(hlstats_Events_Statsme.shots) as shots,
                    SUM(hlstats_Events_Statsme.hits) as hits
				    			FROM
						    		hlstats_Events_Statsme
    							LEFT JOIN hlstats_Servers ON
		    						hlstats_Servers.serverId=hlstats_Events_Statsme.serverId
				    			WHERE
						    		hlstats_Servers.game='$game' AND playerId='$player'
    						");
		    				list($playerdata["accuracy"], $sm_shots, $sm_hits) = $db->fetch_row();
  			    		echo $playerdata["acc"] . "%";
    						echo " (".$playerdata["accuracy"] . "%)";
		    				echo $g_options["fontend_normal"];
    					?></td>
    				</tr>
    				</table>
          </td>
		    </tr>
    		</table><br><?php
    			echo $g_options["font_normal"];
    			echo "&nbsp;<a href=\"" . $g_options["scripturl"]
		    		. "?mode=playerhistory&player=$player\"><img "
				    . "src=\"" . $g_options["imgdir"]
    				. "/history.gif\" width=16 height=16 border=0 "
		    		. "hspace=3 align=\"middle\" alt=\"history.gif\">"
    				. htmlentities($playerdata["lastName"], ENT_COMPAT, "UTF-8") . "'s Event&nbsp;History</a>";
          if (LOG_CHAT > 0)  {          
            echo "&nbsp;&nbsp;&nbsp;<a href=\"" . $g_options["scripturl"]
              . "?mode=chathistory&amp;player=$player\"><img "
              . "src=\"" . $g_options["imgdir"]
              . "/history.gif\" width=16 height=16 border=0 "
              . "hspace=3 align=\"middle\" alt=\"history.gif\">"
              . htmlentities($playerdata["lastName"], ENT_COMPAT, "UTF-8") . "'s Chat&nbsp;History</a>\n";
          }                        
    		  ?><br>&nbsp;<a href="<?php echo $g_options["scripturl"]; ?>?mode=search&st=player&q=<?php echo $pl_urlname; ?>"><img src="<?php echo $g_options["imgdir"]; ?>/search.gif" width=16 height=16 hspace=3 border=0 align="middle" alt="search.gif">Find other players with the same name</a><?php echo $g_options["fontend_normal"]; ?></td>
      </td>
    </tr>
  </table>    
</tr>

</table><p>

<?php
	flush();
	
	$tblAliases = new Table(
		array(
			new TableColumn(
				"name",
				"Name",
				"width=21"
			),
			new TableColumn(
				"connection_time",
				"Time",
				"width=8&align=right&type=timestamp"
			),
			new TableColumn(
				"lastuse",
				"Last Use",
				"width=15"
			),
			new TableColumn(
				"kills",
				"Kills",
				"width=7&align=right"
			),
			new TableColumn(
				"deaths",
				"Deaths",
				"width=7&align=right"
			),
			new TableColumn(
				"kpd",
				"Kills per Death",
				"width=11&align=right"
			),
			new TableColumn(
				"headshots",
				"Headshots",
				"width=8&align=right"
			),
			new TableColumn(
				"hpk",
				"Hpk",
				"width=6&align=right"
			),
			new TableColumn(
				"suicides",
				"Suicides",
				"width=6&align=right"
			),
			new TableColumn(
				"acc",
				"Accuracy",
				"width=6&align=right&append=" . urlencode("%")
			)
		),
		"name",
		"lastuse",
		"name",
		true,
		20,
		"aliases_page",
		"aliases_sort",
		"aliases_sortorder",
		"aliases"
	);

	$result = $db->query("
		SELECT
			name,
      connection_time,
			lastuse,
			numuses,
			kills,
			deaths,
			IFNULL(
				kills / deaths,
				'-'
			) AS kpd,
			headshots,
			IFNULL(
				headshots / kills,
				'-'
			) AS hpk,
			suicides,
			IFNULL(ROUND((hits / shots * 100), 1), 0.0) AS acc
		FROM
			hlstats_PlayerNames
		WHERE
			playerId=$player
		ORDER BY
			$tblAliases->sort $tblAliases->sortorder
		LIMIT $tblAliases->startitem,$tblAliases->numperpage
	");
	
	$resultCount = $db->query("
		SELECT
			COUNT(*)
		FROM
			hlstats_PlayerNames
		WHERE
			playerId=$player
	");
	
	list($numitems) = $db->fetch_row($resultCount);

	if ($numitems > 1)
	{
?>

<table width="100%" align="center" border=0 cellspacing=0 cellpadding=0>

<tr>
	<td width="100%" colspan=3><a name="aliases"></a>
<?php echo $g_options["font_normal"]; ?>&nbsp;<img src="<?php echo $g_options["imgdir"]; ?>/downarrow.gif" width=9 height=6 border=0 align="middle" alt="downarrow.gif"><b>&nbsp;Aliases</b><?php echo $g_options["fontend_normal"];?></td>
</tr>

<tr>
  <td width="100%" colspan=3 style="padding-left:25px;">&nbsp;<br>
	<?php
		$tblAliases->draw($result, $numitems, 100);
	?></td>
</tr>

</table><p>
<?php
	}

	flush();
	
	$tblPlayerActions = new Table(
		array(
			new TableColumn(
				"description",
				"Action",
				"width=45"
			),
			new TableColumn(
				"obj_count",
				"Achieved",
				"width=25&align=right&append=+times"
			),
			new TableColumn(
				"obj_bonus",
				"Points Bonus",
				"width=25&align=right"
			)
		),
		"id",
		"obj_count",
		"description",
		true,
		9999,
		"obj_page",
		"obj_sort",
		"obj_sortorder",
		"playeractions"
	);

	$result = $db->query("
		SELECT
			hlstats_Actions.description,
			COUNT(hlstats_Events_PlayerActions.id) AS obj_count,
			COUNT(hlstats_Events_PlayerActions.id) * hlstats_Actions.reward_player AS obj_bonus
		FROM
			hlstats_Actions
		LEFT JOIN hlstats_Events_PlayerActions ON
			hlstats_Events_PlayerActions.actionId = hlstats_Actions.id
		LEFT JOIN hlstats_Servers ON
			hlstats_Servers.serverId=hlstats_Events_PlayerActions.serverId
		WHERE
			hlstats_Servers.game='$game' AND hlstats_Events_PlayerActions.playerId=$player
		GROUP BY
			hlstats_Actions.id
		ORDER BY
			$tblPlayerActions->sort $tblPlayerActions->sortorder,
			$tblPlayerActions->sort2 $tblPlayerActions->sortorder
	");
	
	$numitems = $db->num_rows($result);
	
	if ($numitems > 0)
	{
?>
<table width="100%" align="center" border=0 cellspacing=0 cellpadding=0>

<tr>
	<td width="50%" colspan="2"><a name="playeractions"></a>
<?php echo $g_options["font_normal"]; ?>&nbsp;<img src="<?php echo $g_options["imgdir"]; ?>/downarrow.gif" width=9 height=6 border=0 align="middle" alt="downarrow.gif"><b>&nbsp;Player Actions</b><?php echo $g_options["fontend_normal"];?></td>
	<td width="50%" align="right"><?php echo $g_options["font_normal"]; ?>(Last <?php echo DELETEDAYS; ?> Days)<?php echo $g_options["fontend_normal"];?></td>
</tr>

<tr>
  <td width="100%" colspan=3 style="padding-left:25px;">&nbsp;<br>
	<?php
		$tblPlayerActions->draw($result, $numitems, 100);
	?></td>
</tr>

</table><p>
<?php
	}
	
	
	$tblPlayerPlayerActions = new Table(
		array(
			new TableColumn(
				"description",
				"Action",
				"width=45"
			),
			new TableColumn(
				"obj_count",
				"Achieved",
				"width=25&align=right&append=+times"
			),
			new TableColumn(
				"obj_bonus",
				"Points Bonus",
				"width=25&align=right"
			)
		),
		"id",
		"obj_count",
		"description",
		true,
		9999,
		"ppa_page",
		"ppa_sort",
		"ppa_sortorder",
		"playerplayeractions"
	);

	$result = $db->query("
		SELECT
			hlstats_Actions.description,
			COUNT(hlstats_Events_PlayerPlayerActions.id) AS obj_count,
			COUNT(hlstats_Events_PlayerPlayerActions.id) * hlstats_Actions.reward_player AS obj_bonus
		FROM
			hlstats_Actions
		LEFT JOIN hlstats_Events_PlayerPlayerActions ON
			hlstats_Events_PlayerPlayerActions.actionId = hlstats_Actions.id
		LEFT JOIN hlstats_Servers ON
			hlstats_Servers.serverId=hlstats_Events_PlayerPlayerActions.serverId
		WHERE
			hlstats_Servers.game='$game' AND hlstats_Events_PlayerPlayerActions.playerId=$player
		GROUP BY
			hlstats_Actions.id
		ORDER BY
			$tblPlayerPlayerActions->sort $tblPlayerPlayerActions->sortorder,
			$tblPlayerPlayerActions->sort2 $tblPlayerPlayerActions->sortorder
	");
	
	$numitems = $db->num_rows($result);
	
	if ($numitems > 0)
	{
?>
<table width="100%" align="center" border=0 cellspacing=0 cellpadding=0>

<tr>
	<td width="50%" colspan=2><a name="playerplayeractions"></a>
<?php echo $g_options["font_normal"]; ?>&nbsp;<img src="<?php echo $g_options["imgdir"]; ?>/downarrow.gif" width=9 height=6 border=0 align="middle" alt="downarrow.gif"><b>&nbsp;Player-Player Actions</b><?php echo $g_options["fontend_normal"];?></td>
	<td width="50%" align="right"><?php echo $g_options["font_normal"]; ?>(Last <?php echo DELETEDAYS; ?> Days)<?php echo $g_options["fontend_normal"];?></td>
</tr>

<tr>
  <td width="100%" colspan=3 style="padding-left:25px;">&nbsp;<br>
	<?php
		$tblPlayerPlayerActions->draw($result, $numitems, 100);
	?></td>
</tr>

</table><p>
<?php
	}
	
	
	flush();
	
	$tblTeams = new Table(
		array(
			new TableColumn(
				"name",
				"Team",
				"width=35"
			),
			new TableColumn(
				"teamcount",
				"Joined",
				"width=10&align=right&append=+times"
			),
			new TableColumn(
				"percent",
				"Percentage of Times",
				"width=40&sort=no&type=bargraph"
			),
			new TableColumn(
				"percent",
				"%",
				"width=10&sort=no&align=right&append=" . urlencode("%")
			)
		),
		"name",
		"teamcount",
		"name",
		true,
		9999,
		"teams_page",
		"teams_sort",
		"teams_sortorder",
		"teams"
	);
	
    
    
	$db->query("
		SELECT
			COUNT(*)
		FROM
			hlstats_Events_ChangeTeam
    LEFT JOIN hlstats_Servers ON
      hlstats_Servers.serverId=hlstats_Events_ChangeTeam.serverId
		WHERE
			playerId=$player 
      AND hlstats_Servers.game='$game'  
	");
	list($numteamjoins) = $db->fetch_row();

	$result = $db->query("
		SELECT
			IFNULL(hlstats_Teams.name, hlstats_Events_ChangeTeam.team) AS name,
			COUNT(hlstats_Events_ChangeTeam.id) AS teamcount,
			COUNT(hlstats_Events_ChangeTeam.id) / $numteamjoins * 100 AS percent
		FROM
			hlstats_Events_ChangeTeam
		LEFT JOIN hlstats_Teams ON
			hlstats_Events_ChangeTeam.team=hlstats_Teams.code
		LEFT JOIN hlstats_Servers ON
			hlstats_Servers.serverId=hlstats_Events_ChangeTeam.serverId
		WHERE
      hlstats_Teams.game='$game' 
			AND hlstats_Servers.game='$game' 
      AND hlstats_Events_ChangeTeam.playerId=$player 
      AND (hidden <>'1' OR hidden IS NULL)
		GROUP BY
			hlstats_Events_ChangeTeam.team
		ORDER BY
			$tblTeams->sort $tblTeams->sortorder,
			$tblTeams->sort2 $tblTeams->sortorder
	");
	
	$numitems = $db->num_rows($result);
	
	if ($numitems > 0)
	{
?>
<table width="100%" align="center" border=0 cellspacing=0 cellpadding=0>

<tr>
	<td width="50%" colspan=2><a name="teams"></a>
<?php echo $g_options["font_normal"]; ?>&nbsp;<img src="<?php echo $g_options["imgdir"]; ?>/downarrow.gif" width=9 height=6 border=0 align="middle" alt="downarrow.gif"><b>&nbsp;Team Selection</b><?php echo $g_options["fontend_normal"];?></td>
	<td width="50%" align="right"><?php echo $g_options["font_normal"]; ?>(Last <?php echo DELETEDAYS; ?> Days)<?php echo $g_options["fontend_normal"];?></td>
</tr>

<tr>
  <td width="100%" colspan=3 style="padding-left:25px;">&nbsp;<br>
	<?php
		$tblTeams->draw($result, $numitems, 100);
	?></td>
</tr>

</table><p>
<?php
	}
	
	
	flush();
	
	$tblRoles = new Table(
		array(
			new TableColumn(
				"name",
				"Role",
				"width=35"
			),
			new TableColumn(
				"rolecount",
				"Joined",
				"width=10&align=right&append=+times"
			),
			new TableColumn(
				"percent",
				"Percentage of Times",
				"width=40&sort=no&type=bargraph"
			),
			new TableColumn(
				"percent",
				"%",
				"width=10&sort=no&align=right&append=" . urlencode("%")
			)
		),
		"name",
		"rolecount",
		"name",
		true,
		9999,
		"roles_page",
		"roles_sort",
		"roles_sortorder",
		"roles"
	);
	
	$db->query("
		SELECT
			COUNT(*)
		FROM
			hlstats_Events_ChangeRole
    LEFT JOIN hlstats_Servers ON
      hlstats_Servers.game='$game' AND hlstats_Servers.serverId=hlstats_Events_ChangeRole.serverId
		WHERE
			playerId=$player
	");
	list($numrolejoins) = $db->fetch_row();

	$result = $db->query("
		SELECT
			IFNULL(hlstats_Roles.name, hlstats_Events_ChangeRole.role) AS name,
			COUNT(hlstats_Events_ChangeRole.id) AS rolecount,
			COUNT(hlstats_Events_ChangeRole.id) / $numrolejoins * 100 AS percent
		FROM
			hlstats_Events_ChangeRole
		LEFT JOIN hlstats_Roles ON
			hlstats_Events_ChangeRole.role=hlstats_Roles.code
		LEFT JOIN hlstats_Servers ON
			hlstats_Servers.serverId=hlstats_Events_ChangeRole.serverId
		WHERE
			hlstats_Servers.game='$game' AND hlstats_Events_ChangeRole.playerId=$player AND (hidden <>'1' OR hidden IS NULL)
		GROUP BY
			hlstats_Events_ChangeRole.role
		ORDER BY
			$tblRoles->sort $tblRoles->sortorder,
			$tblRoles->sort2 $tblRoles->sortorder
	");
	
	$numitems = $db->num_rows($result);
	
	if ($numitems > 0)
	{
?>
<table width="100%" align="center" border=0 cellspacing=0 cellpadding=0>

<tr>
	<td width="50%" colspan=2><a name="roles"></a>
<?php echo $g_options["font_normal"]; ?>&nbsp;<img src="<?php echo $g_options["imgdir"]; ?>/downarrow.gif" width=9 height=6 border=0 align="middle" alt="downarrow.gif"><b>&nbsp;Role Selection</b><?php echo $g_options["fontend_normal"];?></td>
	<td width="50%" align="right"><?php echo $g_options["font_normal"]; ?>(Last <?php echo DELETEDAYS; ?> Days)<?php echo $g_options["fontend_normal"];?></td>
</tr>

<tr>
  <td width="100%" colspan=3 style="padding-left:25px;">&nbsp;<br>
	<?php
		$tblRoles->draw($result, $numitems, 100);
	?></td>
</tr>

</table><p>

<?php
	}
	
	
	flush();
	
	$tblWeapons = new Table(
		array(
			new TableColumn(
				"weapon",
				"Weapon",
				"width=15&type=weaponimg&align=center&link=" . urlencode("mode=weaponinfo&weapon=%k&game=$game")
			),
			new TableColumn(
				"modifier",
				"Points Modifier",
				"width=10&align=right"
			),
			new TableColumn(
				"kills",
				"Kills",
				"width=11&align=right"
			),
			new TableColumn(
				"kpercent",
				"Percentage of Kills",
				"width=18&sort=no&type=bargraph"
			),
			new TableColumn(
				"kpercent",
				"%",
				"width=5&sort=no&align=right&append=" . urlencode("%")
			),
			new TableColumn(
				"headshots",
				"Headshots",
				"width=8&align=right"
			),
			new TableColumn(
				"hpercent",
				"Percentage of Headshots",
				"width=18&sort=no&type=bargraph"
			),
			new TableColumn(
				"hpercent",
				"%",
				"width=5&sort=no&align=right&append=" . urlencode("%")
			),
			new TableColumn(
				"hpk",
				"Hpk",
				"width=5&align=right"
			)
		),
		"weapon",
		"kills",
		"weapon",
		true,
		9999,
		"weap_page",
		"weap_sort",
		"weap_sortorder",
		"weapons"
	);
	
	$result = $db->query("
		SELECT
			hlstats_Events_Frags.weapon,
			IFNULL(hlstats_Weapons.modifier, 1.00) AS modifier,
			COUNT(hlstats_Events_Frags.weapon) AS kills,
			COUNT(hlstats_Events_Frags.weapon) / $realkills * 100 AS kpercent,
			SUM(hlstats_Events_Frags.headshot=1) as headshots,
			SUM(hlstats_Events_Frags.headshot=1) / COUNT(hlstats_Events_Frags.weapon) AS hpk,
			SUM(hlstats_Events_Frags.headshot=1) / $realheadshots * 100 AS hpercent
		FROM
			hlstats_Events_Frags
		LEFT JOIN hlstats_Weapons ON
			hlstats_Weapons.code = hlstats_Events_Frags.weapon
		LEFT JOIN hlstats_Servers ON
			hlstats_Servers.serverId=hlstats_Events_Frags.serverId
		WHERE
			hlstats_Servers.game='$game' AND hlstats_Events_Frags.killerId=$player
			AND (hlstats_Weapons.game='$game' OR hlstats_Weapons.weaponId IS NULL)
		GROUP BY
			hlstats_Events_Frags.weapon
		ORDER BY
			$tblWeapons->sort $tblWeapons->sortorder,
			$tblWeapons->sort2 $tblWeapons->sortorder
	");

?>
<table width="100%" align="center" border=0 cellspacing=0 cellpadding=0>

<tr>
	<td width="50%" colspan=2><a name="weapons"></a>
<?php echo $g_options["font_normal"]; ?>&nbsp;<img src="<?php echo $g_options["imgdir"]; ?>/downarrow.gif" width=9 height=6 border=0 align="middle" alt="downarrow.gif"><b>&nbsp;Weapon Usage</b><?php echo $g_options["fontend_normal"];?></td>
	<td width="50%" align="right"><?php echo $g_options["font_normal"]; ?>(Last <?php echo DELETEDAYS; ?> Days)<?php echo $g_options["fontend_normal"];?></td>
</tr>

<tr>
  <td width="100%" colspan=3 style="padding-left:25px;">&nbsp;<br>
	<?php
		$tblWeapons->draw($result, $db->num_rows($result), 100);
	?></td>
</tr>

</table><p>
<!-- Begin StatsMe Addon 1.0 by JustinHoMi@aol.com -->
<?php
	
	flush();

	$tblWeaponstats = new Table(
		array(
			new TableColumn(
				"smweapon",
				"Weapon",
				"width=15&type=weaponimg&align=center&link=" . urlencode("mode=weaponinfo&weapon=%k&game=$game")
			),
			new TableColumn(
				"smshots",
				"Shots",
				"width=8&align=right"
			),
			new TableColumn(
				"smhits",
				"Hits",
				"width=8&align=right"
			),
			new TableColumn(
				"smdamage",
				"Damage",
				"width=8&align=right"
			),
			new TableColumn(
				"smheadshots",
				"Headshots",
				"width=8&align=right"
			),
			new TableColumn(
				"smkills",
				"Kills",
				"width=7&align=right"
			),
			new TableColumn(
				"smkdr",
				"Kills per Death",
				"width=12&align=right"
			),
			new TableColumn(
				"smaccuracy",
				"Accuracy",
				"width=8&align=right&append=" . urlencode("%")
			),
			new TableColumn(
				"smdhr",
				"Damage per Hit",
				"width=10&align=right"
			),
			new TableColumn(
				"smspk",
				"Shots per Kill",
				"width=11&align=right"
			)
		),
		"smweapon",
		"smkills",
		"smweapon",
		true,
		9999,
		"weap_page",
		"weap_sort",
		"weap_sortorder",
		"weaponstats"
	);
	
	$result = $db->query("
		SELECT
			hlstats_Events_Statsme.weapon AS smweapon,
			SUM(hlstats_Events_Statsme.kills) AS smkills,
			SUM(hlstats_Events_Statsme.hits) AS smhits,
			SUM(hlstats_Events_Statsme.shots) AS smshots,
			SUM(hlstats_Events_Statsme.headshots) AS smheadshots,
			SUM(hlstats_Events_Statsme.deaths) AS smdeaths,
			SUM(hlstats_Events_Statsme.damage) AS smdamage,
			ROUND((SUM(hlstats_Events_Statsme.damage) / (IF( SUM(hlstats_Events_Statsme.hits)=0, 1, SUM(hlstats_Events_Statsme.hits) ))), 1) as smdhr,
			SUM(hlstats_Events_Statsme.kills) / IF((SUM(hlstats_Events_Statsme.deaths)=0), 1, (SUM(hlstats_Events_Statsme.deaths))) as smkdr,
      ROUND((SUM(hlstats_Events_Statsme.hits) / SUM(hlstats_Events_Statsme.shots) * 100), 1) as smaccuracy,
			ROUND(( (IF(SUM(hlstats_Events_Statsme.kills)=0, 0, SUM(hlstats_Events_Statsme.shots))) / (IF( SUM(hlstats_Events_Statsme.kills)=0, 1, SUM(hlstats_Events_Statsme.kills) ))), 1) as smspk
		FROM
			hlstats_Events_Statsme
		LEFT JOIN hlstats_Servers ON
			hlstats_Servers.serverId=hlstats_Events_Statsme.serverId
		WHERE
			hlstats_Servers.game='$game' AND hlstats_Events_Statsme.PlayerId=$player
		GROUP BY
			hlstats_Events_Statsme.weapon
    HAVING
      SUM(hlstats_Events_Statsme.shots)>0
		ORDER BY
			$tblWeaponstats->sort $tblWeaponstats->sortorder,
			$tblWeaponstats->sort2 $tblWeaponstats->sortorder
	");
    
if ($db->num_rows($result) != 0)
{
?>
<table width="100%" align="center" border=0 cellspacing=0 cellpadding=0>

<tr>
	<td width="50%" colspan=2><a name="weaponstats"></a>
<?php echo $g_options["font_normal"]; ?>&nbsp;<img src="<?php echo $g_options["imgdir"]; ?>/downarrow.gif" width=9 height=6 border=0 align="middle" alt="downarrow.gif"><b>&nbsp;Weapon Stats</b><?php echo $g_options["fontend_normal"];?></td>
	<td width="50%" align="right"><?php echo $g_options["font_normal"]; ?>(Last <?php echo DELETEDAYS; ?> Days)<?php echo $g_options["fontend_normal"];?></td>
</tr>

<tr>
  <td width="100%" colspan=3 style="padding-left:25px;">&nbsp;<br>
	<?php
		$tblWeaponstats->draw($result, $db->num_rows($result), 100);
	?></td>
</tr>

</table><p>
<!-- End StatsMe Addon 1.0 by JustinHoMi@aol.com -->
<?php
}
	
	flush();
    
  if (SHOW_WEAPON_TARGET_FLASH == 1)  {  

    	$tblWeaponstats2 = new Table(
    		array(
    			new TableColumn(
    				"smweapon",
    				"Weapon",
    				"width=35&type=weaponimg&align=center&link=javascript:switch_weapon('%k');"
    			),
    			new TableColumn(
    				"smhits",
    				"Hits",
    				"width=15&align=right"
    			),
    			new TableColumn(
    				"smleft",
    				"Left",
    				"width=15&align=right&append=" . urlencode("%")
    			),
    			new TableColumn(
    				"smmiddle",
    				"Middle",
    				"width=15&align=right&append=" . urlencode("%")
    			),
    			new TableColumn(
    				"smright",
    				"Right",
    				"width=15&align=right&append=" . urlencode("%")
    			)
    		),
    		"smweapon",
    		"smhits",
    		"smweapon",
    		true,
    		9999,
    		"weap_page",
    		"weap_sort",
    		"weap_sortorder",
    		"weaponstats2"
    	);
  } else {
        $tblWeaponstats2 = new Table(
            array(
                new TableColumn(
                    "smweapon",
                    "Weapon",
                    "width=15&type=weaponimg&align=center&link=" . urlencode("mode=weaponinfo&weapon=%k&game=$game")
                ),
                new TableColumn(
                    "smhits",
                    "Hits",
                    "width=7&align=right"
                ),
                new TableColumn(
                    "smhead",
                    "Head",
                    "width=7&align=right"
                ),
                new TableColumn(
                    "smchest",
                    "Chest",
                    "width=7&align=right"
                ),
                new TableColumn(
                    "smstomach",
                    "Stomach",
                    "width=7&align=right"
                ),
                new TableColumn(
                    "smleftarm",
                    "Left Arm",
                    "width=7&align=right"
                ),
                new TableColumn(
                    "smrightarm",
                    "Right Arm",
                    "width=7&align=right"
                ),
                new TableColumn(
                    "smleftleg",
                    "Left Leg",
                    "width=7&align=right"
                ),
                new TableColumn(
                    "smrightleg",
                    "Right Leg",
                    "width=7&align=right"
                ),
                new TableColumn(
                    "smleft",
                    "Left",
                    "width=8&align=right&append=" . urlencode("%")
                ),
                new TableColumn(
                    "smmiddle",
                    "Middle",
                    "width=8&align=right&append=" . urlencode("%")
                ),
                new TableColumn(
                    "smright",
                    "Right",
                    "width=8&align=right&append=" . urlencode("%")
                )
            ),
            "smweapon",
            "smhits",
            "smweapon",
            true,
            9999,
            "weap_page",
            "weap_sort",
            "weap_sortorder",
            "weaponstats2"
        );
  }        

	$query = "
		SELECT
			hlstats_Events_Statsme2.weapon AS smweapon,
			SUM(hlstats_Events_Statsme2.head) AS smhead,
			SUM(hlstats_Events_Statsme2.chest) AS smchest,
			SUM(hlstats_Events_Statsme2.stomach) AS smstomach,
			SUM(hlstats_Events_Statsme2.leftarm) AS smleftarm,
			SUM(hlstats_Events_Statsme2.rightarm) AS smrightarm,
			SUM(hlstats_Events_Statsme2.leftleg) AS smleftleg,
			SUM(hlstats_Events_Statsme2.rightleg) AS smrightleg,
			SUM(hlstats_Events_Statsme2.head)+SUM(hlstats_Events_Statsme2.chest)+SUM(hlstats_Events_Statsme2.stomach)+
      SUM(hlstats_Events_Statsme2.leftarm)+SUM(hlstats_Events_Statsme2.rightarm)+SUM(hlstats_Events_Statsme2.leftleg)+
      SUM(hlstats_Events_Statsme2.rightleg) as smhits,							
			IFNULL(ROUND((SUM(hlstats_Events_Statsme2.leftarm) + SUM(hlstats_Events_Statsme2.leftleg)) / (SUM(hlstats_Events_Statsme2.head) + SUM(hlstats_Events_Statsme2.chest) + SUM(hlstats_Events_Statsme2.stomach) + SUM(hlstats_Events_Statsme2.leftarm ) + SUM(hlstats_Events_Statsme2.rightarm) + SUM(hlstats_Events_Statsme2.leftleg) + SUM(hlstats_Events_Statsme2.rightleg)) * 100, 1), 0.0) AS smleft,
			IFNULL(ROUND((SUM(hlstats_Events_Statsme2.rightarm) + SUM(hlstats_Events_Statsme2.rightleg)) / (SUM(hlstats_Events_Statsme2.head) + SUM(hlstats_Events_Statsme2.chest) + SUM(hlstats_Events_Statsme2.stomach) + SUM(hlstats_Events_Statsme2.leftarm ) + SUM(hlstats_Events_Statsme2.rightarm) + SUM(hlstats_Events_Statsme2.leftleg) + SUM(hlstats_Events_Statsme2.rightleg)) * 100, 1), 0.0) AS smright,
			IFNULL(ROUND((SUM(hlstats_Events_Statsme2.head) + SUM(hlstats_Events_Statsme2.chest) + SUM(hlstats_Events_Statsme2.stomach)) / (SUM(hlstats_Events_Statsme2.head) + SUM(hlstats_Events_Statsme2.chest) + SUM(hlstats_Events_Statsme2.stomach) + SUM(hlstats_Events_Statsme2.leftarm ) + SUM(hlstats_Events_Statsme2.rightarm) + SUM(hlstats_Events_Statsme2.leftleg) + SUM(hlstats_Events_Statsme2.rightleg)) * 100, 1), 0.0) AS smmiddle
		FROM
			hlstats_Events_Statsme2
		LEFT JOIN hlstats_Servers ON
			hlstats_Servers.serverId=hlstats_Events_Statsme2.serverId
		WHERE
			hlstats_Servers.game='$game' AND hlstats_Events_Statsme2.PlayerId=$player
		GROUP BY
			hlstats_Events_Statsme2.weapon
		HAVING
			smhits > 0				
		ORDER BY
			$tblWeaponstats2->sort $tblWeaponstats2->sortorder,
			$tblWeaponstats2->sort2 $tblWeaponstats2->sortorder
	";
  $result = $db->query($query);    	

if ($db->num_rows($result) != 0)
{
?>
<table width="100%" align="center" border=0 cellspacing=0 cellpadding=0>

<tr>
	<td width="50%" colspan=2><a name="weaponstats2"></a>
<?php echo $g_options["font_normal"]; ?>&nbsp;<img src="<?php echo $g_options["imgdir"]; ?>/downarrow.gif" width=9 height=6 border=0 align="middle" alt="downarrow.gif"><b>&nbsp;Weapon Target</b><?php echo $g_options["fontend_normal"];?></td>
	<td width="50%" align="right"><?php echo $g_options["font_normal"]; ?>(Last <?php echo DELETEDAYS; ?> Days)<?php echo $g_options["fontend_normal"];?></td>
</tr>

<script type="text/javascript">
  <?php
    global $game;
    
    $weapon_data = array();
    $css_models              = array("ct", "ct2", "ct3", "ct4", "ts", "ts2", "ts3", "ts4");
    $css_ct_weapons          = array("usp", "tmp", "m4a1",
                                     "aug", "famas", "sig550");
    $css_ts_weapons          = array("glock", "elite", "mac10",  
                                     "ak47", "sg552", "galil",
                                     "g3sg1");
    $css_random_weapons      = array("knife", "deagle", "p228",
                                     "m3", "xm1014", "mp5navy",
                                     "p90", "scout", "awp",
                                     "m249", "hegrenade", "flashbang",
                                     "ump45", "smokegrenade_projectile");
    $dods_models             = array("allies", "axis");
    $dods_allies_weapons     = array("thompson", "colt", "spring",
                                     "garand", "riflegren_us", "m1carbine",
                                     "bar", "amerknife", "30cal",
                                     "bazooka", "frag_us", "riflegren_us",
                                     "smoke_us");
    $dods_axis_weapons       = array("spade", "riflegren_ger", "k98",
                                     "mp40", "p38", "frag_ger",
                                     "smoke_ger", "mp44", "k98_scoped",
                                     "mg42", "pschreck", "c96");


    while ($rowdata = $db->fetch_array()) {
      $weapon_data['total']['head']                 += $rowdata["smhead"];   
      $weapon_data['total']['leftarm']              += $rowdata["smleftarm"];   
      $weapon_data['total']['rightarm']             += $rowdata["smrightarm"];
      $weapon_data['total']['chest']                += $rowdata["smchest"];
      $weapon_data['total']['stomach']              += $rowdata["smstomach"];
      $weapon_data['total']['leftleg']              += $rowdata["smleftleg"];
      $weapon_data['total']['rightleg']             += $rowdata["smrightleg"];
      $weapon_data[$rowdata["smweapon"]]['head']     = $rowdata["smhead"];   
      $weapon_data[$rowdata["smweapon"]]['leftarm']  = $rowdata["smleftarm"];   
      $weapon_data[$rowdata["smweapon"]]['rightarm'] = $rowdata["smrightarm"];
      $weapon_data[$rowdata["smweapon"]]['chest']    = $rowdata["smchest"];
      $weapon_data[$rowdata["smweapon"]]['stomach']  = $rowdata["smstomach"];
      $weapon_data[$rowdata["smweapon"]]['leftleg']  = $rowdata["smleftleg"];
      $weapon_data[$rowdata["smweapon"]]['rightleg'] = $rowdata["smrightleg"];
      $weapon_data[$rowdata["smweapon"]]['model']    = "ct";                               
      if (strpos($game, "dod") !== false)      
        $weapon_data[$rowdata["smweapon"]]['model']  = "allies";                               

      if (strpos($game, "css") !== false) {      
        if (in_array($rowdata["smweapon"], $css_random_weapons)) {
          $weapon_data[$rowdata["smweapon"]]['model'] = $css_models[array_rand($css_models)];                               
        } elseif (in_array($rowdata["smweapon"], $css_ct_weapons)) {
          $weapon_data[$rowdata["smweapon"]]['model'] = $css_models[rand(0, 2) + 3];                                
        } elseif (in_array($rowdata["smweapon"], $css_ts_weapons)) {
          $weapon_data[$rowdata["smweapon"]]['model'] = $css_models[rand(0, 2)];                    
        }
      } elseif (strpos($game, "dod") !== false) {      
        if (in_array($rowdata["smweapon"], $dods_allies_weapons)) {
          $weapon_data[$rowdata["smweapon"]]['model'] = $dods_models[1];                                
        } elseif (in_array($rowdata["smweapon"], $dods_axis_weapons)) {
          $weapon_data[$rowdata["smweapon"]]['model'] = $dods_models[0];                    
        }
      }      

    }
    
    $start_model   = $css_models[array_rand($css_models)];
    if (strpos($game, "dod") !== false)
      $start_model = $dods_models[array_rand($dods_models)];
      
          
    $weapon_data['total']['model'] = $start_model;                               
    
    echo "var data_array = new Array();\n";
    $i = 1;
    foreach ($weapon_data as $key => $entry) {
      if ($key == "total")
        $key = "All Weapons";   
      echo "data_array['".$key."'] = ['".ucfirst($key)."',".$entry['head'].",".$entry['leftarm'].",".$entry['rightarm'].",".$entry['chest'].",".$entry['stomach'].",".$entry['leftleg'].",".$entry['rightleg'].",'".$entry['model']."'];\n";
      $i++; 
    }    
    $result = $db->query($query);
    
  ?>
   function switch_weapon(weapon) {
     if (document.embeds && document.embeds.hitbox) {
       if (document.embeds.hitbox.LoadMovie) {
         document.embeds.hitbox.LoadMovie(0, '<?php echo IMAGE_PATH_URL."/".$g_options["imgdir"]; ?>/hitbox.swf?wname='+data_array[weapon][0]+'&head='+data_array[weapon][1]+'&rightarm='+data_array[weapon][2]+'&leftarm='+data_array[weapon][3]+'&chest='+data_array[weapon][4]+'&stomach='+data_array[weapon][5]+'&rightleg='+data_array[weapon][6]+'&leftleg='+data_array[weapon][7]+'&model='+data_array[weapon][8]+'&numcolor_num=<?php echo $g_options['body_text'] ?>&numcolor_pct=<?php echo $g_options['body_text'] ?>&linecolor=<?php echo $g_options['table_head_text'] ?>&barcolor=#FFFFFF&barbackground=#000000&textcolor=#FFFFFF&captioncolor=#FFFFFF&textcolor_total=#FFFFFF');
       }   
     } else if (document.getElementById) { 
       var obj = document.getElementById('hitbox'); 
       if (typeof obj.LoadMovie != 'undefined') { 
         obj.LoadMovie(0, '<?php echo IMAGE_PATH_URL."/".$g_options["imgdir"]; ?>/hitbox.swf?wname='+data_array[weapon][0]+'&head='+data_array[weapon][1]+'&rightarm='+data_array[weapon][2]+'&leftarm='+data_array[weapon][3]+'&chest='+data_array[weapon][4]+'&stomach='+data_array[weapon][5]+'&rightleg='+data_array[weapon][6]+'&leftleg='+data_array[weapon][7]+'&model='+data_array[weapon][8]+'&numcolor_num=<?php echo $g_options['body_text'] ?>&numcolor_pct=<?php echo $g_options['body_text'] ?>&linecolor=<?php echo $g_options['table_head_text'] ?>&barcolor=#FFFFFF&barbackground=#000000&textcolor=#FFFFFF&captioncolor=#FFFFFF&textcolor_total=#FFFFFF');
       } 
     }
   }     
</script>

<tr>  
	<?php
    if (SHOW_WEAPON_TARGET_FLASH == 1) {
      echo '<td width="80%" valign="top" style="padding-top:20px;padding-left:25px;">';

      $tblWeaponstats2->draw($result, $db->num_rows($result), 100);
      ?>
      </td><td colspan="2" align="left" valign="top" style="padding-top:20px;">
      <table border=0 cellspacing=0 cellpadding=0 bgcolor="<?php echo $g_options["table_border"]; ?>">
      <tr valign="top"><td>
        <table width="100%" border=0 cellspacing=1 cellpadding=4>
        <tr bgcolor="<?php echo $g_options["table_head_bgcolor"]; ?>"><td align="center"><?php echo $g_options["font_small"]; ?><font color="<?php echo $g_options["table_head_text"] ?>">Targets</font><?php echo $g_options["fontend_small"]; ?><img src="<?php echo $g_options["imgdir"]; ?>/spacer.gif"width=7 height=7 hspace=4 border=0 align="middle" alt="spacer.gif"></td></tr>
        <tr bgcolor="<?php echo $g_options["table_bgcolor1"]; ?>"><td>                                                                                                              
        <OBJECT classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" WIDTH="470" HEIGHT="360" ALIGN="" codebase="http://download.  macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0" id="hitbox">
         <PARAM NAME="movie"   VALUE="<?php echo IMAGE_PATH_URL."/".$g_options["imgdir"]; ?>/hitbox.swf?wname=All+Weapons&head=<?php echo $weapon_data['total']['head'] ?>&rightarm=<?php echo $weapon_data['total']['leftarm'] ?>&leftarm=<?php echo $weapon_data['total']['rightarm'] ?>&chest=<?php echo $weapon_data['total']['chest'] ?>&stomach=<?php echo $weapon_data['total']['stomach'] ?>&rightleg=<?php echo $weapon_data['total']['leftleg'] ?>&leftleg=<?php echo $weapon_data['total']['rightleg'] ?>&model=<?php echo $start_model ?>&numcolor_num=<?php echo $g_options['body_text'] ?>&numcolor_pct=<?php echo $g_options['body_text'] ?>&linecolor=<?php echo $g_options['table_head_text'] ?>&barcolor=#FFFFFF&barbackground=#000000&textcolor=#FFFFFF&captioncolor=#FFFFFF&textcolor_total=#FFFFFF">
         <PARAM NAME="quality" VALUE="high">
         <PARAM NAME="wmode"   VALUE="opaque">
         <PARAM NAME="bgcolor" VALUE="<?php echo $g_options["table_bgcolor1"] ?>">
         <EMBED src="<?php echo IMAGE_PATH_URL."/".$g_options["imgdir"]; ?>/hitbox.swf?wname=All+Weapons&head=<?php echo $weapon_data['total']['head'] ?>&rightarm=<?php echo $weapon_data['total']['leftarm'] ?>&leftarm=<?php echo $weapon_data['total']['rightarm'] ?>&chest=<?php echo $weapon_data['total']['chest'] ?>&stomach=<?php echo $weapon_data['total']['stomach'] ?>&rightleg=<?php echo $weapon_data['total']['leftleg'] ?>&leftleg=<?php echo $weapon_data['total']['rightleg'] ?>&model=<?php echo $start_model ?>&numcolor_num=<?php echo $g_options['body_text'] ?>&numcolor_pct=<?php echo $g_options['body_text'] ?>&linecolor=<?php echo $g_options['table_head_text'] ?>&barcolor=#FFFFFF&barbackground=#000000&textcolor=#FFFFFF&captioncolor=#FFFFFF&textcolor_total=#FFFFFF"
           quality="high"
           wmode="opaque"
           width="470"
           height="360"
           bgcolor="<?php echo $g_options["table_bgcolor1"] ?>"
           name="hitbox"
           swLiveConnect="true"
           TYPE="application/x-shockwave-flash"
           PLUGINSPAGE="http://www.macromedia.com/go/getflashplayer">
         </EMBED>
        </OBJECT>
        </td></tr>
        <tr bgcolor="<?php echo $g_options["table_bgcolor1"]; ?>"><td align="center"><?php echo $g_options["font_small"]; ?><a href="javascript:switch_weapon('All Weapons');">Show total target statistics</a><?php echo $g_options["fontend_small"]; ?></td>
        </tr>
        </table>
      </td></tr>  
      </table>  
      <?php
    } else {
      echo '<td width="100%" colspan=3 style="padding-left:25px;">&nbsp;<br>';
      $tblWeaponstats2->draw($result, $db->num_rows($result), 100);
      
    }  
	?></td>
</tr>

</table><p>
<?php
}
	flush();
	
	$tblMaps = new Table(
		array(
			new TableColumn(
				"map",
				"Map Name",
				"width=15&align=left&link=" . urlencode("mode=mapinfo&map=%k&game=$game")
			),
			new TableColumn(
				"kills",
				"Kills",
				"width=6&align=right"
			),
			new TableColumn(
				"kpercent",
				"Percentage of Kills",
				"width=15&sort=no&type=bargraph"
			),
			new TableColumn(
				"kpercent",
				"%",
				"width=5&sort=no&align=right&append=" . urlencode("%")
			),
			new TableColumn(
				"deaths",
				"Deaths",
				"width=6&align=right"
			),
			new TableColumn(
				"kpd",
				"Kills per Death",
				"width=13&align=right"
			),
			new TableColumn(
				"headshots",
				"Headshots",
				"width=9&align=right"
			),
			new TableColumn(
				"hpercent",
				"Percentage of Headshots",
				"width=16&sort=no&type=bargraph"
			),
			new TableColumn(
				"hpercent",
				"%",
				"width=5&sort=no&align=right&append=" . urlencode("%")
			),
			new TableColumn(
				"hpk",
				"Hpk",
				"width=5&align=right"
			)
			
		),
		"map",
		"kpd",
		"kills",
		true,
		9999,
		"maps_page",
		"maps_sort",
		"maps_sortorder",
		"maps"
	);

	$result = $db->query("
		SELECT
			IF(map='', '(Unaccounted)', map) AS map,
			SUM(killerId=$player) AS kills,
			SUM(victimId=$player) AS deaths,
			IFNULL(SUM(killerId=$player) / SUM(victimId=$player), '-') AS kpd,
			ROUND(CONCAT(SUM(killerId=$player)) / $realkills * 100, 2) AS kpercent,
			SUM(killerID=$player AND headshot=1) as headshots,
			IFNULL(SUM(killerID=$player AND headshot=1) / SUM(killerId=$player), '-') AS hpk,
			ROUND(CONCAT(SUM(killerId=$player AND headshot=1)) / $realheadshots * 100, 2) AS hpercent
		FROM
			hlstats_Events_Frags
		LEFT JOIN hlstats_Servers ON
			hlstats_Servers.serverId=hlstats_Events_Frags.serverId
		WHERE
			hlstats_Servers.game='$game' AND killerId='$player'
			OR victimId='$player'
		GROUP BY
			map
		ORDER BY
			$tblMaps->sort $tblMaps->sortorder,
			$tblMaps->sort2 $tblMaps->sortorder
	");
?>
<table width="100%" align="center" border=0 cellspacing=0 cellpadding=0>

<tr>
	<td width="50%" colspan=2><a name="maps"></a>
<?php echo $g_options["font_normal"]; ?>&nbsp;<img src="<?php echo $g_options["imgdir"]; ?>/downarrow.gif" width=9 height=6 border=0 align="middle" alt="downarrow.gif"><b>&nbsp;Map Performance</b><?php echo $g_options["fontend_normal"];?></td>
	<td width="50%" align="right"><?php echo $g_options["font_normal"]; ?>(Last <?php echo DELETEDAYS; ?> Days)<?php echo $g_options["fontend_normal"];?></td>
</tr>

<tr>
  <td width="100%" colspan=3 style="padding-left:25px;">&nbsp;<br>
	<?php
		$tblMaps->draw($result, $db->num_rows($result), 100);
	?></td>
</tr>

</table><p>

<?php
	flush();

	$tblPlayerKillStats = new Table(
		array(
			new TableColumn(
				"name",
				"Victim",
        "width=32&flag=1&link=" . urlencode("mode=playerinfo&player=%k")
			),
			new TableColumn(
				"kills",
				"Kills",
        "width=8&align=right"
			),
			new TableColumn(
				"deaths",
				"Deaths",
        "width=8&align=right"
			),
			new TableColumn(
				"kpd",
				"Kills per Death",
        "width=12&align=right"
			),
			new TableColumn(
				"headshots",
				"Headshots",
				"width=8&align=right"
			),
			new TableColumn(
				"hpercent",
				"Percentage of Headshots",
				"width=17&sort=no&type=bargraph"
			),
			new TableColumn(
				"hpercent",
				"%",
				"width=5&sort=no&align=right&append=" . urlencode("%")
			),
			new TableColumn(
				"hpk",
				"Hpk",
				"width=5&align=right"
			)
			
		),
		"victimId",
		"kills",
		"deaths",
		true,
		9999,
		"playerkills_page",
		"playerkills_sort",
		"playerkills_sortorder",
		"playerkills"
	);

  if(!isset($_GET['killLimit']))  
     $killLimit = 5;
  else   
    $killLimit = valid_request($_GET['killLimit'], 1);

	//there might be a better way to do this, but I could not figure one out.

	 $db->query("DROP TABLE IF EXISTS hlstats_Frags_Kills");
	 $db->query("
		CREATE TEMPORARY TABLE hlstats_Frags_Kills
		(
			playerId INT(10),
			kills INT(10),
			deaths INT(10),
			headshot INT(10),
      country varchar(128),
      flag char(2)

		)
	");
	 $db->query("
			INSERT INTO
				hlstats_Frags_Kills
				(
					playerId,
					kills,
					headshot
				)
					SELECT
						hlstats_Events_Frags.victimId,
						hlstats_Events_Frags.killerId,
					  hlstats_Events_Frags.headshot
  				FROM
						hlstats_Events_Frags, hlstats_Servers
					WHERE
            hlstats_Servers.serverId=hlstats_Events_Frags.serverId
            AND hlstats_Servers.game='$game' 
            AND hlstats_Events_Frags.killerId = $player
					GROUP BY
					  hlstats_Events_Frags.id
	");

	 $db->query("
			INSERT INTO
				hlstats_Frags_Kills
				(
					playerId,
					deaths
				)
					SELECT
						killerId,
						victimId
					FROM
						hlstats_Events_Frags, hlstats_Servers
					WHERE
            hlstats_Servers.serverId=hlstats_Events_Frags.serverId
						AND hlstats_Servers.game='$game' AND victimId = $player
		");
		
		$result = $db->query("
				SELECT
					SUM(hlstats_Frags_Kills.headshot) as headshots
				FROM
					hlstats_Frags_Kills
				GROUP BY
					hlstats_Frags_Kills.playerId
				HAVING
          Count(hlstats_Frags_Kills.kills) >= $killLimit
		");
		$realheadshots = 0;
		while ($rowdata = $db->fetch_array($result))  {
			$realheadshots += $rowdata['headshots'];
		}	

		$result = $db->query("
				SELECT
					hlstats_Players.lastName AS name,
          hlstats_Players.flag AS flag,
          hlstats_Players.country AS country,
					Count(hlstats_Frags_Kills.kills) AS kills,
					Count(hlstats_Frags_Kills.deaths) AS deaths,
					hlstats_Frags_Kills.playerId as victimId,
					IFNULL(Count(hlstats_Frags_Kills.kills)/Count(hlstats_Frags_Kills.deaths),
					IFNULL(FORMAT(Count(hlstats_Frags_Kills.kills), 2), '-')) AS kpd,
					SUM(hlstats_Frags_Kills.headshot=1) AS headshots,
 			    IFNULL(SUM(hlstats_Frags_Kills.headshot=1) / Count(hlstats_Frags_Kills.kills), '-') AS hpk,
			    ROUND(CONCAT(SUM(hlstats_Frags_Kills.headshot=1)) / $realheadshots * 100, 2) AS hpercent
				FROM
					hlstats_Frags_Kills,
					hlstats_Players
				WHERE
					hlstats_Frags_Kills.playerId = hlstats_Players.playerId
				GROUP BY
					hlstats_Frags_Kills.playerId
				HAVING
					Count(hlstats_Frags_Kills.kills) >= $killLimit
				ORDER BY
	            $tblPlayerKillStats->sort $tblPlayerKillStats->sortorder,
	            $tblPlayerKillStats->sort2 $tblPlayerKillStats->sortorder
		");

	$numitems = $db->num_rows($result);
			
?>
<table width="100%" align="center" border=0 cellspacing=0 cellpadding=0>
<tr>
  <td width="50%" colspan=2><a name="playerkills"></a>
<?php echo $g_options["font_normal"]; ?>&nbsp;<img src="<?php echo $g_options["imgdir"]; ?>/downarrow.gif" width=9 height=6 border=0 align="middle" alt="downarrow.gif"><b>&nbsp;Player Kill Statistics (<?php echo $killLimit ?> or more kills)</b><?php echo $g_options["fontend_normal"];?></td>
	<td width="50%" align="right"><?php echo $g_options["font_normal"]; ?>(Last <?php echo DELETEDAYS; ?> Days)<?php echo $g_options["fontend_normal"];?></td>
</tr>

<?php 
  if ($numitems > 0) {
?>
<tr>
  <td width="100%" colspan=3 style="padding-left:25px;">&nbsp;<br>
	<?php
    $tblPlayerKillStats->draw($result, $numitems, 100);
  ?></td>
</tr>
<?php } ?>
<tr>
	<td align="left" colspan=3 style="padding-left:25px"><form method="GET" action="<?php echo $g_options["scripturl"]; ?>" style="text-align:left;">
  <?php
    if ($numitems == 0)
      echo "<br>";
  ?>    
	<?php echo $g_options["font_normal"]; ?>Show people this person has killed
	<SELECT name="killLimit" onchange='changeLimit(this.options[this.selectedIndex].value)'>
<?php
  for($j = 0; $j < 16; $j++) {
		echo "<option value=$j";
		if($killLimit == $j) { echo " selected"; }
		echo ">$j</option>";
	}
?>
	</select>
	or more times in the last <?php echo DELETEDAYS; ?> days<?php echo $g_options["fontend_normal"];?>
	<script type="text/javascript" language="javascript">
	<!--
	function changeLimit(num) {
		location = "http://<?php echo $_SERVER['HTTP_HOST'] . $_SERVER['PHP_SELF'] ?>?mode=playerinfo&player=<?php echo $player ?>&killLimit=" + num + "#playerkills";
	}
	-->
	</script>
	</form></td>
</tr>
</table><p>

<table width="95%" align="center" border=0 cellspacing=0 cellpadding=0>

<tr>
	<td width="100%" align="right"><br><br>
	<?php echo $g_options["font_small"]; ?><b>Admin Options:</b> <a href="<?php echo $g_options["scripturl"] . "?mode=admin&task=tools_editdetails_player&id=$player"; ?>">Edit Player Details</a><?php echo $g_options["fontend_small"]; ?></td>
</tr>

</table><p>
