<?php
#
# HLstatsX - Real-time player and clan rankings and statistics for Half-Life 2
# http://www.hlstatsx.com/
# Copyright (C) 2005-2007 Tobias Oetzel (Tobi@hlstatsx.com)
#
# HlstatsX is an enhanced version of HLstats made by Simon Garner
# HLstats - Real-time player and clan rankings and statistics for Half-Life
# http://sourceforge.net/projects/hlstats/
# Copyright (C) 2001  Simon Garner
#             
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
	
	
	
	// Player Rankings
  $game="css";  
  if ((isset($_GET['game'])) && (is_string($_GET['game'])))
   $game = valid_request($_GET['game'], 0);
	
	$db->query("SELECT name FROM hlstats_Games WHERE code='$game'");
	if ($db->num_rows() < 1) error("No such game '$game'.");
	
	list($gamename) = $db->fetch_row();
	$db->free_result();
	
	$minkills = 1;
	
?>

<?php
	$table = new Table(
		array(
			new TableColumn(
				"lastName",
				"Name",
				"width=32&flag=1&link=" . urlencode("mode=statsme&amp;player=%k")
			),
			new TableColumn(
				"skill",
				"Points",
				"width=7&align=right&skill_change=1"
			),
      new TableColumn(
       "activity",
       "Activity",
       "width=6&sort=no&type=bargraph"
      ),
      new TableColumn(
       "connection_time",
       "Time",
       "width=14&align=right&type=timestamp"
      ),
      
			new TableColumn(
				"kills",
				"Kills",
				"width=7&align=right"
			),
			new TableColumn(
				"deaths",
				"Deaths",
				"width=7&align=right"
			),
			new TableColumn(
				"headshots",
				"Hs",
				"width=5&align=right"
			),
			new TableColumn(
				"hpk",
				"Hpk",
				"width=5&align=right"
			),
      new TableColumn(
        "kpd",
        "Kpd",
        "width=5&align=right"
      ),
			new TableColumn(
				"acc",
				"Accuracy",
				"width=7&align=right&append=" . urlencode("%")
			),
		),
		"playerId",
		"skill",
		"kpd",
		true,
    25
	);
	
  $day_interval = 28;  
	$result = $db->query("
		SELECT
			playerId,
      connection_time,
			lastName,
      flag,
      country,
			skill,
			kills,
			deaths,
			IFNULL(kills/deaths, '-') AS kpd,
			headshots,
			IFNULL(headshots/kills, '-') AS hpk,
			IFNULL(ROUND((hits / shots * 100), 1), 0.0) AS acc,
      IF(".MINACTIVITY." > (UNIX_TIMESTAMP() - last_event), ((100/".MINACTIVITY.") * (".MINACTIVITY." - (UNIX_TIMESTAMP() - last_event))), -1) as activity,
      last_skill_change
		FROM
			hlstats_Players
		WHERE
			game='$game'
			AND hideranking=0
			AND kills >= $minkills
    HAVING activity > 0
		ORDER BY
			$table->sort $table->sortorder,
			$table->sort2 $table->sortorder,
			lastName ASC
		LIMIT $table->startitem,$table->numperpage
	");
	
	$resultCount = $db->query("
		SELECT
			COUNT(*)
		FROM
			hlstats_Players
		WHERE
			game='$game'
			AND hideranking=0
			AND kills >= $minkills
      AND IF(".MINACTIVITY." > (UNIX_TIMESTAMP() - last_event), UNIX_TIMESTAMP() - last_event, 0) > 0
	");
	
	list($numitems) = $db->fetch_row($resultCount);
	
	$table->draw($result, 25, 100);
?>
