<?php
#
# HLstatsX - Real-time player and clan rankings and statistics for Half-Life 2
# http://www.hlstatsx.com/
# Copyright (C) 2005-2007 Tobias Oetzel (Tobi@hlstatsx.com)
#
# HlstatsX is an enhanced version of HLstats made by Simon Garner
# HLstats - Real-time player and clan rankings and statistics for Half-Life
# http://sourceforge.net/projects/hlstats/
# Copyright (C) 2001  Simon Garner
#             
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
	 
	$db->query("SELECT name FROM hlstats_Games WHERE code='$game'");
	if ($db->num_rows() < 1) error("No such game '$game'.");
	
	list($gamename) = $db->fetch_row();
	$db->free_result();

	pageHeader(array($gamename), array($gamename=>""));
    
?>
<?php
    $query= "
			SELECT
				count(*)
			FROM
				hlstats_Players
      WHERE 
        game='$game'
		";
		$result = $db->query($query);
		list($total_players) = $db->fetch_row($result);

    $query= "
        SELECT 
          players 
        FROM 
          hlstats_Trend 
        WHERE       
          game='$game'
          AND timestamp<=".(time()-86400)."
        ORDER BY 
          timestamp DESC LIMIT 0,1";
    $result = $db->query($query);
    list($total_players_24h) = $db->fetch_row($result);
    $players_last_day = -1;
    if ($total_players_24h > 0)
      $players_last_day = $total_players - $total_players_24h;
        

    $query= "
			SELECT
				SUM(kills),
				SUM(headshots),
				count(serverId)		
			FROM
				hlstats_Servers
      WHERE 
        game='$game'
      ORDER BY serverId
		";
		$result = $db->query($query);
		list($total_kills, $total_headshots, $total_servers) = $db->fetch_row($result);
        
    $query= "
            SELECT
                serverId,
                name,
                IF(publicaddress != '',
                    publicaddress,
                    concat(address, ':', port)
                ) AS addr,
                statusurl,
                kills,
                headshots,              
                act_players,                                
                max_players,
                act_map,
                map_started,
                map_ct_wins,
                map_ts_wins                 
            FROM
                hlstats_Servers
            WHERE
                game='$game'
            ORDER BY
                serverId
        ";
        $db->query($query);
        $servers = array();
        while ($rowdata = $db->fetch_array())
          $servers[] = $rowdata;
        
?>

<table width="100%" align="center" border=0 cellspacing=0 cellpadding=0>

<tr>
    <td><?php echo $g_options["font_normal"]; ?>&nbsp;<img src="<?php echo $g_options["imgdir"]; ?>/downarrow.gif" width=9 height=6 border=0 align="middle" alt="downarrow.gif"><b>&nbsp;Participating Servers</b><?php echo $g_options["fontend_normal"];?><p>

<?php
  if (count($servers) == 1)  {
?>


    <table width="95%" align="center" border=0 cellspacing=1 cellpadding=4 bgcolor="<?php echo $g_options["table_border"]; ?>">
    <tr bgcolor="<?php echo $g_options["table_head_bgcolor"]; ?>"><td width="100%" align="left"><font color="<?php echo $g_options["table_head_text"]; ?>"><?php
				if ($total_kills>0)
				  $hpk = sprintf("%.2f", ($total_headshots/$total_kills)*100);
				else  
				  $hpk = sprintf("%.2f", 0);
     		echo $g_options["font_normal"];
        if ($players_last_day > -1)    
				  echo "Tracking <b>".number_format($total_players)."</b> players (<b>+".number_format($players_last_day)."</b> new players last 24h) with <b>".number_format($total_kills)."</b> kills and <b>".number_format($total_headshots)."</b> headshots (<b>$hpk%</b>) on <b>".number_format($total_servers)."</b> servers";
        else
          echo "Tracking <b>".number_format($total_players)."</b> players with <b>".number_format($total_kills)."</b> kills and <b>".number_format($total_headshots)."</b> headshots (<b>$hpk%</b>) on <b>".number_format($total_servers)."</b> servers";
	      echo $g_options["fontend_normal"]; ?></font></td>
		</tr>	
    </table>

<?php
  } else  {
?>

    <table width="95%" align="center" border=0 cellspacing=1 cellpadding=2 bgcolor="<?php echo $g_options["table_border"]; ?>">
      <tr bgcolor="<?php echo $g_options["table_head_bgcolor"]; ?>"><td colspan="8" width="100%" align="left" style="padding:4px;"><font color="<?php echo $g_options["table_head_text"]; ?>"><?php
                     if ($total_kills>0)
                       $hpk = sprintf("%.2f", ($total_headshots/$total_kills)*100);
                     else  
                       $hpk = sprintf("%.2f", 0);
                     echo $g_options["font_normal"];
                     if ($players_last_day > -1)    
                       echo "Tracking <b>".number_format($total_players)."</b> players (<b>+".number_format($players_last_day)."</b> new players last 24h) with <b>".number_format($total_kills)."</b> kills and <b>".number_format($total_headshots)."</b> headshots (<b>$hpk%</b>) on <b>".number_format($total_servers)."</b> servers";
                     else
                       echo "Tracking <b>".number_format($total_players)."</b> players with <b>".number_format($total_kills)."</b> kills and <b>".number_format($total_headshots)."</b> headshots (<b>$hpk%</b>) on <b>".number_format($total_servers)."</b> servers";
                     echo $g_options["fontend_normal"]; ?></font></td>
      </tr>   

      <tr valign="bottom" bgcolor="<?php echo $g_options["table_head_bgcolor"]; ?>">
        <td style="padding:4px;" width="37%"><?php echo $g_options["font_small"]; ?><font color="<?php echo $g_options["table_head_text"]; ?>">&nbsp;Server</font><?php echo $g_options["fontend_small"]; ?></td>
        <td style="padding:4px;" width="23%"><?php echo $g_options["font_small"]; ?><font color="<?php echo $g_options["table_head_text"]; ?>">&nbsp;Address</font><?php echo $g_options["fontend_small"]; ?></td>
        <td style="padding:4px;" width="6%" align="center"><?php echo $g_options["font_small"]; ?><font color="<?php echo $g_options["table_head_text"]; ?>">&nbsp;Map</font><?php echo $g_options["fontend_small"]; ?></td>
        <td style="padding:4px;" width="6%" align="center"><?php echo $g_options["font_small"]; ?><font color="<?php echo $g_options["table_head_text"]; ?>">&nbsp;Played</font><?php echo $g_options["fontend_small"]; ?></td>
        <td style="padding:4px;" width="10%" align="center"><?php echo $g_options["font_small"]; ?><font color="<?php echo $g_options["table_head_text"]; ?>">&nbsp;Players</font><?php echo $g_options["fontend_small"]; ?></td>
        <td style="padding:4px;" width="6%" align="center"><?php echo $g_options["font_small"]; ?><font color="<?php echo $g_options["table_head_text"]; ?>">&nbsp;Kills</font><?php echo $g_options["fontend_small"]; ?></td>
        <td style="padding:4px;" width="6%" align="center"><?php echo $g_options["font_small"]; ?><font color="<?php echo $g_options["table_head_text"]; ?>">&nbsp;Headshots</font><?php echo $g_options["fontend_small"]; ?></td>
        <td style="padding:4px;" width="6%" align="center"><?php echo $g_options["font_small"]; ?><font color="<?php echo $g_options["table_head_text"]; ?>">&nbsp;Hpk</font><?php echo $g_options["fontend_small"]; ?></td>
      </tr>

<?php    
    $i=0;
    for ($i=0; $i<count($servers); $i++)
    {
        $rowdata = $servers[$i]; 
        $server_id = $rowdata['serverId'];
        $c = ($i % 2) + 1;
        if ($rowdata["statusurl"]) {
           $addr = $rowdata["addr"];
            #$addr = "<a href=\"" . $rowdata["statusurl"] . "\">"
            #   . $rowdata["addr"] . "</a>";
        } else {
            $addr = $rowdata["addr"];
        }
        $kills     = $rowdata['kills'];
        $headshots = $rowdata['headshots'];
        $player_string = $rowdata['act_players']."/".$rowdata['max_players'];
        $map_teama_wins = $rowdata['map_ct_wins'];
        $map_teamb_wins = $rowdata['map_ts_wins'];
?>

        <tr valign="middle" bgcolor="<?php echo $g_options["table_bgcolor$c"]; ?>">
            <td align="left" style="background:white;color:black"><?php
                echo $g_options["font_normal"];
                $imgfile = $g_options["imgdir"] . "/game-$game.gif";
                echo "<img style=\"vertical-align:middle;\"src=\"";
                if (file_exists($imgfile))
                  echo $imgfile;
                else
                  echo $g_options["imgdir"] . "/game.gif";
                echo "\">&nbsp;";
                echo "<b><a href=\"".$g_options["scripturl"]."?mode=servers&amp;server_id=$server_id&amp;game=$game\" style=\"color:black;text-decoration:none;\">".$rowdata["name"]."</a></b>";
                echo $g_options["fontend_normal"]; ?></td>
            <td align="left" style="background:white;color:black"><?php
                echo $g_options["font_normal"];
                echo "<a href=\"hlsw://$addr\" style=\"color:black\">$addr</a>";
                echo $g_options["fontend_normal"];
            ?></td>
            <td align="center" style="background:white;color:black"><?php
                echo $g_options["font_normal"];
                echo $rowdata['act_map'];
                echo $g_options["fontend_normal"];
            ?></td>
            <td align="center" style="background:white;color:black"><?php
               $stamp = time()-$rowdata['map_started'];
               $hours = sprintf("%02d", floor($stamp / 3600));
               $min   = sprintf("%02d", floor(($stamp % 3600) / 60));
               $sec   = sprintf("%02d", floor($stamp % 60)); 
               echo $g_options["font_normal"];
               echo $hours.":".$min.":".$sec;
               echo $g_options["fontend_normal"];
            ?></td>
            <td align="center" style="background:white;color:black"><?php
                echo $g_options["font_normal"];
                echo $player_string;
                echo $g_options["fontend_normal"];
            ?></td>
            <td align="center" style="background:white;color:black"><?php
                echo $g_options["font_normal"];
                echo number_format($kills);
                echo $g_options["fontend_normal"];
            ?></td>
            <td align="center" style="background:white;color:black"><?php
                echo $g_options["font_normal"];
                echo number_format($headshots);
                echo $g_options["fontend_normal"];
            ?></td>
            <td align="center" style="background:white;color:black"><?php
                echo $g_options["font_normal"];
                if ($kills>0)
                  echo sprintf("%.4f", ($headshots/$kills));
                else  
                  echo sprintf("%.4f", 0);
                echo $g_options["fontend_normal"];
            ?></td>
        </tr>
    <?php } echo '</table>'; } ?>         
    
    <?php if ((SHOW_GOOGLE_MAP == 1) || (SHOW_SERVER_LOAD_IMAGE == 1)){ ?>  
    <table width="95%" align="center" border=0 cellspacing=0 cellpadding=0 bgcolor="<?php echo $g_options["table_border"]; ?>" style="border-bottom:1px solid <?php echo $g_options["table_border"]; ?>;border-left:1px solid <?php echo $g_options["table_border"]; ?>;border-right:1px solid <?php echo $g_options["table_border"]; ?>;margin-bottom:40px;">
     <?php if (SHOW_GOOGLE_MAP == 1) { ?>  
        <tr bgcolor="<?php echo $g_options["table_head_bgcolor"]; ?>">
          <td align="center">
            <div id="map" style="margin:10px auto;width: 870px; height: 340px; color:black;"></div>
          </td>
        </tr>  
     <?php } ?>  
     <?php if (SHOW_SERVER_LOAD_IMAGE == 1) { ?>  
     <tr bgcolor="<?php echo $g_options["table_head_bgcolor"]; ?>">
       <td align="center" style="padding:0px;background:<?php echo $g_options["table_head_bgcolor"]; ?>;">
       <img src="show_graph.php?type=1&amp;game=<?php echo $game ?>&amp;width=870&amp;height=200&amp;bgcolor=<?php echo substr($g_options["table_head_bgcolor"], 1); ?>&amp;color=<?php echo substr($g_options["table_head_text"], 1); ?>">
       </td>
     </tr>
     <?php } ?>
    </table>
    <?php } ?>
    <?php if ((SHOW_GOOGLE_MAP == 0) && (SHOW_SERVER_LOAD_IMAGE == 0)){ ?>
      <br />     
    <?php } ?>
			
	
<?php

		$i=0;
		for ($i=0; $i<count($servers); $i++)
		{
			$rowdata = $servers[$i]; 
			
			$server_id = $rowdata['serverId'];
			
			$c = ($i % 2) + 1;
			
			if ($rowdata["statusurl"])
			{
        $addr = $rowdata["addr"];
				#$addr = "<a href=\"" . $rowdata["statusurl"] . "\">"
				#	. $rowdata["addr"] . "</a>";
			}
			else
			{
				$addr = $rowdata["addr"];
			}
			
			$kills     = $rowdata['kills'];
			$headshots = $rowdata['headshots'];
			
		  
		  $player_string = $rowdata['act_players']."/".$rowdata['max_players'];
		  $map_teama_wins = $rowdata['map_ct_wins'];
		  $map_teamb_wins = $rowdata['map_ts_wins'];

?>

      <table width="95%" align="center" border=0 cellspacing=1 cellpadding=2 bgcolor="<?php echo $g_options["table_border"]; ?>">
				<tr valign="bottom" bgcolor="<?php echo $g_options["table_head_bgcolor"]; ?>">
					<td style="padding:4px;"  width="37%"><?php echo $g_options["font_small"]; ?><font color="<?php echo $g_options["table_head_text"]; ?>">&nbsp;Server</font><?php echo $g_options["fontend_small"]; ?></td>
					<td style="padding:4px;"  width="23%"><?php echo $g_options["font_small"]; ?><font color="<?php echo $g_options["table_head_text"]; ?>">&nbsp;Address</font><?php echo $g_options["fontend_small"]; ?></td>
					<td style="padding:4px;"  width="6%" align="center"><?php echo $g_options["font_small"]; ?><font color="<?php echo $g_options["table_head_text"]; ?>">&nbsp;Map</font><?php echo $g_options["fontend_small"]; ?></td>
					<td style="padding:4px;"  width="6%" align="center"><?php echo $g_options["font_small"]; ?><font color="<?php echo $g_options["table_head_text"]; ?>">&nbsp;Played</font><?php echo $g_options["fontend_small"]; ?></td>
					<td style="padding:4px;"  width="10%" align="center"><?php echo $g_options["font_small"]; ?><font color="<?php echo $g_options["table_head_text"]; ?>">&nbsp;Players</font><?php echo $g_options["fontend_small"]; ?></td>
					<td style="padding:4px;"  width="6%" align="center"><?php echo $g_options["font_small"]; ?><font color="<?php echo $g_options["table_head_text"]; ?>">&nbsp;Kills</font><?php echo $g_options["fontend_small"]; ?></td>
					<td style="padding:4px;"  width="6%" align="center"><?php echo $g_options["font_small"]; ?><font color="<?php echo $g_options["table_head_text"]; ?>">&nbsp;Headshots</font><?php echo $g_options["fontend_small"]; ?></td>
					<td style="padding:4px;"  width="6%" align="center"><?php echo $g_options["font_small"]; ?><font color="<?php echo $g_options["table_head_text"]; ?>">&nbsp;Hpk</font><?php echo $g_options["fontend_small"]; ?></td>
				</tr>
				<tr valign="middle" bgcolor="<?php echo $g_options["table_bgcolor$c"]; ?>">
					<td align="left" style="background:white;color:black"><?php
						echo $g_options["font_normal"];
            $imgfile = $g_options["imgdir"] . "/game-$game.gif";
            echo "<img style=\"vertical-align:middle;\"src=\"";
            if (file_exists($imgfile))
              echo $imgfile;
            else
              echo $g_options["imgdir"] . "/game.gif";
            echo "\">&nbsp;";
            echo "<b><a href=\"".$g_options["scripturl"]."?mode=servers&amp;server_id=$server_id&amp;game=$game\" style=\"color:black;text-decoration:none;\">".$rowdata["name"]."</a></b>";
						echo $g_options["fontend_normal"]; ?></td>
					<td align="left" style="background:white;color:black"><?php
						echo $g_options["font_normal"];
						echo "<a href=\"hlsw://$addr\" style=\"color:black\">$addr</a>";
						echo $g_options["fontend_normal"];
					?></td>
					<td align="center" style="background:white;color:black"><?php
						echo $g_options["font_normal"];
						echo $rowdata['act_map'];
						echo $g_options["fontend_normal"];
					?></td>
					<td align="center" style="background:white;color:black"><?php
         	  $stamp = time()-$rowdata['map_started'];
         	  $hours = sprintf("%02d", floor($stamp / 3600));
	       	  $min   = sprintf("%02d", floor(($stamp % 3600) / 60));
	      	  $sec   = sprintf("%02d", floor($stamp % 60)); 
						echo $g_options["font_normal"];
						echo $hours.":".$min.":".$sec;
						echo $g_options["fontend_normal"];
					?></td>
					<td align="center" style="background:white;color:black"><?php
						echo $g_options["font_normal"];
						echo $player_string;
						echo $g_options["fontend_normal"];
					?></td>
					<td align="center" style="background:white;color:black"><?php
						echo $g_options["font_normal"];
						echo number_format($kills);
						echo $g_options["fontend_normal"];
					?></td>
					<td align="center" style="background:white;color:black"><?php
						echo $g_options["font_normal"];
						echo number_format($headshots);
						echo $g_options["fontend_normal"];
					?></td>
					<td align="center" style="background:white;color:black"><?php
						echo $g_options["font_normal"];
						if ($kills>0)
						  echo sprintf("%.4f", ($headshots/$kills));
						else  
						  echo sprintf("%.4f", 0);
						echo $g_options["fontend_normal"];
					?></td>
				</tr>
        </table>        

        <table width="95%" align="center" border=0 cellspacing=0 cellpadding=0 bgcolor="<?php echo $g_options["table_border"]; ?>" style="border-bottom:1px solid <?php echo $g_options["table_border"]; ?>;border-left:1px solid <?php echo $g_options["table_border"]; ?>;border-right:1px solid <?php echo $g_options["table_border"]; ?>;">
        <tr bgcolor="<?php echo $g_options["table_head_bgcolor"]; ?>">
          <td align="center" style="padding:0px;background:<?php echo $g_options["table_head_bgcolor"]; ?>;">
            <a href="<?php $g_options["scripturl"] ?>?mode=servers&amp;server_id=<?php echo $server_id ?>&amp;game=<?php echo $game ?>" style="text-decoration:none;"><img src="show_graph.php?type=0&amp;width=870&amp;height=200&amp;server_id=<?php echo $server_id ?>&amp;bgcolor=<?php echo substr($g_options["table_head_bgcolor"], 1); ?>&amp;color=<?php echo substr($g_options["table_head_text"], 1); ?>" style="border:0px;"></a>
          </td>
        </tr>
        </table>
                
        <table width="95%" align="center" border=0 cellspacing=0 cellpadding=2 bgcolor="<?php echo $g_options["table_border"]; ?>" style="border-bottom:1px solid <?php echo $g_options["table_border"]; ?>;border-left:1px solid <?php echo $g_options["table_border"]; ?>;border-right:1px solid <?php echo $g_options["table_border"]; ?>;margin-bottom:40px;">
    				<tr valign="bottom" bgcolor="<?php echo $g_options["table_head_bgcolor"]; ?>">

			  		<td width="2%" align="center"><?php echo $g_options["font_small"]; ?><font color="<?php echo $g_options["table_head_text"]; ?>">&nbsp;#</font><?php echo $g_options["fontend_small"]; ?></td>
		  			<td width="42%" align="left"><?php echo $g_options["font_small"]; ?><font color="<?php echo $g_options["table_head_text"]; ?>">&nbsp;Player</font><?php echo $g_options["fontend_small"]; ?></td>
			  		<td colspan="3" width="5%" align="center"><?php echo $g_options["font_small"]; ?><font color="<?php echo $g_options["table_head_text"]; ?>">&nbsp;Frags</font><?php echo $g_options["fontend_small"]; ?></td>
			  		<td width="4%" align="center"><?php echo $g_options["font_small"]; ?><font color="<?php echo $g_options["table_head_text"]; ?>">&nbsp;Hs</font><?php echo $g_options["fontend_small"]; ?></td>
			  		<td width="8%" align="center"><?php echo $g_options["font_small"]; ?><font color="<?php echo $g_options["table_head_text"]; ?>">&nbsp;Hpk</font><?php echo $g_options["fontend_small"]; ?></td>
			  		<td width="6%" align="center"><?php echo $g_options["font_small"]; ?><font color="<?php echo $g_options["table_head_text"]; ?>">&nbsp;Acc</font><?php echo $g_options["fontend_small"]; ?></td>
			  		<td width="6%" align="center"><?php echo $g_options["font_small"]; ?><font color="<?php echo $g_options["table_head_text"]; ?>">&nbsp;Lat</font><?php echo $g_options["fontend_small"]; ?></td>
			  		<td width="10%" align="center"><?php echo $g_options["font_small"]; ?><font color="<?php echo $g_options["table_head_text"]; ?>">&nbsp;Time</font><?php echo $g_options["fontend_small"]; ?></td>
			  		<td width="6%" align="center"><?php echo $g_options["font_small"]; ?><font color="<?php echo $g_options["table_head_text"]; ?>">&nbsp;+/-</font><?php echo $g_options["fontend_small"]; ?></td>
			  		<td width="6%" align="center"><?php echo $g_options["font_small"]; ?><font color="<?php echo $g_options["table_head_text"]; ?>">&nbsp;Skill</font><?php echo $g_options["fontend_small"]; ?></td>

				  </tr>
				
<?php 
    $team_colors = array("CT"        => array("#D2E8F7", "#0080C0", "Counter-Terrorist"),
                         "TERRORIST" => array("#FFD5D5", "#FF2D2D", "Terrorist"),
                         "Allies"    => array("#C1FFC1", "#006600", "Allies"),
                         "Axis"      => array("#FFD5D5", "#FF2D2D", "Axis")
                        );    
     
    $players = $db->query("SELECT * FROM hlstats_Livestats WHERE server_id=".$server_id." ORDER BY kills DESC");
		
		$teama_wins      = 0;
		$teama_kills     = 0;
		$teama_deaths    = 0;
		$teama_time      = 0;
		$teama_headshots = 0;
		$teama_pings     = 0;
		$teama_skill     = 0;
		$teama_shots     = 0;
		$teama_hits      = 0;
		
		$teamb_wins      = 0;
		$teamb_kills     = 0;
		$teamb_deaths    = 0;
		$teamb_time      = 0;
		$teamb_headshots = 0;
		$teamb_pings     = 0;
		$teamb_skill     = 0;
		$teamb_shots     = 0;
		$teamb_hits      = 0;

		$teama_players = array();
		$teamb_players = array();
		$co_players = array();
		while ($pl_rowdata = $db->fetch_array())
		{
			 if (($pl_rowdata['team'] == "CT") || ($pl_rowdata['team'] == "Allies")){
			   if ($pl_rowdata['connected'] > 0) {
  			 	 $teama_players[]  = $pl_rowdata;
           $teama_name       = $pl_rowdata['team'];       
  			 	 $teama_kills     += $pl_rowdata['kills'];
  			 	 $teama_deaths    += $pl_rowdata['deaths'];
  			 	 $teama_headshots += $pl_rowdata['headshots'];
  			 	 $teama_pings     += $pl_rowdata['ping'];
  			 	 $teama_skill     += $pl_rowdata['skill'];
  			 	 $teama_shots     += $pl_rowdata['shots']; 
  			 	 $teama_hits      += $pl_rowdata['hits']; 
  			 	 $teama_time      += time()-$pl_rowdata['connected'];
			   } else
  			   $co_players[] = $pl_rowdata;	 
			 } else if (($pl_rowdata['team'] == "TERRORIST") || ($pl_rowdata['team'] == "Axis")){
			   if ($pl_rowdata['connected'] > 0) {
			 	   $teamb_players[]  = $pl_rowdata;
           $teamb_name       = $pl_rowdata['team'];       
  			 	 $teamb_kills     += $pl_rowdata['kills'];
  			 	 $teamb_deaths    += $pl_rowdata['deaths'];
  			 	 $teamb_headshots += $pl_rowdata['headshots'];
  			 	 $teamb_pings     += $pl_rowdata['ping'];
  			 	 $teamb_skill     += $pl_rowdata['skill'];
  			 	 $teamb_shots     += $pl_rowdata['shots']; 
  			 	 $teamb_hits      += $pl_rowdata['hits']; 
  			 	 $teamb_time      += time()-$pl_rowdata['connected'];
			   } else
  			   $co_players[] = $pl_rowdata;	 
			 } else
			   $co_players[] = $pl_rowdata;	 
		}
        
    $color_team_a = "";
    if (isset($team_colors[$teama_name])) {
      $color_teama        = "background:".$team_colors[$teama_name][0].";color:".$team_colors[$teama_name][1];
      $color_teama_border = "background:".$team_colors[$teama_name][0].";color:".$team_colors[$teama_name][1].";border-top:1px ".$team_colors[$teama_name][1]." solid";
      $teama_display_name  = $team_colors[$teama_name][2];
    }     

    $color_team_b = "";
    if (isset($team_colors[$teamb_name])) {
      $color_teamb        = "background:".$team_colors[$teamb_name][0].";color:".$team_colors[$teamb_name][1];
      $color_teamb_border = "background:".$team_colors[$teamb_name][0].";color:".$team_colors[$teamb_name][1].";border-top:1px ".$team_colors[$teamb_name][1]." solid";
      $teamb_display_name  = $team_colors[$teamb_name][2];
    }
    
    $color_co = "background:#EFEFEF;color:#000";     
		
		$j=0;
		while (isset($teama_players[$j])) {
            		
?>
      <tr>
				<td align="center" style="<?php echo $color_teama ?>"><?php 
		   		echo $g_options["font_normal"];
		   		if (isset($teama_players[$j]))
			       echo ($j+1);
			     else
			       echo "&nbsp";  
			     echo $g_options["fontend_normal"]; ?></td>
				<td align="left" style="<?php echo $color_teama ?>"><?php 
		   		echo $g_options["font_normal"];
		   		if (isset($teama_players[$j])) {
            if (strlen($teama_players[$j]['name'])>50)
              $teama_players[$j]['name'] = substr($teama_players[$j]['name'], 0, 50);
				        echo "<a class=\"".strtolower($teama_name)."_link\" href=\"".$g_options["scripturl"]."?mode=playerinfo&amp;player=".$teama_players[$j]['player_id']."\">";
            if (SHOW_FLAGS == 1)            
              echo '<img src="'.$g_options["imgdir"].'/flags/'.flag_exists(strtolower($teama_players[$j]['cli_flag']).".gif").'" style="border:0px;" alt="'.ucfirst(strtolower($teama_players[$j]['cli_country'])).'" title="'.ucfirst(strtolower($teama_players[$j]['cli_country'])).'">&nbsp;';   
            echo htmlentities($teama_players[$j]['name'], ENT_COMPAT, "UTF-8")."</a>";
		   		} else
			      echo "&nbsp";  
			    echo $g_options["fontend_normal"]; ?></td>
				<td width="2%" align="right" style="<?php echo $color_teama ?>"><?php 
		   		echo $g_options["font_normal"];
		   		if (isset($teama_players[$j]))
			      echo $teama_players[$j]['kills'];
			    else
			      echo "&nbsp";  
			    echo $g_options["fontend_normal"]; ?></td>
				<td width="1%" align="center" style="<?php echo $color_teama ?>"><?php 
		   		echo $g_options["font_normal"];
		   		if (isset($teama_players[$j]))
			      echo ":";
			    else
			      echo "&nbsp";  
			    echo $g_options["fontend_normal"]; ?></td>
				<td width="2%" align="left" style="<?php echo $color_teama ?>"><?php 
      		echo $g_options["font_normal"];
      		if (isset($teama_players[$j]))
		        echo $teama_players[$j]['deaths'];
		      else
		        echo "&nbsp";  
		      echo $g_options["fontend_normal"]; ?></td>
				<td align="center" style="<?php echo $color_teama ?>"><?php 
      		echo $g_options["font_normal"];
      		if (isset($teama_players[$j]))
	          echo $teama_players[$j]['headshots'];
      		else
		        echo "&nbsp";  
		      echo $g_options["fontend_normal"]; ?></td>
				<td align="center" style="<?php echo $color_teama ?>"><?php 
      		echo $g_options["font_normal"];
      		if (isset($teama_players[$j])) {
      			$hpk = sprintf("%.2f", 0);
      			if ($teama_players[$j]['kills'] > 0) {
      				$hpk = sprintf("%.2f", $teama_players[$j]['headshots']/$teama_players[$j]['kills']);
      			}	  
	          echo $hpk;
      		} else
				    echo "&nbsp";  
		      echo $g_options["fontend_normal"]; ?></td>
				<td align="center" style="<?php echo $color_teama ?>"><?php 
	     		echo $g_options["font_normal"];
	     		if (isset($teama_players[$j])) {
	     			$acc = sprintf("%.0f", 0);
	    			if ($teama_players[$j]['shots'] > 0) {
	     				$acc = sprintf("%.0f", ($teama_players[$j]['hits']/$teama_players[$j]['shots'])*100);
	     			}	  
	          echo $acc."%";
	     		} else
  	        echo "&nbsp";  
			    echo $g_options["fontend_normal"]; ?></td>
    		<td align="center" style="<?php echo $color_teama ?>"><?php 
			 		echo $g_options["font_normal"];
			 		if (isset($teama_players[$j]))
			      echo sprintf("%.0f", $teama_players[$j]['ping'] / 2);
			    else
			      echo "&nbsp";  
			    echo $g_options["fontend_normal"]; ?></td>
   	  	<td align="center" style="<?php echo $color_teama ?>"><?php 
			 		echo $g_options["font_normal"];
			 		if (isset($teama_players[$j]))
			      if ($teama_players[$j]['connected']>0) {
			      	$stamp = time()-$teama_players[$j]['connected'];
					    $hours = sprintf("%02d", floor($stamp / 3600));
					    $min   = sprintf("%02d", floor(($stamp % 3600) / 60));
					    $sec   = sprintf("%02d", floor($stamp % 60)); 
					    echo $hours.":".$min.":".$sec;  
					  } else
					    echo "Unknown";	
			    else
		        echo "&nbsp";  
		      echo $g_options["fontend_normal"]; ?></td>
   			<td align="center" style="<?php echo $color_teama ?>"><?php 
      		echo $g_options["font_normal"];
      		if (isset($teama_players[$j]))
		        echo $teama_players[$j]['skill_change'];
		      else
		        echo "&nbsp";  
		      echo $g_options["fontend_normal"]; ?></td>
				<td align="center" style="<?php echo $color_teama ?>"><?php 
      		echo $g_options["font_normal"];
      		if (isset($teama_players[$j]))
		        echo number_format($teama_players[$j]['skill']);
		      else
		        echo "&nbsp";  
		      echo $g_options["fontend_normal"]; ?></td>
      </tr>
              
              
                        
<?php		
    $j++;
    }  // while teama players
    
    if (count($teama_players)>0) 
    {  // show summary
    ?>
       <tr>
         <td align="center" style="<?php echo $color_teama_border ?>"><?php 
            echo $g_options["font_normal"];
            echo "&nbsp";  
            echo $g_options["fontend_normal"]; ?></td>
         <td align="left" style="<?php echo $color_teama_border ?>"><?php 
            echo $g_options["font_normal"];
            echo "<b>".$teama_display_name."</b>";
            if (($map_teama_wins > 0) || ($map_teamb_wins > 0))
              echo "&nbsp;(".$map_teama_wins." wins)";  
            echo $g_options["fontend_normal"]; ?></td>
         <td width="2%" align="right" style="<?php echo $color_teama_border ?>"><?php 
            echo $g_options["font_normal"];
            if (count($teama_players) > 0)
              echo $teama_kills;
            else
              echo "&nbsp";  
            echo $g_options["fontend_normal"]; ?></td>
         <td width="1%" align="center" style="<?php echo $color_teama_border ?>"><?php 
            echo $g_options["font_normal"];
            if (count($teama_players) > 0)
              echo ":";
            else
              echo "&nbsp";  
            echo $g_options["fontend_normal"]; ?></td>
         <td width="2%" align="left" style="<?php echo $color_teama_border ?>"><?php 
            echo $g_options["font_normal"];
            if (count($teama_players) > 0)
              echo $teama_deaths;
            else
              echo "&nbsp";  
            echo $g_options["fontend_normal"]; ?></td>
         <td align="center" style="<?php echo $color_teama_border ?>"><?php 
            echo $g_options["font_normal"];
            if (count($teama_players) > 0)
              echo $teama_headshots;
            else
              echo "&nbsp";  
            echo $g_options["fontend_normal"]; ?></td>
         <td align="center" style="<?php echo $color_teama_border ?>"><?php 
            echo $g_options["font_normal"];
            if (count($teama_players) > 0) {
              $hpk = sprintf("%.2f", 0);
              if ($teama_kills > 0)
                $hpk = sprintf("%.2f", $teama_headshots/$teama_kills);
              echo $hpk;
            } else
              echo "&nbsp";  
            echo $g_options["fontend_normal"]; ?></td>
         <td align="center" style="<?php echo $color_teama_border ?>"><?php 
            echo $g_options["font_normal"];
            if (count($teama_players) > 0) {
              $acc = sprintf("%.0f", 0);
              if ($teama_shots > 0)
                $acc = sprintf("%.0f", ($teama_hits/$teama_shots)*100);
               echo $acc."%";
            } else
              echo "&nbsp";  
            echo $g_options["fontend_normal"]; ?></td>
         <td align="center" style="<?php echo $color_teama_border ?>"><?php 
            echo $g_options["font_normal"];
            if (count($teama_players) > 0)
              echo sprintf("%.0f", ($teama_pings / 2) / count($teama_players));
            else
              echo "&nbsp";  
            echo $g_options["fontend_normal"]; ?></td>
         <td align="center" style="<?php echo $color_teama_border ?>"><?php 
            echo $g_options["font_normal"];
            if (count($teama_players) > 0)
              if ($teama_time > 0) {
                $stamp = $teama_time;
                $hours = sprintf("%02d", floor($stamp / 3600));
                $min   = sprintf("%02d", floor(($stamp % 3600) / 60));
                $sec   = sprintf("%02d", floor($stamp % 60)); 
                echo $hours.":".$min.":".$sec;  
              } else
                echo "Unknown";   
            else
              echo "&nbsp";  
            echo $g_options["fontend_normal"]; ?></td>
          <td align="center" style="<?php echo $color_teama_border ?>"><?php 
             echo $g_options["font_normal"];
             echo "-";  
             echo $g_options["fontend_normal"]; ?></td>
          <td align="center" style="<?php echo $color_teama_border ?>"><?php 
             echo $g_options["font_normal"];
             if (count($teama_players)>0)
               echo number_format(sprintf("%.0f", $teama_skill/count($teama_players)));
             else
               echo "&nbsp";  
             echo $g_options["fontend_normal"]; ?></td>
      </tr>
                        
<?php
    }    
    
    $j=0;
    while (isset($teamb_players[$j])) {        
?>
      <tr>
        <td align="center" style="<?php echo $color_teamb ?>"><?php 
          echo $g_options["font_normal"];
          if (isset($teamb_players[$j]))
            echo ($j+1);
          else
            echo "&nbsp";  
          echo $g_options["fontend_normal"]; ?></td>
        <td align="left" style="<?php echo $color_teamb ?>"><?php 
           echo $g_options["font_normal"];
           if (isset($teamb_players[$j])) {
             if (strlen($teamb_players[$j]['name'])>50)
               $teamb_players[$j]['name'] = substr($teamb_players[$j]['name'], 0, 50);
             echo "<a class=\"".strtolower($teamb_name)."_link\" href=\"".$g_options["scripturl"]."?mode=playerinfo&amp;player=".$teamb_players[$j]['player_id']."\">";
             if (SHOW_FLAGS == 1)            
               echo '<img src="'.$g_options["imgdir"].'/flags/'.flag_exists(strtolower($teamb_players[$j]['cli_flag']).".gif").'" style="border:0px;" alt="'.ucfirst(strtolower($teamb_players[$j]['cli_country'])).'" title="'.ucfirst(strtolower($teamb_players[$j]['cli_country'])).'">&nbsp;';   
             echo htmlentities($teamb_players[$j]['name'], ENT_COMPAT, "UTF-8")."</a>";
           } else
             echo "&nbsp";  
           echo $g_options["fontend_normal"]; ?></td>
        <td width="2%" align="right" style="<?php echo $color_teamb ?>"><?php 
           echo $g_options["font_normal"];
           if (isset($teamb_players[$j]))
             echo $teamb_players[$j]['kills'];
           else
             echo "&nbsp";  
           echo $g_options["fontend_normal"]; ?></td>
        <td width="1%" align="center" style="<?php echo $color_teamb ?>"><?php 
           echo $g_options["font_normal"];
           if (isset($teamb_players[$j]))
             echo ":";
           else
             echo "&nbsp";  
           echo $g_options["fontend_normal"]; ?></td>
        <td width="2%" align="left" style="<?php echo $color_teamb ?>"><?php 
           echo $g_options["font_normal"];
           if (isset($teamb_players[$j]))
             echo $teamb_players[$j]['deaths'];
           else
             echo "&nbsp";  
           echo $g_options["fontend_normal"]; ?></td>
        <td align="center" style="<?php echo $color_teamb ?>"><?php 
           echo $g_options["font_normal"];
           if (isset($teamb_players[$j]))
             echo $teamb_players[$j]['headshots'];
           else
             echo "&nbsp";  
           echo $g_options["fontend_normal"]; ?></td>
        <td align="center" style="<?php echo $color_teamb ?>"><?php 
           echo $g_options["font_normal"];
           if (isset($teamb_players[$j])) {
             $hpk = sprintf("%.2f", 0);
             if ($teamb_players[$j]['kills'] > 0)
               $hpk = sprintf("%.2f", $teamb_players[$j]['headshots']/$teamb_players[$j]['kills']);
             echo $hpk;
           } else
             echo "&nbsp";  
           echo $g_options["fontend_normal"]; ?></td>
        <td align="center" style="<?php echo $color_teamb ?>"><?php 
           echo $g_options["font_normal"];
           if (isset($teamb_players[$j])) {
             $acc = sprintf("%.0f", 0);
             if ($teamb_players[$j]['shots'] > 0) {
               $acc = sprintf("%.0f", ($teamb_players[$j]['hits']/$teamb_players[$j]['shots'])*100);
             }     
             echo $acc."%";
           } else
             echo "&nbsp";  
           echo $g_options["fontend_normal"]; ?></td>
        <td align="center" style="<?php echo $color_teamb ?>"><?php 
           echo $g_options["font_normal"];
           if (isset($teamb_players[$j]))
             echo sprintf("%.0f", $teamb_players[$j]['ping'] / 2);
           else
             echo "&nbsp";  
           echo $g_options["fontend_normal"]; ?></td>
        <td align="center" style="<?php echo $color_teamb ?>"><?php 
           echo $g_options["font_normal"];
           if (isset($teamb_players[$j]))
             if ($teamb_players[$j]['connected']>0) {
                $stamp = time()-$teamb_players[$j]['connected'];
                $hours = sprintf("%02d", floor($stamp / 3600));
                $min   = sprintf("%02d", floor(($stamp % 3600) / 60));
                $sec   = sprintf("%02d", floor($stamp % 60)); 
                echo $hours.":".$min.":".$sec;  
              } else
                echo "Unknown"; 
           else
             echo "&nbsp";  
           echo $g_options["fontend_normal"]; ?></td>
        <td align="center" style="<?php echo $color_teamb ?>"><?php 
           echo $g_options["font_normal"];
           if (isset($teamb_players[$j]))
             echo $teamb_players[$j]['skill_change'];
           else
             echo "&nbsp";  
           echo $g_options["fontend_normal"]; ?></td>
        <td align="center" style="<?php echo $color_teamb ?>"><?php 
           echo $g_options["font_normal"];
           if (isset($teamb_players[$j]))
             echo number_format($teamb_players[$j]['skill']);
           else
             echo "&nbsp";  
           echo $g_options["fontend_normal"]; ?></td>
      </tr>
                        
<?php       
    $j++;
    }  // while teamb players

    
    if (count($teamb_players)>0) 
    {  // show summary
    ?>
       <tr>
         <td align="center" style="<?php echo $color_teamb_border ?>"><?php 
            echo $g_options["font_normal"];
            echo "&nbsp";  
            echo $g_options["fontend_normal"]; ?></td>
         <td align="left" style="<?php echo $color_teamb_border ?>"><?php 
            echo $g_options["font_normal"];
            echo "<b>".$teamb_display_name."</b>";
            if (($map_teama_wins > 0) || ($map_teamb_wins > 0))
              echo "&nbsp;(".$map_teamb_wins." wins)";  
            echo $g_options["fontend_normal"]; ?></td>
         <td width="2%" align="right" style="<?php echo $color_teamb_border ?>"><?php 
            echo $g_options["font_normal"];
            if (count($teamb_players) > 0)
              echo $teamb_kills;
            else
              echo "&nbsp";  
            echo $g_options["fontend_normal"]; ?></td>
         <td width="1%" align="center" style="<?php echo $color_teamb_border ?>"><?php 
            echo $g_options["font_normal"];
            if (count($teamb_players) > 0)
              echo ":";
            else
              echo "&nbsp";  
            echo $g_options["fontend_normal"]; ?></td>
         <td width="2%" align="left" style="<?php echo $color_teamb_border ?>"><?php 
            echo $g_options["font_normal"];
            if (count($teamb_players) > 0)
              echo $teamb_deaths;
            else
              echo "&nbsp";  
            echo $g_options["fontend_normal"]; ?></td>
         <td align="center" style="<?php echo $color_teamb_border ?>"><?php 
            echo $g_options["font_normal"];
            if (count($teamb_players) > 0)
              echo $teamb_headshots;
            else
              echo "&nbsp";  
            echo $g_options["fontend_normal"]; ?></td>
         <td align="center" style="<?php echo $color_teamb_border ?>"><?php 
            echo $g_options["font_normal"];
            if (count($teamb_players) > 0) {
              $hpk = sprintf("%.2f", 0);
              if ($teamb_kills > 0)
                $hpk = sprintf("%.2f", $teamb_headshots/$teamb_kills);
              echo $hpk;
            } else
              echo "&nbsp";  
            echo $g_options["fontend_normal"]; ?></td>
         <td align="center" style="<?php echo $color_teamb_border ?>"><?php 
            echo $g_options["font_normal"];
            if (count($teamb_players) > 0) {
              $acc = sprintf("%.0f", 0);
              if ($teamb_shots > 0)
                $acc = sprintf("%.0f", ($teamb_hits/$teamb_shots)*100);
               echo $acc."%";
            } else
              echo "&nbsp";  
            echo $g_options["fontend_normal"]; ?></td>
         <td align="center" style="<?php echo $color_teamb_border ?>"><?php 
            echo $g_options["font_normal"];
            if (count($teamb_players) > 0)
              echo sprintf("%.0f", ($teamb_pings / 2) / count($teamb_players));
            else
              echo "&nbsp";  
            echo $g_options["fontend_normal"]; ?></td>
         <td align="center" style="<?php echo $color_teamb_border ?>"><?php 
            echo $g_options["font_normal"];
            if (count($teamb_players) > 0)
              if ($teamb_time > 0) {
                $stamp = $teamb_time;
                $hours = sprintf("%02d", floor($stamp / 3600));
                $min   = sprintf("%02d", floor(($stamp % 3600) / 60));
                $sec   = sprintf("%02d", floor($stamp % 60)); 
                echo $hours.":".$min.":".$sec;  
              } else
                echo "Unknown";   
            else
              echo "&nbsp";  
            echo $g_options["fontend_normal"]; ?></td>
          <td align="center" style="<?php echo $color_teamb_border ?>"><?php 
             echo $g_options["font_normal"];
             echo "-";  
             echo $g_options["fontend_normal"]; ?></td>
          <td align="center" style="<?php echo $color_teamb_border ?>"><?php 
             echo $g_options["font_normal"];
             if (count($teamb_players)>0)
               echo number_format(sprintf("%.0f", $teamb_skill/count($teamb_players)));
             else
               echo "&nbsp";  
             echo $g_options["fontend_normal"]; ?></td>
      </tr>
                        
<?php
    }    
    
    $j=0;
    while (isset($co_players[$j])) {        
?>
      <tr>
        <td align="center" style="<?php echo $color_co ?>"><?php 
          echo $g_options["font_normal"];
          if (isset($co_players[$j]))
            echo ($j+1);
          else
            echo "&nbsp";  
          echo $g_options["fontend_normal"]; ?></td>
        <td align="left" style="<?php echo $color_co ?>"><?php 
           echo $g_options["font_normal"];
           if (isset($co_players[$j])) {
             if (strlen($co_players[$j]['name'])>50)
               $co_players[$j]['name'] = substr($co_players[$j]['name'], 0, 50);
             echo "<a class=\"co_link\" href=\"".$g_options["scripturl"]."?mode=playerinfo&amp;player=".$co_players[$j]['player_id']."\">";
             if (SHOW_FLAGS == 1)            
               echo '<img src="'.$g_options["imgdir"].'/flags/'.flag_exists(strtolower($co_players[$j]['cli_flag']).".gif").'" style="border:0px;" alt="'.ucfirst(strtolower($co_players[$j]['cli_country'])).'" title="'.ucfirst(strtolower($co_players[$j]['cli_country'])).'">&nbsp;';   
             echo htmlentities($co_players[$j]['name'], ENT_COMPAT, "UTF-8")."</a>";
           } else
             echo "&nbsp";  
           echo $g_options["fontend_normal"]; ?></td>
        <td width="2%" align="right" style="<?php echo $color_co ?>"><?php 
           echo $g_options["font_normal"];
           if (isset($co_players[$j]))
             echo $co_players[$j]['kills'];
           else
             echo "&nbsp";  
           echo $g_options["fontend_normal"]; ?></td>
        <td width="1%" align="center" style="<?php echo $color_co ?>"><?php 
           echo $g_options["font_normal"];
           if (isset($co_players[$j]))
             echo ":";
           else
             echo "&nbsp";  
           echo $g_options["fontend_normal"]; ?></td>
        <td width="2%" align="left" style="<?php echo $color_co ?>"><?php 
           echo $g_options["font_normal"];
           if (isset($co_players[$j]))
             echo $co_players[$j]['deaths'];
           else
             echo "&nbsp";  
           echo $g_options["fontend_normal"]; ?></td>
        <td align="center" style="<?php echo $color_co ?>"><?php 
           echo $g_options["font_normal"];
           if (isset($co_players[$j]))
             echo $co_players[$j]['headshots'];
           else
             echo "&nbsp";  
           echo $g_options["fontend_normal"]; ?></td>
        <td align="center" style="<?php echo $color_co ?>"><?php 
           echo $g_options["font_normal"];
           if (isset($co_players[$j])) {
             $hpk = sprintf("%.2f", 0);
             if ($co_players[$j]['kills'] > 0)
               $hpk = sprintf("%.2f", $co_players[$j]['headshots']/$co_players[$j]['kills']);
             echo $hpk;
           } else
             echo "&nbsp";  
           echo $g_options["fontend_normal"]; ?></td>
        <td align="center" style="<?php echo $color_co ?>"><?php 
           echo $g_options["font_normal"];
           if (isset($co_players[$j])) {
             $acc = sprintf("%.0f", 0);
             if ($co_players[$j]['shots'] > 0) {
               $acc = sprintf("%.0f", ($co_players[$j]['hits']/$co_players[$j]['shots'])*100);
             }     
             echo $acc."%";
           } else
             echo "&nbsp";  
           echo $g_options["fontend_normal"]; ?></td>
        <td align="center" style="<?php echo $color_co ?>"><?php 
           echo $g_options["font_normal"];
           if (isset($co_players[$j]))
             echo sprintf("%.0f", $co_players[$j]['ping'] / 2);
           else
             echo "&nbsp";  
           echo $g_options["fontend_normal"]; ?></td>
        <td align="center" style="<?php echo $color_co ?>"><?php 
           echo $g_options["font_normal"];
           if (isset($co_players[$j]))
             if ($co_players[$j]['connected']>0) {
                $stamp = time()-$co_players[$j]['connected'];
                $hours = sprintf("%02d", floor($stamp / 3600));
                $min   = sprintf("%02d", floor(($stamp % 3600) / 60));
                $sec   = sprintf("%02d", floor($stamp % 60)); 
                echo $hours.":".$min.":".$sec;  
              } else
                echo "Unknown"; 
           else
             echo "&nbsp";  
           echo $g_options["fontend_normal"]; ?></td>
        <td align="center" style="<?php echo $color_co ?>"><?php 
           echo $g_options["font_normal"];
           if (isset($co_players[$j]))
             echo $co_players[$j]['skill_change'];
           else
             echo "&nbsp";  
           echo $g_options["fontend_normal"]; ?></td>
        <td align="center" style="<?php echo $color_co ?>"><?php 
           echo $g_options["font_normal"];
           if (isset($co_players[$j]))
             echo number_format($co_players[$j]['skill']);
           else
             echo "&nbsp";  
           echo $g_options["fontend_normal"]; ?></td>
      </tr>
                        
<?php       
    $j++;
    }  // while co players
    if ((count($teama_players)==0) && (count($teamb_players)==0) && (count($co_players)==0))
    {
    	?>
              <tr>
       					<td align="center" style="background:#EFEFEF;color:black"><?php 
				      		echo $g_options["font_normal"];
					        echo "&nbsp";  
						      echo $g_options["fontend_normal"]; ?></td>
       					<td colspan="11" align="left" style="background:#EFEFEF;color:black"><?php 
				      		echo $g_options["font_normal"];
					        echo "No Players";  
						      echo $g_options["fontend_normal"]; ?></td>
						  </tr>
			<?php			      
    	
    }
    ?>
		  </table>
<?php			  	
	}  // for servers
?>
		
</table>
<?php
	$resultAwards = $db->query("
		SELECT
			hlstats_Awards.awardType,
			hlstats_Awards.code,
			hlstats_Awards.name,
			hlstats_Awards.verb,
			hlstats_Awards.d_winner_id,
			hlstats_Awards.d_winner_count,
			hlstats_Players.lastName AS d_winner_name,
      hlstats_Players.flag AS flag,
      hlstats_Players.country AS country
		FROM
			hlstats_Awards
		LEFT JOIN hlstats_Players ON
			hlstats_Players.playerId = hlstats_Awards.d_winner_id
		WHERE
			hlstats_Awards.game='$game'
		ORDER BY
			hlstats_Awards.awardType DESC,
			hlstats_Awards.name ASC
	");
	
	$result = $db->query("
		SELECT
			IFNULL(value, 1)
		FROM
			hlstats_Options
		WHERE
			keyname='awards_numdays'
	");

	if ($db->num_rows($result) == 1)
		list($awards_numdays) = $db->fetch_row($result);
	else
		$awards_numdays = 1;

	$result = $db->query("
		SELECT
			DATE_FORMAT(value, '%W %e %b'),
			DATE_FORMAT( DATE_SUB( value, INTERVAL $awards_numdays DAY ) , '%W %e %b' )
		FROM
			hlstats_Options
		WHERE
			keyname='awards_d_date'
	");
	list($awards_d_date, $awards_s_date) = $db->fetch_row($result);

	if ($db->num_rows($resultAwards) > 0 && $awards_d_date)
	{
?>
<table width="100%" align="center" border=0 cellspacing=0 cellpadding=0>

<tr>
	<td><?php echo $g_options["font_normal"]; ?>&nbsp;<img src="<?php echo $g_options["imgdir"]; ?>/downarrow.gif" width=9 height=6 border=0 align="middle" alt="downarrow.gif"><b>&nbsp; <?php if ($awards_numdays == 1) {echo "Daily";} else { echo "$awards_numdays Day";}; ?> Awards (<?php echo "$awards_d_date."; ?>)</b><?php echo $g_options["fontend_normal"];?><p>

		<table width="95%" align="center" border=0 cellspacing=0 cellpadding=0 bgcolor="<?php echo $g_options["table_border"]; ?>">
		<tr>
			<td>
				<table width="100%" border=0 cellspacing=1 cellpadding=4>

<?php
		$c = 0;
		while ($awarddata = $db->fetch_array($resultAwards))
		{
			$colour = ($c % 2) + 1;
			$c++;
?>

<tr bgcolor="<?php echo $g_options["table_bgcolor$colour"]; ?>">
	<td width="40%"><?php
			echo $g_options["font_normal"];
			echo htmlspecialchars($awarddata["name"]);
			echo $g_options["fontend_normal"];
		?></td>
	<td width="60%"><?php
			echo $g_options["font_normal"];
			
			if ($awarddata["d_winner_id"])
			{

        if (SHOW_FLAGS == 1) {  

          $flag = "0.gif";
          $alt  = "Unknown Country";
          if ($awarddata["flag"] != "") {
             $flag = flag_exists(strtolower($awarddata["flag"]).".gif");
             $alt  = ucfirst(strtolower($awarddata["country"]));
          }
  				echo "<a href=\"" . $g_options["scripturl"] . "?mode=playerinfo&amp;player="
	  				. $awarddata["d_winner_id"] . "\"><img src=\""
		  			. $g_options["imgdir"] . "/flags/$flag\""
			  		. "hspace=4 border=0 align=\"middle\" alt=\"$alt\" title=\"$alt\"><b>"
				  	. htmlentities($awarddata["d_winner_name"], ENT_COMPAT, "UTF-8") . "</b></a> ("
					  . $awarddata["d_winner_count"] . " " . htmlspecialchars($awarddata["verb"]) . ")";
        } else {
          echo "<a href=\"" . $g_options["scripturl"] . "?mode=playerinfo&amp;player="
               . $awarddata["d_winner_id"] . "\"><img src=\""
               . $g_options["imgdir"] . "/player.gif\""
               . "hspace=4 border=0 align=\"middle\" alt=\"Player\"><b>"
               . htmlentities($awarddata["d_winner_name"], ENT_COMPAT, "UTF-8") . "</b></a> ("
               . $awarddata["d_winner_count"] . " " . htmlspecialchars($awarddata["verb"]) . ")";
        }                  
			}
            
			else
			{
				echo "&nbsp;&nbsp;(Nobody)";
			}
			
			echo $g_options["fontend_normal"];
		?></td>
</tr>

<?php
		}
?></table></td>
		</tr>
		</table>


</table><p>

<?php
	}
?>
