<?php
#
# HLstatsX - Real-time player and clan rankings and statistics for Half-Life 2
# http://www.hlstatsx.com/
# Copyright (C) 2005-2007 Tobias Oetzel (Tobi@hlstatsx.com)
#
# HlstatsX is an enhanced version of HLstats made by Simon Garner
# HLstats - Real-time player and clan rankings and statistics for Half-Life
# http://sourceforge.net/projects/hlstats/
# Copyright (C) 2001  Simon Garner
#             
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
	
	
	// Clan Details
	
	$clan = valid_request(intval($HTTP_GET_VARS["clan"]), 1)
		or error("No clan ID specified.");
	
	$db->query("
		SELECT
			hlstats_Clans.tag,
			hlstats_Clans.name,
			hlstats_Clans.homepage,
			hlstats_Clans.game,
			SUM(hlstats_Players.kills) AS kills,
			SUM(hlstats_Players.deaths) AS deaths,
      SUM(hlstats_Players.connection_time) AS connection_time,
			COUNT(hlstats_Players.playerId) AS nummembers,
			ROUND(AVG(hlstats_Players.skill)) AS avgskill,
      TRUNCATE(AVG(IF(".MINACTIVITY." > (UNIX_TIMESTAMP() - hlstats_Players.last_event), ((100/".MINACTIVITY.") * (".MINACTIVITY." - (UNIX_TIMESTAMP() - hlstats_Players.last_event))), -1)),2) as activity
		FROM
			hlstats_Clans
		LEFT JOIN hlstats_Players ON
			hlstats_Players.clan = hlstats_Clans.clanId
      AND IF(".MINACTIVITY." > (UNIX_TIMESTAMP() - hlstats_Players.last_event), ((100/".MINACTIVITY.") * (".MINACTIVITY." - (UNIX_TIMESTAMP() - hlstats_Players.last_event))), -1) >= 0
		WHERE
			hlstats_Clans.clanId=$clan
      AND hlstats_Players.hideranking = 0
		GROUP BY
			hlstats_Clans.clanId
	");
	if ($db->num_rows() != 1)
		error("No such clan '$clan'.");
	
	$clandata = $db->fetch_array();
	$db->free_result();
	
	
	$cl_name = ereg_replace(" ", "&nbsp;", htmlspecialchars($clandata["name"]));
	$cl_tag  = ereg_replace(" ", "&nbsp;", htmlspecialchars($clandata["tag"]));
	$cl_full = $cl_tag . " " . $cl_name;
	
	$game = $clandata["game"];
	$db->query("SELECT name FROM hlstats_Games WHERE code='$game'");
	if ($db->num_rows() != 1)
		$gamename = ucfirst($game);
	else
		list($gamename) = $db->fetch_row();
	
	
	pageHeader(
		array($gamename, "Clan Details", $cl_full),
		array(
			$gamename=>$g_options["scripturl"] . "?game=$game",
			"Clan Rankings"=>$g_options["scripturl"] . "?mode=clans&amp;game=$game",
			"Clan Details"=>""
		),
		$clandata["name"]
	);
?>



<table width="100%" align="center" border=0 cellspacing=0 cellpadding=0>

<tr>
	<td width="100%" colspan=2><?php echo $g_options["font_normal"]; ?>&nbsp;<img src="<?php echo $g_options["imgdir"]; ?>/downarrow.gif" width=9 height=6 border=0 align="middle" alt="downarrow.gif"><b>&nbsp;Clan Information</b><?php echo $g_options["fontend_normal"];?></td>
</tr>

<tr valign="top">
  <td width="2%">&nbsp;</td>
  <td width="98%" colspan=2>&nbsp;<br>
		<table width="60%" border=0 cellspacing=0 cellpadding=0 bgcolor="<?php echo $g_options["table_border"]; ?>">
		<tr>
			<td>
				<table width="100%" border=0 cellspacing=1 cellpadding=4>

        <tr valign="bottom" bgcolor="<?php echo $g_options["table_head_bgcolor"]; ?>">
          <td align="left" colspan="3"><?php
             echo $g_options["font_normal"];
             echo "<font color=\"".$g_options["table_head_text"]."\">Statistics Summary</font>";
             echo $g_options["fontend_normal"];
           ?></td>
       </tr>


        <tr bgcolor="<?php echo $g_options["table_bgcolor1"]; ?>">
            <td align="left"><?php
                echo $g_options["font_normal"];
                echo "Clan Name:";
                echo $g_options["fontend_normal"];
            ?></td>
            <td align="left" colspan="2"><?php
                echo $g_options["font_normal"];
                echo "<b>".$clandata["name"]."</b>";
                echo $g_options["fontend_normal"];
            ?></td>
        </tr>


				<tr bgcolor="<?php echo $g_options["table_bgcolor2"]; ?>">
					<td align="left"><?php
						echo $g_options["font_normal"];
						echo "Home Page:";
						echo $g_options["fontend_normal"];
					?></td>
					<td align="left" colspan="2"><?php
						echo $g_options["font_normal"];
						if ($url = getLink($clandata["homepage"]))
						{
							echo $url;
						}
						else
						{
							echo "(Not specified.)";
						}
						echo $g_options["fontend_normal"];
					?></td>
				</tr>
				
				<tr bgcolor="<?php echo $g_options["table_bgcolor1"]; ?>">
					<td align="left"><?php
						echo $g_options["font_normal"];
						echo "Number of Members:";
						echo $g_options["fontend_normal"];
					?></td>
					<td align="left" colspan="2"><?php
						echo $g_options["font_normal"];
						echo $clandata["nummembers"];
						echo $g_options["fontend_normal"];
					?></td>
				</tr>
				
				<tr bgcolor="<?php echo $g_options["table_bgcolor2"]; ?>">
					<td align="left"><?php
						echo $g_options["font_normal"];
						echo "Avg. Member Points:";
						echo $g_options["fontend_normal"];
					?></td>
					<td align="left" colspan="2"><?php
						echo $g_options["font_normal"];
						echo number_format($clandata["avgskill"]);
						echo $g_options["fontend_normal"];
					?></td>
				</tr>
                
        <tr bgcolor="<?php echo $g_options["table_bgcolor1"]; ?>">
           <td align="left" width="45%"><?php
              echo $g_options["font_normal"];
              echo "Activity:";
              echo $g_options["fontend_normal"];
            ?></td>
            <td align="left" width="40%"><?php
              $width = sprintf("%d%%", $clandata['activity'] + 0.5);
              $bar_type = 1;
              if ($clandata['activity'] > 40)
                $bar_type = "6";
              elseif ($clandata['activity'] > 30)
                $bar_type = "5";
              elseif ($clandata['activity'] > 20)
                $bar_type = "4";
              elseif ($clandata['activity'] > 10)
                $bar_type = "3";
              elseif ($clandata['activity'] > 5)
                $bar_type = "2";
              echo "<img src=\"" . $g_options["imgdir"] . "/bar".$bar_type.".gif\" width=\"".$width."\" height=10 border=0 alt=\"".$clandata['activity']."%\">";            
            ?></td>
            <td align="left" width="15%"><?php
              echo $g_options["font_normal"];
              echo sprintf("%0.2f", $clandata["activity"])."%";
              echo $g_options["fontend_normal"];
            ?></td>
         </tr>
				
				<tr bgcolor="<?php echo $g_options["table_bgcolor2"]; ?>">
					<td align="left"><?php
						echo $g_options["font_normal"];
						echo "Total Kills:";
						echo $g_options["fontend_normal"];
					?></td>
					<td align="left" colspan="2"><?php
						echo $g_options["font_normal"];
						echo number_format($clandata["kills"]);
						echo $g_options["fontend_normal"];
					?></td>
				</tr>
				
				<tr bgcolor="<?php echo $g_options["table_bgcolor1"]; ?>">
					<td align="left"><?php
						echo $g_options["font_normal"];
						echo "Total Deaths:";
						echo $g_options["fontend_normal"];
					?></td>
					<td align="left" colspan="2"><?php
						echo $g_options["font_normal"];
						echo number_format($clandata["deaths"]);
						echo $g_options["fontend_normal"];
					?></td>
				</tr>
				
				<tr bgcolor="<?php echo $g_options["table_bgcolor2"]; ?>">
					<td align="left"><?php
						echo $g_options["font_normal"];
						echo "Kills per Death:";
						echo $g_options["fontend_normal"];
					?></td>
					<td align="left" colspan="2"><?php
						echo $g_options["font_normal"];
						if ($clandata["deaths"] != 0)
						{
							printf("%0.2f", $clandata["kills"] / $clandata["deaths"]);
						}
						else
						{
							echo "-";
						}
						echo $g_options["fontend_normal"];
					?></td>
        </tr>            
        <tr bgcolor="<?php echo $g_options["table_bgcolor1"]; ?>">
          <td align="left"><?php
             echo $g_options["font_normal"];
             echo "Total Connection Time:";
             echo $g_options["fontend_normal"];
          ?></td>
          <td align="left" colspan="2"><?php
             echo $g_options["font_normal"];
             echo timestamp_to_str($clandata['connection_time']);
             echo $g_options["fontend_normal"]; ?></td>
				</tr>


				</table></td>
		</tr>
		
		</table></td>
</tr>

</table><p>

<?php
	flush();
	
	$tblMembers = new Table(
		array(
			new TableColumn(
				"lastName",
				"Name",
				"width=32&flag=1&link=" . urlencode("mode=playerinfo&amp;player=%k")
			),
			new TableColumn(
				"skill",
				"Points",
				"width=6&align=right"
			),
      new TableColumn(
       "activity",
       "Activity",
       "width=10&sort=no&type=bargraph"
      ),
      new TableColumn(
       "connection_time",
       "Time",
       "width=13&align=right&type=timestamp"
      ),
			new TableColumn(
				"kills",
				"Kills",
				"width=6&align=right"
			),
			new TableColumn(
				"percent",
				"Clan Kills",
				"width=10&sort=no&type=bargraph"
			),
			new TableColumn(
				"percent",
				"%",
				"width=6&sort=no&align=right&append=" . urlencode("%")
			),
			new TableColumn(
				"deaths",
				"Deaths",
				"width=6&align=right"
			),
			new TableColumn(
				"kpd",
				"Kpd",
				"width=6&align=right"
			),
		),
		"playerId",
		"skill",
		"kpd",
		true,
		20,
		"members_page",
		"members_sort",
		"members_sortorder",
		"members"
	);

	$result = $db->query("
		SELECT
			playerId,
			lastName,
      country,
      flag,
			skill,
      connection_time,
			kills,
			deaths,
			IFNULL(kills/deaths, '-') AS kpd,
			(kills/" . $clandata["kills"] . ") * 100 AS percent,
      IF(".MINACTIVITY." > (UNIX_TIMESTAMP() - last_event), ((100/".MINACTIVITY.") * (".MINACTIVITY." - (UNIX_TIMESTAMP() - last_event))), -1) as activity
		FROM
			hlstats_Players
		WHERE
			clan=$clan
      AND hlstats_Players.hideranking = 0
    GROUP BY
      hlstats_Players.playerId
    HAVING
      activity >= 0
		ORDER BY
			$tblMembers->sort $tblMembers->sortorder,
			$tblMembers->sort2 $tblMembers->sortorder,
			lastName ASC
		LIMIT $tblMembers->startitem,$tblMembers->numperpage
	");
	
	$resultCount = $db->query("
		SELECT
			COUNT(*)
		FROM
			hlstats_Players
		WHERE
			clan=$clan
	");
	
	list($numitems) = $db->fetch_row($resultCount);
?>
<table width="100%" align="center" border=0 cellspacing=0 cellpadding=0>

<tr>
	<td width="100%" colspan=2><a name="members"></a>
<?php echo $g_options["font_normal"]; ?>&nbsp;<img src="<?php echo $g_options["imgdir"]; ?>/downarrow.gif" width=9 height=6 border=0 align="middle" alt="downarrow.gif"><b>&nbsp;Members</b><?php echo $g_options["fontend_normal"];?></td>
</tr>

<tr>
  <td width="2%">&nbsp;</td>
  <td width="98%" colspan=2>&nbsp;<br>
	<?php
		$tblMembers->draw($result, $numitems, 100);
	?></td>
</tr>

</table><p>

<br>
<br>

<table width="95%" align="center" border=0 cellspacing=0 cellpadding=0>

<tr>
	<td width="100%" align="right"><br><br>
	<?php echo $g_options["font_small"]; ?><b>Admin Options:</b> <a href="<?php echo $g_options["scripturl"] . "?mode=admin&amp;task=tools_editdetails_clan&amp;id=$clan"; ?>">Edit Clan Details</a><?php echo $g_options["fontend_small"]; ?></td>
</tr>

</table><p>
