<?php
#
# HLstatsX - Real-time player and clan rankings and statistics for Half-Life 2
# http://www.hlstatsx.com/
# Copyright (C) 2005-2007 Tobias Oetzel (Tobi@hlstatsx.com)
#
# HlstatsX is an enhanced version of HLstats made by Simon Garner
# HLstats - Real-time player and clan rankings and statistics for Half-Life
# http://sourceforge.net/projects/hlstats/
# Copyright (C) 2001  Simon Garner
#             
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
	
	
	
	// Player Rankings
	
	$db->query("SELECT name FROM hlstats_Games WHERE code='$game'");
	if ($db->num_rows() < 1) error("No such game '$game'.");
	
	list($gamename) = $db->fetch_row();
	$db->free_result();
	
	if (isset($HTTP_GET_VARS["minkills"]))
	{
		$minkills =  valid_request(intval($HTTP_GET_VARS["minkills"]),1);
	}
	else
	{
		$minkills = 0;
	}
	
	pageHeader(
		array($gamename, "Cheating Players"),
		array($gamename=>"%s?game=$game", "Cheating Players"=>"")
	);
?>
<table width="100%" align="center" border=0 cellspacing=0 cellpadding=0>
<tr>
    <td><?php echo $g_options["font_normal"]; ?>&nbsp;<img src="<?php echo $g_options["imgdir"]; ?>/downarrow.gif" width=9 height=6 border=0 align="middle" alt="downarrow.gif"><b>&nbsp;Cheating Players</b><?php echo $g_options["fontend_normal"];?><p>



<form method="GET" action="<?php echo $g_options["scripturl"]; ?>">
<input type="hidden" name="mode" value="search">
<input type="hidden" name="game" value="<?php echo $game; ?>">
<input type="hidden" name="st" value="player">

<table width="95%" align="center" border=0 cellspacing=0 cellpadding=2>

<tr valign="bottom">
	<td width="75%"><?php echo $g_options["font_normal"]; ?><b>&#149;</b> Find a player: <input type="text" name="q" size=20 maxlength=64 class="textbox"> <input type="submit" value="Search" class="smallsubmit"><?php echo $g_options["fontend_normal"]; ?></td>
	<td width="25%" align="right" nowrap>&nbsp;</td>
</tr>

</table><p>
</form>

<?php
	$table = new Table(
		array(
			new TableColumn(
				"lastName",
				"Name",
				"width=26&flag=1&link=" . urlencode("mode=playerinfo&amp;player=%k")
			),
      new TableColumn(
        "catch_date",
        "Catch Date",
        "width=15&align=right"
      ),
			new TableColumn(
				"skill",
				"Points",
				"width=5&align=right"
			),
      new TableColumn(
       "activity",
       "Activity",
       "width=10&sort=no&type=bargraph"
      ),
			new TableColumn(
				"kills",
				"Kills",
				"width=5&align=right"
			),
			new TableColumn(
				"deaths",
				"Deaths",
				"width=5&align=right"
			),
			new TableColumn(
				"headshots",
				"Headshots",
				"width=5&align=right"
			),
			new TableColumn(
				"hpk",
				"Hpk",
				"width=5&align=right"
			),
      new TableColumn(
        "kpd",
        "Kills per Death",
        "width=10&align=right"
      ),
			new TableColumn(
				"acc",
				"Accuracy",
				"width=5&align=right&append=" . urlencode("%")
			),
			new TableColumn(
				"playerId",
				"ID",
				"width=4&align=right&sort=no"
			)
		),
		"playerId",
		"last_event",
		"skill",
		true
	);
	
  $day_interval = 28;  
	$result = $db->query("
		SELECT
      FROM_UNIXTIME(last_event,'%d.%m.%Y %T') as catch_date,
			playerId,
      flag,
			lastName,
			skill,
			kills,
			deaths,
			IFNULL(kills/deaths, '-') AS kpd,
			headshots,
			IFNULL(headshots/kills, '-') AS hpk,
			IFNULL(ROUND((hits / shots * 100), 1), 0.0) AS acc,
      IF(".MINACTIVITY." > (UNIX_TIMESTAMP() - last_event), ((100/".MINACTIVITY.") * (".MINACTIVITY." - (UNIX_TIMESTAMP() - last_event))), 0) as activity
		FROM
			hlstats_Players
		WHERE
			game='$game'
			AND hideranking=2
			AND kills >= $minkills
		ORDER BY
			$table->sort $table->sortorder,
			$table->sort2 $table->sortorder,
			lastName ASC
		LIMIT $table->startitem,$table->numperpage
	");
	
	$resultCount = $db->query("
		SELECT
			COUNT(*)
		FROM
			hlstats_Players
		WHERE
			game='$game'
			AND hideranking=2
			AND kills >= $minkills
	");
	
	list($numitems) = $db->fetch_row($resultCount);
	
	$table->draw($result, $numitems, 95);
?><p>

<form method="GET" action="<?php echo $g_options["scripturl"]; ?>">
<table width="95%" align="center" border=0 cellspacing=0 cellpadding=2>

<tr valign="bottom">
	<td width="75%"><?php echo $g_options["font_normal"]; ?>
<?php
	foreach ($HTTP_GET_VARS as $k=>$v)
	{
    $v = valid_request($v, 0);     
		if ($k != "minkills")
		{
			echo "		<input type=\"hidden\" name=\"$k\" value=\"" . htmlspecialchars($v) . "\">\n";
		}
	}
?>
		<b>&#149;</b> Only show players with <input type="text" name="minkills" size=4 maxlength=2 value="<?php echo $minkills; ?>" class="textbox"> or more kills. <input type="submit" value="Apply" class="smallsubmit"><?php echo $g_options["fontend_normal"]; ?> </td>
</tr>

</table>
</form>

</td></tr>
</table>
