-- GunFu Deadlands
-- Copyright 2009 Christiaan Janssen, September-December 2009
--
-- This file is part of GunFu Deadlands.
--
--     GunFu Deadlands is free software: you can redistribute it and/or modify
--     it under the terms of the GNU General Public License as published by
--     the Free Software Foundation, either version 3 of the License, or
--     (at your option) any later version.
--
--     GunFu Deadlands is distributed in the hope that it will be useful,
--     but WITHOUT ANY WARRANTY; without even the implied warranty of
--     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--     GNU General Public License for more details.
--
--     You should have received a copy of the GNU General Public License
--     along with GunFu Deadlands.  If not, see <http://www.gnu.org/licenses/>.

function load()

	-- Dependencies
	love.filesystem.require("mymath.lua")
	love.filesystem.require("lists.lua")

	love.filesystem.require("sprites.lua")
	love.filesystem.require("audio.lua")

	love.filesystem.require("player.lua")
	love.filesystem.require("movement.lua")
	love.filesystem.require("enemies.lua")

	love.filesystem.require("entities.lua")
	love.filesystem.require("level.lua")

	love.filesystem.require("bullettime.lua")
	love.filesystem.require("editor.lua")
	love.filesystem.require("editor_files.lua")
	love.filesystem.require("userlevel.lua")

	love.filesystem.require("game.lua")



	-- Initialization
	start_time = love.timer.getTime()

	math.randomseed(os.time())

	-- Init graphics mode
    screensize = { 640, 480 }
	--if not love.graphics.setMode( screensize[1], screensize[2], false, true, 0 ) then
	if not Graphics.setWindowed() then
		love.system.exit()
	end

	Game.init()

	-- Colors
	Colors.init()

	-- Audio system
	if Sounds.active then
	love.audio.setChannels(16)
	love.audio.setVolume(.3)
	end

	-- Font
	love.graphics.setFont( love.graphics.newImageFont ("images/western_font_clear.png",
		"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890($>:.,!?)'<-+\\/ ") )


	Editor.load()
	UserLevel.load()

	Game.titlescreen()

	Music.start()


end

function update(dt)

	if Editor.enabled then
		Editor.update(dt)
		return
	elseif UserLevel.enabled then
		UserLevel.update(dt)
		return
	end

    Game.update(dt)

end


function draw()
	if Editor.enabled then
		Editor.draw()
		return
	elseif UserLevel.enabled then
		UserLevel.draw()
		return
	end

	Graphics.draw()

end


function keypressed(key)
	-- general
	if key == love.key_n then
		Sounds.switch()
	end

	if key == love.key_m then
		Music.switch()
	end

	if key == love.key_f12 then
		Graphics.toggleMode()
	end

	if Editor.enabled then
		Editor.keypressed( key )
		return
	elseif UserLevel.enabled then
		UserLevel.keypressed( key )
		return
	end

	Game.keypressed(key)

end


function keyreleased(key)
	if Editor.enabled then
		Editor.keyreleased( key )
		return
	elseif UserLevel.enabled then
		UserLevel.keyreleased( key )
		return
	end


	Game.keyreleased(key)

end


function mousepressed(x, y, button)
	if Editor.enabled then
		Editor.mousepressed(x, y, button)
		return
	elseif UserLevel.enabled then
		UserLevel.mousepressed(x, y, button)
		return
	end

	Game.mousepressed(x,y,button)

end



function mousereleased(x, y, button)
	if Editor.enabled then
		Editor.mousereleased(x, y, button)
		return
	elseif UserLevel.enabled then
		UserLevel.mousereleased(x, y, button)
		return
	end


	Game.mousereleased(x,y, button)

end



