"""
Copyright (C) 2008  Matthew and Joey Marshall <joey@arcticpaint.com>

See main.py for full notice.
"""
from __future__ import division

import sys

from gamelib import data
from gamelib.editor_ui import EditorUI
from gamelib.world import Map

import rabbyt
import pyglet
from pyglet.window import Window
from pyglet.clock import Clock
import snowui
from gamelib.main import cursors

def main():
    window = Window(width=1024, height=768)
    rabbyt.set_default_attribs()

    clock = Clock()
    clock.set_fps_limit(60)
    time = 0
    rabbyt.set_time(time)

    m = Map(sys.argv[1].strip(), clock)

    view = snowui.View(window)
    ui = EditorUI(m, view, window)
    window.push_handlers(ui)
    ui.setup()
    ui.cursors = cursors


    while not window.has_exit:
        time += clock.tick()
        window.dispatch_events()
        rabbyt.clear((.63,.79,1))
        rabbyt.set_time(time)
        view.set_viewport()
        #m.world.step()
        m.world.render()
        ui.render()
        window.flip()

if __name__ == "__main__":
    main()

