/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.metadata.identification;

import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opengis.util.CodeList;

public final class CharacterSet
extends CodeList {
    private static final long serialVersionUID = -4726629268456735927L;
    private static final List VALUES = new ArrayList(29);
    public static final CharacterSet UCS_2 = new CharacterSet("UCS_2", "UCS-2");
    public static final CharacterSet UCS_4 = new CharacterSet("UCS_4", "UCS-4");
    public static final CharacterSet UTF_7 = new CharacterSet("UTF_7", "UTF-7");
    public static final CharacterSet UTF_8 = new CharacterSet("UTF_8", "UTF-8");
    public static final CharacterSet UTF_16 = new CharacterSet("UTF_16", "UTF-16");
    public static final CharacterSet ISO_8859_1 = new CharacterSet("ISO_8859_1", "ISO-8859-1");
    public static final CharacterSet ISO_8859_2 = new CharacterSet("ISO_8859_2", "ISO-8859-2");
    public static final CharacterSet ISO_8859_3 = new CharacterSet("ISO_8859_3", "ISO-8859-3");
    public static final CharacterSet ISO_8859_4 = new CharacterSet("ISO_8859_4", "ISO-8859-4");
    public static final CharacterSet ISO_8859_5 = new CharacterSet("ISO_8859_5", "ISO-8859-5");
    public static final CharacterSet ISO_8859_6 = new CharacterSet("ISO_8859_6", "ISO-8859-6");
    public static final CharacterSet ISO_8859_7 = new CharacterSet("ISO_8859_7", "ISO-8859-7");
    public static final CharacterSet ISO_8859_8 = new CharacterSet("ISO_8859_8", "ISO-8859-8");
    public static final CharacterSet ISO_8859_9 = new CharacterSet("ISO_8859_9", "ISO-8859-9");
    public static final CharacterSet ISO_8859_10 = new CharacterSet("ISO_8859_10", "ISO-8859-10");
    public static final CharacterSet ISO_8859_11 = new CharacterSet("ISO_8859_11", "ISO-8859-11");
    public static final CharacterSet ISO_8859_12 = new CharacterSet("ISO_8859_12", "ISO-8859-12");
    public static final CharacterSet ISO_8859_13 = new CharacterSet("ISO_8859_13", "ISO-8859-13");
    public static final CharacterSet ISO_8859_14 = new CharacterSet("ISO_8859_14", "ISO-8859-14");
    public static final CharacterSet ISO_8859_15 = new CharacterSet("ISO_8859_15", "ISO-8859-15");
    public static final CharacterSet ISO_8859_16 = new CharacterSet("ISO_8859_16", "ISO-8859-16");
    public static final CharacterSet JIS = new CharacterSet("JIS", "JIS_X0201");
    public static final CharacterSet SHIFT_JIS = new CharacterSet("SHIFT_JIS", "Shift_JIS");
    public static final CharacterSet EUC_JP = new CharacterSet("EUC_JP", "EUC-JP");
    public static final CharacterSet US_ASCII = new CharacterSet("US_ASCII", "US-ASCII");
    public static final CharacterSet EBCDIC = new CharacterSet("EBCDIC", null);
    public static final CharacterSet EUC_KR = new CharacterSet("EUC_KR", "EUC-KR");
    public static final CharacterSet BIG_5 = new CharacterSet("BIG_5", "Big5");
    public static final CharacterSet GB2312 = new CharacterSet("GB2312", "GB2312");
    private final String charset;

    private CharacterSet(String string, String string2) {
        super(string, VALUES);
        this.charset = string2 != null ? string2 : string;
    }

    public Charset toCharset() throws UnsupportedCharsetException {
        return Charset.forName(this.charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CharacterSet[] values() {
        List list = VALUES;
        synchronized (list) {
            return VALUES.toArray(new CharacterSet[VALUES.size()]);
        }
    }

    public CodeList[] family() {
        return VALUES.toArray(new CodeList[VALUES.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CharacterSet valueOf(String string) {
        if (string == null) {
            return null;
        }
        List list = VALUES;
        synchronized (list) {
            Iterator iterator = VALUES.iterator();
            while (iterator.hasNext()) {
                CharacterSet characterSet = (CharacterSet)iterator.next();
                if (!string.equalsIgnoreCase(characterSet.name())) continue;
                return characterSet;
            }
            return new CharacterSet(string, string);
        }
    }
}

