/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.coverage;

import java.awt.image.renderable.RenderableImage;
import java.util.List;
import java.util.Set;
import org.opengis.coverage.CannotEvaluateException;
import org.opengis.coverage.CommonPointRule;
import org.opengis.coverage.GeometryValuePair;
import org.opengis.coverage.MetadataNameNotFoundException;
import org.opengis.coverage.SampleDimension;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.Geometry;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.temporal.Period;
import org.opengis.util.InternationalString;
import org.opengis.util.Record;
import org.opengis.util.RecordType;

public interface Coverage {
    public CoordinateReferenceSystem getCoordinateReferenceSystem();

    public Envelope getEnvelope();

    public Set getDomainExtents();

    public Set getDomainElements();

    public Set getRangeElements();

    public RecordType getRangeType();

    public CommonPointRule getCommonPointRule();

    public Set list();

    public Set select(Geometry var1, Period var2);

    public List find(DirectPosition var1, int var2);

    public GeometryValuePair find(DirectPosition var1);

    public Set evaluate(DirectPosition var1, Set var2);

    public Object evaluate(DirectPosition var1) throws CannotEvaluateException;

    public boolean[] evaluate(DirectPosition var1, boolean[] var2) throws CannotEvaluateException, ArrayIndexOutOfBoundsException;

    public byte[] evaluate(DirectPosition var1, byte[] var2) throws CannotEvaluateException, ArrayIndexOutOfBoundsException;

    public int[] evaluate(DirectPosition var1, int[] var2) throws CannotEvaluateException, ArrayIndexOutOfBoundsException;

    public float[] evaluate(DirectPosition var1, float[] var2) throws CannotEvaluateException, ArrayIndexOutOfBoundsException;

    public double[] evaluate(DirectPosition var1, double[] var2) throws CannotEvaluateException, ArrayIndexOutOfBoundsException;

    public Set evaluateInverse(Record var1);

    public InternationalString[] getDimensionNames();

    public int getNumSampleDimensions();

    public SampleDimension getSampleDimension(int var1) throws IndexOutOfBoundsException;

    public List getSources();

    public String[] getMetadataNames();

    public String getMetadataValue(String var1) throws MetadataNameNotFoundException;

    public RenderableImage getRenderableImage(int var1, int var2) throws UnsupportedOperationException, IndexOutOfBoundsException;
}

