/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.coverage.grid;

import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.coverage.grid.GridNotEditableException;
import org.opengis.coverage.grid.GridPacking;
import org.opengis.coverage.grid.GridRange;
import org.opengis.coverage.grid.InvalidRangeException;

@UML(identifier="CV_GridCoverage", specification=Specification.OGC_01004)
public interface GridCoverage
extends Coverage {
    @UML(identifier="dataEditable", obligation=Obligation.MANDATORY, specification=Specification.OGC_01004)
    public boolean isDataEditable();

    @UML(identifier="gridPacking", obligation=Obligation.MANDATORY, specification=Specification.OGC_01004)
    public GridPacking getGridPacking();

    @UML(identifier="gridGeometry", obligation=Obligation.MANDATORY, specification=Specification.OGC_01004)
    public GridGeometry getGridGeometry();

    @UML(identifier="optimalDataBlockSizes", obligation=Obligation.OPTIONAL, specification=Specification.OGC_01004)
    public int[] getOptimalDataBlockSizes();

    @UML(identifier="numOverviews", obligation=Obligation.MANDATORY, specification=Specification.OGC_01004)
    public int getNumOverviews();

    @UML(identifier="getOverviewGridGeometry", obligation=Obligation.MANDATORY, specification=Specification.OGC_01004)
    public GridGeometry getOverviewGridGeometry(int var1) throws IndexOutOfBoundsException;

    @UML(identifier="getOverview", obligation=Obligation.MANDATORY, specification=Specification.OGC_01004)
    public GridCoverage getOverview(int var1) throws IndexOutOfBoundsException;

    @UML(identifier="getDataBlockAsBoolean", obligation=Obligation.MANDATORY, specification=Specification.OGC_01004)
    public boolean[] getDataBlock(GridRange var1, boolean[] var2) throws InvalidRangeException, ArrayIndexOutOfBoundsException;

    @UML(identifier="getDataBlockAsByte", obligation=Obligation.MANDATORY, specification=Specification.OGC_01004)
    public byte[] getDataBlock(GridRange var1, byte[] var2) throws InvalidRangeException, ArrayIndexOutOfBoundsException;

    @UML(identifier="getDataBlockAsInteger", obligation=Obligation.MANDATORY, specification=Specification.OGC_01004)
    public short[] getDataBlock(GridRange var1, short[] var2) throws InvalidRangeException, ArrayIndexOutOfBoundsException;

    @UML(identifier="getDataBlockAsInteger", obligation=Obligation.MANDATORY, specification=Specification.OGC_01004)
    public int[] getDataBlock(GridRange var1, int[] var2) throws InvalidRangeException, ArrayIndexOutOfBoundsException;

    public float[] getDataBlock(GridRange var1, float[] var2) throws InvalidRangeException, ArrayIndexOutOfBoundsException;

    @UML(identifier="getValueBlockAsDouble", obligation=Obligation.MANDATORY, specification=Specification.OGC_01004)
    public double[] getDataBlock(GridRange var1, double[] var2) throws InvalidRangeException, ArrayIndexOutOfBoundsException;

    @UML(identifier="getPackedDataBlock", obligation=Obligation.MANDATORY, specification=Specification.OGC_01004)
    public byte[] getPackedDataBlock(GridRange var1) throws InvalidRangeException;

    @UML(identifier="setDataBlockAsBoolean", obligation=Obligation.MANDATORY, specification=Specification.OGC_01004)
    public void setDataBlock(GridRange var1, boolean[] var2) throws InvalidRangeException, GridNotEditableException, ArrayIndexOutOfBoundsException;

    @UML(identifier="setDataBlockAsByte", obligation=Obligation.MANDATORY, specification=Specification.OGC_01004)
    public void setDataBlock(GridRange var1, byte[] var2) throws InvalidRangeException, GridNotEditableException, ArrayIndexOutOfBoundsException;

    @UML(identifier="setDataBlockAsByte", obligation=Obligation.MANDATORY, specification=Specification.OGC_01004)
    public void setDataBlock(GridRange var1, short[] var2) throws InvalidRangeException, GridNotEditableException, ArrayIndexOutOfBoundsException;

    @UML(identifier="setDataBlockAsInteger", obligation=Obligation.MANDATORY, specification=Specification.OGC_01004)
    public void setDataBlock(GridRange var1, int[] var2) throws InvalidRangeException, GridNotEditableException, ArrayIndexOutOfBoundsException;

    @UML(identifier="setDataBlockAsInteger", obligation=Obligation.MANDATORY, specification=Specification.OGC_01004)
    public void setDataBlock(GridRange var1, float[] var2) throws InvalidRangeException, GridNotEditableException, ArrayIndexOutOfBoundsException;

    @UML(identifier="setDataBlockAsDouble", obligation=Obligation.MANDATORY, specification=Specification.OGC_01004)
    public void setDataBlock(GridRange var1, double[] var2) throws InvalidRangeException, GridNotEditableException, ArrayIndexOutOfBoundsException;

    @UML(identifier="setPackedDataBlock", obligation=Obligation.MANDATORY, specification=Specification.OGC_01004)
    public void setPackedDataBlock(GridRange var1, byte[] var2) throws InvalidRangeException, GridNotEditableException, ArrayIndexOutOfBoundsException;
}

