/*$************************************************************************************************
 **
 ** $Id: SymbolVisitor.java 982 2007-03-27 10:54:51Z desruisseaux $
 **
 ** $URL: https://geoapi.svn.sourceforge.net/svnroot/geoapi/tags/2.1.0/geoapi/src/main/java/org/opengis/sld/SymbolVisitor.java $
 **
 ** Copyright (C) 2005 Open GIS Consortium, Inc.
 ** All Rights Reserved. http://www.opengis.org/legal/
 **
 *************************************************************************************************/
package org.opengis.sld;

import org.opengis.annotation.Extension;


/**
 * Visitor with {@code visit} methods to be called by {@link Symbol#accept Symbol.accept(...)}.
 *
 * @version <A HREF="http://portal.opengeospatial.org/files/?artifact_id=1188">Implementation specification 1.0</A>
 * @author Chris Dillard (SYS Technologies)
 * @since GeoAPI 2.0
 */
@Extension
public interface SymbolVisitor {
    Object visit(LineSymbol    symbol, Object userData);
    Object visit(PointSymbol   symbol, Object userData);
    Object visit(PolygonSymbol symbol, Object userData);
    Object visit(TextSymbol    symbol, Object userData);
}
