/**************************************************************************************************
 **
 ** $Id: Halo.java 1122 2007-11-24 18:49:16Z desruisseaux $
 **
 ** $URL: https://geoapi.svn.sourceforge.net/svnroot/geoapi/tags/2.1.0/geoapi/src/main/java/org/opengis/go/display/style/Halo.java $
 **
 ** Copyright (C) 2003 Open GIS Consortium, Inc. All Rights Reserved. http://www.opengis.org/Legal/
 **
 *************************************************************************************************/
package org.opengis.go.display.style;


/**
 * Encapsulates the halo radius that can be applied to any text Graphic.
 *
 * @version 0.2
 * @author <A HREF="http://www.opengis.org">OpenGIS&reg; consortium</A>
 */
public interface Halo {
    /**
     * Halo radius attribute name.
     */
    String RADIUS = "HALO_RADIUS";

    /**
     * Returns the halo radius value.
     * @return the value of the halo radius.
     */
    float getRadius();

    /**
     * Returns whether the halo radius value has been set.
     * @return true if the halo radius value has been set, false otherwise.
     */
    boolean isRadiusSet();

    /**
     * Sets the halo radius value.
     * @param haloRadius the value of the halo radius.
     */
    void setRadius(float haloRadius);

    /**
     * Sets the fact that the halo radius value has been set.
     * @param flag true if the halo radius value has been set, false otherwise.
     */
    void setRadiusSet(boolean flag);
}
