/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.geometry.coordinate;

import java.util.List;
import java.util.Set;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.MismatchedReferenceSystemException;
import org.opengis.geometry.aggregate.MultiPrimitive;
import org.opengis.geometry.coordinate.Arc;
import org.opengis.geometry.coordinate.ArcByBulge;
import org.opengis.geometry.coordinate.ArcString;
import org.opengis.geometry.coordinate.ArcStringByBulge;
import org.opengis.geometry.coordinate.BSplineCurve;
import org.opengis.geometry.coordinate.BSplineSurface;
import org.opengis.geometry.coordinate.Geodesic;
import org.opengis.geometry.coordinate.GeodesicString;
import org.opengis.geometry.coordinate.Knot;
import org.opengis.geometry.coordinate.KnotType;
import org.opengis.geometry.coordinate.LineSegment;
import org.opengis.geometry.coordinate.LineString;
import org.opengis.geometry.coordinate.PointArray;
import org.opengis.geometry.coordinate.Polygon;
import org.opengis.geometry.coordinate.PolyhedralSurface;
import org.opengis.geometry.coordinate.Position;
import org.opengis.geometry.coordinate.Tin;
import org.opengis.geometry.primitive.Surface;
import org.opengis.geometry.primitive.SurfaceBoundary;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface GeometryFactory {
    public CoordinateReferenceSystem getCoordinateReferenceSystem();

    public DirectPosition createDirectPosition();

    public DirectPosition createDirectPosition(double[] var1);

    public Envelope createEnvelope(DirectPosition var1, DirectPosition var2) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    @UML(identifier="GM_LineSegment(GM_Position[2])", obligation=Obligation.MANDATORY, specification=Specification.ISO_19107)
    public LineSegment createLineSegment(Position var1, Position var2) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    @UML(identifier="GM_LineString(GM_Position[2..n])", obligation=Obligation.MANDATORY, specification=Specification.ISO_19107)
    public LineString createLineString(List<Position> var1) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    public Geodesic createGeodesic(Position var1, Position var2) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    @UML(identifier="GM_GeodesicString(GM_Position[2..n])", obligation=Obligation.MANDATORY, specification=Specification.ISO_19107)
    public GeodesicString createGeodesicString(List<Position> var1) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    @UML(identifier="GM_Arc(GM_Position[3])", obligation=Obligation.MANDATORY, specification=Specification.ISO_19107)
    public Arc createArc(Position var1, Position var2, Position var3) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    @UML(identifier="GM_Arc(GM_Position[2],Real,Vector)", obligation=Obligation.MANDATORY, specification=Specification.ISO_19107)
    public Arc createArc(Position var1, Position var2, double var3, double[] var5) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    @UML(identifier="GM_ArcString(GM_Position[3, 5, 7...])", obligation=Obligation.MANDATORY, specification=Specification.ISO_19107)
    public ArcString createArcString(List<Position> var1) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    @UML(identifier="GM_ArcByBulge(GM_Position[2],Real,Vector)", obligation=Obligation.MANDATORY, specification=Specification.ISO_19107)
    public ArcByBulge createArcByBulge(Position var1, Position var2, double var3, double[] var5) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    @UML(identifier="GM_ArcStringByBulge(GM_Position[2..n],Real[1..n],Vector[1..n])", obligation=Obligation.MANDATORY, specification=Specification.ISO_19107)
    public ArcStringByBulge createArcStringByBulge(List<Position> var1, double[] var2, List<double[]> var3) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    @UML(identifier="GM_BSplineCurve(Integer,GM_PointArray,Sequence<GM_Knot>,GM_KnotType)", obligation=Obligation.MANDATORY, specification=Specification.ISO_19107)
    public BSplineCurve createBSplineCurve(int var1, PointArray var2, List<Knot> var3, KnotType var4) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    @UML(identifier="GM_BSplineSurface(Sequence<GM_PointArray>,Integer,Sequence<GM_Knot>,GM_KnotType)", obligation=Obligation.MANDATORY, specification=Specification.ISO_19107)
    public BSplineSurface createBSplineSurface(List<PointArray> var1, int[] var2, List<Knot>[] var3, KnotType var4) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    @UML(identifier="GM_Polygon(GM_SurfaceBondary)", obligation=Obligation.MANDATORY, specification=Specification.ISO_19107)
    public Polygon createPolygon(SurfaceBoundary var1) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    @UML(identifier="GM_Polygon(GM_SurfaceBondary,GM_Surface)", obligation=Obligation.MANDATORY, specification=Specification.ISO_19107)
    public Polygon createPolygon(SurfaceBoundary var1, Surface var2) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    @UML(identifier="GM_Tin(Set<GM_Position>,Set<GM_LineString>,Set<GM_LineString>,Number)", obligation=Obligation.MANDATORY, specification=Specification.ISO_19107)
    public Tin createTin(Set<Position> var1, Set<LineString> var2, Set<LineString> var3, double var4) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    @UML(identifier="GM_PolyhedralSurace(GM_Polygon)", obligation=Obligation.MANDATORY, specification=Specification.ISO_19107)
    public PolyhedralSurface createPolyhedralSurface(List<Polygon> var1) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    @Deprecated
    public MultiPrimitive createMultiPrimitive();
}

