/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.xinput.ftp;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.util.StringTokenizer;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.xinput.FileType;
import net.sourceforge.dvb.projectx.xinput.StreamInfo;
import net.sourceforge.dvb.projectx.xinput.XInputFileIF;
import net.sourceforge.dvb.projectx.xinput.XInputStream;
import net.sourceforge.dvb.projectx.xinput.ftp.FtpVO;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;

public class XInputFileImpl
implements XInputFileIF {
    public boolean debug = false;
    private FileType fileType = null;
    private boolean isopen = false;
    private PushbackInputStream pbis = null;
    private File rafFile = null;
    private RandomAccessFile raf = null;
    private byte[] buffer = new byte[8];
    private FtpVO ftpVO = null;
    private FTPFile ftpFile = null;
    private FTPClient client = null;
    private DataInputStream in = null;
    public XInputStream xIs = null;
    private Object constructorParameter = null;
    private StreamInfo streamInfo = null;
    private boolean supportsResume = true;

    private XInputFileImpl() {
        throw new UnsupportedOperationException();
    }

    public XInputFileImpl(FtpVO aFtpVO) {
        if (this.debug) {
            System.out.println("Try to create XInputFile of Type FTP");
        }
        this.ftpVO = aFtpVO;
        this.ftpFile = aFtpVO.getFtpFile();
        this.fileType = FileType.FTP;
        if (!this.exists()) {
            throw new IllegalArgumentException("File is not of type FileType.FTP");
        }
        if (this.debug) {
            System.out.println("Succeeded to create XInputFile of Type FTP");
        }
    }

    public String toString() {
        String name = this.ftpFile.getName();
        name = this.replaceStringByString(name, "\u00c3\u00a4", "\u00e4");
        name = this.replaceStringByString(name, "\u00c3\u00b6", "\u00f6");
        name = this.replaceStringByString(name, "\u00c3\u00bc", "\u00fc");
        name = this.replaceStringByString(name, "\u00c3\u201e", "\u00c4");
        name = this.replaceStringByString(name, "\u00c3\u2013", "\u00d6");
        name = this.replaceStringByString(name, "\u00c3\u0153", "\u00dc");
        name = this.replaceStringByString(name, "\u00c3\u0178", "\u00df");
        name = this.replaceStringByString(name, "\u00c3\u00a1", "\u00e1");
        name = this.replaceStringByString(name, "\u00c3\u00a0", "\u00e0");
        name = this.replaceStringByString(name, "\u00c3\u00a9", "\u00e9");
        name = this.replaceStringByString(name, "\u00c3\u00a8", "\u00e8");
        name = this.replaceStringByString(name, "\u00c3\u00ad", "\u00ed");
        name = this.replaceStringByString(name, "\u00c3\u00ac", "\u00ec");
        name = this.replaceStringByString(name, "\u00c3\u00b3", "\u00f3");
        name = this.replaceStringByString(name, "\u00c3\u00b2", "\u00f2");
        name = this.replaceStringByString(name, "\u00c3\u00ba", "\u00fa");
        name = this.replaceStringByString(name, "\u00c3\u00b9", "\u00f9");
        String s = "ftp://" + this.ftpVO.getUser() + ":" + this.ftpVO.getPassword() + "@" + this.ftpVO.getServer() + this.ftpVO.getPort(":") + this.ftpVO.getDirectory() + "/" + name;
        return s;
    }

    private String replaceStringByString(String name, String arg1, String arg2) {
        if (name == null) {
            return name;
        }
        StringBuffer sb = new StringBuffer(name);
        int i = 0;
        while ((i = sb.toString().indexOf(arg1, i)) != -1) {
            sb.replace(i, i + 2, arg2);
        }
        return sb.toString();
    }

    public void setConstructorParameter(Object obj) {
        this.constructorParameter = obj;
    }

    public Object getConstructorParameter() {
        return this.constructorParameter;
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public String getUrl() {
        String s = "ftp://" + this.ftpVO.getUser() + ":" + this.ftpVO.getPassword() + "@" + this.ftpVO.getServer() + this.ftpVO.getPort(":") + this.ftpVO.getDirectory() + "/" + this.ftpFile.getName();
        return s;
    }

    public long length() {
        return this.ftpFile.getSize();
    }

    public long lastModified() {
        return this.ftpFile.getTimestamp().getTime().getTime();
    }

    public boolean setLastModified() {
        return true;
    }

    public boolean exists() {
        boolean b = false;
        if (this.ftpFile != null) {
            b = true;
        }
        return b;
    }

    public String getName() {
        String s = null;
        s = this.ftpFile.getName();
        s = this.replaceStringByString(s, "\u00c3\u00a4", "\u00e4");
        s = this.replaceStringByString(s, "\u00c3\u00b6", "\u00f6");
        s = this.replaceStringByString(s, "\u00c3\u00bc", "\u00fc");
        s = this.replaceStringByString(s, "\u00c3\u201e", "\u00c4");
        s = this.replaceStringByString(s, "\u00c3\u2013", "\u00d6");
        s = this.replaceStringByString(s, "\u00c3\u0153", "\u00dc");
        s = this.replaceStringByString(s, "\u00c3\u0178", "\u00df");
        s = this.replaceStringByString(s, "\u00c3\u00a1", "\u00e1");
        s = this.replaceStringByString(s, "\u00c3\u00a0", "\u00e0");
        s = this.replaceStringByString(s, "\u00c3\u00a9", "\u00e9");
        s = this.replaceStringByString(s, "\u00c3\u00a8", "\u00e8");
        s = this.replaceStringByString(s, "\u00c3\u00ad", "\u00ed");
        s = this.replaceStringByString(s, "\u00c3\u00ac", "\u00ec");
        s = this.replaceStringByString(s, "\u00c3\u00b3", "\u00f3");
        s = this.replaceStringByString(s, "\u00c3\u00b2", "\u00f2");
        s = this.replaceStringByString(s, "\u00c3\u00ba", "\u00fa");
        s = this.replaceStringByString(s, "\u00c3\u00b9", "\u00f9");
        return s;
    }

    public String getParent() {
        return this.ftpVO.getDirectory();
    }

    public InputStream getInputStream() throws FileNotFoundException, MalformedURLException, IOException {
        return this.getInputStream(0L);
    }

    public InputStream getInputStream(long start_position) throws FileNotFoundException, MalformedURLException, IOException {
        this.supportsResume = Common.getSettings().getBooleanProperty(Keys.KEY_useFtpServerResume);
        this.randomAccessOpen("r");
        if (this.supportsResume) {
            this.client.setRestartOffset(start_position);
        }
        if (this.debug) {
            System.out.println("gIS name " + this.getName());
        }
        this.xIs = new XInputStream(this.client.retrieveFileStream(this.ftpFile.getName()));
        if (this.debug) {
            System.out.println("gIS retriveStream " + this.client.getReplyString());
        }
        if (!this.supportsResume) {
            this.xIs.skip(start_position);
        }
        this.xIs.setFtpFile(this);
        return this.xIs;
    }

    public boolean rename() throws IOException {
        if (this.isopen) {
            return false;
        }
        this.randomAccessOpen("r");
        String name = this.getName();
        String newName = null;
        boolean ret = false;
        newName = Common.getGuiInterface().getUserInputDialog(name, String.valueOf(Resource.getString((String)"autoload.dialog.rename")) + " " + this.getUrl());
        if (newName != null && !newName.equals("")) {
            ret = this.client.rename(name, newName);
        }
        if (ret) {
            FTPFile[] aFtpFiles = this.client.listFiles();
            int i = 0;
            while (i < aFtpFiles.length) {
                if (aFtpFiles[i].getName().equals(newName) && aFtpFiles[i].isFile()) {
                    this.ftpFile = aFtpFiles[i];
                    this.ftpVO.setFtpFile(this.ftpFile);
                    break;
                }
                ++i;
            }
        }
        this.randomAccessClose();
        return ret;
    }

    public void randomAccessOpen(String mode) throws IOException {
        if (this.isopen) {
            throw new IllegalStateException("XInputFile is already open!");
        }
        if (mode.compareTo("r") != 0) {
            throw new IllegalStateException("Illegal access mode for FileType.FTP");
        }
        boolean ret = false;
        this.client = new FTPClient();
        this.client.connect(this.ftpVO.getServer(), this.ftpVO.getPortasInteger());
        if (this.debug) {
            System.out.println("rAO connect " + this.client.getReplyString());
        }
        ret = this.client.login(this.ftpVO.getUser(), this.ftpVO.getPassword());
        if (this.debug) {
            System.out.println("rAO login " + ret + " / " + this.client.getReplyString());
        }
        ret = this.client.changeWorkingDirectory(this.ftpVO.getDirectory());
        if (this.debug) {
            System.out.println("rAO cwd " + ret + " / " + this.client.getReplyString());
        }
        ret = this.client.setFileType(2);
        if (this.debug) {
            System.out.println("rAO binary " + ret + " / " + this.client.getReplyString());
        }
        this.client.enterLocalPassiveMode();
        if (this.debug) {
            System.out.println("rAO PASV " + this.client.getReplyString());
        }
        String[] commands = this.getUserFTPCommand();
        int i = 0;
        while (i < commands.length) {
            if (commands[i] != null && commands[i].length() > 0) {
                this.client.sendCommand(commands[i]);
                if (this.debug) {
                    System.out.println("rAO cmd " + this.client.getReplyString());
                }
            }
            ++i;
        }
        this.isopen = true;
    }

    public String[] getUserFTPCommand() {
        StringTokenizer st = new StringTokenizer(Common.getSettings().getProperty(Keys.KEY_FtpServer_Commands), "|");
        String[] tokens = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            tokens[i] = st.nextElement().toString().trim();
            ++i;
        }
        return tokens;
    }

    private boolean EOF() throws IOException {
        int ret;
        return this.in != null ? (ret = this.in.read()) < 0 : this.xIs != null && (ret = this.xIs.read()) < 0;
    }

    public void randomAccessClose() throws IOException {
        block20: {
            if (!this.isopen) {
                throw new IllegalStateException("XInputFile is already closed!");
            }
            boolean ret = false;
            if (this.debug) {
                System.out.println("rAC last " + this.client.getReplyCode() + " / " + this.client.getReplyString());
            }
            ret = this.client.isConnected();
            if (this.debug) {
                System.out.println("rAC isCon " + ret + " / " + this.client.getReplyCode() + " / " + this.client.getReplyString());
            }
            if (!this.EOF()) {
                if (this.debug) {
                    System.out.println("rAC !eof ");
                }
                if (this.in != null) {
                    this.in.close();
                    this.in = null;
                    ret = this.client.completePendingCommand();
                    if (this.debug) {
                        System.out.println("rAC complete " + ret + " / " + this.client.getReplyCode() + " / " + this.client.getReplyString());
                    }
                } else if (this.xIs != null) {
                    if (Common.getSettings().getBooleanProperty(Keys.KEY_killFtpClient)) {
                        if (this.debug) {
                            System.out.println("rAC kill ");
                        }
                        this.in = null;
                        this.xIs = null;
                        this.client = null;
                        this.isopen = false;
                        System.gc();
                        if (this.debug) {
                            System.out.println("rAC out kill");
                        }
                        return;
                    }
                    ret = this.client.abort();
                    if (this.debug) {
                        System.out.println("rAC abort " + ret + " / " + this.client.getReplyCode() + " / " + this.client.getReplyString());
                    }
                }
            }
            ret = this.client.logout();
            if (this.debug) {
                System.out.println("rAC logout " + ret + " / " + this.client.getReplyCode() + " / " + this.client.getReplyString());
            }
            ret = this.client.isConnected();
            if (this.debug) {
                System.out.println("rAC isCon " + ret + " / " + this.client.getReplyCode() + " / " + this.client.getReplyString());
            }
            if (ret) {
                try {
                    this.client.disconnect();
                    if (this.debug) {
                        System.out.println("rAC disc " + this.client.getReplyCode() + " / " + this.client.getReplyString());
                    }
                }
                catch (IOException e) {
                    if (!this.debug) break block20;
                    System.out.println("rAC disc-er " + e);
                }
            }
        }
        this.in = null;
        this.xIs = null;
        this.client = null;
        this.isopen = false;
        System.gc();
        if (this.debug) {
            System.out.println("rAC out ");
        }
    }

    public void randomAccessSeek(long aPosition) throws IOException {
        this.client.setRestartOffset(aPosition);
        if (this.debug) {
            System.out.println("rAS REST " + this.client.getReplyString() + " /aP " + aPosition);
        }
        this.in = new DataInputStream(this.client.retrieveFileStream(this.ftpFile.getName()));
        if (this.debug) {
            System.out.println("rAS retriveStream " + this.client.getReplyString());
        }
    }

    public long randomAccessGetFilePointer() throws IOException {
        return this.raf.getFilePointer();
    }

    public int randomAccessRead() throws IOException {
        this.buffer[0] = -1;
        this.randomAccessRead(this.buffer, 0, 1);
        return this.buffer[0];
    }

    public int randomAccessRead(byte[] aBuffer) throws IOException {
        return this.randomAccessRead(aBuffer, 0, aBuffer.length);
    }

    public int randomAccessRead(byte[] aBuffer, int aOffset, int aLength) throws IOException {
        int bytesRead;
        int totalBytes = aOffset;
        while ((bytesRead = this.in.read(aBuffer, totalBytes, aLength - totalBytes)) > 0) {
            totalBytes += bytesRead;
        }
        return bytesRead;
    }

    public String randomAccessReadLine() throws IOException {
        return this.in.readLine();
    }

    public void randomAccessWrite(byte[] aBuffer) throws IOException {
        throw new IllegalStateException("Illegal access for FileType.FTP");
    }

    public void randomAccessSingleRead(byte[] aBuffer, long aPosition) throws IOException {
        this.randomAccessOpen("r");
        this.randomAccessSeek(aPosition);
        this.randomAccessRead(aBuffer);
        this.randomAccessClose();
    }

    public long randomAccessReadLong() throws IOException {
        return this.in.readLong();
    }

    public void setStreamInfo(StreamInfo _streamInfo) {
        this.streamInfo = _streamInfo;
    }

    public StreamInfo getStreamInfo() {
        return this.streamInfo;
    }
}

