/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.gui;

import de.m740.projectx.gigaset.GDialog;
import de.m740.projectx.gigaset.GPanelLost;
import de.m740.projectx.gigaset.GStart;
import de.m740.projectx.gigaset.GStrings;
import de.m740.projectx.gigaset.Utils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.JobCollection;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.gui.AboutBox;
import net.sourceforge.dvb.projectx.gui.CheckBoxListener;
import net.sourceforge.dvb.projectx.gui.CollectionPanel;
import net.sourceforge.dvb.projectx.gui.ColumnLayout;
import net.sourceforge.dvb.projectx.gui.ComboBoxIndexListener;
import net.sourceforge.dvb.projectx.gui.ComboBoxItemListener;
import net.sourceforge.dvb.projectx.gui.CommonGui;
import net.sourceforge.dvb.projectx.gui.FtpChooser;
import net.sourceforge.dvb.projectx.gui.HexViewer;
import net.sourceforge.dvb.projectx.gui.Html;
import net.sourceforge.dvb.projectx.gui.MainFrame;
import net.sourceforge.dvb.projectx.gui.MemoryMonitor;
import net.sourceforge.dvb.projectx.gui.PatchDialog;
import net.sourceforge.dvb.projectx.gui.StartUp;
import net.sourceforge.dvb.projectx.gui.TextFieldListener;
import net.sourceforge.dvb.projectx.gui.UISwitchListener;
import net.sourceforge.dvb.projectx.parser.HpFix;
import net.sourceforge.dvb.projectx.parser.StripAudio;
import net.sourceforge.dvb.projectx.parser.StripRelook;
import net.sourceforge.dvb.projectx.xinput.StreamInfo;
import net.sourceforge.dvb.projectx.xinput.XInputDirectory;
import net.sourceforge.dvb.projectx.xinput.XInputFile;

public class MainFrame
extends JPanel {
    private static String frametitle = "";
    private static int GlobalReturnCode = 0;
    private static boolean SilentAction = true;
    private static Object[][] FileObjectTable = new Object[5][11];
    private static CollectionPanel collection_panel;
    private static JFrame frame;
    private static JComboBox comboBox_0;
    private JRadioButtonMenuItem[] lf_item = null;
    private JTable tableView;
    private JList list1;
    private JViewport viewport;
    private JTextField outfield;
    private ComboBoxIndexListener _ComboBoxIndexListener = new ComboBoxIndexListener();
    private ComboBoxItemListener _ComboBoxItemListener = new ComboBoxItemListener();
    private CheckBoxListener _CheckBoxListener = new CheckBoxListener();
    private TextFieldListener _TextFieldListener = new TextFieldListener();
    private JPopupMenu popup;
    private JFrame autoload;
    private Thread thread = null;
    private PatchDialog patch_panel;
    private GDialog aGDialog = null;
    private static ClipboardOwner defaultClipboardOwner;
    private ActionListener _BoxListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            String actName = e.getActionCommand();
            JCheckBoxMenuItem box = (JCheckBoxMenuItem)e.getSource();
            Common.getSettings().setBooleanProperty(actName, box.getState());
        }
    };
    private ActionListener _MenuListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            String actName = e.getActionCommand();
            if (actName.equals("sendTo3")) {
                if (Common.isCollectionListEmpty()) {
                    return;
                }
                int index = MainFrame.this.tableView.getSelectedRow();
                if (index < 0) {
                    return;
                }
                try {
                    String str = Common.getSettings().getProperty(Keys.KEY_PostCommands_Cmd3);
                    if (str.trim().length() > 0) {
                        Common.performCommand((String)(String.valueOf(str) + " \"" + Common.getCollection().getInputFile(index).toString() + "\""));
                    }
                }
                catch (Exception ex) {
                    Common.setExceptionMessage((Exception)ex);
                }
            } else if (actName.equals("add")) {
                CommonGui.getMainFileChooser().rescanCurrentDirectory();
                CommonGui.getMainFileChooser().setDialogType(0);
                CommonGui.getMainFileChooser().setMultiSelectionEnabled(true);
                int retval = CommonGui.getMainFileChooser().showDialog((Component)frame, null);
                if (retval == 0) {
                    File[] theFiles = CommonGui.getMainFileChooser().getSelectedFiles();
                    if (theFiles == null) {
                        return;
                    }
                    if (theFiles.length == 0) {
                        theFiles = new File[]{CommonGui.getMainFileChooser().getSelectedFile()};
                    }
                    if (theFiles != null) {
                        Common.addCollection((boolean)false);
                        JobCollection collection = Common.getCollection();
                        int i = 0;
                        while (i < theFiles.length) {
                            if (theFiles[i].isFile()) {
                                collection.addInputFile((Object)new XInputFile((Object)theFiles[i].getAbsoluteFile()));
                            }
                            ++i;
                        }
                        MainFrame.this.updateCollectionTable(collection.getCollectionAsTable());
                        MainFrame.updateCollectionPanel(Common.getActiveCollection());
                    }
                    return;
                }
            } else {
                if (actName.equals("gigaset")) {
                    MainFrame.this.showGigasetDialog();
                    return;
                }
                if (actName.equals("newOutName")) {
                    int index = MainFrame.this.tableView.getSelectedRow();
                    JobCollection collection = Common.getCollection();
                    if (index < 0 || index >= collection.getInputFilesCount()) {
                        return;
                    }
                    String name = ((XInputFile)collection.getInputFiles()[0]).getName();
                    String newoutname = CommonGui.getUserInput((String)name, (String)(String.valueOf(Resource.getString((String)"popup.newOutName")) + " " + name), (Object)collection.getOutputName());
                    if (newoutname != null) {
                        collection.setOutputName(newoutname);
                        MainFrame.this.updateOutputField(collection);
                        MainFrame.this.updateCollectionTable(collection.getCollectionAsTable());
                    }
                } else if (actName.equals("remove")) {
                    int[] indices = MainFrame.this.tableView.getSelectedRows();
                    if (indices.length > 0) {
                        JobCollection collection = Common.getCollection();
                        if (collection == null) {
                            return;
                        }
                        collection.removeInputFile(indices);
                        MainFrame.this.updateCollectionTable(collection.getCollectionAsTable());
                        MainFrame.updateCollectionPanel(Common.getActiveCollection());
                        MainFrame.this.tableView.clearSelection();
                    }
                } else if (actName.equals("rename")) {
                    int index = MainFrame.this.tableView.getSelectedRow();
                    if (index < 0 || MainFrame.this.tableView.getValueAt(index, 0) == null) {
                        return;
                    }
                    JobCollection collection = Common.getCollection();
                    try {
                        if (((XInputFile)collection.getInputFile(index)).rename()) {
                            MainFrame.this.reloadInputDirectories();
                        }
                    }
                    catch (IOException name) {
                        // empty catch block
                    }
                    MainFrame.this.updateCollectionTable(collection.getCollectionAsTable());
                } else if (actName.equals("changeTimestamp")) {
                    int[] indices = MainFrame.this.tableView.getSelectedRows();
                    if (indices.length == 0) {
                        return;
                    }
                    JobCollection collection = Common.getCollection();
                    int i = 0;
                    while (i < indices.length) {
                        XInputFile xInputFile;
                        if (MainFrame.this.tableView.getValueAt(i, 0) != null && CommonGui.getUserConfirmation((String)("really update the timestamp of '" + (xInputFile = (XInputFile)collection.getInputFile(i)).getName() + "' ?"))) {
                            xInputFile.setLastModified();
                        }
                        ++i;
                    }
                    MainFrame.this.updateCollectionTable(collection.getCollectionAsTable());
                } else if (actName.equals("viewAsHex")) {
                    int index = MainFrame.this.tableView.getSelectedRow();
                    if (index < 0 || MainFrame.this.tableView.getValueAt(index, 0) == null) {
                        return;
                    }
                    JobCollection collection = Common.getCollection();
                    XInputFile xInputFile = ((XInputFile)collection.getInputFile(index)).getNewInstance();
                    if (xInputFile != null && xInputFile.exists()) {
                        new HexViewer().view(xInputFile);
                    }
                } else if (actName.equals("fixHpAc3")) {
                    int index = MainFrame.this.tableView.getSelectedRow();
                    if (index < 0 || MainFrame.this.tableView.getValueAt(index, 0) == null) {
                        return;
                    }
                    JobCollection collection = Common.getCollection();
                    XInputFile xInputFile = ((XInputFile)collection.getInputFile(index)).getNewInstance();
                    if (xInputFile != null && xInputFile.exists() && CommonGui.getUserConfirmation((String)("really process '" + xInputFile.getName() + "' ?"))) {
                        HpFix hpfix = new HpFix();
                        Common.setOSDMessage((String)"fixing wrong Hp Ac3 File...");
                        xInputFile = hpfix.process(xInputFile);
                        collection.removeInputFile(index);
                        if (xInputFile != null) {
                            collection.addInputFile(index, (Object)xInputFile);
                        }
                        MainFrame.this.updateCollectionTable(collection.getCollectionAsTable());
                        MainFrame.updateCollectionPanel(Common.getActiveCollection());
                        MainFrame.this.tableView.clearSelection();
                    }
                } else if (actName.equals("stripAudio")) {
                    int index = MainFrame.this.tableView.getSelectedRow();
                    if (index < 0 || MainFrame.this.tableView.getValueAt(index, 0) == null) {
                        return;
                    }
                    JobCollection collection = Common.getCollection();
                    XInputFile xInputFile = ((XInputFile)collection.getInputFile(index)).getNewInstance();
                    if (xInputFile != null && xInputFile.exists() && xInputFile.getStreamInfo().getStreamType() == 14 && CommonGui.getUserConfirmation((String)("really process '" + xInputFile.getName() + "' ?"))) {
                        StripAudio stripAudio = new StripAudio();
                        Common.setOSDMessage((String)"strip audio data...");
                        xInputFile = stripAudio.process(xInputFile);
                        collection.removeInputFile(index);
                        if (xInputFile != null) {
                            collection.addInputFile(index, (Object)xInputFile);
                        }
                        MainFrame.this.updateCollectionTable(collection.getCollectionAsTable());
                        MainFrame.updateCollectionPanel(Common.getActiveCollection());
                        MainFrame.this.tableView.clearSelection();
                    }
                } else if (actName.equals("stripRelook")) {
                    this.stripRelook(0);
                } else if (actName.equals("stripRelook1")) {
                    this.stripRelook(1);
                } else if (actName.equals("editBasics")) {
                    int index = MainFrame.this.tableView.getSelectedRow();
                    if (index < 0 || MainFrame.this.tableView.getValueAt(index, 0) == null) {
                        return;
                    }
                    JobCollection collection = Common.getCollection();
                    XInputFile xInputFile = (XInputFile)collection.getInputFile(index);
                    if (MainFrame.this.patch_panel == null) {
                        MainFrame.this.patch_panel = new PatchDialog(frame);
                    }
                    if (MainFrame.this.patch_panel.entry(xInputFile)) {
                        MainFrame.this.ScanInfo(xInputFile);
                    }
                } else if (actName.equals("clipboard")) {
                    int index = MainFrame.this.tableView.getSelectedRow();
                    if (index < 0 || MainFrame.this.tableView.getValueAt(index, 0) == null) {
                        return;
                    }
                    JobCollection collection = Common.getCollection();
                    XInputFile xInputFile = (XInputFile)collection.getInputFile(index);
                    try {
                        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                        if (clipboard != null) {
                            String srcData = xInputFile.getStreamInfo().getFullInfo();
                            StringSelection contents = new StringSelection(srcData);
                            clipboard.setContents(contents, defaultClipboardOwner);
                        }
                    }
                    catch (Exception clipboard) {}
                } else if (actName.equals("applyAction")) {
                    Object[] items = Keys.ITEMS_ConversionMode;
                    String str = ((JMenuItem)e.getSource()).getText();
                    int val = -1;
                    int i = 0;
                    while (i < items.length) {
                        if (str.equals(items[i].toString())) {
                            val = i;
                            break;
                        }
                        ++i;
                    }
                    Common.getCollection().setActionType(val);
                } else if (actName.equals("assignStreamtype")) {
                    int index = MainFrame.this.tableView.getSelectedRow();
                    if (index < 0 || MainFrame.this.tableView.getValueAt(index, 0) == null) {
                        return;
                    }
                    JobCollection collection = Common.getCollection();
                    XInputFile xInputFile = (XInputFile)collection.getInputFile(index);
                    Object[] items = Keys.ITEMS_FileTypes;
                    String str = ((JMenuItem)e.getSource()).getText();
                    int i = 0;
                    while (i < items.length) {
                        if (str.equals(items[i].toString())) {
                            if (xInputFile.getStreamInfo() == null) {
                                MainFrame.this.ScanInfo(xInputFile);
                            }
                            xInputFile.getStreamInfo().setStreamType(i);
                            MainFrame.this.ScanInfo(xInputFile, i);
                            MainFrame.this.updateCollectionTable(collection.getCollectionAsTable());
                            return;
                        }
                        ++i;
                    }
                    xInputFile.setStreamInfo(null);
                    MainFrame.this.ScanInfo(xInputFile);
                    MainFrame.this.updateCollectionTable(collection.getCollectionAsTable());
                } else if (actName.equals("exit")) {
                    Common.exitApplication((int)0);
                } else if (actName.equals("url")) {
                    String value = null;
                    XInputFile inputValue = null;
                    URL url = null;
                    block12: while (true) {
                        if ((value = CommonGui.getUserInput((String)Resource.getString((String)"dialog.input.url"))) == null) {
                            return;
                        }
                        try {
                            url = new URL(value);
                            String protocol = url.getProtocol();
                            if (protocol.equals("ftp")) {
                                XInputDirectory xid = new XInputDirectory((Object)url);
                                XInputFile[] xif = xid.getFiles();
                                int i = 0;
                                while (i < xif.length) {
                                    if (new URL(xif[i].toString()).getFile().equals(url.getFile())) {
                                        inputValue = xif[i];
                                        break block12;
                                    }
                                    ++i;
                                }
                                Common.setMessage((String)("!> URL incorrect or not accessible: " + url.toString()), (boolean)true);
                                continue;
                            }
                            if (protocol.equals("file")) {
                                inputValue = new XInputFile((Object)new File(String.valueOf(url.getHost()) + url.getFile()));
                                break;
                            }
                            Common.setMessage((String)("!> Protocol not yet supported: " + protocol), (boolean)true);
                            return;
                        }
                        catch (Exception u1) {
                            Common.setMessage((String)("!> URL Exc: (" + value + ")"));
                            Common.setExceptionMessage((Exception)u1);
                            continue;
                        }
                        break;
                    }
                    if (inputValue == null) {
                        return;
                    }
                    Common.addCollection((boolean)false);
                    JobCollection collection = Common.getCollection();
                    collection.addInputFile((Object)inputValue);
                    MainFrame.this.updateCollectionTable(collection.getCollectionAsTable());
                    MainFrame.updateCollectionPanel(Common.getActiveCollection());
                    return;
                }
            }
        }

        private void stripRelook(int type) {
            int index = MainFrame.this.tableView.getSelectedRow();
            if (index < 0 || MainFrame.this.tableView.getValueAt(index, 0) == null) {
                return;
            }
            JobCollection collection = Common.getCollection();
            XInputFile xInputFile = ((XInputFile)collection.getInputFile(index)).getNewInstance();
            if (xInputFile != null && xInputFile.exists() && xInputFile.getStreamInfo().getStreamType() == 1 && CommonGui.getUserConfirmation((String)("really process '" + xInputFile.getName() + "' ?"))) {
                StripRelook stripRelook = new StripRelook(type);
                Common.setOSDMessage((String)("strip Relook\u00ae data, type " + type + "..."));
                XInputFile[] xif = stripRelook.process(xInputFile, collection.getOutputDirectory());
                collection.removeInputFile(index);
                if (xif != null) {
                    int i = 0;
                    int j = index;
                    while (i < xif.length) {
                        if (xif[i] != null) {
                            collection.addInputFile(j++, (Object)xif[i]);
                        }
                        ++i;
                    }
                }
                MainFrame.this.updateCollectionTable(collection.getCollectionAsTable());
                MainFrame.updateCollectionPanel(Common.getActiveCollection());
                MainFrame.this.tableView.clearSelection();
            }
        }
    };
    static /* synthetic */ Class class$0;

    static {
        frame = new JFrame();
        defaultClipboardOwner = new ClipboardObserver();
    }

    public MainFrame(StartUp startup) {
        frame.setBackground(new Color(200, 200, 200));
        CommonGui.setMainFrame((JFrame)frame);
        this.initialize(startup);
    }

    public static void addCollectionAtEnd() {
        SilentAction = true;
        comboBox_0.addItem(String.valueOf(comboBox_0.getItemCount()));
        comboBox_0.setSelectedIndex(comboBox_0.getItemCount() - 1);
        SilentAction = false;
    }

    public void updateOutputField(JobCollection collection) {
        this.outfield.setText(collection.getOutputDirectory());
        String str = collection.getOutputName();
        if (str.length() > 0) {
            this.outfield.setText(String.valueOf(this.outfield.getText()) + " {" + str + "}");
            this.outfield.setBackground(new Color(255, 225, 255));
        } else {
            this.outfield.setBackground(new Color(225, 255, 225));
        }
    }

    public void updateCollectionTable(Object[][] objects) {
        FileObjectTable = objects == null ? new Object[5][11] : objects;
        this.tableView.clearSelection();
        this.tableView.revalidate();
        this.tableView.repaint();
    }

    private void updateAutoloadList(Object[] objects) {
        this.list1.setListData(objects);
    }

    private void buildGUI(StartUp startup) {
        this.setLayout(new BoxLayout(this, 1));
        this.showStartUpProgress(startup, 10, "Loading Menus...");
        this.buildMenus();
        this.showStartUpProgress(startup, 20, "Loading Popup Menus...");
        this.buildPopupMenu();
        this.showStartUpProgress(startup, 30, "Loading Quickload Panel...");
        this.buildAutoloadPanel();
        this.showStartUpProgress(startup, 40, "Loading Control Panel...");
        this.add(this.buildMainPanel());
        this.showStartUpProgress(startup, 50, "Loading Status Panel...");
        this.add((Component)this.buildStatusPanel(), "South");
        this.add(Box.createRigidArea(new Dimension(1, 5)));
    }

    protected void buildPopupMenu() {
        this.popup = new JPopupMenu(Resource.getString((String)"popup.what"));
        JMenuItem menuitem_8 = this.popup.add(Resource.getString((String)"popup.url"));
        menuitem_8.setActionCommand("url");
        JMenuItem menuitem_13 = this.popup.add(GStrings.getString("popup.gigaset"));
        menuitem_13.setActionCommand("gigaset");
        JMenuItem menuitem_4 = this.popup.add(Resource.getString((String)"popup.rename"));
        menuitem_4.setActionCommand("rename");
        JMenuItem menuitem_5 = this.popup.add(Resource.getString((String)"popup.openhex"));
        menuitem_5.setActionCommand("viewAsHex");
        JMenuItem menuitem_6 = this.popup.add(Resource.getString((String)"popup.patchbasics"));
        menuitem_6.setActionCommand("editBasics");
        JMenuItem menuitem_7 = this.popup.add(Resource.getString((String)"popup.sendtocl3"));
        menuitem_7.setActionCommand("sendTo3");
        this.popup.addSeparator();
        JMenuItem menuitem_10 = this.popup.add(Resource.getString((String)"popup.changeTimestamp"));
        menuitem_10.setActionCommand("changeTimestamp");
        JMenuItem menuitem_12 = this.popup.add(Resource.getString((String)"popup.fixHpAc3"));
        menuitem_12.setActionCommand("fixHpAc3");
        JMenuItem menuitem_14 = this.popup.add(Resource.getString((String)"popup.stripAudio"));
        menuitem_14.setActionCommand("stripAudio");
        JMenuItem menuitem_15 = this.popup.add("strip Relook\u00ae type 0 to separate pes..");
        menuitem_15.setActionCommand("stripRelook");
        JMenuItem menuitem_16 = this.popup.add("strip Relook\u00ae type 1 to separate pes..");
        menuitem_16.setActionCommand("stripRelook1");
        this.popup.addSeparator();
        JMenuItem menuitem_11 = this.popup.add(Resource.getString((String)"popup.copyInfoToClipboard"));
        menuitem_11.setActionCommand("clipboard");
        Object[] objects = Keys.ITEMS_FileTypes;
        JMenu streamtype = new JMenu(Resource.getString((String)"popup.assignStreamType"));
        int i = 0;
        while (i <= objects.length) {
            JMenuItem item = new JMenuItem(i == objects.length ? Resource.getString((String)"popup.automatic") : objects[i].toString());
            item.setActionCommand("assignStreamtype");
            item.addActionListener(this._MenuListener);
            if (i == objects.length) {
                streamtype.addSeparator();
            }
            streamtype.add(item);
            ++i;
        }
        this.popup.add(streamtype);
        this.popup.addSeparator();
        JMenuItem menuitem_9 = this.popup.add(Resource.getString((String)"popup.newOutName"));
        menuitem_9.setActionCommand("newOutName");
        objects = Keys.ITEMS_ConversionMode;
        JMenu action = new JMenu(Resource.getString((String)"popup.assignActionType"));
        int i2 = -1;
        while (i2 < objects.length) {
            JMenuItem item = new JMenuItem(i2 < 0 ? Resource.getString((String)"popup.unspecified") : objects[i2].toString());
            item.setActionCommand("applyAction");
            item.addActionListener(this._MenuListener);
            if (i2 == 0) {
                action.addSeparator();
            }
            action.add(item);
            ++i2;
        }
        this.popup.add(action);
        this.popup.pack();
        UIManager.addPropertyChangeListener((PropertyChangeListener)new UISwitchListener((JComponent)this.popup));
        menuitem_4.addActionListener(this._MenuListener);
        menuitem_5.addActionListener(this._MenuListener);
        menuitem_6.addActionListener(this._MenuListener);
        menuitem_7.addActionListener(this._MenuListener);
        menuitem_8.addActionListener(this._MenuListener);
        menuitem_9.addActionListener(this._MenuListener);
        menuitem_10.addActionListener(this._MenuListener);
        menuitem_11.addActionListener(this._MenuListener);
        menuitem_12.addActionListener(this._MenuListener);
        menuitem_14.addActionListener(this._MenuListener);
        menuitem_15.addActionListener(this._MenuListener);
        menuitem_16.addActionListener(this._MenuListener);
        menuitem_13.addActionListener(this._MenuListener);
    }

    protected void buildMenus() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.buildFileMenu());
        menuBar.add(this.buildViewerMenu());
        menuBar.add(this.buildGeneralMenu());
        menuBar.add(this.buildPreferencesMenu());
        menuBar.add(this.buildLanguageMenu());
        menuBar.add(this.buildAddonMenu());
        menuBar.add(this.buildHelpMenu());
        frame.setJMenuBar(menuBar);
    }

    protected JMenu buildFileMenu() {
        JMenu file = new JMenu();
        CommonGui.localize((AbstractButton)file, (String)"Common.File");
        JMenuItem add = new JMenuItem();
        CommonGui.localize((AbstractButton)add, (String)"file.add");
        add.setActionCommand("add");
        add.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        JMenuItem gigaset = new JMenuItem(GStrings.getString("file.gigaset"));
        gigaset.setActionCommand("gigaset");
        JMenuItem url = new JMenuItem();
        CommonGui.localize((AbstractButton)url, (String)"file.url");
        url.setActionCommand("url");
        url.setAccelerator(KeyStroke.getKeyStroke(85, 2));
        JMenuItem remove = new JMenuItem();
        CommonGui.localize((AbstractButton)remove, (String)"file.remove");
        remove.setActionCommand("remove");
        remove.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        JMenuItem rename = new JMenuItem();
        CommonGui.localize((AbstractButton)rename, (String)"file.rename");
        rename.setActionCommand("rename");
        rename.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        JMenuItem exit = new JMenuItem();
        CommonGui.localize((AbstractButton)exit, (String)"Common.Exit");
        exit.setActionCommand("exit");
        exit.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        file.add(add);
        file.add(url);
        file.add(gigaset);
        file.add(remove);
        file.addSeparator();
        file.add(rename);
        file.addSeparator();
        file.add(exit);
        url.addActionListener(this._MenuListener);
        add.addActionListener(this._MenuListener);
        gigaset.addActionListener(this._MenuListener);
        remove.addActionListener(this._MenuListener);
        rename.addActionListener(this._MenuListener);
        exit.addActionListener(this._MenuListener);
        return file;
    }

    protected JMenu buildSettingsMenu() {
        JMenu setting = new JMenu();
        CommonGui.localize((AbstractButton)setting, (String)"settings.menu");
        JMenuItem open = new JMenuItem();
        CommonGui.localize((AbstractButton)open, (String)"settings.settings");
        setting.add(open);
        return setting;
    }

    protected JMenu buildPreferencesMenu() {
        JMenu preferencesMenu = new JMenu();
        CommonGui.localize((AbstractButton)preferencesMenu, (String)"Common.Preferences");
        JMenuItem preferences = new JMenuItem();
        CommonGui.localize((AbstractButton)preferences, (String)"Common.Preferences");
        preferences.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        preferences.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Common.getGuiInterface().showPreSettings();
            }
        });
        preferencesMenu.add(preferences);
        preferencesMenu.addSeparator();
        JCheckBoxMenuItem save = new JCheckBoxMenuItem(Resource.getString((String)Keys.KEY_SaveSettingsOnExit[0]));
        save.setActionCommand(Keys.KEY_SaveSettingsOnExit[0]);
        save.setState(Common.getSettings().getBooleanProperty(Keys.KEY_SaveSettingsOnExit));
        save.addActionListener(this._BoxListener);
        preferencesMenu.add(save);
        return preferencesMenu;
    }

    protected JMenu buildGeneralMenu() {
        JMenu general = new JMenu();
        CommonGui.localize((AbstractButton)general, (String)"general.menu");
        UIManager.LookAndFeelInfo[] lf_info = UIManager.getInstalledLookAndFeels();
        this.lf_item = new JRadioButtonMenuItem[lf_info.length];
        ButtonGroup lfgroup = new ButtonGroup();
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String lnfName = e.getActionCommand();
                Common.getSettings().setProperty(Keys.KEY_LookAndFeel[0], lnfName);
                MainFrame.this.setLookAndFeel(lnfName);
            }
        };
        int a = 0;
        while (a < this.lf_item.length) {
            this.lf_item[a] = new JRadioButtonMenuItem(lf_info[a].getClassName());
            general.add(this.lf_item[a]);
            lfgroup.add(this.lf_item[a]);
            this.lf_item[a].addActionListener(al);
            ++a;
        }
        this.setLookAndFeel(Common.getSettings().getProperty(Keys.KEY_LookAndFeel));
        return general;
    }

    private void setLookAndFeel(String lnfName) {
        if (lnfName != null && !lnfName.equals("")) {
            Component selectedRadio = null;
            try {
                int a = 0;
                while (a < this.lf_item.length) {
                    if (this.lf_item[a].getActionCommand().equals(lnfName)) {
                        this.lf_item[a].setSelected(true);
                        selectedRadio = this.lf_item[a];
                    }
                    ++a;
                }
                UIManager.setLookAndFeel(lnfName);
                SwingUtilities.updateComponentTreeUI(frame);
                if (CommonGui.getMainFileChooser() != null) {
                    SwingUtilities.updateComponentTreeUI((Component)CommonGui.getMainFileChooser());
                }
                if (this.aGDialog != null) {
                    SwingUtilities.updateComponentTreeUI(this.aGDialog);
                }
            }
            catch (Exception exc) {
                selectedRadio.getParent().remove(selectedRadio);
                System.err.println("!> Could not load LookAndFeel: " + lnfName);
                Common.setErrorMessage((String)("!> Could not load LookAndFeel: " + lnfName));
            }
        }
    }

    protected JMenu buildViewerMenu() {
        JMenu preview = new JMenu();
        CommonGui.localize((AbstractButton)preview, (String)"options.menu");
        JMenuItem hex = new JMenuItem();
        CommonGui.localize((AbstractButton)hex, (String)"options.openhexview");
        hex.setActionCommand("viewAsHex");
        hex.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        preview.add(hex);
        preview.addSeparator();
        JMenuItem basic = new JMenuItem();
        CommonGui.localize((AbstractButton)basic, (String)"options.pachtbasics");
        basic.setActionCommand("editBasics");
        basic.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        preview.add(basic);
        preview.addSeparator();
        JMenuItem subtitle = new JMenuItem();
        CommonGui.localize((AbstractButton)subtitle, (String)"options.subtitlepreview");
        subtitle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Common.getGuiInterface().showSubpicture();
            }
        });
        subtitle.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        preview.add(subtitle);
        preview.addSeparator();
        JMenuItem pagematrix = new JMenuItem();
        CommonGui.localize((AbstractButton)pagematrix, (String)"options.teletext");
        pagematrix.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Common.getGuiInterface().showTtxPageMatrix();
            }
        });
        pagematrix.setAccelerator(KeyStroke.getKeyStroke(77, 2));
        preview.add(pagematrix);
        hex.addActionListener(this._MenuListener);
        basic.addActionListener(this._MenuListener);
        return preview;
    }

    protected JMenu buildLanguageMenu() {
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String action = event.getActionCommand();
                if (action.equals("check")) {
                    new Html("http://project-x.sourceforge.net/optional/resources/").show();
                    return;
                }
                if (action.equals("system")) {
                    Resource.setChosenLanguage(null);
                } else {
                    Resource.setChosenLanguage((String)action);
                }
                CommonGui.showMessageDialog((Object)Resource.getString((String)"msg.new.language"), (String)Resource.getString((String)"msg.infomessage"));
            }
        };
        JMenu langMenu = new JMenu();
        CommonGui.localize((AbstractButton)langMenu, (String)"language.menu");
        JMenuItem item_check = new JMenuItem();
        CommonGui.localize((AbstractButton)item_check, (String)"language.check");
        item_check.addActionListener(listener);
        item_check.setActionCommand("check");
        langMenu.add(item_check);
        langMenu.addSeparator();
        ButtonGroup group = new ButtonGroup();
        JRadioButtonMenuItem item_sys = new JRadioButtonMenuItem();
        CommonGui.localize((AbstractButton)item_sys, (String)"language.system");
        item_sys.addActionListener(listener);
        item_sys.setSelected(Resource.getChosenLanguage() == null);
        item_sys.setActionCommand("system");
        langMenu.add(item_sys);
        group.add(item_sys);
        langMenu.addSeparator();
        Locale[] locales = Resource.getAvailableLocales();
        int i = 0;
        while (i < locales.length) {
            Locale item = locales[i];
            JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(item.getLanguage());
            menuItem.addActionListener(listener);
            if (Resource.getChosenLanguage() != null) {
                menuItem.setSelected(item.getLanguage().equals(Resource.getChosenLanguage()));
            }
            menuItem.setActionCommand(item.getLanguage());
            langMenu.add(menuItem);
            group.add(menuItem);
            ++i;
        }
        return langMenu;
    }

    protected JMenu buildAddonMenu() {
        JMenu menu = new JMenu();
        CommonGui.localize((AbstractButton)menu, (String)"Common.Addons");
        menu.add(new JMenuItem("available components:"));
        menu.addSeparator();
        if (Common.canAccessFtp()) {
            menu.add(new JMenuItem("commons-net library (FTP access)"));
        }
        if (Common.canAccessRawRead()) {
            menu.add(new JMenuItem("rawread dll (ext. disk access)"));
        }
        if (Common.getMpvDecoderClass().isAccelerated()) {
            menu.add(new JMenuItem("accelerated preview (ext. IDCT)"));
        }
        if (Common.canAccessColorTable()) {
            menu.add(new JMenuItem("color tables (DVB subpicture)"));
        }
        if (Common.canAccessSilentAC3()) {
            menu.add(new JMenuItem("silent AC3 frames (replacements)"));
        }
        return menu;
    }

    protected JMenu buildHelpMenu() {
        JMenu help = new JMenu();
        CommonGui.localize((AbstractButton)help, (String)"help.menu");
        JMenuItem about = new JMenuItem();
        CommonGui.localize((AbstractButton)about, (String)"help.about");
        about.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new AboutBox((Frame)frame);
            }
        });
        JMenuItem openHtml = new JMenuItem();
        CommonGui.localize((AbstractButton)openHtml, (String)"help.help");
        openHtml.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new Html().show();
            }
        });
        openHtml.setAccelerator(KeyStroke.getKeyStroke("F1"));
        JMenuItem version = new JMenuItem();
        CommonGui.localize((AbstractButton)version, (String)"help.version");
        version.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Common.checkVersion();
            }
        });
        help.add(about);
        help.addSeparator();
        help.add(openHtml);
        help.addSeparator();
        help.add(version);
        return help;
    }

    protected JScrollPane createTable() {
        final String[] names = new String[]{"#", Resource.getString((String)"CollectionTable.Source"), Resource.getString((String)"CollectionTable.FileName"), Resource.getString((String)"CollectionTable.FileLocation"), Resource.getString((String)"CollectionTable.Size"), Resource.getString((String)"CollectionTable.lastModified"), Resource.getString((String)"ScanInfo.Video").substring(0, 1), Resource.getString((String)"ScanInfo.Audio").substring(0, 1), Resource.getString((String)"ScanInfo.Teletext").substring(0, 1), Resource.getString((String)"ScanInfo.Subpicture").substring(0, 1), Resource.getString((String)"CollectionTable.Streamtype")};
        AbstractTableModel dataModel = new AbstractTableModel(){

            public int getColumnCount() {
                return names.length;
            }

            public int getRowCount() {
                return FileObjectTable.length;
            }

            public Object getValueAt(int row, int col) {
                return FileObjectTable[row][col];
            }

            public String getColumnName(int column) {
                return names[column];
            }

            public Class getColumnClass(int c) {
                Object obj = this.getValueAt(0, c);
                if (obj == null) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return clazz;
                }
                return obj.getClass();
            }

            public boolean isCellEditable(int row, int col) {
                return false;
            }

            public void setValueAt(Object aValue, int row, int column) {
                FileObjectTable[row][column] = aValue;
            }
        };
        this.tableView = new JTable(dataModel);
        DefaultTableCellRenderer renderer_1 = new DefaultTableCellRenderer();
        DefaultTableCellRenderer renderer_2 = new DefaultTableCellRenderer();
        renderer_1.setHorizontalAlignment(4);
        renderer_2.setHorizontalAlignment(0);
        this.tableView.setRowHeight(15);
        this.tableView.setGridColor(new Color(220, 220, 220));
        this.tableView.removeEditor();
        this.tableView.setToolTipText(Resource.getString((String)"FilePanel.DragDrop.Tip"));
        this.tableView.setSelectionMode(2);
        this.tableView.setSelectionBackground(new Color(220, 220, 255));
        this.tableView.setSelectionForeground(Color.black);
        this.tableView.getColumn("#").setCellRenderer(renderer_2);
        this.tableView.getColumn("#").setMaxWidth(20);
        this.tableView.getColumn(names[1]).setCellRenderer(renderer_2);
        this.tableView.getColumn(names[1]).setMinWidth(32);
        this.tableView.getColumn(names[1]).setMaxWidth(32);
        this.tableView.getColumn(names[2]).setPreferredWidth(200);
        this.tableView.getColumn(names[3]).setPreferredWidth(200);
        this.tableView.getColumn(names[4]).setCellRenderer(renderer_1);
        this.tableView.getColumn(names[4]).setMinWidth(62);
        this.tableView.getColumn(names[4]).setMaxWidth(62);
        this.tableView.getColumn(names[5]).setCellRenderer(renderer_2);
        this.tableView.getColumn(names[5]).setMinWidth(96);
        this.tableView.getColumn(names[5]).setMaxWidth(96);
        int i = 6;
        while (i < 10) {
            this.tableView.getColumn(names[i]).setCellRenderer(renderer_2);
            this.tableView.getColumn(names[i]).setMinWidth(16);
            this.tableView.getColumn(names[i]).setMaxWidth(16);
            ++i;
        }
        this.tableView.getColumn(names[10]).setMinWidth(90);
        this.tableView.sizeColumnsToFit(3);
        this.tableView.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() < 1) {
                    return;
                }
                int row = MainFrame.this.tableView.getSelectedRow();
                if (row >= 0 && MainFrame.this.tableView.getValueAt(row, 0) == null) {
                    row = -1;
                }
                int index = Common.getActiveCollection();
                if (e.getModifiers() == 4) {
                    MenuElement[] elements = MainFrame.this.popup.getSubElements();
                    if (elements == null) {
                        return;
                    }
                    int i = 2;
                    while (i < 13) {
                        elements[i].getComponent().setEnabled(row >= 0);
                        ++i;
                    }
                    i = 13;
                    while (i < elements.length) {
                        elements[i].getComponent().setEnabled(index >= 0);
                        ++i;
                    }
                    MainFrame.this.popup.show(MainFrame.this.tableView, e.getX(), e.getY() - MainFrame.this.popup.getHeight());
                } else if (row >= 0) {
                    MainFrame.this.ScanInfo((XInputFile)Common.getCollection((int)index).getInputFile(row));
                }
                if (e.getClickCount() >= 2 && e.getModifiers() == 16) {
                    Common.getGuiInterface().showPreSettings();
                }
            }
        });
        DropTargetListener dnd1Listener = new DropTargetListener(){

            public void drop(DropTargetDropEvent e) {
                try {
                    int dropaction = e.getDropAction();
                    if (dropaction == 0 || dropaction > 2) {
                        e.rejectDrop();
                        return;
                    }
                    e.acceptDrop(dropaction);
                    Transferable tr = e.getTransferable();
                    DataFlavor[] df = tr.getTransferDataFlavors();
                    ArrayList<File> list = null;
                    Object obj = tr.getTransferData(df[0]);
                    try {
                        list = (ArrayList<File>)obj;
                    }
                    catch (Exception ce1) {
                        try {
                            URL url = (URL)obj;
                            File f = new File(url.getFile());
                            list = new ArrayList<File>();
                            list.add(f);
                        }
                        catch (Exception ce2) {
                            e.dropComplete(true);
                            return;
                        }
                    }
                    ArrayList<XInputFile> tempList = new ArrayList<XInputFile>();
                    int i = 0;
                    while (i < list.size()) {
                        tempList.add(new XInputFile((Object)((File)list.get(i))));
                        ++i;
                    }
                    list = tempList;
                    if (dropaction == 1) {
                        Object[] val = list.toArray();
                        int i2 = 0;
                        while (i2 < val.length) {
                            JobCollection collection = Common.addCollection();
                            collection.addInputFile(val[i2]);
                            MainFrame.this.updateCollectionTable(collection.getCollectionAsTable());
                            ++i2;
                        }
                    } else if (dropaction == 2) {
                        Common.addCollection((boolean)false);
                        Object[] val = list.toArray();
                        if (val.length > 0) {
                            JobCollection collection = Common.getCollection((int)comboBox_0.getSelectedIndex());
                            collection.addInputFile(val);
                            MainFrame.this.updateCollectionTable(collection.getCollectionAsTable());
                        }
                    }
                    e.dropComplete(true);
                    if (list.size() > 0) {
                        MainFrame.updateCollectionPanel(Common.getActiveCollection());
                    }
                }
                catch (Exception eee) {
                    e.dropComplete(false);
                    Common.setExceptionMessage((Exception)eee);
                }
                MainFrame.this.tableView.setBackground(Color.white);
            }

            public void dragEnter(DropTargetDragEvent e) {
                MainFrame.this.tableView.setBackground(Color.green);
            }

            public void dragExit(DropTargetEvent e) {
                MainFrame.this.tableView.setBackground(Color.white);
            }

            public void dragOver(DropTargetDragEvent e) {
            }

            public void dropActionChanged(DropTargetDragEvent e) {
            }
        };
        DropTarget dropTarget_2 = new DropTarget(this.tableView, dnd1Listener);
        JScrollPane scrollpane = new JScrollPane(this.tableView);
        return scrollpane;
    }

    protected JPanel buildFilePanel() {
        JPanel panel_1 = new JPanel();
        panel_1.setLayout((LayoutManager)new ColumnLayout());
        JButton open_autoload = new JButton(CommonGui.loadIcon((String)"fwd_10.gif"));
        open_autoload.setPreferredSize(new Dimension(30, 22));
        open_autoload.setMaximumSize(new Dimension(30, 22));
        open_autoload.setToolTipText(Resource.getString((String)"FilePanel.openAutoloadPanel.Tip"));
        open_autoload.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.autoload.setState(0);
                MainFrame.this.autoload.show();
            }
        });
        panel_1.add(open_autoload);
        JButton file_add = new JButton(CommonGui.loadIcon((String)"add.gif"));
        file_add.setPreferredSize(new Dimension(30, 22));
        file_add.setMaximumSize(new Dimension(30, 22));
        file_add.setToolTipText(Resource.getString((String)"FilePanel.FileAdd.Tip"));
        file_add.setActionCommand("add");
        file_add.addActionListener(this._MenuListener);
        panel_1.add(file_add);
        JButton file_giga = new JButton("G", null);
        file_giga.setPreferredSize(new Dimension(30, 22));
        file_giga.setMaximumSize(new Dimension(30, 22));
        file_giga.setToolTipText(GStrings.getString("FilePanel.Gigaset.Tip"));
        file_giga.setActionCommand("gigaset");
        file_giga.addActionListener(this._MenuListener);
        panel_1.add(file_giga);
        JButton file_remove = new JButton(CommonGui.loadIcon((String)"rem.gif"));
        file_remove.setPreferredSize(new Dimension(30, 22));
        file_remove.setMaximumSize(new Dimension(30, 22));
        file_remove.setToolTipText(Resource.getString((String)"FilePanel.FileRemove.Tip"));
        file_remove.setActionCommand("remove");
        file_remove.addActionListener(this._MenuListener);
        panel_1.add(file_remove);
        JButton file_up = new JButton(CommonGui.loadIcon((String)"up.gif"));
        file_up.setPreferredSize(new Dimension(30, 22));
        file_up.setMaximumSize(new Dimension(30, 22));
        file_up.setToolTipText(Resource.getString((String)"FilePanel.FileUp.Tip"));
        file_up.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int[] indices = MainFrame.this.tableView.getSelectedRows();
                if (indices.length > 0) {
                    JobCollection collection = Common.getCollection((int)comboBox_0.getSelectedIndex());
                    if (collection == null) {
                        return;
                    }
                    int i = 0;
                    while (i < indices.length) {
                        int index = indices[i];
                        if (index > 0 && MainFrame.this.tableView.getValueAt(index, 0) != null) {
                            Object object = collection.removeInputFile(index);
                            collection.addInputFile(index - 1, object);
                            indices[i] = index - 1;
                        }
                        ++i;
                    }
                    MainFrame.this.updateCollectionTable(collection.getCollectionAsTable());
                    MainFrame.updateCollectionPanel(Common.getActiveCollection());
                }
            }
        });
        panel_1.add(file_up);
        JButton file_down = new JButton(CommonGui.loadIcon((String)"dn.gif"));
        file_down.setPreferredSize(new Dimension(30, 22));
        file_down.setMaximumSize(new Dimension(30, 22));
        file_down.setToolTipText(Resource.getString((String)"FilePanel.FileDown.Tip"));
        file_down.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int[] indices = MainFrame.this.tableView.getSelectedRows();
                if (indices.length > 0) {
                    JobCollection collection = Common.getCollection((int)comboBox_0.getSelectedIndex());
                    if (collection == null) {
                        return;
                    }
                    int i = indices.length - 1;
                    while (i >= 0) {
                        int index = indices[i];
                        if (index < collection.getInputFilesCount() - 1 && MainFrame.this.tableView.getValueAt(index, 0) != null) {
                            Object object = collection.removeInputFile(index);
                            collection.addInputFile(index + 1, object);
                            indices[i] = index + 1;
                        }
                        --i;
                    }
                    MainFrame.this.updateCollectionTable(collection.getCollectionAsTable());
                    MainFrame.updateCollectionPanel(Common.getActiveCollection());
                }
            }
        });
        panel_1.add(file_down);
        JPanel panel_2 = new JPanel();
        panel_2.setLayout(new BoxLayout(panel_2, 0));
        panel_2.add(new JLabel(Resource.getString((String)"FilePanel.OutputDirectory")));
        panel_2.add(Box.createRigidArea(new Dimension(6, 1)));
        this.outfield = new JTextField();
        this.outfield.setBackground(new Color(225, 255, 225));
        this.outfield.setMaximumSize(new Dimension(280, 20));
        this.outfield.setMinimumSize(new Dimension(280, 20));
        this.outfield.setEditable(false);
        this.outfield.setToolTipText(Resource.getString((String)"FilePanel.OutputDirectory.Tip"));
        panel_2.add(this.outfield);
        panel_2.add(Box.createRigidArea(new Dimension(6, 1)));
        panel_2.add(new JLabel(Resource.getString((String)"FilePanel.recentOutputDirectories")));
        panel_2.add(Box.createRigidArea(new Dimension(6, 1)));
        final JComboBox<Object> comboBox_13 = new JComboBox<Object>(Common.getSettings().getOutputDirectories().toArray());
        comboBox_13.setMinimumSize(new Dimension(280, 20));
        comboBox_13.setMaximumSize(new Dimension(280, 20));
        comboBox_13.setMaximumRowCount(8);
        comboBox_13.insertItemAt(Resource.getString((String)"working.output.std"), 0);
        comboBox_13.setSelectedItem(Common.getSettings().getProperty(Keys.KEY_OutputDirectory));
        comboBox_13.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (comboBox_13.getItemCount() > 1) {
                    if (comboBox_13.getSelectedIndex() == 0) {
                        Common.getSettings().remove(Keys.KEY_OutputDirectory[0]);
                    } else {
                        Common.getSettings().setProperty(Keys.KEY_OutputDirectory[0], comboBox_13.getSelectedItem());
                    }
                    if (comboBox_0.getItemCount() > 0) {
                        Common.setActiveCollection((int)comboBox_0.getSelectedIndex());
                        JobCollection collection = Common.getCollection();
                        collection.setOutputDirectory(Common.getSettings().getProperty(Keys.KEY_OutputDirectory));
                        MainFrame.this.updateOutputField(collection);
                        MainFrame.this.updateCollectionTable(collection.getCollectionAsTable());
                    }
                } else {
                    Common.getSettings().remove(Keys.KEY_OutputDirectory[0]);
                    if (comboBox_0.getItemCount() > 0) {
                        Common.setActiveCollection((int)comboBox_0.getSelectedIndex());
                        JobCollection collection = Common.getCollection();
                        collection.setOutputDirectory(Common.getSettings().getProperty(Keys.KEY_OutputDirectory));
                        MainFrame.this.updateOutputField(collection);
                        MainFrame.this.updateCollectionTable(collection.getCollectionAsTable());
                    }
                }
            }
        });
        JButton add_output = new JButton(CommonGui.loadIcon((String)"add.gif"));
        add_output.setMinimumSize(new Dimension(24, 20));
        add_output.setMaximumSize(new Dimension(24, 20));
        add_output.setToolTipText(Resource.getString((String)"FilePanel.addRecentOutputDirectory.Tip"));
        add_output.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CommonGui.getMainFileChooser().rescanCurrentDirectory();
                CommonGui.getMainFileChooser().setDialogType(0);
                CommonGui.getMainFileChooser().setFileSelectionMode(2);
                int retval = CommonGui.getMainFileChooser().showDialog((Component)frame, null);
                if (retval == 0) {
                    File theFile = CommonGui.getMainFileChooser().getSelectedFile();
                    String file = "";
                    if (theFile != null) {
                        if (theFile.isFile()) {
                            file = theFile.getParent();
                        } else if (theFile.isDirectory()) {
                            file = theFile.getAbsolutePath();
                        }
                        int i = 0;
                        while (i < comboBox_13.getItemCount()) {
                            if (file.equalsIgnoreCase(comboBox_13.getItemAt(i).toString())) {
                                return;
                            }
                            ++i;
                        }
                        Common.getSettings().addOutputDirectory((Object)file);
                        comboBox_13.addItem(file);
                        comboBox_13.setSelectedItem(file);
                    }
                }
            }
        });
        JButton remove_output = new JButton(CommonGui.loadIcon((String)"rem.gif"));
        remove_output.setMinimumSize(new Dimension(24, 20));
        remove_output.setMaximumSize(new Dimension(24, 20));
        remove_output.setToolTipText(Resource.getString((String)"FilePanel.removeRecentOutputDirectory.Tip"));
        remove_output.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (comboBox_13.getItemCount() > 1) {
                    int index = comboBox_13.getSelectedIndex();
                    if (index > 0) {
                        Common.getSettings().removeOutputDirectory(index - 1);
                        comboBox_13.removeItemAt(index);
                    } else {
                        Common.setOSDErrorMessage((String)"Eintrag kann nicht entfernt werden..");
                    }
                }
                if (comboBox_13.getItemCount() <= 1) {
                    Common.getSettings().remove(Keys.KEY_OutputDirectory[0]);
                }
            }
        });
        panel_2.add(add_output);
        panel_2.add(remove_output);
        panel_2.add(comboBox_13);
        JPanel control_1 = new JPanel(new BorderLayout());
        control_1.setAlignmentX(0.5f);
        control_1.add((Component)this.createTable(), "Center");
        control_1.add((Component)panel_2, "South");
        JPanel control_2 = new JPanel(new BorderLayout());
        control_2.setAlignmentX(0.5f);
        control_2.add((Component)control_1, "Center");
        control_2.add((Component)panel_1, "West");
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(1, 1));
        panel.setBorder(BorderFactory.createEtchedBorder());
        panel.add(control_2);
        panel.setPreferredSize(new Dimension(900, 136));
        panel.setMaximumSize(new Dimension(900, 136));
        panel.setMinimumSize(new Dimension(900, 136));
        return panel;
    }

    private void closeAutoloadPanel() {
        this.autoload.dispose();
    }

    protected void buildAutoloadPanel() {
        this.autoload = new JFrame(Resource.getString((String)"autoload.title"));
        this.autoload.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MainFrame.this.closeAutoloadPanel();
            }
        });
        JMenu fileMenu = new JMenu();
        CommonGui.localize((AbstractButton)fileMenu, (String)"Common.File");
        JMenuItem closemenu = new JMenuItem();
        CommonGui.localize((AbstractButton)closemenu, (String)"Common.Close");
        closemenu.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        closemenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.closeAutoloadPanel();
            }
        });
        fileMenu.add(closemenu);
        JMenu editMenu = new JMenu();
        CommonGui.localize((AbstractButton)editMenu, (String)"Common.Edit");
        JCheckBoxMenuItem subdir = new JCheckBoxMenuItem(Resource.getString((String)Keys.KEY_InputDirectoriesDepth[0]));
        subdir.setToolTipText(String.valueOf(Resource.getString((String)Keys.KEY_InputDirectoriesDepth[0])) + ".Tip");
        subdir.setActionCommand(Keys.KEY_InputDirectoriesDepth[0]);
        subdir.setState(Common.getSettings().getBooleanProperty(Keys.KEY_InputDirectoriesDepth));
        subdir.addActionListener(this._BoxListener);
        editMenu.add(subdir);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(fileMenu);
        menuBar.add(editMenu);
        this.autoload.setJMenuBar(menuBar);
        JPanel bb = new JPanel();
        bb.setLayout((LayoutManager)new ColumnLayout());
        final JComboBox<Object> comboBox_12 = new JComboBox<Object>(Common.getSettings().getListProperty("Application.InputDirectories.").toArray());
        comboBox_12.setMaximumRowCount(8);
        comboBox_12.setPreferredSize(new Dimension(400, 24));
        JButton remove_input = new JButton(CommonGui.loadIcon((String)"rem.gif"));
        remove_input.setPreferredSize(new Dimension(50, 28));
        remove_input.setMaximumSize(new Dimension(50, 28));
        remove_input.setToolTipText(Resource.getString((String)"autoload.dir.remove.tip"));
        remove_input.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (comboBox_12.getItemCount() > 0) {
                    int index = comboBox_12.getSelectedIndex();
                    Common.getSettings().removeInputDirectory(index);
                    Common.getSettings().updateInputDirectories();
                    comboBox_12.removeItemAt(index);
                }
                MainFrame.this.reloadInputDirectories();
            }
        });
        bb.add(remove_input);
        JButton add_input = new JButton(CommonGui.loadIcon((String)"add.gif"));
        add_input.setPreferredSize(new Dimension(50, 28));
        add_input.setMaximumSize(new Dimension(50, 24));
        add_input.setToolTipText(Resource.getString((String)"autoload.dir.add.tip"));
        add_input.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CommonGui.getMainFileChooser().rescanCurrentDirectory();
                CommonGui.getMainFileChooser().setDialogType(0);
                CommonGui.getMainFileChooser().setFileSelectionMode(2);
                int retval = CommonGui.getMainFileChooser().showDialog((Component)frame, null);
                if (retval == 0) {
                    File theFile = CommonGui.getMainFileChooser().getSelectedFile();
                    if (theFile != null) {
                        String str;
                        if (theFile.isFile()) {
                            theFile = theFile.getParentFile();
                        }
                        if ((str = Common.getSettings().addInputDirectory((Object)theFile.getAbsoluteFile())) != null) {
                            Common.getSettings().updateInputDirectories();
                            comboBox_12.addItem(str);
                            comboBox_12.setSelectedItem(str);
                        }
                        MainFrame.this.reloadInputDirectories();
                    }
                    MainFrame.this.autoload.toFront();
                    return;
                }
                MainFrame.this.autoload.toFront();
            }
        });
        bb.add(add_input);
        JButton add_inputftp = new JButton(CommonGui.loadIcon((String)"ftp.gif"));
        add_inputftp.setPreferredSize(new Dimension(50, 28));
        add_inputftp.setMaximumSize(new Dimension(50, 24));
        add_inputftp.setToolTipText(Resource.getString((String)"autoload.ftp.add.tip"));
        add_inputftp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FtpChooser ftpChooser = new FtpChooser();
                ftpChooser.pack();
                ftpChooser.show();
                XInputDirectory xInputDirectory = ftpChooser.getXInputDirectory();
                if (ftpChooser.isTested() && xInputDirectory != null) {
                    String str = Common.getSettings().addInputDirectory((Object)xInputDirectory);
                    if (str != null) {
                        Common.getSettings().updateInputDirectories();
                        comboBox_12.addItem(str);
                        comboBox_12.setSelectedItem(str);
                    }
                    MainFrame.this.reloadInputDirectories();
                }
                MainFrame.this.autoload.setState(0);
                MainFrame.this.autoload.toFront();
            }
        });
        bb.add(add_inputftp);
        JButton refresh_list = new JButton(CommonGui.loadIcon((String)"rf.gif"));
        refresh_list.setPreferredSize(new Dimension(50, 28));
        refresh_list.setMaximumSize(new Dimension(50, 28));
        refresh_list.setToolTipText(Resource.getString((String)"autoload.dir.refresh.tip"));
        refresh_list.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.reloadInputDirectories();
            }
        });
        bb.add(refresh_list);
        bb.add(new JLabel(" "));
        JButton add_coll_and_files = new JButton(CommonGui.loadIcon((String)"addleft.gif"));
        add_coll_and_files.setPreferredSize(new Dimension(50, 28));
        add_coll_and_files.setMaximumSize(new Dimension(50, 28));
        add_coll_and_files.setToolTipText(Resource.getString((String)"autoload.add.coll.tip"));
        add_coll_and_files.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object[] val = MainFrame.this.list1.getSelectedValues();
                int i = 0;
                while (i < val.length) {
                    JobCollection collection = Common.addCollection();
                    collection.addInputFile(val[i]);
                    MainFrame.this.updateCollectionTable(collection.getCollectionAsTable());
                    ++i;
                }
                if (val.length > 0) {
                    MainFrame.updateCollectionPanel(Common.getActiveCollection());
                }
                MainFrame.this.autoload.toFront();
            }
        });
        bb.add(add_coll_and_files);
        JButton add_files = new JButton(CommonGui.loadIcon((String)"left.gif"));
        add_files.setPreferredSize(new Dimension(50, 28));
        add_files.setMaximumSize(new Dimension(50, 28));
        add_files.setToolTipText(Resource.getString((String)"autoload.add.file.tip"));
        add_files.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object[] val = MainFrame.this.list1.getSelectedValues();
                if (val.length > 0) {
                    Common.addCollection((boolean)false);
                    JobCollection collection = Common.getCollection((int)comboBox_0.getSelectedIndex());
                    collection.addInputFile(val);
                    MainFrame.this.updateCollectionTable(collection.getCollectionAsTable());
                    MainFrame.updateCollectionPanel(Common.getActiveCollection());
                    MainFrame.this.autoload.toFront();
                }
            }
        });
        bb.add(add_files);
        bb.add(new JLabel(" "));
        JButton close = new JButton(CommonGui.loadIcon((String)"x.gif"));
        close.setPreferredSize(new Dimension(50, 28));
        close.setMaximumSize(new Dimension(50, 28));
        close.setToolTipText(Resource.getString((String)"autoload.close"));
        close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.closeAutoloadPanel();
            }
        });
        bb.add(close);
        this.list1 = new JList<Object>(new Object[0]);
        this.list1.setName("inl");
        this.list1.setVisibleRowCount(8);
        this.list1.setSelectionMode(2);
        this.list1.setToolTipText(Resource.getString((String)"autoload.rename.tip"));
        this.list1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int index = MainFrame.this.list1.locationToIndex(e.getPoint());
                if (e.getClickCount() > 1) {
                    if (e.getModifiers() == 4 && index > -1) {
                        try {
                            if (((XInputFile)MainFrame.this.list1.getSelectedValue()).rename()) {
                                MainFrame.this.reloadInputDirectories();
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        MainFrame.this.autoload.toFront();
                    } else if (e.getModifiers() == 16 && index > -1) {
                        Common.addCollection((boolean)false);
                        Object[] val = MainFrame.this.list1.getSelectedValues();
                        if (val.length > 0) {
                            JobCollection collection = Common.getCollection((int)comboBox_0.getSelectedIndex());
                            collection.addInputFile(val);
                            MainFrame.this.updateCollectionTable(collection.getCollectionAsTable());
                            MainFrame.updateCollectionPanel(Common.getActiveCollection());
                        }
                        MainFrame.this.autoload.toFront();
                    }
                } else if (e.getClickCount() == 1 && MainFrame.this.list1.getSelectedValue() != null) {
                    MainFrame.this.ScanInfo((XInputFile)MainFrame.this.list1.getSelectedValue());
                }
            }
        });
        this.list1.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    Common.addCollection((boolean)false);
                    Object[] val = MainFrame.this.list1.getSelectedValues();
                    if (val.length > 0) {
                        JobCollection collection = Common.getCollection((int)comboBox_0.getSelectedIndex());
                        collection.addInputFile(val);
                        MainFrame.this.updateCollectionTable(collection.getCollectionAsTable());
                        MainFrame.updateCollectionPanel(Common.getActiveCollection());
                    }
                    MainFrame.this.autoload.toFront();
                }
            }
        });
        JScrollPane scrolltext = new JScrollPane();
        scrolltext.setViewportView(this.list1);
        JPanel control_1 = new JPanel(new BorderLayout());
        control_1.setAlignmentX(0.5f);
        control_1.add((Component)scrolltext, "Center");
        control_1.add(comboBox_12, "North");
        JPanel control_2 = new JPanel(new BorderLayout());
        control_2.setAlignmentX(0.5f);
        control_2.add((Component)control_1, "Center");
        control_2.add((Component)bb, "West");
        this.autoload.getContentPane().add(control_2);
        UIManager.addPropertyChangeListener((PropertyChangeListener)new UISwitchListener((JComponent)control_2));
        this.autoload.setBounds(200, 200, 700, 350);
    }

    protected JPanel buildMainPanel() {
        JPanel panel_1 = new JPanel();
        panel_1.setLayout((LayoutManager)new ColumnLayout());
        MemoryMonitor memo = new MemoryMonitor();
        if (Common.showGUI()) {
            memo.surf.start();
        }
        panel_1.add((Component)memo, "North");
        panel_1.add(Box.createRigidArea(new Dimension(1, 5)));
        panel_1.add(Box.createRigidArea(new Dimension(1, 54)));
        panel_1.add(this.buildProcessControlPanel());
        panel_1.add(this.buildCollectionControlPanel());
        panel_1.setPreferredSize(new Dimension(115, 468));
        panel_1.setMaximumSize(new Dimension(115, 468));
        panel_1.setMinimumSize(new Dimension(115, 468));
        JPanel panel_2 = new JPanel();
        panel_2.setLayout(new BoxLayout(panel_2, 0));
        panel_2.add((Component)panel_1, "West");
        collection_panel = new CollectionPanel();
        panel_2.add((Component)collection_panel, "Center");
        panel_2.setPreferredSize(new Dimension(900, 468));
        panel_2.setMaximumSize(new Dimension(900, 468));
        panel_2.setMinimumSize(new Dimension(900, 468));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add((Component)panel_2, "Center");
        panel.add((Component)this.buildFilePanel(), "South");
        return panel;
    }

    protected JRootPane buildFilePanel1() {
        JRootPane pane = new JRootPane();
        pane.getContentPane().add(this.buildFilePanel());
        return pane;
    }

    protected JPanel buildProcessControlPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Resource.getString((String)"MainPanel.Process")));
        JButton process = new JButton(Resource.getString((String)"MainPanel.QuickStart"));
        process.setToolTipText(Resource.getString((String)"MainPanel.QuickStart.Tip"));
        process.setMnemonic('q');
        process.setPreferredSize(new Dimension(100, 24));
        process.setMaximumSize(new Dimension(100, 24));
        process.setMinimumSize(new Dimension(100, 24));
        process.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Common.startProcess()) {
                    Common.startMainProcess();
                }
            }
        });
        panel.add(process);
        panel.add(Box.createRigidArea(new Dimension(1, 5)));
        JButton processwindow = new JButton(Resource.getString((String)"ProcessWindowPanel.Button"));
        processwindow.setPreferredSize(new Dimension(100, 24));
        processwindow.setMaximumSize(new Dimension(100, 24));
        processwindow.setMinimumSize(new Dimension(100, 24));
        processwindow.setToolTipText(String.valueOf(Resource.getString((String)"MainPanel.Process")) + " " + Resource.getString((String)"ProcessWindowPanel.Button"));
        processwindow.setMnemonic('p');
        processwindow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Common.getGuiInterface().showLogWindow();
            }
        });
        panel.add(processwindow);
        return panel;
    }

    protected JPanel buildCollectionControlPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Resource.getString((String)"MainPanel.Collection")));
        Color idle_color = new Color(230, 230, 230);
        Color running_color = new Color(245, 215, 215);
        JTextArea textarea = new JTextArea();
        textarea.setToolTipText(Resource.getString((String)"FilePanel.Textfield.Tip"));
        textarea.setBackground(idle_color);
        textarea.setFont(new Font("Tahoma", 0, 11));
        textarea.setEditable(false);
        JPanel panel_2 = new JPanel();
        panel_2.setLayout(new GridLayout(1, 1));
        panel_2.setBorder(BorderFactory.createLoweredBevelBorder());
        panel_2.setPreferredSize(new Dimension(100, 138));
        panel_2.setMaximumSize(new Dimension(100, 138));
        panel_2.setMinimumSize(new Dimension(100, 138));
        panel_2.add(textarea);
        panel.add(panel_2);
        JLabel coll_label = new JLabel(Resource.getString((String)"FilePanel.CollectionNumber"));
        coll_label.setPreferredSize(new Dimension(50, 24));
        coll_label.setMaximumSize(new Dimension(50, 24));
        coll_label.setHorizontalAlignment(0);
        coll_label.setToolTipText(Resource.getString((String)"FilePanel.CollectionNumber.Tip"));
        comboBox_0 = new JComboBox();
        comboBox_0.setPreferredSize(new Dimension(50, 24));
        comboBox_0.setMaximumSize(new Dimension(50, 24));
        comboBox_0.setMinimumSize(new Dimension(50, 24));
        comboBox_0.setMaximumRowCount(6);
        comboBox_0.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (comboBox_0.getItemCount() > 0) {
                    Common.setActiveCollection((int)comboBox_0.getSelectedIndex());
                    JobCollection collection = Common.getCollection();
                    MainFrame.this.updateOutputField(collection);
                    MainFrame.this.updateCollectionTable(collection.getCollectionAsTable());
                    if (!SilentAction) {
                        MainFrame.updateCollectionPanel(Common.getActiveCollection());
                    }
                } else {
                    Common.setActiveCollection((int)-1);
                    MainFrame.this.outfield.setText("");
                    MainFrame.this.updateCollectionTable(null);
                }
            }
        });
        JButton remove_coll = new JButton(CommonGui.loadIcon((String)"rem.gif"));
        remove_coll.setPreferredSize(new Dimension(50, 24));
        remove_coll.setMaximumSize(new Dimension(50, 24));
        remove_coll.setToolTipText(Resource.getString((String)"FilePanel.removeCollection.Tip"));
        remove_coll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Common.isCollectionListEmpty()) {
                    return;
                }
                int index = comboBox_0.getSelectedIndex();
                if (!Common.removeCollection((int)index)) {
                    return;
                }
                comboBox_0.removeAllItems();
                int i = 0;
                while (i < Common.getCollectionListSize()) {
                    comboBox_0.addItem(String.valueOf(i));
                    ++i;
                }
                if (index < comboBox_0.getItemCount()) {
                    comboBox_0.setSelectedIndex(index);
                }
                if (!Common.isCollectionListEmpty() && index >= comboBox_0.getItemCount()) {
                    comboBox_0.setSelectedIndex(comboBox_0.getItemCount() - 1);
                }
                if (Common.isCollectionListEmpty()) {
                    MainFrame.updateCollectionPanel(-1);
                }
            }
        });
        JButton add_coll = new JButton(CommonGui.loadIcon((String)"add.gif"));
        add_coll.setPreferredSize(new Dimension(50, 24));
        add_coll.setMaximumSize(new Dimension(50, 24));
        add_coll.setToolTipText(Resource.getString((String)"FilePanel.addCollection.Tip"));
        add_coll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Common.addCollection();
                MainFrame.updateCollectionPanel(Common.getActiveCollection());
            }
        });
        JPanel panel_0 = new JPanel();
        panel_0.setLayout(new BoxLayout(panel_0, 0));
        panel_0.add(add_coll);
        panel_0.add(coll_label);
        panel.add(panel_0);
        JPanel panel_1 = new JPanel();
        panel_1.setLayout(new BoxLayout(panel_1, 0));
        panel_1.add(remove_coll);
        panel_1.add(comboBox_0);
        panel.add(panel_1);
        class Clock
        implements Runnable {
            private Thread clockThread;
            private String text;
            final /* synthetic */ MainFrame this$0;
            private final /* synthetic */ JTextArea val$textarea;
            private final /* synthetic */ Color val$running_color;
            private final /* synthetic */ Color val$idle_color;

            Clock(MainFrame mainFrame, JTextArea jTextArea, Color color, Color color2) {
                this.this$0 = mainFrame;
                this.val$textarea = jTextArea;
                this.val$running_color = color;
                this.val$idle_color = color2;
                this.clockThread = null;
                this.text = "";
            }

            public void start() {
                if (this.clockThread == null) {
                    this.clockThread = new Thread((Runnable)this, "Clock_3");
                    this.clockThread.setPriority(1);
                    this.clockThread.start();
                }
            }

            public void run() {
                Thread myThread = Thread.currentThread();
                while (this.clockThread == myThread) {
                    this.update();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }

            private void update() {
                String str;
                JobCollection collection = Common.getCollection();
                String string = str = collection == null ? Resource.getString((String)"JobCollection.NoInfo") : collection.getShortSummary();
                if (this.text.equals(str)) {
                    return;
                }
                this.text = str;
                this.val$textarea.setText(this.text);
                this.val$textarea.setBackground(collection != null && collection.isActive() ? this.val$running_color : this.val$idle_color);
            }

            public void stop() {
                this.clockThread = null;
            }
        }
        new Clock(this, textarea, running_color, idle_color).start();
        return panel;
    }

    protected JPanel buildStatusPanel() {
        JLabel status = new JLabel(Resource.getString((String)"run.status"));
        status.setToolTipText("status of processing");
        JLabel settings = new JLabel(CommonGui.loadIcon((String)"save_yes.gif"));
        settings.setToolTipText("do or don't save settings on exit");
        settings.setEnabled(false);
        JLabel date = new JLabel();
        JLabel time = new JLabel();
        JLabel onlineIcon = new JLabel("OFF");
        onlineIcon.setToolTipText("WebIF online status");
        DateFormat date_format = DateFormat.getDateInstance(1);
        DateFormat time_format = DateFormat.getTimeInstance(1);
        class Clock
        implements Runnable {
            private Thread clockThread;
            private String StatusString;
            private String DateString;
            private boolean SaveSettings;
            private boolean WebIFisOnline;
            final /* synthetic */ MainFrame this$0;
            private final /* synthetic */ JLabel val$status;
            private final /* synthetic */ JLabel val$onlineIcon;
            private final /* synthetic */ JLabel val$settings;
            private final /* synthetic */ DateFormat val$date_format;
            private final /* synthetic */ JLabel val$date;
            private final /* synthetic */ JLabel val$time;
            private final /* synthetic */ DateFormat val$time_format;

            Clock(MainFrame mainFrame, JLabel jLabel, JLabel jLabel2, JLabel jLabel3, DateFormat dateFormat, JLabel jLabel4, JLabel jLabel5, DateFormat dateFormat2) {
                this.this$0 = mainFrame;
                this.val$status = jLabel;
                this.val$onlineIcon = jLabel2;
                this.val$settings = jLabel3;
                this.val$date_format = dateFormat;
                this.val$date = jLabel4;
                this.val$time = jLabel5;
                this.val$time_format = dateFormat2;
                this.clockThread = null;
                this.StatusString = "";
                this.DateString = "";
                this.SaveSettings = false;
                this.WebIFisOnline = false;
            }

            public void start() {
                if (this.clockThread == null) {
                    this.clockThread = new Thread((Runnable)this, "Clock_1");
                    this.clockThread.setPriority(1);
                    this.clockThread.start();
                }
            }

            public void run() {
                Thread myThread = Thread.currentThread();
                while (this.clockThread == myThread) {
                    this.update();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }

            private void update() {
                this.updateStatusLabel();
                this.updateWebIFLabel();
                this.updateSettingsLabel();
                this.updateDateLabel();
                this.updateTimeLabel();
            }

            private void updateStatusLabel() {
                String str = Common.getStatusString();
                if (str.equals(this.StatusString)) {
                    return;
                }
                this.StatusString = str;
                this.val$status.setText(this.StatusString);
            }

            private void updateWebIFLabel() {
                boolean b = Common.isWebServerOnline();
                if (b == this.WebIFisOnline) {
                    return;
                }
                this.WebIFisOnline = b;
                this.val$onlineIcon.setText(this.WebIFisOnline ? "ON" : "OFF");
            }

            private void updateSettingsLabel() {
                boolean b = Common.getSettings().getBooleanProperty(Keys.KEY_SaveSettingsOnExit);
                if (b == this.SaveSettings) {
                    return;
                }
                this.SaveSettings = b;
                this.val$settings.setEnabled(this.SaveSettings);
            }

            private void updateDateLabel() {
                String str = this.val$date_format.format(new Date());
                if (str.equals(this.DateString)) {
                    return;
                }
                this.DateString = str;
                this.val$date.setText(this.DateString);
            }

            private void updateTimeLabel() {
                this.val$time.setText(this.val$time_format.format(new Date()));
            }

            public void stop() {
                this.clockThread = null;
            }
        }
        new Clock(this, status, onlineIcon, settings, date_format, date, time, time_format).start();
        JPanel status_1 = new JPanel(new BorderLayout());
        status_1.setBorder(BorderFactory.createLoweredBevelBorder());
        status_1.setPreferredSize(new Dimension(580, 22));
        status_1.setMaximumSize(new Dimension(580, 22));
        status_1.add(status);
        JPanel status_2 = new JPanel(new BorderLayout());
        status_2.setBorder(BorderFactory.createLoweredBevelBorder());
        status_2.setPreferredSize(new Dimension(30, 22));
        status_2.setMaximumSize(new Dimension(30, 22));
        status_2.add(onlineIcon);
        JPanel status_3 = new JPanel(new BorderLayout());
        status_3.setBorder(BorderFactory.createLoweredBevelBorder());
        status_3.setPreferredSize(new Dimension(30, 22));
        status_3.setMaximumSize(new Dimension(30, 22));
        status_3.add(settings);
        JPanel status_4 = new JPanel(new BorderLayout());
        status_4.setBorder(BorderFactory.createLoweredBevelBorder());
        status_4.setPreferredSize(new Dimension(130, 22));
        status_4.setMaximumSize(new Dimension(130, 22));
        status_4.add(date);
        JPanel status_5 = new JPanel(new BorderLayout());
        status_5.setBorder(BorderFactory.createLoweredBevelBorder());
        status_5.setPreferredSize(new Dimension(130, 22));
        status_5.setMaximumSize(new Dimension(130, 22));
        status_5.add(time);
        JPanel mainStatusPanel = new JPanel();
        mainStatusPanel.setLayout(new BoxLayout(mainStatusPanel, 0));
        mainStatusPanel.add(status_1);
        mainStatusPanel.add(status_2);
        mainStatusPanel.add(status_3);
        mainStatusPanel.add(status_4);
        mainStatusPanel.add(status_5);
        return mainStatusPanel;
    }

    public void ScanInfo(XInputFile aXInputFile) {
        this.ScanInfo(aXInputFile, -1);
    }

    public void ScanInfo(XInputFile aXInputFile, int streamtype) {
        if (aXInputFile.getStreamInfo() == null || streamtype > -1) {
            Common.getScanClass().getStreamInfo(aXInputFile, streamtype);
        }
        CommonGui.getPicturePanel().setStreamInfo(aXInputFile.getStreamInfo());
    }

    public void reloadInputDirectories() {
        this.updateAutoloadList(Common.reloadInputDirectories());
    }

    private void showStartUpProgress(StartUp startup, int value, String str) {
        if (startup == null) {
            System.out.println(str);
        } else {
            startup.setProgress(value, str);
        }
    }

    private void initialize(StartUp startup) {
        String[] version = GStart.getVersion();
        try {
            this.showStartUpProgress(startup, 0, "Loading GUI...");
            this.buildGUI(startup);
            this.showStartUpProgress(startup, 70, "Loading Input Directories...");
            this.reloadInputDirectories();
            this.showStartUpProgress(startup, 80, "Loading Main Frame...");
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    Common.exitApplication((int)0);
                }
            });
            frame.addComponentListener(new ComponentListener(){

                public void componentHidden(ComponentEvent e) {
                }

                public void componentMoved(ComponentEvent e) {
                }

                public void componentShown(ComponentEvent e) {
                }

                public void componentResized(ComponentEvent e) {
                    int w = Integer.parseInt(Keys.KEY_WindowPositionMain_Width[1]);
                    int h = Integer.parseInt(Keys.KEY_WindowPositionMain_Height[1]);
                    Component c = e.getComponent();
                    Dimension preferred = new Dimension(w, h);
                    Dimension current = c.getSize();
                    double newHeight = preferred.getHeight() > current.getHeight() ? preferred.getHeight() : current.getHeight();
                    double newWidth = preferred.getWidth() > current.getWidth() ? preferred.getWidth() : current.getWidth();
                    c.setSize(new Dimension((int)newWidth, (int)newHeight));
                }
            });
            frame.getContentPane().add(this);
            frame.setLocation(Common.getSettings().getIntProperty(Keys.KEY_WindowPositionMain_X), Common.getSettings().getIntProperty(Keys.KEY_WindowPositionMain_Y));
            frame.setSize(new Dimension(Common.getSettings().getIntProperty(Keys.KEY_WindowPositionMain_Width), Common.getSettings().getIntProperty(Keys.KEY_WindowPositionMain_Height)));
            frametitle = String.valueOf(version[0]) + "/" + version[1] + " " + version[2] + " " + version[3];
            MainFrame.setFrameTitle(frametitle);
            this.showStartUpProgress(startup, 90, "Printing Environment Settings...");
            Common.setMessage(null, (boolean)false);
            Object[] obj = Common.getJavaEV((String)Common.getSettings().getInifile());
            Common.setMessage((Object[])obj);
            Common.setMessage((String)"");
            CommonGui.getPicturePanel().setOSDMessage(obj, true);
            this.showStartUpProgress(startup, 100, "Showing Main Frame...");
            if (startup != null) {
                startup.set(Common.getSettings().getBooleanProperty(Keys.KEY_Agreement));
                if (startup.get()) {
                    MainFrame.setVisible0(true);
                    startup.close();
                    startup = null;
                }
            } else {
                MainFrame.setVisible0(true);
            }
        }
        catch (Exception e) {
            if (Common.showGUI()) {
                if (startup != null) {
                    startup.close();
                    startup = null;
                }
                if (frame != null) {
                    frame.setVisible(false);
                }
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                CommonGui.showErrorMessageDialog((Object)(String.valueOf(Resource.getString((String)"startup.error")) + "\n\n" + sw.toString()), (String)Resource.getString((String)"startup.error.title"));
            } else {
                e.printStackTrace();
            }
            Common.exitApplication((int)1);
        }
    }

    public static void setVisible0(boolean b) {
        SwingUtilities.updateComponentTreeUI(frame);
        frame.setVisible(b);
    }

    public static void closeProgram(boolean b) {
        if (Common.isRunningProcess() && !CommonGui.getUserConfirmation((String)"process is running, really stop'em ?")) {
            return;
        }
        Common.exitApplication((int)GlobalReturnCode);
    }

    public static void setFrameTitle(String str) {
        frame.setTitle(str);
    }

    public static void resetFrameTitle() {
        MainFrame.setFrameTitle(frametitle);
    }

    public static Rectangle getFrameBounds() {
        return frame.getBounds();
    }

    public static void showFrame(boolean b) {
        frame.setState(b ? 0 : 1);
    }

    public static void showActiveCollection(int index) {
        if (index >= 0 && index < Common.getCollectionListSize()) {
            comboBox_0.setSelectedIndex(index);
        }
        if (Common.isCollectionListEmpty()) {
            Common.setActiveCollection((int)-1);
            comboBox_0.removeAllItems();
            MainFrame.updateCollectionPanel(-1);
        }
    }

    public static void updateCollectionPanel(int index) {
        collection_panel.entry(index);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void insertBoxFiles(GDialog inpDialog, List inpFileList, int inpID) {
        Cursor tmpCursor;
        block17: {
            if (inpFileList == null) return;
            if (inpFileList.size() < 1) {
                return;
            }
            tmpCursor = null;
            String tmpStatus = null;
            try {
                try {
                    tmpCursor = null;
                    tmpStatus = Common.getStatusString();
                    Common.setStatusString((String)Resource.getString((String)"gdialog.status.transfer"));
                    JobCollection tmpCollection = Common.getCollection();
                    if (inpID > 0 && tmpCollection != null && tmpCollection.getAllSizes() != 0L) {
                        Common.addCollection((boolean)true);
                    } else {
                        Common.addCollection((boolean)false);
                    }
                    JobCollection collection = Common.getCollection();
                    List tmpFileList = collection.getInputFilesAsList();
                    int primaryFilesCount = tmpFileList == null ? 0 : tmpFileList.size();
                    StreamInfo tmpStreamInfo = null;
                    int anz = inpFileList.size();
                    int i = 0;
                    while (true) {
                        XInputFile tmpXFile;
                        block18: {
                            if (i < anz) break block18;
                            collection.setPrimaryInputFileSegments(primaryFilesCount);
                            this.updateCollectionTable(collection.getCollectionAsTable());
                            MainFrame.updateCollectionPanel(Common.getActiveCollection());
                            String newoutname = inpDialog.getSelectedOutname();
                            if (newoutname != null) {
                                collection.setOutputName(Utils.legalFilename(newoutname));
                                this.updateOutputField(collection);
                                this.updateCollectionTable(collection.getCollectionAsTable());
                            }
                            break;
                        }
                        Object tmpObject = inpFileList.get(i);
                        if (tmpObject instanceof XInputFile && (tmpXFile = (XInputFile)tmpObject).exists()) {
                            if (tmpStreamInfo == null) {
                                tmpStreamInfo = tmpXFile.getStreamInfo();
                                if (tmpStreamInfo == null) {
                                    Common.getScanClass().getStreamInfo(tmpXFile);
                                    tmpStreamInfo = tmpXFile.getStreamInfo();
                                }
                            } else {
                                tmpXFile.setStreamInfo(tmpStreamInfo);
                            }
                            tmpFileList.add(tmpXFile);
                            ++primaryFilesCount;
                        }
                        ++i;
                    }
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                Object var15_18 = null;
                if (tmpStatus != null) {
                    Common.setStatusString((String)tmpStatus);
                }
                if (tmpCursor != null) {
                    this.setCursor(tmpCursor);
                }
                if (inpID != 1) throw throwable;
                this.getGDialog().toFront();
                throw throwable;
            }
            {
                Object var15_19 = null;
                if (tmpStatus == null) break block17;
            }
            Common.setStatusString((String)tmpStatus);
        }
        if (tmpCursor != null) {
            this.setCursor(tmpCursor);
        }
        if (inpID != 1) return;
        this.getGDialog().toFront();
    }

    protected GDialog getGDialog() {
        if (this.aGDialog == null) {
            this.aGDialog = new GDialog();
        }
        return this.aGDialog;
    }

    protected void showGigasetDialog() {
        Object tmpStatus = null;
        try {
            final GDialog gigaset = this.getGDialog();
            if (gigaset.isVisible()) {
                gigaset.toFront();
                return;
            }
            ActionListener tmpActionListener = gigaset.getActionListener();
            if (tmpActionListener == null) {
                tmpActionListener = new ActionListener(){

                    public void actionPerformed(ActionEvent inpE) {
                        MainFrame.this.insertBoxFiles(gigaset, inpE);
                    }
                };
                gigaset.setActionListener(tmpActionListener);
            }
            gigaset.setLocationRelativeTo(this);
            gigaset.setVisible(true);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    protected void insertBoxFiles(final GDialog inpDialog, ActionEvent inpEvent) {
        try {
            List tmpList;
            final int tmpID = inpEvent.getID();
            Object tmpSource = inpEvent.getSource();
            GPanelLost tmpPanelLost = tmpSource instanceof GPanelLost ? (GPanelLost)tmpSource : null;
            List list = tmpList = tmpPanelLost != null ? tmpPanelLost.getSelectedLostMPGs() : inpDialog.getSelectedRecording();
            if (tmpList == null || tmpList.size() == 0) {
                return;
            }
            Runnable tmpRunnable = new Runnable(){

                public void run() {
                    MainFrame.this.insertBoxFiles(inpDialog, tmpList, tmpID);
                }
            };
            new Thread(tmpRunnable).start();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    static class ClipboardObserver
    implements ClipboardOwner {
        ClipboardObserver() {
        }

        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }
    }
}

