/*
 * Decompiled with CFR 0.152.
 */
package de.m740.projectx.gigaset;

import de.m740.projectx.gigaset.GAufnahmeContainer;
import de.m740.projectx.gigaset.GAufnahmeIF;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

public class GTableCellRenderer
implements TableCellRenderer {
    protected transient Icon collapsedIcon;
    protected transient Icon leafIcon;
    protected transient Icon defaultLeafIcon;
    protected transient Icon expandedIcon;
    private StringBuffer aStringBuffer = null;
    private JLabel aLabel = null;
    private Color lightBlue = new Color(160, 160, 255);
    private Color darkBlue = new Color(64, 64, 128);

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel label = this.getLabel();
        StringBuffer tmpBuf = this.getStringBuffer();
        tmpBuf.setLength(0);
        tmpBuf.append(String.valueOf(value));
        label.setOpaque(true);
        Border b = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        label.setBorder(b);
        label.setFont(table.getFont());
        label.setForeground(table.getForeground());
        label.setBackground(table.getBackground());
        if (hasFocus) {
            label.setBackground(this.darkBlue);
            label.setForeground(Color.white);
        } else if (isSelected) {
            label.setBackground(this.lightBlue);
        }
        GAufnahmeIF tmpAufnahme = null;
        Icon tmpIcon = null;
        if (value instanceof GAufnahmeIF) {
            tmpAufnahme = (GAufnahmeIF)value;
        } else if (value instanceof GAufnahmeContainer) {
            GAufnahmeContainer tmpContainer = (GAufnahmeContainer)value;
            tmpAufnahme = tmpContainer.getAufnahme();
            if (tmpContainer.isExpandedDouble()) {
                tmpIcon = this.getLeafIcon();
            } else if (tmpContainer.hasChildren()) {
                tmpIcon = tmpContainer.isExpanded() ? this.getExpandedIcon() : this.getCollapsedIcon();
            } else {
                tmpBuf.insert(0, "   ");
            }
        }
        if (tmpAufnahme != null) {
            Color tmpColor = null;
            if (tmpAufnahme.getByte() < 0L) {
                tmpColor = Color.blue;
            } else if (tmpAufnahme.isFehlerhaft()) {
                tmpColor = Color.red;
            } else if (tmpAufnahme.isLaufend()) {
                tmpColor = Color.red;
            }
            if (tmpColor != null) {
                label.setForeground(tmpColor);
            }
        }
        label.setIcon(tmpIcon);
        label.setText(tmpBuf.toString());
        return label;
    }

    private JLabel getLabel() {
        if (this.aLabel == null) {
            this.aLabel = new JLabel();
        }
        return this.aLabel;
    }

    private StringBuffer getStringBuffer() {
        if (this.aStringBuffer == null) {
            this.aStringBuffer = new StringBuffer();
        }
        return this.aStringBuffer;
    }

    private Icon getExpandedIcon() {
        if (this.expandedIcon == null) {
            this.expandedIcon = UIManager.getIcon("Tree.expandedIcon");
        }
        return this.expandedIcon;
    }

    private Icon getCollapsedIcon() {
        if (this.collapsedIcon == null) {
            this.collapsedIcon = UIManager.getIcon("Tree.collapsedIcon");
        }
        return this.collapsedIcon;
    }

    private Icon getLeafIcon() {
        if (this.leafIcon == null) {
            this.leafIcon = new ChildIcon();
        }
        return this.leafIcon;
    }

    protected Icon getDefaultLeafIcon() {
        if (this.defaultLeafIcon == null) {
            this.defaultLeafIcon = UIManager.getIcon("Tree.leafIcon");
        }
        return this.defaultLeafIcon;
    }

    protected void setLeafIcon(Icon inpLeafIcon) {
        this.leafIcon = inpLeafIcon;
    }

    class ChildIcon
    implements Icon {
        ChildIcon() {
        }

        private void drawDashedHorizontalLine(Graphics g, int y, int x1, int x2) {
            x1 += x1 % 2;
            int x = x1;
            while (x <= x2) {
                g.drawLine(x, y, x, y);
                x += 2;
            }
        }

        private void drawDashedVerticalLine(Graphics g, int x, int y1, int y2) {
            y1 += y1 % 2;
            int y = y1;
            while (y <= y2) {
                g.drawLine(x, y, x, y);
                y += 2;
            }
        }

        public int getIconHeight() {
            return GTableCellRenderer.this.getDefaultLeafIcon().getIconHeight();
        }

        public int getIconWidth() {
            return GTableCellRenderer.this.getDefaultLeafIcon().getIconWidth();
        }

        public void paintIcon(Component inpC, Graphics inpG, int inpX, int inpY) {
            int height = this.getIconHeight();
            int width = this.getIconWidth();
            int x1 = inpX + width / 2;
            int y1 = inpY;
            int y2 = y1 + height - 5;
            Color tmpColor = inpG.getColor();
            inpG.setColor(Color.black);
            this.drawDashedVerticalLine(inpG, x1, y1, y2);
            int x2 = x1 + width / 2;
            this.drawDashedHorizontalLine(inpG, y2, x1, x2);
            inpG.setColor(tmpColor);
        }
    }
}

