/*
 * Decompiled with CFR 0.152.
 */
package de.m740.projectx.gigaset;

import de.m740.projectx.gigaset.GConsole;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.xinput.XInputDirectory;
import net.sourceforge.dvb.projectx.xinput.XInputFile;
import net.sourceforge.dvb.projectx.xinput.ftp.FtpVO;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;

public class GFTPHandler {
    protected boolean debug = false;

    private String[] getUserFTPCommand() {
        StringTokenizer st = new StringTokenizer(Common.getSettings().getProperty(Keys.KEY_FtpServer_Commands), "|");
        String[] tokens = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            tokens[i] = st.nextElement().toString().trim();
            ++i;
        }
        return tokens;
    }

    public FTPClient openClient(FtpVO inpFtpVO) {
        FTPClient tmpClient = null;
        try {
            boolean ret = false;
            tmpClient = new FTPClient();
            tmpClient.connect(inpFtpVO.getServer(), inpFtpVO.getPortasInteger());
            if (this.debug) {
                System.out.println("rAO connect " + tmpClient.getReplyString());
            }
            ret = tmpClient.login(inpFtpVO.getUser(), inpFtpVO.getPassword());
            if (this.debug) {
                System.out.println("rAO login " + ret + " / " + tmpClient.getReplyString());
            }
            ret = tmpClient.changeWorkingDirectory(inpFtpVO.getDirectory());
            if (this.debug) {
                System.out.println("rAO cwd " + ret + " / " + tmpClient.getReplyString());
            }
            ret = tmpClient.setFileType(2);
            if (this.debug) {
                System.out.println("rAO binary " + ret + " / " + tmpClient.getReplyString());
            }
            tmpClient.enterLocalPassiveMode();
            if (this.debug) {
                System.out.println("rAO PASV " + tmpClient.getReplyString());
            }
            String[] commands = this.getUserFTPCommand();
            int i = 0;
            while (i < commands.length) {
                if (commands[i] != null && commands[i].length() > 0) {
                    tmpClient.sendCommand(commands[i]);
                    if (this.debug) {
                        System.out.println("rAO cmd " + tmpClient.getReplyString());
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return tmpClient;
    }

    public void closeClient(FTPClient tmpClient) {
        try {
            block11: {
                boolean ret = false;
                if (this.debug) {
                    System.out.println("rAC last " + tmpClient.getReplyCode() + " / " + tmpClient.getReplyString());
                }
                ret = tmpClient.isConnected();
                if (this.debug) {
                    System.out.println("rAC isCon " + ret + " / " + tmpClient.getReplyCode() + " / " + tmpClient.getReplyString());
                }
                ret = tmpClient.logout();
                if (this.debug) {
                    System.out.println("rAC logout " + ret + " / " + tmpClient.getReplyCode() + " / " + tmpClient.getReplyString());
                }
                ret = tmpClient.isConnected();
                if (this.debug) {
                    System.out.println("rAC isCon " + ret + " / " + tmpClient.getReplyCode() + " / " + tmpClient.getReplyString());
                }
                if (ret) {
                    try {
                        tmpClient.disconnect();
                        if (this.debug) {
                            System.out.println("rAC disc " + tmpClient.getReplyCode() + " / " + tmpClient.getReplyString());
                        }
                    }
                    catch (IOException e) {
                        if (!this.debug) break block11;
                        System.out.println("rAC disc-er " + e);
                    }
                }
            }
            if (this.debug) {
                System.out.println("rAC out ");
            }
        }
        catch (IOException exc) {
            GConsole.setErrorMessage(exc);
        }
    }

    public FtpVO makeVOFrom(XInputDirectory inpDir) {
        try {
            XInputDirectory tmpXDirectory = inpDir;
            String tmpDirectory = tmpXDirectory.getDirectory();
            String tmpServer = tmpXDirectory.getServer();
            String tmpUser = tmpXDirectory.getUser();
            String tmpPassword = tmpXDirectory.getPassword();
            String tmpPort = tmpXDirectory.getPort();
            FtpVO tmpVO = new FtpVO(tmpServer, tmpUser, tmpPassword, tmpDirectory, tmpPort, null);
            return tmpVO;
        }
        catch (Exception e) {
            GConsole.setErrorMessage(e);
            return null;
        }
    }

    public XInputDirectory makeDirectoryFrom(XInputFile inpFile, FtpVO inpVO) {
        try {
            String tmpDirectory = String.valueOf(inpFile.getParent()) + "/" + inpFile.getName();
            String tmpServer = inpVO.getServer();
            String tmpUser = inpVO.getUser();
            String tmpPassword = inpVO.getPassword();
            String tmpPort = inpVO.getPort();
            FtpVO tmpVO = new FtpVO(tmpServer, tmpUser, tmpPassword, tmpDirectory, tmpPort, null);
            XInputDirectory tmpIDirectory = new XInputDirectory((Object)tmpVO);
            if (tmpIDirectory.test()) {
                return tmpIDirectory;
            }
        }
        catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return null;
    }

    private XInputFile[] listFiles(FTPClient inpClient, FtpVO inpVO) throws IOException {
        FTPFile[] tmpFTPFiles = null;
        tmpFTPFiles = inpClient.listFiles();
        int anz = tmpFTPFiles == null ? 0 : tmpFTPFiles.length;
        ArrayList<XInputFile> tmpList = new ArrayList<XInputFile>(anz);
        int i = 0;
        while (i < anz) {
            FTPFile tmpFTPFile = tmpFTPFiles[i];
            String tmpFN = tmpFTPFile.getName();
            if (!".".equals(tmpFN) && !"..".equals(tmpFN)) {
                FtpVO tempFtpVO = (FtpVO)inpVO.clone();
                tempFtpVO.setFtpFile(tmpFTPFiles[i]);
                tmpList.add(new XInputFile((Object)tempFtpVO));
            }
            ++i;
        }
        anz = tmpList == null ? 0 : tmpList.size();
        XInputFile[] ftpInputFiles = new XInputFile[anz];
        int i2 = 0;
        while (i2 < anz) {
            ftpInputFiles[i2] = (XInputFile)tmpList.get(i2);
            ++i2;
        }
        return ftpInputFiles;
    }

    public XInputFile[] getFilesAndDirectories(XInputDirectory inpDir) {
        XInputFile[] tmpXFiles = null;
        try {
            FtpVO tmpFtpVO = this.makeVOFrom(inpDir);
            FTPClient tmpClient = this.openClient(tmpFtpVO);
            tmpXFiles = this.listFiles(tmpClient, tmpFtpVO);
            this.closeClient(tmpClient);
        }
        catch (Exception exc) {
            GConsole.setErrorMessage(exc);
        }
        return tmpXFiles;
    }
}

