/*
 * Decompiled with CFR 0.152.
 */
package de.m740.projectx.gigaset;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class GConsole
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTextArea aTextArea = null;
    private JScrollPane aScrollPane = null;
    private static GConsole aInstance = null;

    private GConsole() {
        this.initialize();
    }

    private void initialize() {
        try {
            GConsole.setInstance(this);
            this.setLayout(new BorderLayout());
            this.add((Component)this.getScrollPane(), "Center");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private JScrollPane getScrollPane() {
        if (this.aScrollPane == null) {
            this.aScrollPane = new JScrollPane(this.getTextArea());
        }
        return this.aScrollPane;
    }

    private JTextArea getTextArea() {
        if (this.aTextArea == null) {
            this.aTextArea = new JTextArea();
        }
        return this.aTextArea;
    }

    public static void clear() {
        try {
            if (aInstance != null) {
                JTextArea tmpArea = aInstance.getTextArea();
                tmpArea.setText("");
                aInstance.getScrollPane().getViewport().setViewPosition(new Point(0, tmpArea.getHeight()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setMessage(String inpMsg) {
        try {
            if (aInstance == null) {
                System.out.println(inpMsg);
            } else {
                JTextArea tmpArea = aInstance.getTextArea();
                tmpArea.append(inpMsg);
                tmpArea.append("\n");
                aInstance.getScrollPane().getViewport().setViewPosition(new Point(0, tmpArea.getHeight()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setInfo(String inpMsg) {
        try {
            inpMsg = "Info> " + inpMsg;
            if (aInstance == null) {
                System.out.println(inpMsg);
            } else {
                JTextArea tmpArea = aInstance.getTextArea();
                tmpArea.append(inpMsg);
                tmpArea.append("\n");
                aInstance.getScrollPane().getViewport().setViewPosition(new Point(0, tmpArea.getHeight()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setErrorMessage(Throwable inpError) {
        try {
            StringWriter sw = new StringWriter();
            inpError.printStackTrace(new PrintWriter(sw));
            String tmpStr = sw.toString();
            GConsole.setMessage(tmpStr);
            if (aInstance != null) {
                System.out.println(tmpStr);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static GConsole getInstance() {
        if (aInstance == null) {
            aInstance = new GConsole();
        }
        return aInstance;
    }

    private static void setInstance(GConsole inpInstance) {
        aInstance = inpInstance;
    }
}

