/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.tools.fsa;

import java.lang.reflect.Method;
import java.util.Arrays;

import org.apache.log4j.Logger;


/**
 * try to provide some useful methods
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.28 $ <h2> Associations </h2>
 */
public class FSAUtility
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (FSAUtility.class);


   /**
    * Default Constructor
    */
   private FSAUtility() { }


   /**
    * get name from full qualified name
    *
    * @param name  the full qualified name <..>.<..>.className
    * @return      className
    */
   public static String getClassName (String name)
   {
      if (name == null)
      {
         return null;
      }

      int dotpos = name.lastIndexOf ('.');

      return name.substring (dotpos + 1);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param oldString  No description provided
    * @return           No description provided
    */
   public static String downFirstChar (String oldString)
   {
      if (oldString.length() == 0)
      {
         return oldString;
      }
      else
      {
         StringBuffer newBuffer = new StringBuffer (oldString);

         newBuffer.setCharAt (0, Character.toLowerCase (newBuffer.charAt (0)));

         return newBuffer.toString();
      }
   }


   /**
    * convert source Object to target Class
    *
    * @param target  the target class
    * @param source  the source object
    * @return        the converted object
    */
   public static Object convert (Object source, Class target)
   {
      if (target == null || source == null)
      {
         log.error ("FSAUtility.convert ( " + source
            + " , " + target + " ) ! ");
         return null;
      }

      if (target == source.getClass() || target == java.lang.Object.class)
      {
         return source;
      }

      Method converterMethod = FSATypeConverterCache.get().getDefaultConverterMethods (source.getClass(), target);

      if (converterMethod == null)
      {
         log.error ("FSAUtility.convert ( " + source.getClass()
            + " , " + target + " ) : converterMethod is null!");
         return null;
      }

      Object newObject;
      Object args[] =
         {source};

      try
      {
         newObject = converterMethod.invoke (null, args);
      }
      catch (Exception exception)
      {
         log.error ("FSAUtility.convert ( '" + source
            + "' , " + target + " ) : invoke failed \n" +
            exception);
         exception.printStackTrace();
         return null;
      }

      return newObject;
   }


   /**
    * Get the arrayAsString attribute of the FSAUtility class
    *
    * @param array  No description provided
    * @return       The arrayAsString value
    */
   public static String getArrayAsString (Object[] array)
   {
      if (array == null)
      {
         return "<null>";
      }
      else
      {
         return Arrays.asList (array).toString();
      }
   }

}

/*
 * $Log: FSAUtility.java,v $
 * Revision 1.28  2004/10/20 17:50:34  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
