/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.views.gui;

import java.awt.*;
import java.awt.event.*;
import java.util.HashSet;
import java.util.Iterator;

import javax.swing.*;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.SelectionManager;
import de.uni_paderborn.fujaba.gui.comp.FujabaDialog;
import de.uni_paderborn.fujaba.uml.UMLDiagram;
import de.uni_paderborn.fujaba.uml.UMLDiagramItem;
import de.uni_paderborn.fujaba.views.*;
import de.upb.tools.fca.*;


/**
 * A basic implementation of the JDialog class.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.20 $
 */
public class ViewDefinitionDialog extends FujabaDialog implements ActionListener,
   ChangeListener,
   ItemListener,
   WindowListener
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JList diagItemsList = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JList startItemsList = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JComboBox filterComboBox = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JCheckBox updateCheckBox = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JTextField nContextTextField = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JRadioButton nContextRadioButton = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JRadioButton maxContextRadioButton = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private ButtonGroup contextButtonGroup = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JButton editButton = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JTextField nameField = null;


   /**
    * Constructor for class ViewDefinitionDialog
    *
    * @param parentFrame  No description provided
    */
   public ViewDefinitionDialog (JFrame parentFrame)
   {
      super (parentFrame);
      setModal (true);
      setTitle ("Edit ViewDefinition");
      addWindowListener (this);

      guiBuild();
   }


   /**
    * Creates a new instance of ViewDefinitionDialog with the given title.
    *
    * @param sTitle       the title for the new frame.
    * @param parentFrame  No description provided
    */
   public ViewDefinitionDialog (JFrame parentFrame, String sTitle)
   {
      this (parentFrame);
      setTitle (sTitle);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void guiBuild()
   {
      getContentPane().setLayout (new BorderLayout());
      getContentPane().add (guiPanelOkCancelHelp(), BorderLayout.SOUTH);

      JPanel namePanel = new JPanel();
      namePanel.setLayout (new GridLayout (2, 1));
      nameField = new JTextField();
      namePanel.add (new JLabel ("Definition Name"));
      namePanel.add (nameField);

      getContentPane().add (namePanel, BorderLayout.NORTH);

      JPanel mainPanel = new JPanel();
      //mainPanel.setBorder (new BevelBorder (BevelBorder.RAISED));
      mainPanel.setLayout (new GridBagLayout()); //BorderLayout());

      GridBagConstraints constraints = new GridBagConstraints();
      constraints.gridx = 0;
      constraints.gridy = 0;
      constraints.gridheight = 1;
      constraints.gridwidth = 2;
      constraints.weightx = 0.5;
      constraints.weighty = 0;
      constraints.anchor = GridBagConstraints.NORTHWEST;
      constraints.fill = GridBagConstraints.BOTH;

      JPanel filterPanel = new JPanel();
      filterPanel.setBorder (new TitledBorder ("Filter"));
      //filterPanel.setLayout(new GridLayout(2,1,0,0));

      filterComboBox = new JComboBox();
      filterComboBox.setActionCommand ("filter");
      filterComboBox.addActionListener (this);
      filterComboBox.addItemListener (this);
      filterComboBox.setRenderer (FilterManager.getListCellRenderer());
      filterPanel.add (filterComboBox);

      editButton = new JButton();
      editButton.setText ("Edit Filter");
      editButton.setActionCommand ("editFilter");
      editButton.addActionListener (this);

      JPanel lowerPanel = new JPanel();
      lowerPanel.add (editButton);

      filterPanel.add (lowerPanel);

      mainPanel.add (filterPanel, constraints);

      JPanel updatePanel = new JPanel();
      updatePanel.setBorder (new TitledBorder ("Update View"));
      updateCheckBox = new JCheckBox();
      updateCheckBox.setSelected (true);
      updateCheckBox.setText ("Keep View up-to-date");

      updatePanel.add (updateCheckBox);

      constraints.gridx = 3;
      constraints.anchor = GridBagConstraints.NORTHEAST;
      mainPanel.add (updatePanel, constraints);

      JPanel diagItemsPanel = new JPanel();
      diagItemsPanel.setBorder (new TitledBorder ("Diagram Items"));
      diagItemsPanel.setLayout (new GridLayout (1, 1, 0, 0));

      JScrollPane diagItemsScrollPane = new JScrollPane();
      diagItemsScrollPane.setBorder (new BevelBorder (BevelBorder.LOWERED));
      //diagItemsScrollPane.getViewport().setLayout(new GridLayout(1,1,0,0));

      diagItemsList = new JList();
      diagItemsList.setModel (new DefaultListModel());
      //diagItemsList.setModel (itemsModel);
      diagItemsList.setCellRenderer (new DiagramItemRenderer());
      diagItemsScrollPane.getViewport().setView (diagItemsList);
      diagItemsPanel.add (diagItemsScrollPane);

      constraints.gridx = 0;
      constraints.gridy = 1;
      constraints.gridheight = 2;
      constraints.weighty = 1;
      constraints.anchor = GridBagConstraints.WEST;
      constraints.fill = GridBagConstraints.BOTH;
      mainPanel.add (diagItemsPanel, constraints);

      JPanel startItemsPanel = new JPanel();
      startItemsPanel.setBorder (new TitledBorder ("0-Context"));
      startItemsPanel.setLayout (new GridLayout (1, 1, 0, 0));

      JScrollPane startItemsScrollPane = new JScrollPane();
      startItemsScrollPane.setBorder (new BevelBorder (BevelBorder.LOWERED));
      //startItemsScrollPane.getViewport().setLayout(new GridLayout(1,1,0,0));

      startItemsList = new JList();
      startItemsList.setCellRenderer (new DiagramItemRenderer());
      startItemsList.setModel (new DefaultListModel());
      startItemsScrollPane.getViewport().setView (startItemsList);
      startItemsPanel.add (startItemsScrollPane);

      constraints.gridx = 3;
      constraints.anchor = GridBagConstraints.EAST;
      mainPanel.add (startItemsPanel, constraints);

      JPanel itemsButtonPanel = new JPanel();
      itemsButtonPanel.setLayout (new GridLayout (3, 1, 0, 0));

      JButton addItemButton = new JButton();
      addItemButton.setText ("Add >");
      addItemButton.setActionCommand ("addItem");
      addItemButton.addActionListener (this);
      itemsButtonPanel.add (addItemButton);

      JButton removeItemButton = new JButton();
      removeItemButton.setText ("< Remove");
      removeItemButton.setActionCommand ("removeItem");
      removeItemButton.addActionListener (this);
      itemsButtonPanel.add (removeItemButton);

      JButton moreItemsButton = new JButton();
      moreItemsButton.setText ("Get more items");
      moreItemsButton.setActionCommand ("moreItems");
      moreItemsButton.addActionListener (this);
      itemsButtonPanel.add (moreItemsButton);

      constraints.gridx = 2;
      constraints.gridy = 2;
      constraints.gridwidth = 1;
      constraints.weightx = 0;
      constraints.weighty = 0;
      constraints.anchor = GridBagConstraints.CENTER;
      constraints.fill = GridBagConstraints.NONE;
      mainPanel.add (itemsButtonPanel, constraints);

      JPanel contextPanel = createContextPanel();
      constraints.gridy = 0;
      constraints.fill = GridBagConstraints.NONE;
      mainPanel.add (contextPanel, constraints);
      getContentPane().add (mainPanel, BorderLayout.CENTER);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   private JPanel createContextPanel()
   {
      JPanel contextPanel = new JPanel();
      contextPanel.setBorder (new TitledBorder ("Context"));
      contextPanel.setLayout (new GridBagLayout());

      GridBagConstraints constraints = new GridBagConstraints();
      constraints.gridx = 0;
      constraints.gridy = 0;
      constraints.gridwidth = 1;
      constraints.gridheight = 1;
      constraints.weightx = 0;
      constraints.weighty = 0;
      constraints.anchor = GridBagConstraints.WEST;
      constraints.fill = GridBagConstraints.NONE;

      contextButtonGroup = new ButtonGroup();

      nContextRadioButton = new JRadioButton();
      nContextRadioButton.setActionCommand ("nContext");
      nContextRadioButton.addChangeListener (this);
      contextButtonGroup.add (nContextRadioButton);

      contextPanel.add (nContextRadioButton, constraints);

      nContextTextField = new JTextField();
      nContextTextField.setEnabled (false);
      constraints.gridx = 1;
      constraints.weightx = 1;
      constraints.fill = GridBagConstraints.HORIZONTAL;
      contextPanel.add (nContextTextField, constraints);

      maxContextRadioButton = new JRadioButton();
      maxContextRadioButton.setText ("max. Context");
      maxContextRadioButton.setActionCommand ("maxContext");
      maxContextRadioButton.addChangeListener (this);
      contextButtonGroup.add (maxContextRadioButton);
      maxContextRadioButton.setSelected (true);

      constraints.gridx = 0;
      constraints.gridy = 1;
      constraints.gridwidth = 2;
      contextPanel.add (maxContextRadioButton, constraints);

      return contextPanel;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void unparse()
   {
      ViewDefinition view = getView();

      if (view != null)
      {
         nameField.setText (view.getName());
      }
      DefaultListModel diagItemsModel = (DefaultListModel) diagItemsList.getModel();
      DefaultListModel startItemsModel = (DefaultListModel) startItemsList.getModel();

      diagItemsModel.removeAllElements();
      startItemsModel.removeAllElements();

      if (filterComboBox.getModel() != null && filterComboBox.getModel() instanceof FilterManager.FMListModel)
      {
          ((FilterManager.FMListModel) filterComboBox.getModel()).removeYou();
      }
      //filterComboBox.setModel (FilterManager.get ().getListModel (getSourceDiagram ()));
      filterComboBox.setModel (FilterManager.get().getListModel (mainDiagram));

      filterComboBox.setRenderer (new FilterRenderer ( (view != null ? view.getFilter() : null)));

      if (view != null && view.getFilter() != null)
      {
         Filter insert = view.getFilter();
         int size = filterComboBox.getItemCount();
         for (int i = size - 1; i >= size; i--)
         {
            Filter filter = (Filter) filterComboBox.getItemAt (i);
            if (filter.getName() != null && filter.getName().equals (insert.getName()))
            {
               filterComboBox.removeItem (filter);
            }
         }
         filterComboBox.addItem (insert);
         filterComboBox.setSelectedItem (insert);
      }

      if (view != null && view.getContext() >= 0)
      {
         nContextTextField.setText (String.valueOf (view.getContext()));
         nContextRadioButton.setSelected (true);
      }
      else
      {
         nContextTextField.setText ("1");
         maxContextRadioButton.setSelected (true);
      }
      UMLDiagram sourceDiag = mainDiagram;
      if (sourceDiag == null)
      {
         diagItemsList.setEnabled (false);
      }
      else
      {
         fillDiagItemsList();
         diagItemsList.setEnabled (true);
      }

      if (view != null)
      {
         fillStartItemsList();
      }

   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void parse()
   {
      ViewDefinition view = getView();

      if (view == null)
      {
         view = new ViewDefinition();
      }

      view.setName (nameField.getText().trim());
      view.setUpdate (updateCheckBox.isSelected());

      if (maxContextRadioButton.isSelected())
      {
         view.setContext (-1);
      }
      else
      {
         view.setContext (Integer.valueOf (nContextTextField.getText()).intValue());
      }

      HashSet viewStartItems = new HashSet();
      Iterator itemIter = view.iteratorOfStartItems();
      while (itemIter.hasNext())
      {
         viewStartItems.add (itemIter.next());
      }

      HashSet selectedStartItems = new HashSet();
      DefaultListModel model = (DefaultListModel) startItemsList.getModel();
      int size = model.getSize();
      for (int i = 0; i < size; i++)
      {
         Object obj = model.getElementAt (i);
         if (! (obj instanceof UMLDiagramItem))
         {
            continue;
         }
         selectedStartItems.add (obj);
      }

      viewStartItems.removeAll (selectedStartItems);
      itemIter = viewStartItems.iterator();
      while (itemIter.hasNext())
      {
         view.removeFromStartItems ((UMLDiagramItem) itemIter.next());
      }
      itemIter = selectedStartItems.iterator();
      while (itemIter.hasNext())
      {
         UMLDiagramItem tmpItem = (UMLDiagramItem) itemIter.next();
         view.addToItems (tmpItem);
         view.addToStartItems (tmpItem);
         //view.addToStartItems ((UMLDiagramItem) itemIter.next ());
      }
      view.setFilter ((Filter) filterComboBox.getSelectedItem());
      setView (view);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private void fillDiagItemsList()
   {
      ViewDefinition view = getView();
      UMLDiagram sourceDiag = null;
      FDuplicatedTreeMap elements = new FDuplicatedTreeMap();
      FDuplicatedTreeMap selected = new FDuplicatedTreeMap();

      DefaultListModel model = (DefaultListModel) diagItemsList.getModel();
      int selItems = 0;

      model.removeAllElements();
      Iterator diagIter = this.iteratorOfSourceDiagrams();
      while (diagIter.hasNext())
      {
         sourceDiag = (UMLDiagram) diagIter.next();

         Iterator itemIter = sourceDiag.iteratorOfElements();
         while (itemIter.hasNext())
         {
            ASGElement asgElement = (ASGElement) itemIter.next();

            if (asgElement instanceof UMLDiagramItem)
            {
               UMLDiagramItem item = (UMLDiagramItem) asgElement;
               if (view != null && view.hasInStartItems (item))
               {
                  continue;
               } // if

               if (!isSelected (item, sourceDiag))
               {
                  elements.put (DiagramItemRenderer.getStringRepresentation (item), item);
               }
               else
               {
                  selected.put (DiagramItemRenderer.getStringRepresentation (item), item);
               }
            }
         } // while

      } // while

      Iterator iter = selected.values().iterator();
      while (iter.hasNext())
      {
         model.addElement (iter.next());
         selItems++;
      }
      iter = elements.values().iterator();
      while (iter.hasNext())
      {
         model.addElement (iter.next());
      }
      if (selItems > 0)
      {
         diagItemsList.setSelectionInterval (0, selItems - 1);
      } // if
      elements.clear();
      selected.clear();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private void fillStartItemsList()
   {
      ViewDefinition view = getView();
      DefaultListModel model = (DefaultListModel) startItemsList.getModel();
      FDuplicatedTreeMap elements = new FDuplicatedTreeMap();
      FDuplicatedTreeMap selected = new FDuplicatedTreeMap();

      int selItems = 0;
      if (view == null)
      {
         return;
      }

      Iterator itemIter = view.iteratorOfStartItems();
      while (itemIter.hasNext())
      {
         UMLDiagramItem item = (UMLDiagramItem) itemIter.next();

         if (!isSelected (item, view.getDiagram()))
         {
            elements.put (DiagramItemRenderer.getStringRepresentation (item), item);
         } // if

         else
         {
            selected.put (DiagramItemRenderer.getStringRepresentation (item), item);
         } // else
      }
      Iterator iter = selected.values().iterator();
      while (iter.hasNext())
      {
         model.addElement (iter.next());
         selItems++;
      }
      iter = elements.values().iterator();
      while (iter.hasNext())
      {
         model.addElement (iter.next());
      }
      if (selItems > 0)
      {
         startItemsList.setSelectionInterval (0, selItems - 1);
      }
      elements.clear();
      selected.clear();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void actionPerformed (ActionEvent e)
   {
      String command = e.getActionCommand();
      if (command.equals ("addItem"))
      {
         addItemAction();
      }
      else if (command.equals ("removeItem"))
      {
         removeItemAction();
      }
      else if (command.equals ("moreItems"))
      {
         moreItemsAction();
      }
      else if (command.equals ("filter"))
      {
         filterAction();
      }
      else if (command.equals ("editFilter"))
      {
         editFilterAction();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void stateChanged (ChangeEvent e)
   {
      nContextTextField.setEnabled (nContextRadioButton.isSelected());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void itemStateChanged (ItemEvent e)
   {
      filterAction();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private void filterAction()
   {
      DefaultComboBoxModel model = (DefaultComboBoxModel) filterComboBox.getModel();
      editButton.setEnabled (model.getSelectedItem() != null &&
         model.getSelectedItem() instanceof ConfigurableFilter);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private void editFilterAction()
   {
      DefaultComboBoxModel model = (DefaultComboBoxModel) filterComboBox.getModel();
      Filter filter = (Filter) model.getSelectedItem();

      if (filter == null)
      {
         return;
      }

      SmallFilterEditorDialog editor = new SmallFilterEditorDialog (null);
      editor.setFilter (filter);
      editor.showCentered();
   }


   /**
    * Access method for an one to n association.
    *
    * @return   No description provided
    */
   private boolean addItemAction()
   {
      Object[] sel = diagItemsList.getSelectedValues();
      if (sel == null || sel.length == 0)
      {
         return false;
      }

      DefaultListModel sourceModel = (DefaultListModel) diagItemsList.getModel();
      DefaultListModel targetModel = (DefaultListModel) startItemsList.getModel();
      for (int i = sel.length - 1; i > -1; i--)
      {
         sourceModel.removeElement (sel[i]);
         targetModel.add (0, sel[i]);
      }
      startItemsList.setSelectionInterval (0, sel.length - 1);
      return true;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   private boolean removeItemAction()
   {
      Object[] sel = startItemsList.getSelectedValues();
      if (sel == null || sel.length == 0)
      {
         return false;
      }

      DefaultListModel targetModel = (DefaultListModel) diagItemsList.getModel();
      DefaultListModel sourceModel = (DefaultListModel) startItemsList.getModel();
      for (int i = sel.length - 1; i > -1; i--)
      {
         sourceModel.removeElement (sel[i]);
         targetModel.add (0, sel[i]);
      }
      diagItemsList.setSelectionInterval (0, sel.length - 1);
      return true;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   private boolean moreItemsAction()
   {
      Iterator diagIter = this.iteratorOfSourceDiagrams();
      while (diagIter.hasNext())
      {
         try
         {
            UMLDiagram tmpDiag =  ((ViewDiagram) diagIter.next()).getDiagram();
            this.addToSourceDiagrams (tmpDiag);
            this.fillDiagItemsList();
         } // try

         catch (ClassCastException e)
         {
         } // catch

      } // while

      return true;
   } //moreItemsAction

   // #####################################################################
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private UMLDiagram mainDiagram = null;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private FHashSet sourceDiagrams;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean hasInSourceDiagrams (UMLDiagram value)
   {
      return  ( (this.sourceDiagrams != null) &&
          (value != null) &&
         this.sourceDiagrams.contains (value));
   } // hasInSourceDiagrams


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator iteratorOfSourceDiagrams()
   {
      return  ( (this.sourceDiagrams == null)
         ? FEmptyIterator.get()
         : this.sourceDiagrams.iterator());
   } // iteratorOfSourceDiagrams


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public int sizeOfSourceDiagrams()
   {
      return  ( (this.sourceDiagrams == null)
         ? 0
         : this.sourceDiagrams.size());
   } // sizeOfSourceDiagrams


   /**
    * Access method for an one to n association.
    *
    * @param value  The object added.
    * @return       No description provided
    */
   public boolean addToSourceDiagrams (UMLDiagram value)
   {
      boolean changed = false;
      if (value != null)
      {
         if (this.sourceDiagrams == null)
         {
            this.sourceDiagrams = new FHashSet();
            mainDiagram = value;
         } // if

         changed = this.sourceDiagrams.add (value);
      } // if

      if (changed)
      {
         unparse();
      }
      return changed;
   } // addToSourceDiagrams


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean removeFromSourceDiagrams (UMLDiagram value)
   {
      boolean changed = false;
      if ( (this.sourceDiagrams != null) &&  (value != null))
      {
         changed = this.sourceDiagrams.remove (value);
      } // if

      if (changed)
      {
         unparse();
      }
      return changed;
   } // removeFromSourceDiagrams


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeAllFromSourceDiagrams()
   {
      UMLDiagram tmpValue;
      Iterator iter = this.iteratorOfSourceDiagrams();
      while (iter.hasNext())
      {
         tmpValue = (UMLDiagram) iter.next();
         this.removeFromSourceDiagrams (tmpValue);
      } // while

   } // removeAllFromSourceDiagrams

   // #####################################################################
   /*
    *  private UMLDiagram sourceDiagram = null;
    *  public void setSourceDiagram (UMLDiagram diag)
    *  {
    *  if (sourceDiagram != diag)
    *  {
    *  sourceDiagram = diag;
    *  unparse ();
    *  }
    *  }
    *  public UMLDiagram getSourceDiagram ()
    *  {
    *  return sourceDiagram;
    *  }
    */
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private ViewDefinition view = null;


   /**
    * Sets the view attribute of the ViewDefinitionDialog object
    *
    * @param view  The new view value
    */
   public void setView (ViewDefinition view)
   {
      if (this.view != view)
      {
         this.view = view;
         unparse();
      }
   }


   /**
    * Get the view attribute of the ViewDefinitionDialog object
    *
    * @return   The view value
    */
   public ViewDefinition getView()
   {
      return view;
   }


   /**
    * Get the selected attribute of the ViewDefinitionDialog object
    *
    * @param item  No description provided
    * @param diag  No description provided
    * @return      The selected value
    */
   private boolean isSelected (UMLDiagramItem item, UMLDiagram diag)
   {
      Iterator fsaIter = item.iteratorOfFsaObjects();
      while (fsaIter.hasNext())
      {
         FSAObject obj = (FSAObject) fsaIter.next();
         if (SelectionManager.get().hasInSelection (obj))
         {
            return true;
         }
      }

      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void windowActivated (WindowEvent e) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void windowDeactivated (WindowEvent e) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void windowIconified (WindowEvent e) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void windowDeiconified (WindowEvent e) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void windowClosing (WindowEvent e) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void windowOpened (WindowEvent e) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void windowClosed (WindowEvent e)
   {
      ComboBoxModel model =  (filterComboBox != null ? filterComboBox.getModel() : null);

      if (model != null && model instanceof FilterManager.FMListModel)
      {
          ((FilterManager.FMListModel) model).removeYou();
      }
   }

}


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.20 $
 */
class DiagramItemRenderer extends DefaultListCellRenderer
{


   /**
    * Get the listCellRendererComponent attribute of the DiagramItemRenderer object
    *
    * @param list          No description provided
    * @param value         No description provided
    * @param index         No description provided
    * @param isSelected    No description provided
    * @param cellHasFocus  No description provided
    * @return              The listCellRendererComponent value
    */
   public Component getListCellRendererComponent (JList list,
                                                  Object value,
                                                  int index,
                                                  boolean isSelected,
                                                  boolean cellHasFocus)
   {
      if (value == null || ! (value instanceof UMLDiagramItem))
      {
         return super.getListCellRendererComponent (list, value, index, isSelected, cellHasFocus);
      }

      UMLDiagramItem item = (UMLDiagramItem) value;

      return super.getListCellRendererComponent (list, getStringRepresentation (item), index, isSelected, cellHasFocus);
   }


   /**
    * Get the stringRepresentation attribute of the DiagramItemRenderer class
    *
    * @param item  No description provided
    * @return      The stringRepresentation value
    */
   public static String getStringRepresentation (UMLDiagramItem item)
   {
      String name = item.getName();

      if (name == null || name.trim().equals ("no name") || name.trim().length() == 0)
      {
         name = item.getID();
      }

      String className = item.getClass().getName();
      int lastDot = className.lastIndexOf (".");
      if (lastDot > -1)
      {
         className = className.substring (lastDot + 1);
      }

      if (className.startsWith ("UML"))
      {
         className = className.substring (3);
      }

      return className + " " + name;
   }
}


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.20 $
 */
class FilterRenderer extends DefaultListCellRenderer
{


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   Filter filter = null;


   /**
    * Constructor for class FilterRenderer
    *
    * @param filter  No description provided
    */
   public FilterRenderer (Filter filter)
   {
      this.filter = filter;
   }


   /**
    * Get the listCellRendererComponent attribute of the FilterRenderer object
    *
    * @param list          No description provided
    * @param value         No description provided
    * @param index         No description provided
    * @param isSelected    No description provided
    * @param cellHasFocus  No description provided
    * @return              The listCellRendererComponent value
    */
   public Component getListCellRendererComponent (JList list,
                                                  Object value,
                                                  int index,
                                                  boolean isSelected,
                                                  boolean cellHasFocus)
   {
      Filter render = (Filter) value;
      String name =  (render != null ? render.getName() : " ");
      if (this.filter != null && this.filter == value)
      {
         name += " <current>";
      }
      return super.getListCellRendererComponent (list, name, index, isSelected, cellHasFocus);
   }

}

/*
 * $Log: ViewDefinitionDialog.java,v $
 * Revision 1.20  2004/10/20 17:50:33  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
