/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.views.gui;

import java.awt.*;

import javax.swing.*;
import javax.swing.border.BevelBorder;

import de.uni_paderborn.fujaba.gui.comp.FujabaDialog;
import de.uni_paderborn.fujaba.views.Filter;


/**
 * A basic implementation of the JDialog class to show the editor panel for configurable filters
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.11 $
 */
public class SmallFilterEditorDialog extends FujabaDialog
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   FilterEditorPanel panel = null;


   /**
    * Constructor for class SmallFilterEditorDialog
    *
    * @param parentFrame  No description provided
    */
   public SmallFilterEditorDialog (JFrame parentFrame)
   {
      super (parentFrame);
      setModal (true);
      setTitle ("Edit Filter");
      guiBuild();
   }


   /**
    * Creates a new instance of SmallFilterEditorDialog with the given title.
    *
    * @param sTitle       the title for the new frame.
    * @param parentFrame  No description provided
    */
   public SmallFilterEditorDialog (JFrame parentFrame, String sTitle)
   {
      this (parentFrame);
      setTitle (sTitle);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void guiBuild()
   {
      getContentPane().setLayout (new BorderLayout());

      panel = new FilterEditorPanel (null);
      panel.setBorder (new BevelBorder (BevelBorder.RAISED));
      DefaultComboBoxModel model = new DefaultComboBoxModel();
      model.addElement (filter);
      panel.setModel (model);
      panel.setCurrentFilter (filter);
      //      panel.setSelectedFilter (filter);


      getContentPane().add (panel, BorderLayout.CENTER);
      getContentPane().add (guiPanelCloseHelp(), BorderLayout.SOUTH);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void unparse()
   {
      DefaultComboBoxModel model = new DefaultComboBoxModel();
      model.addElement (filter);
      panel.setModel (model);
      panel.setCurrentFilter (getFilter());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void parse()
   {
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Filter filter = null;


   /**
    * Get the filter attribute of the SmallFilterEditorDialog object
    *
    * @return   The filter value
    */
   public Filter getFilter()
   {
      return filter;
   }


   /**
    * Sets the filter attribute of the SmallFilterEditorDialog object
    *
    * @param filter  The new filter value
    */
   public void setFilter (Filter filter)
   {
      if (this.filter != filter)
      {
         this.filter = filter;
         unparse();
      }
   }
}

/*
 * $Log: SmallFilterEditorDialog.java,v $
 * Revision 1.11  2004/10/20 17:50:33  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
