/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.views.cf;

import java.util.*;

import de.uni_paderborn.fujaba.uml.*;
import de.uni_paderborn.fujaba.views.*;


/**
 * CFFilterNode is a node with an associated filter for context computation
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.14 $
 */
public class CFFilterNode extends CFOrNode
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Object clone()
   {
      CFFilterNode clone = new CFFilterNode();
      clone.setContext (getContext());

      Filter filter = getFilter();
      if (filter instanceof ConfigurableFilter)
      {
         try
         {
            Filter copy = (Filter)  ((ConfigurableFilter) filter).clone();
            filter = copy;
         }
         catch (Exception e)
         {
         }
      }
      else
      {
         try
         {
            Filter copy = (Filter) filter.getClass().newInstance();
            filter = copy;
         }
         catch (Exception e)
         {
         }
      }
      clone.setFilter (filter);
      clone.setComputeLastStep (isComputeLastStep());

      return clone;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private int context = 0;


   /**
    * Sets the context attribute of the CFFilterNode object
    *
    * @param context  The new context value
    */
   public void setContext (int context)
   {
      if (context != this.context)
      {
         int old = this.context;
         this.context = context;
         firePropertyChange ("context", old, context);
      }
   }


   /**
    * Get the context attribute of the CFFilterNode object
    *
    * @return   The context value
    */
   public int getContext()
   {
      return context;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private boolean computeLastStep = false;


   /**
    * Sets the computeLastStep attribute of the CFFilterNode object
    *
    * @param step  The new computeLastStep value
    */
   public void setComputeLastStep (boolean step)
   {
      if (computeLastStep != step)
      {
         this.computeLastStep = step;
         firePropertyChange ("computeLastStep", !step, step);
      }
   }


   /**
    * Get the computeLastStep attribute of the CFFilterNode object
    *
    * @return   The computeLastStep value
    */
   public boolean isComputeLastStep()
   {
      return computeLastStep;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Filter filter = null;


   /**
    * Sets the filter attribute of the CFFilterNode object
    *
    * @param filter  The new filter value
    */
   public void setFilter (Filter filter)
   {
      if (filter != this.filter)
      {
         Filter old = this.filter;
         this.filter = filter;
         firePropertyChange ("filter", old, filter);
      }
   }


   /**
    * Get the filter attribute of the CFFilterNode object
    *
    * @return   The filter value
    */
   public Filter getFilter()
   {
      return filter;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param diag           No description provided
    * @param item           No description provided
    * @param sourceResults  No description provided
    * @return               No description provided
    */
   protected Set computeResult (UMLDiagram diag, UMLDiagramItem item, Collection sourceResults)
   {
      if (isComputeLastStep())
      {
         return computeLastStepResult (diag, item, sourceResults);
      }
      else
      {
         return computeNormalResult (diag, item, sourceResults);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param diag           No description provided
    * @param item           No description provided
    * @param sourceResults  No description provided
    * @return               No description provided
    */
   private Set computeNormalResult (UMLDiagram diag, UMLDiagramItem item, Collection sourceResults)
   {
      Filter filter = getFilter();
      if (filter == null)
      {
         return new HashSet();
      }

      Set input = super.computeResult (diag, item, sourceResults);

      if (getContext() == 0)
      {
         return input;
      }

      Set nContext = filter.getNContext (diag, input.iterator(), getContext());
      return nContext;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param diag           No description provided
    * @param diagItem       No description provided
    * @param sourceResults  No description provided
    * @return               No description provided
    */
   protected Set computeLastStepResult (UMLDiagram diag, UMLDiagramItem diagItem, Collection sourceResults)
   {
      Filter filter = getFilter();
      if (filter == null)
      {
         return new HashSet();
      }

      Set input =  (new CFOrNode()).computeResult (diag, diagItem, sourceResults);

      int depth = getContext();
      if (depth == 0)
      {
         return input;
      }

      Set nextToLastStep = null;
      Set lastStep = input;
      Set lastContext = new HashSet();

      ItemSet result = new ItemSet();
      Set context = null;
      Set tmpSet = null;

      Iterator items = input.iterator();
      while (items.hasNext())
      {
         Object tmpObj = items.next();
         if (! (tmpObj instanceof UMLDiagramItem) || !diag.hasInElements ((UMLDiagramItem) tmpObj))
         {
            continue;
         }

         UMLDiagramItem item = (UMLDiagramItem) tmpObj;

         boolean grows = true;

         nextToLastStep = new HashSet (result);

         context = new ItemSet();
         context.add (item);
         result.add (item);

         lastStep = new HashSet (result);

         for (int i = depth; i != 0 && grows; i--)
         {
            Iterator contextIterator = context.iterator();
            context = new ItemSet();
            while (contextIterator.hasNext())
            {
               tmpSet = getFilter().grow1Context (diag, (UMLDiagramItem) contextIterator.next(), result);

               if (tmpSet != null)
               {
                  context.addAll (tmpSet);
               }
            }
            grows =  (context != null && !context.isEmpty());
            if (grows)
            {
               nextToLastStep = lastStep;
               lastStep = new HashSet (result);
            }
         }
         lastStep.removeAll (nextToLastStep);
         lastContext.addAll (lastStep);
      }

      if (lastStep == input)
      {
         lastContext = input;
      }

      Iterator iter = lastContext.iterator();
      while (iter.hasNext())
      {
         Object obj = iter.next();
         if (obj instanceof UMLConnection &&
            !AbstractFilter.containsConnection (lastContext, (UMLConnection) obj))
         {
            lastContext.remove (obj);
         }
      }

      return lastContext;
   }
}

/*
 * $Log: CFFilterNode.java,v $
 * Revision 1.14  2004/10/20 17:50:32  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
