/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.views.cf;

import java.util.Set;

import de.uni_paderborn.fujaba.uml.UMLDiagram;
import de.uni_paderborn.fujaba.uml.UMLDiagramItem;
import de.uni_paderborn.fujaba.views.ItemSet;


/**
 * CFEndNode returns the result for the context computation of the whole diagram
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.12 $
 */
public class CFEndNode extends de.uni_paderborn.fujaba.views.cf.CFOrNode
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Object clone()
   {
      return new CFEndNode();
   }


   /**
    * Get the results attribute of the CFEndNode object
    *
    * @param diag        No description provided
    * @param item        No description provided
    * @param uncomplete  No description provided
    * @return            The results value
    */
   protected Set getResults (UMLDiagram diag, UMLDiagramItem item, Set uncomplete)
   {
      clearResults();
      Set result = new ItemSet();
      result.addAll (super.getResults (diag, item, uncomplete));
      clearResults();
      return result;
   }


   /**
    * Access method for an one to n association.
    *
    * @param exit  The object added.
    * @return      No description provided
    */
   public boolean addToExits (CFTransition exit)
   {
      throw new RuntimeException ("A CFEndNode cannot have exit transitions");
   }
}

/*
 * $Log: CFEndNode.java,v $
 * Revision 1.12  2004/10/20 17:50:32  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
