/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.views.cf;

import java.util.*;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.uml.UMLDiagram;
import de.uni_paderborn.fujaba.uml.UMLDiagramItem;
import de.uni_paderborn.fujaba.views.CompositeFilter;


/**
 * The CFDiagram aalows definition of complex filter rules by combining rules with set operations
 * represented by nodes in this diagram
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.14 $
 */
public class CFDiagram extends UMLDiagram implements Cloneable
{
   /**
    * <pre>
    *          0..1                            0..1
    * CFDiagram ----------------------------- CompositeFilter
    *          CFDiagram     filter
    * </pre>
    */
   private CompositeFilter filter;


   /**
    * Sets the filter attribute of the CFDiagram object
    *
    * @param value  The new filter value
    * @return       No description provided
    */
   public boolean setFilter (CompositeFilter value)
   {
      if (this.filter != value)
      {
         if (this.filter != null)
         {
            CompositeFilter oldValue = this.filter;
            this.filter = null;
            oldValue.setCFDiagram (null);
         }
         this.filter = value;
         if (value != null)
         {
            this.filter.setCFDiagram (this);
         }

         return true;
      }

      return false;
   }


   /**
    * Get the filter attribute of the CFDiagram object
    *
    * @return   The filter value
    */
   public CompositeFilter getFilter()
   {
      return this.filter;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private CFEndNode endNode = null;


   /**
    * Sets the endNode attribute of the CFDiagram object
    *
    * @param value  The new endNode value
    * @return       No description provided
    */
   public boolean setEndNode (CFEndNode value)
   {
      if (value != endNode)
      {
         if (endNode != null)
         {
            CFEndNode oldValue = endNode;
            endNode = null;
            oldValue.removeFromDiagrams (this);
         }
         endNode = value;
         if (value != null)
         {
            addToElements (value);
         }
         return true;
      }
      return false;
   }


   /**
    * Get the endNode attribute of the CFDiagram object
    *
    * @return   The endNode value
    */
   public CFEndNode getEndNode()
   {
      return endNode;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private CFStartNode startNode = null;


   /**
    * Sets the startNode attribute of the CFDiagram object
    *
    * @param value  The new startNode value
    * @return       No description provided
    */
   public boolean setStartNode (CFStartNode value)
   {
      if (value != startNode)
      {
         if (startNode != null)
         {
            CFStartNode oldValue = startNode;
            startNode = null;
            oldValue.removeFromDiagrams (this);
         }
         startNode = value;
         if (value != null)
         {
            addToElements (value);
         }
         return true;
      }
      return false;
   }


   /**
    * Get the startNode attribute of the CFDiagram object
    *
    * @return   The startNode value
    */
   public CFStartNode getStartNode()
   {
      return startNode;
   }


   /**
    * Access method for an one to n association.
    *
    * @param item  The object added.
    * @return      No description provided
    */
   public boolean addToElements (UMLDiagramItem item)
   {
      boolean changed = super.addToElements (item);
      if (changed)
      {
         if (item instanceof CFStartNode)
         {
            setStartNode ((CFStartNode) item);
         }
         else if (item instanceof CFEndNode)
         {
            setEndNode ((CFEndNode) item);
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param item  No description provided
    * @return      No description provided
    */
   public boolean removeFromElements (UMLDiagramItem item)
   {
      boolean changed = super.removeFromElements (item);
      if (changed)
      {
         if (item == getStartNode())
         {
            setStartNode (null);
         }
         else if (item == getEndNode())
         {
            setEndNode (null);
         }
      }
      return changed;
   }


   /**
    * Get the results attribute of the CFDiagram object
    *
    * @param diag  No description provided
    * @param item  No description provided
    * @return      The results value
    */
   public Set getResults (UMLDiagram diag, UMLDiagramItem item)
   {
      if (getEndNode() == null || getStartNode() == null)
      {
         throw new RuntimeException ("CFDiagram must contain both a start- and endnode");
      }

      return getEndNode().getResults (diag, item);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Object clone()
   {
      CFDiagram clone = new CFDiagram();
      HashMap itemMap = new HashMap();
      HashMap transitionMap = new HashMap();
      UMLDiagramItem tmpItem = null;

      Iterator itemIter = iteratorOfElements();
      while (itemIter.hasNext())
      {
         ASGElement asgElement = (ASGElement) itemIter.next();

         if (asgElement instanceof CFNode)
         {
            try
            {
               tmpItem = (UMLDiagramItem)  ((CFNode) asgElement).clone();
               itemMap.put (asgElement, tmpItem);
               clone.addToElements (tmpItem);
            }
            catch (Exception e)
            {
               throw new RuntimeException ("Unable to clone item " + asgElement + "\nerror: " + e.getMessage());
            }
         }
         else if (asgElement instanceof CFTransition)
         {
            try
            {
               tmpItem = (UMLDiagramItem)  ((CFTransition) asgElement).clone();
               transitionMap.put (asgElement, tmpItem);
               clone.addToElements (tmpItem);
            }
            catch (Exception e)
            {
               throw new RuntimeException ("Unable to clone item " + asgElement + "\nerror: " + e.getMessage());
            }
         }
      }

      if (getStartNode() != null)
      {
         clone.setStartNode ((CFStartNode) itemMap.get (getStartNode()));
      }
      else
      {
         clone.setStartNode (null);
      }

      if (getEndNode() != null)
      {
         clone.setEndNode ((CFEndNode) itemMap.get (getEndNode()));
      }
      else
      {
         clone.setEndNode (null);
      }

      Iterator transIter = transitionMap.entrySet().iterator();
      while (transIter.hasNext())
      {
         Map.Entry entry = (Map.Entry) transIter.next();

         CFTransition orig = (CFTransition) entry.getKey();
         CFTransition copy = (CFTransition) entry.getValue();

         copy.setSource ((CFNode) itemMap.get (orig.getSource()));
         copy.setTarget ((CFNode) itemMap.get (orig.getTarget()));
      }

      return clone;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeYou()
   {
      setFilter (null);
      super.removeYou();
   }
}

/*
 * $Log: CFDiagram.java,v $
 * Revision 1.14  2004/10/20 17:50:32  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
