/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.views.beans;

import java.awt.*;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;

import javax.swing.*;


/**
 * A simple PropertyEditor that wraps another PropertyEditor but provides a custom editor (a
 * simple JTextField) even if the original PropertyEditor had none. Most operations of this
 * class are simply delegated to the wrapped PropertyEditor
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.9 $
 */
public class WrapperEditor implements PropertyEditor
{
   /**
    * Constructor for class WrapperEditor
    *
    * @param delegatee  No description provided
    */
   public WrapperEditor (PropertyEditor delegatee)
   {
      super();
      setDelegatee (delegatee);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PropertyEditor delegatee = null;


   /**
    * Sets the delegatee attribute of the WrapperEditor object
    *
    * @param editor  The new delegatee value
    * @return        No description provided
    */
   public boolean setDelegatee (PropertyEditor editor)
   {
      if (delegatee != editor)
      {
         delegatee = editor;
         setEditor (null);
         return true;
      }
      return false;
   }


   /**
    * Get the delegatee attribute of the WrapperEditor object
    *
    * @return   The delegatee value
    */
   public PropertyEditor getDelegatee()
   {
      return delegatee;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Component editor = null;


   /**
    * Sets the editor attribute of the WrapperEditor object
    *
    * @param editor  The new editor value
    * @return        No description provided
    */
   private boolean setEditor (Component editor)
   {
      if (this.editor != editor)
      {
         this.editor = editor;
         if (editor != null)
         {
            setEditorText (getAsText());
         }

         return true;
      }
      return false;
   }


   /**
    * Get the editor attribute of the WrapperEditor object
    *
    * @return   The editor value
    */
   private Component getEditor()
   {
      if (editor == null)
      {
         if (delegatee != null)
         {
            if (delegatee.getTags() != null)
            {
               setEditor (new BeanTagField (this));
            }
            else
            {
               setEditor (new BeanTextField (this));
            }
         }
      }
      return editor;
   }


   /**
    * Sets the editorText attribute of the WrapperEditor object
    *
    * @param text  The new editorText value
    */
   private void setEditorText (String text)
   {
      if (editor instanceof JComboBox)
      {
         JComboBox box = (JComboBox) editor;
         Object selection = box.getSelectedItem();
         String oldText =  (selection == null) ? null : selection.toString();

         if ( (oldText == null && text != null) ||
             (oldText != null && !oldText.equals (text)))
         {
            box.setSelectedItem (text);
         }
      }
      else
      {
         JTextField field = (JTextField) editor;
         String oldText = field.getText();
         if ( (oldText == null && text != null) ||
             (oldText != null && !oldText.equals (text)))
         {
            field.setText (text);
         }
      }
   }


   /**
    * Access method for an one to n association.
    *
    * @param listener  The object added.
    */
   public void addPropertyChangeListener (PropertyChangeListener listener)
   {
      PropertyEditor delegatee = getDelegatee();

      if (delegatee != null)
      {
         delegatee.addPropertyChangeListener (listener);
      }
      else
      {
         throw new UnsupportedOperationException();
      }
   }


   /**
    * Get the asText attribute of the WrapperEditor object
    *
    * @return   The asText value
    */
   public String getAsText()
   {
      PropertyEditor delegatee = getDelegatee();

      if (delegatee != null)
      {
         return  (delegatee.getValue() == null) ? null : delegatee.getAsText();
      }
      else
      {
         return null;
      }
   }


   /**
    * Get the customEditor attribute of the WrapperEditor object
    *
    * @return   The customEditor value
    */
   public java.awt.Component getCustomEditor()
   {
      return getEditor();
   }


   /**
    * Get the javaInitializationString attribute of the WrapperEditor object
    *
    * @return   The javaInitializationString value
    */
   public String getJavaInitializationString()
   {
      PropertyEditor delegatee = getDelegatee();

      if (delegatee != null)
      {
         return delegatee.getJavaInitializationString();
      }
      else
      {
         return null;
      }
   }


   /**
    * Get the tags attribute of the WrapperEditor object
    *
    * @return   The tags value
    */
   public String[] getTags()
   {
      PropertyEditor delegatee = getDelegatee();

      if (delegatee != null)
      {
         return delegatee.getTags();
      }
      else
      {
         return null;
      }
   }


   /**
    * Get the value attribute of the WrapperEditor object
    *
    * @return   The value value
    */
   public Object getValue()
   {
      PropertyEditor delegatee = getDelegatee();

      if (delegatee != null)
      {
         return delegatee.getValue();
      }
      else
      {
         return null;
      }
   }


   /**
    * Get the paintable attribute of the WrapperEditor object
    *
    * @return   The paintable value
    */
   public boolean isPaintable()
   {
      PropertyEditor delegatee = getDelegatee();

      return  (delegatee != null) && delegatee.isPaintable();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param gfx  No description provided
    * @param box  No description provided
    */
   public void paintValue (java.awt.Graphics gfx, java.awt.Rectangle box)
   {
      PropertyEditor delegatee = getDelegatee();

      if (delegatee != null)
      {
         delegatee.paintValue (gfx, box);
      }
      else
      {
         throw new UnsupportedOperationException();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param listener  No description provided
    */
   public void removePropertyChangeListener (PropertyChangeListener listener)
   {
      PropertyEditor delegatee = getDelegatee();

      if (delegatee != null)
      {
         delegatee.removePropertyChangeListener (listener);
      }
      else
      {
         throw new UnsupportedOperationException();
      }
   }


   /**
    * Sets the asText attribute of the WrapperEditor object
    *
    * @param text                                 The new asText value
    * @throws java.lang.IllegalArgumentException  Exception description not provided
    */
   public void setAsText (String text) throws java.lang.IllegalArgumentException
   {
      PropertyEditor delegatee = getDelegatee();

      if (delegatee != null)
      {
         try
         {
            delegatee.setAsText (text);
         }
         finally
         {
            if (editor != null)
            {
               setEditorText (getAsText());
            }
         }
      }
      else
      {
         throw new UnsupportedOperationException();
      }
   }


   /**
    * Sets the value attribute of the WrapperEditor object
    *
    * @param value  The new value value
    */
   public void setValue (Object value)
   {
      PropertyEditor delegatee = getDelegatee();

      if (delegatee != null)
      {
         try
         {
            delegatee.setValue (value);
         }
         finally
         {
            if (editor != null)
            {
               setEditorText (getAsText());
            }
         }
      }
      else
      {
         throw new UnsupportedOperationException();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public boolean supportsCustomEditor()
   {
      return  (getEditor() != null);
   }
}

/*
 * $Log: WrapperEditor.java,v $
 * Revision 1.9  2004/10/20 17:50:32  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
