/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.views.beans;

import java.awt.*;
import java.text.NumberFormat;
import java.text.ParseException;

import javax.swing.*;
import javax.swing.text.*;

import org.apache.log4j.Logger;


/**
 * This class allows the use of number values in JTextFields It has a NumberFormat to check
 * if the input is a valid number for this textfield.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.13 $
 */
public class NumberTextField extends JTextField
{
   /**
    * log4j logging
    */
   final static transient Logger log = Logger.getLogger (NumberTextField.class);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   Toolkit toolkit;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   NumberFormat parser;


   /**
    * Constructor for class NumberTextField
    *
    * @param columns  No description provided
    */
   public NumberTextField (int columns)
   {
      this (columns, createDefaultParser());
   }


   /**
    * Constructor for class NumberTextField
    *
    * @param columns  No description provided
    * @param parser   No description provided
    */
   public NumberTextField (int columns, NumberFormat parser)
   {
      super (columns);
      toolkit = Toolkit.getDefaultToolkit();
      setParser (parser);
   }


   /**
    * Get the value attribute of the NumberTextField object
    *
    * @return   The value value
    */
   public Number getValue()
   {
      Number retVal = null;
      String text = getText();

      if (text == null || text.equals (""))
      {
         retVal = new Long (0);
      }
      else
      {
         try
         {
            retVal = parser.parse (text);
         }
         catch (ParseException e)
         {
            // This should never happen because insertString allows
            // only properly formatted data to get in the field.
            toolkit.beep();
         }
      }
      return retVal;
   }


   /**
    * Sets the value attribute of the NumberTextField object
    *
    * @param value  The new value value
    */
   public void setValue (Number value)
   {
      if (value != null)
      {
         setText (parser.format (value.doubleValue()));
      }
      else
      {
         setText ("0");
      }
   }


   /**
    * Sets the parser attribute of the NumberTextField object
    *
    * @param parser  The new parser value
    */
   public void setParser (NumberFormat parser)
   {
      if (parser != null)
      {
         this.parser = parser;
      }
      else
      {
         this.parser = createDefaultParser();
      }
   }


   /**
    * Get the parser attribute of the NumberTextField object
    *
    * @return   The parser value
    */
   public NumberFormat getParser()
   {
      return parser;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   protected static NumberFormat createDefaultParser()
   {
      return NumberFormat.getNumberInstance();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   protected Document createDefaultModel()
   {
      return new NumberDocument();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: schneider $
    * @version   $Revision: 1.13 $
    */
   protected class NumberDocument extends PlainDocument
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param offs                   No description provided
       * @param str                    No description provided
       * @param a                      No description provided
       * @throws BadLocationException  Exception description not provided
       */
      public void insertString (int offs, String str, AttributeSet a)
          throws BadLocationException
      {
         int len = getLength() - offs;

         if (offs >= 0 && len >= 0)
         {
            String newValue = this.getText (0, offs) + str + this.getText (offs, getLength() - offs);
            if (newValue.equals (""))
            {
               super.insertString (offs, str, a);
            }
            else
            {
               try
               {
                  parser.parse (newValue);
                  super.insertString (offs, str, a);
               }
               catch (ParseException e)
               {
                  log.error ("ParseException: " + newValue);
                  e.printStackTrace();
                  toolkit.beep();
               }
            }
         }
         else
         {
            throw new BadLocationException ("", offs);
         }
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param offs                   No description provided
       * @param len                    No description provided
       * @throws BadLocationException  Exception description not provided
       */
      public void remove (int offs, int len)
          throws BadLocationException
      {
         int tmpLen = getLength() - offs - len;

         if (offs >= 0 && len >= 0 && tmpLen >= 0)
         {
            String newValue = this.getText (0, offs) + this.getText (offs + len, getLength() - len - offs);
            if (newValue.equals (""))
            {
               super.remove (offs, len);
            }
            else
            {
               try
               {
                  parser.parse (newValue);
                  super.remove (offs, len);
               }
               catch (ParseException e)
               {
                  log.error ("ParseException: " + newValue);
                  e.printStackTrace();
                  toolkit.beep();
               }
            }
         }
         else
         {
            throw new BadLocationException ("", offs);
         }
      }
   }
}

/*
 * $Log: NumberTextField.java,v $
 * Revision 1.13  2004/10/20 17:50:32  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
