/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.views.beans;

import java.awt.*;
import java.beans.PropertyEditorManager;

import sun.beans.editors.DoubleEditor;


/**
 * This editor can have a custom editor<p>
 *
 * If it has one all operations are delegated to that editor, else it behaves just like its
 * superclass
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.9 $
 */
public class ExtendedDoubleEditor extends DoubleEditor
{
   static
   {
      PropertyEditorManager.registerEditor (Double.class, ExtendedDoubleEditor.class);
      PropertyEditorManager.registerEditor (Double.TYPE, ExtendedDoubleEditor.class);
   }

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private NumberInputField editor = null;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public boolean supportsCustomEditor()
   {
      return true;
   }


   /**
    * Get the customEditor attribute of the ExtendedDoubleEditor object
    *
    * @return   The customEditor value
    */
   public Component getCustomEditor()
   {
      if (editor == null)
      {
         createEditor();
      }

      return editor;
   }


   /**
    * Get the value attribute of the ExtendedDoubleEditor object
    *
    * @return   The value value
    */
   public Object getValue()
   {
      if (editor == null)
      {
         return super.getValue();
      }
      return new Double (editor.getDoubleValue());
   }


   /**
    * Sets the value attribute of the ExtendedDoubleEditor object
    *
    * @param value  The new value value
    */
   public void setValue (Object value)
   {
      super.setValue (value);

      if (editor != null)
      {
         editor.setValue ( ((Number) value).doubleValue());
      }
   }


   /**
    * Sets the asText attribute of the ExtendedDoubleEditor object
    *
    * @param text  The new asText value
    */
   public void setAsText (String text)
   {
      setValue (Double.valueOf (text));
   }


   /**
    * Get the asText attribute of the ExtendedDoubleEditor object
    *
    * @return   The asText value
    */
   public String getAsText()
   {
      Object value = getValue();

      return value == null ? null : value.toString();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void createEditor()
   {
      Object value = getValue();
      editor = new NumberInputField();
      editor.setNumberType (Double.TYPE);

      if (value != null)
      {
         editor.setValue ( ((Number) value).doubleValue());
      }
   }
}

/*
 * $Log: ExtendedDoubleEditor.java,v $
 * Revision 1.9  2004/10/20 17:50:31  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
