/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.views.beans;

import java.awt.*;
import java.awt.event.FocusEvent;
import java.beans.PropertyEditor;

import javax.swing.*;


/**
 * Simple textfield that has a property editor it keeps in sync with. If the text of the field
 * changes the setAsText-method of the propertyEditor is called with the new text
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.9 $
 */
public class BeanTextField extends JTextField
{
   /**
    * Constructor for class BeanTextField
    *
    * @param propertyEditor  No description provided
    */
   public BeanTextField (PropertyEditor propertyEditor)
   {
      super (15);
      setPropertyEditor (propertyEditor);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PropertyEditor propertyEditor = null;


   /**
    * Sets the propertyEditor attribute of the BeanTextField object
    *
    * @param propertyEditor  The new propertyEditor value
    * @return                No description provided
    */
   public boolean setPropertyEditor (PropertyEditor propertyEditor)
   {
      if (this.propertyEditor != propertyEditor)
      {
         this.propertyEditor = propertyEditor;
         if (propertyEditor != null)
         {
            setText (propertyEditor.getAsText());
         }
         else
         {
            setText ("");
         }
         return true;
      }
      return false;
   }


   /**
    * Get the propertyEditor attribute of the BeanTextField object
    *
    * @return   The propertyEditor value
    */
   public PropertyEditor getPropertyEditor()
   {
      return propertyEditor;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void fireActionPerformed()
   {
      syncPropertyText();
      super.fireActionPerformed();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   protected void processFocusEvent (FocusEvent e)
   {
      syncPropertyText();
      super.processFocusEvent (e);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private void syncPropertyText()
   {
      PropertyEditor editor = getPropertyEditor();
      if (editor != null)
      {
         try
         {
            editor.setAsText (getText());
         }
         catch (Exception e)
         {
            setText (editor.getAsText());
            Toolkit.getDefaultToolkit().beep();
         }
      }
   }
}

/*
 * $Log: BeanTextField.java,v $
 * Revision 1.9  2004/10/20 17:50:31  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
