/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.views.beans;

import java.awt.*;
import java.beans.PropertyEditor;

import javax.swing.*;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;


/**
 * An editor component for tagged values (meaning you can select the value out of a list of
 * valid items)
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.8 $
 */
public class BeanTagField extends JComboBox implements ListDataListener
{
   /**
    * Constructor for class BeanTagField
    *
    * @param propertyEditor  No description provided
    */
   public BeanTagField (PropertyEditor propertyEditor)
   {
      super();
      setPropertyEditor (propertyEditor);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PropertyEditor propertyEditor = null;


   /**
    * Sets the propertyEditor attribute of the BeanTagField object
    *
    * @param propertyEditor  The new propertyEditor value
    * @return                No description provided
    */
   public boolean setPropertyEditor (PropertyEditor propertyEditor)
   {
      if (this.propertyEditor != propertyEditor)
      {
         this.propertyEditor = propertyEditor;
         clear();
         if (propertyEditor != null)
         {
            addItems (propertyEditor.getTags());
            setSelectedItem (propertyEditor.getAsText());
         }

         return true;
      }
      return false;
   }


   /**
    * Get the propertyEditor attribute of the BeanTagField object
    *
    * @return   The propertyEditor value
    */
   public PropertyEditor getPropertyEditor()
   {
      return propertyEditor;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private void clear()
   {
      while (getItemCount() > 0)
      {
         removeItemAt (0);
      }
   }


   /**
    * Access method for an one to n association.
    *
    * @param items  The object added.
    */
   private void addItems (Object[] items)
   {
      for (int i = 0; i < items.length; i++)
      {
         addItem (items[i]);
      }
   }


   /**
    * Sets the model attribute of the BeanTagField object
    *
    * @param model  The new model value
    */
   public void setModel (ComboBoxModel model)
   {
      ComboBoxModel oldModel = getModel();
      if (oldModel != model)
      {
         if (oldModel != null)
         {
            oldModel.removeListDataListener (this);
         }

         if (model != null)
         {
            model.addListDataListener (this);
         }

         super.setModel (model);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void contentsChanged (ListDataEvent e)
   {
      if (e.getIndex0() == -1 && e.getIndex1() == -1)
      {
         PropertyEditor editor = getPropertyEditor();

         if (editor == null)
         {
            return;
         }

         String oldValue = editor.getAsText();
         Object item = getSelectedItem();
         String newValue =  (item == null) ? null : item.toString();
         if ( (oldValue == null && newValue != null) || !oldValue.equals (newValue))
         {
            try
            {
               editor.setAsText (newValue);
            }
            catch (IllegalArgumentException iae)
            {
               Toolkit.getDefaultToolkit().beep();
               setSelectedItem (oldValue);
            }
         }
      }
   }
}

/*
 * $Log: BeanTagField.java,v $
 * Revision 1.8  2004/10/20 17:50:31  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
