/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.views;

import java.util.Iterator;
import java.util.Set;

import de.uni_paderborn.fujaba.uml.*;


/**
 * This Filter defines its 1-Context by following the inheritance hierarchy to the sub- or
 * superclasses, depending on the current configuration
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.11 $
 */
public class InheritanceFilter extends AbstractConfigurableFilter
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private boolean includeSubclasses = true;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private boolean includeSuperclasses = true;


   /**
    * Constructor for class InheritanceFilter
    */
   public InheritanceFilter()
   {
      super();
      setDescription ("This Filter defines its 1-Context by following " +
         "the inheritance hierarchy to the sub- or superclasses, depending " +
         "on the current configuration");
   }


   /**
    * Get the forDiagram attribute of the InheritanceFilter object
    *
    * @param diag  No description provided
    * @return      The forDiagram value
    */
   public boolean isForDiagram (UMLDiagram diag)
   {
      return  (diag instanceof UMLClassDiagram);
   }


   /**
    * UMLMethod: '+ get1Context (item : UMLDiagramItem;context : Set;newNodes : Set) : Set'
    *
    * @param diag     No description provided
    * @param item     No description provided
    * @param context  No description provided
    * @return         No description provided
    */
   public Set grow1Context (UMLDiagram diag, UMLDiagramItem item, ItemSet context)
   {
      if (item == null || ! (item instanceof UMLClass) || !diag.hasInElements (item))
      {
         return null;
      }

      if (context == null)
      {
         context = new ItemSet();
      }

      ItemSet newNodes = new ItemSet();

      if (includeSuperclasses)
      {
         Iterator superClasses =  ((UMLClass) item).iteratorOfRevSubclass();
         while (superClasses.hasNext())
         {
            UMLGeneralization gen = (UMLGeneralization) superClasses.next();
            UMLDiagramItem tmpItem = tryAddConnection (diag, context, gen);
            if (tmpItem != null)
            {
               newNodes.add (tmpItem);
            }
         }
      }
      if (includeSubclasses)
      {
         Iterator subClasses =  ((UMLClass) item).iteratorOfRevSuperclass();
         while (subClasses.hasNext())
         {
            UMLGeneralization gen = (UMLGeneralization) subClasses.next();
            UMLDiagramItem tmpItem = tryAddConnection (diag, context, gen);
            if (tmpItem != null)
            {
               newNodes.add (tmpItem);
            }
         }
      }
      return newNodes;
   }


   /**
    * Get the includeSubclasses attribute of the InheritanceFilter object
    *
    * @return   The includeSubclasses value
    */
   public boolean isIncludeSubclasses()
   {
      return includeSubclasses;
   }


   /**
    * Sets the includeSubclasses attribute of the InheritanceFilter object
    *
    * @param inc  The new includeSubclasses value
    */
   public void setIncludeSubclasses (boolean inc)
   {
      includeSubclasses = inc;
   }


   /**
    * Get the includeSuperclasses attribute of the InheritanceFilter object
    *
    * @return   The includeSuperclasses value
    */
   public boolean isIncludeSuperclasses()
   {
      return includeSuperclasses;
   }


   /**
    * Sets the includeSuperclasses attribute of the InheritanceFilter object
    *
    * @param inc  The new includeSuperclasses value
    */
   public void setIncludeSuperclasses (boolean inc)
   {
      includeSuperclasses = inc;
   }
}

/*
 * $Log: InheritanceFilter.java,v $
 * Revision 1.11  2004/10/20 17:50:30  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
