/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.views;

import java.io.*;
import java.util.*;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

import de.uni_paderborn.fujaba.preferences.GeneralPreferences;
import de.upb.tools.fca.FEmptyIterator;


/**
 * A ClassLoader for filters. Searches in the Filter Directory additionally to the classpath
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.15 $
 */
public class FilterClassLoader extends ClassLoader
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static FilterClassLoader defaultClassLoader = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static HashMap classLoaders = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static FileFilter classFileFilter = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static FileFilter zipFileFilter = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private HashMap resolvedClasses = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private File path = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private boolean isZipFile = false;


   /**
    * Constructor for class FilterClassLoader
    */
   private FilterClassLoader()
   {
      this (new File (GeneralPreferences.get().getViewFilterFolder()));
   }


   /**
    * Constructor for class FilterClassLoader
    *
    * @param path  No description provided
    */
   private FilterClassLoader (File path)
   {
      super (Filter.class.getClassLoader());
      setPath (path);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public static FilterClassLoader get()
   {
      if (defaultClassLoader == null)
      {
         defaultClassLoader = new FilterClassLoader();
      }

      return defaultClassLoader;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param path  No description provided
    * @return      No description provided
    */
   public static FilterClassLoader get (File path)
   {
      if (path == null || path.equals (get().getPath()))
      {
         return get();
      }

      if (classLoaders == null)
      {
         classLoaders = new HashMap();
      }

      FilterClassLoader loader = (FilterClassLoader) classLoaders.get (getAbsolutePath (path));
      if (loader == null)
      {
         loader = new FilterClassLoader (path);
         classLoaders.put (getAbsolutePath (path), loader);
      }

      return loader;
   }


   /**
    * Get the classFileFilter attribute of the FilterClassLoader class
    *
    * @return   The classFileFilter value
    */
   protected static FileFilter getClassFileFilter()
   {
      if (classFileFilter == null)
      {
         classFileFilter = new NoCaseFileFilter (new String[]
            {
            ".class"
            }
            );
      }

      return classFileFilter;
   }


   /**
    * Get the zipFileFilter attribute of the FilterClassLoader class
    *
    * @return   The zipFileFilter value
    */
   protected static FileFilter getZipFileFilter()
   {
      if (zipFileFilter == null)
      {
         zipFileFilter = new NoCaseFileFilter (new String[]
            {
            ".zip", ".jar"
            }
            );
      }

      return zipFileFilter;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param classFile          No description provided
    * @return                   No description provided
    * @throws ClassFormatError  Exception description not provided
    */
   protected Class defineClass (File classFile) throws ClassFormatError
   {
      Class clazz = getFromResolvedClasses (getAbsolutePath (classFile));
      if (clazz != null)
      {
         return clazz;
      }

      try
      {
         clazz = defineClass (new FileInputStream (classFile), classFile.length());
         addToResolvedClasses (getAbsolutePath (classFile), clazz);
         return clazz;
      }
      catch (IOException e)
      {
         throw new ClassFormatError();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param classFile          No description provided
    * @param classEntry         No description provided
    * @return                   No description provided
    * @throws ClassFormatError  Exception description not provided
    */
   protected Class defineClass (ZipFile classFile, ZipEntry classEntry) throws ClassFormatError
   {
      String id =  (getAbsolutePath (new File (classFile.getName()))) + ":" + classEntry.getName();
      Class clazz = getFromResolvedClasses (id);
      if (clazz != null)
      {
         return clazz;
      }

      try
      {
         clazz = defineClass (classFile.getInputStream (classEntry), classEntry.getSize());
         addToResolvedClasses (id, clazz);
      }
      catch (IOException e)
      {
         throw new ClassFormatError();
      }
      return clazz;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param stream             No description provided
    * @param length             No description provided
    * @return                   No description provided
    * @throws ClassFormatError  Exception description not provided
    */
   protected Class defineClass (InputStream stream, long length) throws ClassFormatError
   {
      BufferedInputStream buffer = new BufferedInputStream (stream);
      int pos = 0;
      long toDo = length;
      int lastRead = 0;
      byte[] classBytes = new byte[(int) toDo];
      try
      {
         while (lastRead != -1 && toDo > 0)
         {
            lastRead = buffer.read (classBytes, pos, (int) toDo);
            if (lastRead != -1)
            {
               pos += lastRead;
               toDo -= lastRead;
            }
         }
      }
      catch (IOException ioe)
      {
         throw new ClassFormatError();
      }
      return defineClass (null, classBytes, 0, classBytes.length);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param name                     No description provided
    * @return                         No description provided
    * @throws ClassNotFoundException  Exception description not provided
    */
   protected Class findClass (String name) throws ClassNotFoundException
   {
      StringTokenizer tokenizer = new StringTokenizer (name, ".");
      String baseName = null;
      StringBuffer packageName = new StringBuffer();
      while (tokenizer.hasMoreTokens())
      {
         String token = tokenizer.nextToken();
         if (tokenizer.hasMoreTokens())
         {
            packageName.append (token + File.separator);
         }
         else
         {
            baseName = token;
         }
      }
      Class clazz = null;
      if (isZipFile())
      {
         clazz = findInZipFile (getPath(), packageName.toString(), baseName);
      }
      else
      {
         clazz = findInDir (getPath(), packageName.toString(), baseName);
      }
      if (clazz == null || !clazz.getName().equals (name))
      {
         throw new ClassNotFoundException();
      }

      return clazz;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param path         No description provided
    * @param packageName  No description provided
    * @param baseName     No description provided
    * @return             No description provided
    */
   private Class findInDir (File path, String packageName, String baseName)
   {
      if (packageName != null && packageName.length() > 0)
      {
         Class clazz = findInDir (new File (path, packageName), null, baseName);
         if (clazz != null)
         {
            return clazz;
         }
      }

      File classFile = new File (path, baseName + ".class");
      if (classFile.exists() && classFile.isFile())
      {
         try
         {
            return defineClass (classFile);
         }
         catch (Exception e)
         {
         }
      }

      classFile = path;
      if (classFile.exists() && classFile.isDirectory())
      {
         File[] files = classFile.listFiles (getClassFileFilter());
         for (int i = 0; i < files.length; i++)
         {
            String name = files[i].getName();
            if (name.startsWith (baseName))
            {
               String ext = name.substring (baseName.length()).toLowerCase();
               if (ext.equals (".class"))
               {
                  try
                  {
                     return defineClass (classFile);
                  }
                  catch (Exception e)
                  {
                  }
                  break;
               }
            }
         }
      }

      File[] files = path.listFiles (getZipFileFilter());
      Class clazz = null;
      for (int i = 0; i < files.length && clazz == null; i++)
      {
         if (! (files[i].getName().toLowerCase().endsWith (".zip") ||
            files[i].getName().toLowerCase().endsWith (".jar")))
         {
            continue;
         }

         clazz = findInZipFile (files[i], packageName, baseName);
      }
      return clazz;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param zipFile      No description provided
    * @param packageName  No description provided
    * @param baseName     No description provided
    * @return             No description provided
    */
   private Class findInZipFile (File zipFile, String packageName, String baseName)
   {
      Class clazz = null;
      try
      {
         ZipFile zipArchive = new ZipFile (zipFile);
         Enumeration entries = zipArchive.entries();
         while (entries.hasMoreElements())
         {
            ZipEntry entry = (ZipEntry) entries.nextElement();

            if (entry.isDirectory())
            {
               continue;
            }

            String name = entry.getName();
            if (!name.startsWith (packageName + baseName))
            {
               continue;
            }

            String ext = name.substring ( (packageName + baseName).length()).toLowerCase();
            if (ext.equals (".class"))
            {
               try
               {
                  clazz = defineClass (zipArchive, entry);
               }
               catch (Exception e)
               {
               }
               break;
            }
         }
      }
      catch (Exception e)
      {
      }

      return clazz;
   }


   /**
    * Sets the path attribute of the FilterClassLoader object
    *
    * @param path  The new path value
    */
   private void setPath (File path)
   {
      if (path != this.path)
      {
         if (path == null || !path.exists())
         {
            throw new IllegalArgumentException ("Path " + getAbsolutePath (path) + " does not exist");
         }

         if (!path.canRead())
         {
            throw new IllegalArgumentException ("Path " + getAbsolutePath (path) + " is unreadable");
         }

         if (path.isFile())
         {
            try
            {
                (new ZipFile (path)).getName();
               isZipFile = true;
            }
            catch (Exception e)
            {
               throw new IllegalArgumentException ("Path " + getAbsolutePath (path) + " is not a directory or a valid zip file");
            }
         }
         else
         {
            isZipFile = false;
         }

         try
         {
            this.path = path.getCanonicalFile();
         }
         catch (IOException e)
         {
            this.path = path.getAbsoluteFile();
         }
      }
   }


   /**
    * Get the path attribute of the FilterClassLoader object
    *
    * @return   The path value
    */
   protected File getPath()
   {
      return path;
   }


   /**
    * Get the zipFile attribute of the FilterClassLoader object
    *
    * @return   The zipFile value
    */
   protected boolean isZipFile()
   {
      return isZipFile;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean hasInResolvedClasses (Class value)
   {
      return  ( (this.resolvedClasses != null) &&
          (value != null) &&
         this.resolvedClasses.containsValue (value));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param key    No description provided
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean hasInResolvedClasses (String key, Class value)
   {
      return  ( (this.resolvedClasses != null) &&
          (value != null) &&  (key != null) &&
          (this.resolvedClasses.get (key) == value));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param key  No description provided
    * @return     No description provided
    */
   public boolean hasKeyInResolvedClasses (String key)
   {
      return  ( (this.resolvedClasses != null) &&
          (key != null) &&
         this.resolvedClasses.containsKey (key));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator iteratorOfResolvedClasses()
   {
      return  ( (this.resolvedClasses == null)
         ? FEmptyIterator.get()
         : this.resolvedClasses.values().iterator());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator keysOfResolvedClasses()
   {
      return  ( (this.resolvedClasses == null)
         ? FEmptyIterator.get()
         : this.resolvedClasses.keySet().iterator());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator entriesOfResolvedClasses()
   {
      return  ( (this.resolvedClasses == null)
         ? FEmptyIterator.get()
         : this.resolvedClasses.entrySet().iterator());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public int sizeOfResolvedClasses()
   {
      return  ( (this.resolvedClasses == null)
         ? 0
         : this.resolvedClasses.size());
   }


   /**
    * Get the fromResolvedClasses attribute of the FilterClassLoader object
    *
    * @param key  No description provided
    * @return     The fromResolvedClasses value
    */
   public Class getFromResolvedClasses (String key)
   {
      return  ( ( (this.resolvedClasses == null) ||  (key == null))
         ? null
         : (Class) this.resolvedClasses.get (key));
   }


   /**
    * Access method for an one to n association.
    *
    * @param key    The object added.
    * @param value  The object added.
    * @return       No description provided
    */
   protected boolean addToResolvedClasses (String key, Class value)
   {
      boolean changed = false;
      if ( (value != null) &&  (key != null))
      {
         if (this.resolvedClasses == null)
         {
            this.resolvedClasses = new HashMap();
         }
         Class oldValue = (Class) this.resolvedClasses.put (key, value);
         if (oldValue != value)
         {
            changed = true;
         }
      }
      return changed;
   }


   /**
    * Access method for an one to n association.
    *
    * @param entry  The object added.
    * @return       No description provided
    */
   protected boolean addToResolvedClasses (Map.Entry entry)
   {
      return addToResolvedClasses ((String) entry.getKey(), (Class) entry.getValue());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   protected boolean removeFromResolvedClasses (Class value)
   {
      boolean changed = false;
      if ( (this.resolvedClasses != null) &&  (value != null))
      {
         Iterator iter = this.entriesOfResolvedClasses();
         Map.Entry entry;
         while (iter.hasNext())
         {
            entry = (Map.Entry) iter.next();
            if (entry.getValue() == value)
            {
               changed = changed | this.removeFromResolvedClasses ((String) entry.getKey(), value);
            }
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param key    No description provided
    * @param value  No description provided
    * @return       No description provided
    */
   protected boolean removeFromResolvedClasses (String key, Class value)
   {
      boolean changed = false;
      if ( (this.resolvedClasses != null) &&  (value != null) &&  (key != null))
      {
         Class oldValue = (Class) this.resolvedClasses.get (key);
         if (oldValue == value)
         {
            this.resolvedClasses.remove (key);
            changed = true;
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param key  No description provided
    * @return     No description provided
    */
   protected boolean removeKeyFromResolvedClasses (String key)
   {
      boolean changed = false;
      if ( (this.resolvedClasses != null) &&  (key != null))
      {
         Class tmpValue = (Class) this.resolvedClasses.get (key);
         if (tmpValue != null)
         {
            this.resolvedClasses.remove (key);
            changed = true;
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void removeAllFromResolvedClasses()
   {
      if (this.resolvedClasses != null)
      {
         Object[] keys = this.resolvedClasses.keySet().toArray();
         for (int i = 0; i < keys.length; i++)
         {
            removeKeyFromResolvedClasses ((String) keys[i]);
         }
      }
   }


   /**
    * Get the absolutePath attribute of the FilterClassLoader class
    *
    * @param file  No description provided
    * @return      The absolutePath value
    */
   private static String getAbsolutePath (File file)
   {
      try
      {
         return file.getCanonicalPath();
      }
      catch (IOException e)
      {
         return file.getAbsolutePath();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation. <<<<
    *
    * @author    $Author: lowende $
    * @version   $Revision: 1.15 $
    */
   private final static class NoCaseFileFilter implements FileFilter
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private String[] extensions = null;


      /**
       * Constructor for class NoCaseFileFilter
       *
       * @param exts  No description provided
       */
      public NoCaseFileFilter (String[] exts)
      {
         super();
         extensions = new String[exts.length];
         for (int i = 0; i < exts.length; i++)
         {
            extensions[i] = exts[i].toLowerCase();
         }
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param file  No description provided
       * @return      No description provided
       */
      public boolean accept (File file)
      {
         if (file.isDirectory())
         {
            return false;
         }

         String name = file.getName().toLowerCase();
         if (extensions == null)
         {
            return true;
         }

         for (int i = 0; i < extensions.length; i++)
         {
            if (name.endsWith (extensions[i]))
            {
               return true;
            }
         }
         return false;
      }
   }
}

/*
 * $Log: FilterClassLoader.java,v $
 * Revision 1.15  2004/10/22 16:41:44  lowende
 * Deprecated warnings removed. Other compile warnings removed.
 *
 */
