/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.views;

import java.awt.*;
import java.beans.*;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.*;

import javax.swing.*;

import de.uni_paderborn.fujaba.views.beans.*;
import de.upb.tools.fca.FEmptyIterator;


/**
 * Default implementation of the FilterEditor interface.<p>
 *
 * Generic Dialog based on Bean-Technology
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.15 $
 */
public class DefaultFilterEditor extends AbstractFilterEditor
{

   static
   {
      ExtendedBoolEditor.init();
      ExtendedIntEditor.init();
   }

   /**
    * Constructor for class DefaultFilterEditor
    *
    * @param filter  No description provided
    */
   public DefaultFilterEditor (ConfigurableFilter filter)
   {
      super (filter);
   }


   /**
    * Sets the filter attribute of the DefaultFilterEditor object
    *
    * @param filter  The new filter value
    */
   public void setFilter (ConfigurableFilter filter)
   {
      ConfigurableFilter oldFilter = getFilter();
      super.setFilter (filter);
      if ( (oldFilter == null && filter != null) ||
          (oldFilter != null && filter == null) ||
          (oldFilter != null && filter != null &&
         oldFilter.getClass() != filter.getClass()))
      {
         buildEditor();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void buildEditor()
   {
      setEditor (createEditor());
   }


   /**
    * Set editor as the editor component
    *
    * @param editor  The new editor value
    */
   private void setEditor (Component editor)
   {
      this.removeAll();

      if (editor != null)
      {
         this.add (editor);
      }
      else
      {
         JTextArea messageArea = new JTextArea();
         String message = "Sorry, there is no Editor available\nfor this View Filter.\n";

         messageArea.setText (message);
         messageArea.setEnabled (false);
         this.add (messageArea);
      }
   }


   /**
    * Create the editor by searching available BeanEditors and compiling the interface from
    * their Editors.
    *
    * @return   No description provided
    */
   private Component createEditor()
   {
      ConfigurableFilter filter = getFilter();
      BeanInfo info = null;
      customizer = null;
      filterClone = null;
      removeAllFromProperties();

      if (filter == null)
      {
         return null;
      }

      try
      {
         info = Introspector.getBeanInfo (filter.getClass());
      }
      catch (Exception e)
      {
      }

      if (info == null)
      {
         return null;
      }

      BeanDescriptor descriptor = info.getBeanDescriptor();
      Component result = null;

      if (descriptor != null && descriptor.getCustomizerClass() != null)
      {
         try
         {
            Customizer aCustomizer = (Customizer) descriptor.getCustomizerClass().newInstance();
            ConfigurableFilter clone = (ConfigurableFilter) clone (filter);
            aCustomizer.setObject (clone);
            if (aCustomizer instanceof Component)
            {
               result = (Component) aCustomizer;
               customizer = aCustomizer;
               filterClone = clone;
            }
         }
         catch (Exception e)
         {
         }
      }

      if (result == null)
      {
         Vector propertyComponents = new Vector();

         PropertyDescriptor[] propInfos = info.getPropertyDescriptors();
         for (int i = 0; propInfos != null && i < propInfos.length; i++)
         {
            if (propInfos[i].getReadMethod() == null || propInfos[i].getWriteMethod() == null ||
               "needsToBeDiffed".equals (propInfos[i].getName()) || "generated".equals (propInfos[i].getName()) ||
               "toBeSavedFPDiagram".equals (propInfos[i].getName()) || "key".equals (propInfos[i].getName()))
            {
               continue;
            }
            Object[] tmpResult = getEditorAndComponent (propInfos[i]);
            Component comp = (Component) tmpResult[1];
            PropertyEditor editor = (PropertyEditor) tmpResult[0];

            if (comp != null && editor != null)
            {
               addToProperties (propInfos[i], editor);
               propertyComponents.add (comp);
            }
         }

         if (propertyComponents.size() > 0)
         {
            JPanel panel = new JPanel();
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            panel.setLayout (gb);
            c.gridheight = 1;
            c.gridwidth = 1;
            c.weighty = 0;
            c.anchor = GridBagConstraints.NORTHWEST;
            c.fill = GridBagConstraints.HORIZONTAL;
            c.ipadx = 2;

            Iterator compIter = propertyComponents.iterator();
            int gridy = 2;
            Component nameComp = null;
            Component descComp = null;
            while (compIter.hasNext())
            {
               Component comp = (Component) compIter.next();
               if ("name".equals (comp.getName()))
               {
                  nameComp = comp;
                  continue;
               }
               if ("description".equals (comp.getName()))
               {
                  descComp = comp;
                  continue;
               }

               JLabel label = new JLabel (convertString (comp.getName()));

               c.weightx = 1;
               c.gridx = 0;
               c.gridy = gridy;
               gb.setConstraints (label, c);
               panel.add (label);
               c.weightx = 0;
               c.gridx = 1;
               gb.setConstraints (comp, c);
               panel.add (comp, c);
               gridy++;
            }

            if (descComp != null)
            {
               JLabel label = new JLabel (convertString (descComp.getName()));

               c.weightx = 1;
               c.gridx = 0;
               c.gridy = 1;
               gb.setConstraints (label, c);
               panel.add (label, 0);
               c.weightx = 0;
               c.gridx = 1;
               gb.setConstraints (descComp, c);
               panel.add (descComp, 1);
            }
            if (nameComp != null)
            {
               JLabel label = new JLabel (convertString (nameComp.getName()));

               c.weightx = 1;
               c.gridx = 0;
               c.gridy = 0;
               gb.setConstraints (label, c);
               panel.add (label, 0);
               c.weightx = 0;
               c.gridx = 1;
               gb.setConstraints (nameComp, c);
               panel.add (nameComp, 1);
            }

            result = panel;
         }
      }
      return result;
   }


   /**
    * @param prop  No description provided
    * @return      Array of length 2, 1st Object is the PropertyEditor and 2nd Object is the
    *      Component for it
    */
   private Object[] getEditorAndComponent (PropertyDescriptor prop)
   {
      Component result = null;
      Class propEditorClass = prop.getPropertyEditorClass();
      PropertyEditor editor = null;

      if (propEditorClass != null &&
         PropertyEditor.class.isAssignableFrom (propEditorClass))
      {
         try
         {
            editor = (PropertyEditor) propEditorClass.newInstance();
         }
         catch (Exception e)
         {
         }
      }

      if (editor == null)
      {
         editor = PropertyEditorManager.findEditor (prop.getPropertyType());
      }

      if (editor != null)
      {
         result = editor.getCustomEditor();
      }
      else
      {
         return new Object[]
            {
            null, null
            };
      }

      if (result == null)
      {
         editor = new WrapperEditor (editor);
         result = editor.getCustomEditor();
      }

      if (result != null)
      {
         result.setName (prop.getDisplayName());
      }

      return new Object[]
         {
         editor, result
         };
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param str  No description provided
    * @return     No description provided
    */
   private String convertString (String str)
   {
      if (str == null)
      {
         return null;
      }
      if (str.equals (""))
      {
         return "";
      }

      StringBuffer result = new StringBuffer (str.substring (0, 1).toUpperCase());
      int length = str.length();
      boolean lastUpperCase = true;

      for (int i = 1; i < length; i++)
      {
         char c = str.charAt (i);
         if (Character.isDigit (c) ||  (!lastUpperCase && Character.isUpperCase (c)))
         {
            result.append (" " + c);
            lastUpperCase = true;
         }
         else
         {
            if (Character.getNumericValue (c) == Character.getNumericValue ('_'))
            {
               c = ' ';
            }

            result.append (c);
            lastUpperCase = false;
         }
      }

      return result.toString();
   }


   /**
    * get the value of the field in the Object defined by the PropertyDescriptor
    *
    * @param target  No description provided
    * @param desc    No description provided
    * @return        The value value
    */
   private Object getValue (Object target, PropertyDescriptor desc)
   {
      if (desc == null)
      {
         return null;
      }

      Method readMethod = desc.getReadMethod();
      if (readMethod == null)
      {
         return null;
      }

      Object result = null;
      try
      {
         result = readMethod.invoke (target, new Object[]
            {
            }
            );
      }
      catch (InvocationTargetException e)
      {
         //throw e.getTargetException();
      }
      catch (Exception e)
      {
      }

      return result;
   }


   /**
    * get the value of the field in the Object defined by the PropertyDescriptor to value
    *
    * @param target  The new value value
    * @param desc    The new value value
    * @param value   The new value value
    */
   private void setValue (Object target, PropertyDescriptor desc, Object value)
   {
      if (desc == null)
      {
         return;
      }

      Method writeMethod = desc.getWriteMethod();
      if (writeMethod == null)
      {
         return;
      }

      try
      {
         writeMethod.invoke (target, new Object[]
            {
            value
            }
            );
      }
      catch (InvocationTargetException e)
      {
         //throw e.getTargetException();
      }
      catch (Exception e)
      {
      }
   }


   /**
    * Get the values attribute of the DefaultFilterEditor object
    *
    * @param filter  No description provided
    */
   protected void getValues (ConfigurableFilter filter)
   {
      if (customizer != null)
      {
         try
         {
            filterClone = (ConfigurableFilter) clone (filter);
            customizer.setObject (filterClone);
         }
         catch (CloneNotSupportedException e)
         {
         }
      }
      else if (sizeOfProperties() > 0)
      {
         Iterator iter = entriesOfProperties();

         while (iter.hasNext())
         {
            Map.Entry entry = (Map.Entry) iter.next();
            PropertyDescriptor desc = (PropertyDescriptor) entry.getKey();
            PropertyEditor editor = (PropertyEditor) entry.getValue();
            Object value = getValue (filter, desc);
            try
            {
               editor.setValue (value);
            }
            catch (Exception e)
            {
            }
         }
      }
   }


   /**
    * Sets the values attribute of the DefaultFilterEditor object
    *
    * @param filter  The new values value
    */
   protected void setValues (ConfigurableFilter filter)
   {
      if (filter == null)
      {
         return;
      }

      if (customizer != null)
      {
         copyProperties (filterClone, filter);
      }
      else if (sizeOfProperties() > 0)
      {
         Iterator iter = entriesOfProperties();

         while (iter.hasNext())
         {
            Map.Entry entry = (Map.Entry) iter.next();
            PropertyDescriptor desc = (PropertyDescriptor) entry.getKey();
            PropertyEditor editor = (PropertyEditor) entry.getValue();
            Object value = editor.getValue();
            setValue (filter, desc, value);
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Customizer customizer;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private ConfigurableFilter filterClone;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private HashMap properties;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   private boolean hasInProperties (PropertyEditor value)
   {
      return  ( (this.properties != null) &&
          (value != null) &&
         this.properties.containsValue (value));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param key    No description provided
    * @param value  No description provided
    * @return       No description provided
    */
   private boolean hasInProperties (PropertyDescriptor key, PropertyEditor value)
   {
      return  ( (this.properties != null) &&
          (value != null) &&  (key != null) &&
          (this.properties.get (key) == value));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param key  No description provided
    * @return     No description provided
    */
   private boolean hasKeyInProperties (PropertyDescriptor key)
   {
      return  ( (this.properties != null) &&
          (key != null) &&
         this.properties.containsKey (key));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   private Iterator iteratorOfProperties()
   {
      return  ( (this.properties == null)
         ? FEmptyIterator.get()
         : this.properties.values().iterator());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   private Iterator keysOfProperties()
   {
      return  ( (this.properties == null)
         ? FEmptyIterator.get()
         : this.properties.keySet().iterator());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   private Iterator entriesOfProperties()
   {
      return  ( (this.properties == null)
         ? FEmptyIterator.get()
         : this.properties.entrySet().iterator());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   private int sizeOfProperties()
   {
      return  ( (this.properties == null)
         ? 0
         : this.properties.size());
   }


   /**
    * Get the fromProperties attribute of the DefaultFilterEditor object
    *
    * @param key  No description provided
    * @return     The fromProperties value
    */
   private PropertyEditor getFromProperties (PropertyDescriptor key)
   {
      return  ( ( (this.properties == null) ||  (key == null))
         ? null
         : (PropertyEditor) this.properties.get (key));
   }


   /**
    * Access method for an one to n association.
    *
    * @param key    The object added.
    * @param value  The object added.
    * @return       No description provided
    */
   private boolean addToProperties (PropertyDescriptor key, PropertyEditor value)
   {
      boolean changed = false;
      if ( (value != null) &&  (key != null))
      {
         if (this.properties == null)
         {
            this.properties = new HashMap();
         }
         PropertyEditor oldValue = (PropertyEditor) this.properties.put (key, value);
         if (oldValue != value)
         {
            changed = true;
         }
      }
      return changed;
   }


   /**
    * Access method for an one to n association.
    *
    * @param entry  The object added.
    * @return       No description provided
    */
   private boolean addToProperties (Map.Entry entry)
   {
      return addToProperties ((PropertyDescriptor) entry.getKey(), (PropertyEditor) entry.getValue());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   private boolean removeFromProperties (PropertyEditor value)
   {
      boolean changed = false;
      if ( (this.properties != null) &&  (value != null))
      {
         Iterator iter = this.entriesOfProperties();
         Map.Entry entry;
         while (iter.hasNext())
         {
            entry = (Map.Entry) iter.next();
            if (entry.getValue() == value)
            {
               changed = changed | this.removeFromProperties ((PropertyDescriptor) entry.getKey(), value);
            }
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param key    No description provided
    * @param value  No description provided
    * @return       No description provided
    */
   private boolean removeFromProperties (PropertyDescriptor key, PropertyEditor value)
   {
      boolean changed = false;
      if ( (this.properties != null) &&  (value != null) &&  (key != null))
      {
         PropertyEditor oldValue = (PropertyEditor) this.properties.get (key);
         if (oldValue == value)
         {
            this.properties.remove (key);
            changed = true;
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param key  No description provided
    * @return     No description provided
    */
   private boolean removeKeyFromProperties (PropertyDescriptor key)
   {
      boolean changed = false;
      if ( (this.properties != null) &&  (key != null))
      {
         PropertyEditor tmpValue = (PropertyEditor) this.properties.get (key);
         if (tmpValue != null)
         {
            this.properties.remove (key);
            changed = true;
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private void removeAllFromProperties()
   {
      properties = null;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param source  No description provided
    * @param target  No description provided
    */
   public static void copyProperties (Object source, Object target)
   {
      if (source == null || target == null || !source.getClass().isInstance (target))
      {
         return;
      }

      BeanInfo sourceInfo = null;
      BeanInfo targetInfo = null;
      try
      {
         sourceInfo = Introspector.getBeanInfo (source.getClass());
         targetInfo = Introspector.getBeanInfo (target.getClass());
      }
      catch (Exception e)
      {
         return;
      }

      HashMap targetProps = new HashMap();
      PropertyDescriptor[] targetDescriptors = targetInfo.getPropertyDescriptors();
      PropertyDescriptor[] sourceDescriptors = sourceInfo.getPropertyDescriptors();
      for (int i = 0; i < targetDescriptors.length; i++)
      {
         String key = targetDescriptors[i].getName() + ":" + targetDescriptors[i].getPropertyType().getName();
         targetProps.put (key, targetDescriptors[i]);
      }
      for (int i = 0; i < sourceDescriptors.length; i++)
      {
         String key = sourceDescriptors[i].getName() + ":" + sourceDescriptors[i].getPropertyType().getName();
         PropertyDescriptor partner = (PropertyDescriptor) targetProps.get (key);
         Method readMethod = sourceDescriptors[i].getReadMethod();
         Method writeMethod = partner.getWriteMethod();

         if (readMethod == null || writeMethod == null)
         {
            continue;
         }

         try
         {
            Object value = readMethod.invoke (source, new Object[]
               {});
            writeMethod.invoke (target, new Object[]
               {
               value
               }
               );
         }
         catch (InvocationTargetException e)
         {
            //throw e.getTargetException();
         }
         catch (Exception e)
         {
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param o                            No description provided
    * @return                             No description provided
    * @throws CloneNotSupportedException  Exception description not provided
    */
   public static Object clone (Object o) throws CloneNotSupportedException
   {
      if (o == null)
      {
         return null;
      }

      Object clone = null;
      try
      {
         if (o instanceof ConfigurableFilter)
         {
            clone =  ((ConfigurableFilter) o).clone();
         }
         else
         {
            Class clazz = o.getClass();
            clone = clazz.newInstance();
            copyProperties (o, clone);
         }
      }
      catch (Exception e)
      {
         throw new CloneNotSupportedException();
      }
      return clone;
   }
}

/*
 * $Log: DefaultFilterEditor.java,v $
 * Revision 1.15  2004/10/20 17:50:30  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
