/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.utility;

import java.util.Iterator;

import de.uni_paderborn.fujaba.asg.*;
import de.uni_paderborn.fujaba.uml.*;
import de.upb.tools.fca.FTreeSet;


/**
 * Utility class for reusable UMLObjectDiagram methodes.
 *
 * @author    $Author: wagner $
 * @version   $Revision: 1.10.2.1 $
 */
public class UMLObjectDiagramUtility extends ASGUtility
{

   /**
    * Constructor for abstract class ASGUtility
    *
    * @param diagram  No description provided
    */
   public UMLObjectDiagramUtility (ASGDiagram diagram)
   {
      super (diagram);
   }


   /**
    * Returns the list of associations for a link.
    *
    * @param link  No description provided
    * @return      The associations value
    */
   public static FTreeSet getAssociations (UMLLink link)
   {
      UMLClass firstClass = null;
      UMLClass secondClass = null;

      UMLObject object = link.getSource();
      if (object != null)
      {
         firstClass = object.getInstanceOf();
      }
      object = link.getTarget();
      if (object != null)
      {
         secondClass = object.getInstanceOf();
      }

      // Calculate all the assocs which are possible between this two
      // classes and add them to the list of associations and return the list.
      return UMLClassDiagramUtility.calculatePossibleAssocs (firstClass, secondClass);
   } // getAssociations


   /**
    * returns the list of associations between two objects.
    *
    * @param srcObj  No description provided
    * @param tgtObj  No description provided
    * @return        The associations value
    */
   public static FTreeSet getAssociations (UMLObject srcObj, UMLObject tgtObj)
   {
      UMLClass firstClass = null;
      UMLClass secondClass = null;

      if ( (srcObj != null) &&  (tgtObj != null))
      {
         firstClass = srcObj.getInstanceOf();
         secondClass = tgtObj.getInstanceOf();

         // Calculate all the assocs which are possible between this two
         // classes and add them to the list of associations and return the list.
         return UMLClassDiagramUtility.calculatePossibleAssocs (firstClass, secondClass);
      }
      else
      {
         return null;
      }

   } // getAssociations


   /**
    * returns the list of associations between two objects.
    *
    * @param srcObj  No description provided
    * @param tgtObj  No description provided
    * @return        The associations value
    */
   public static FTreeSet getASGElementRefAssocs (UMLObject srcObj, UMLObject tgtObj)
   {
      UMLClass firstClass = null;
      UMLClass secondClass = null;

      if ( (srcObj != null) &&  (tgtObj != null))
      {
         firstClass = srcObj.getInstanceOf();
         secondClass = tgtObj.getInstanceOf();

         // Calculate all the assocs which are possible between this two
         // classes and add them to the list of associations and return the list.
         FTreeSet assocs = new FTreeSet();

         if (null != UMLClassDiagramUtility.calculatePossibleAssocsViaASGElementRef (firstClass, secondClass))
         {
            assocs.addAll (UMLClassDiagramUtility.calculatePossibleAssocsViaASGElementRef (firstClass, secondClass));
         }

         if (null != UMLClassDiagramUtility.calculatePossibleAssocsViaASGElementRef (secondClass, firstClass))
         {
            assocs.addAll (UMLClassDiagramUtility.calculatePossibleAssocsViaASGElementRef (secondClass, firstClass));
         }

         if (assocs.isEmpty())
         {
            return null;
         }
         else
         {
            return assocs;
         }

      }
      else
      {
         return null;
      }

   } // getASGElementRefAssocs


   /**
    * returns the object for a given object name.
    *
    * @param objectName  No description provided
    * @return            The associations value
    */
   public static UMLObject getObject (String objectName)
   {
      UMLObjectDiagram diagram = (UMLObjectDiagram) UMLProject.get().getCurrentUMLDiagram();

      if (diagram == null)
      {
         Exception ex = new Exception ("No UML diagram found!");
         ex.printStackTrace();
      }

      UMLObject foundObject = null;
      Iterator iter = diagram.iteratorOfElements();
      while ( (iter.hasNext()) &&  (null == foundObject))
      {
         ASGElement elem = (ASGElement) iter.next();
         if (elem instanceof UMLObject)
         {
            UMLObject object = (UMLObject) elem;
            if ( (object.getObjectName()).equals (objectName))
            {
               foundObject = object;
            }
         }
      }

      return foundObject;
   } // getObject

}

/*
 * $Log: UMLObjectDiagramUtility.java,v $
 * Revision 1.10.2.1  2005/09/08 13:41:32  wagner
 * fixed string compare bug
 *
 */
