/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.update;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;

import de.uni_paderborn.fujaba.fsa.FSADerivePropertyMethodsCache;
import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.fsa.update.LogicToFsaUpdater;
import de.uni_paderborn.fujaba.metamodel.FDeclaration;
import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.uml.UMLIncrement;


/**
 * update Component for Adornment on a Grab
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.1 $
 */
public class UMLShowComponents extends LogicToFsaUpdater implements PropertyChangeListener
{
   /**
    * Constructor for class UMLShowComponents
    */
   public UMLShowComponents()
   {
      super();
      super.setLogicAttrName ("canvasVisibility");
      super.setFsaAttrName ("visible");
   }


   /**
    * Constructor for class UMLShowComponents
    *
    * @param fsa   No description provided
    * @param incr  No description provided
    */
   public UMLShowComponents (FSAObject fsa, LogicUnparseInterface incr)
   {
      this();
      setLogicObject (incr);
      setFsaObject (fsa);
   }


   /**
    * Sets the logicObject attribute of the UMLShowComponents object
    *
    * @param object  The new logicObject value
    * @return        No description provided
    */
   public boolean setLogicObject (Object object)
   {
      if (object == null || object instanceof FElement)
      {
         return super.setLogicObject (object);
      }
      throw new IllegalArgumentException ("Object must be of instance ASGElement");
   }


   /**
    * Sets the logicAttrName attribute of the UMLShowComponents object
    *
    * @param name  The new logicAttrName value
    * @return      No description provided
    */
   public boolean setLogicAttrName (String name)
   {
      if ("canvasVisibity".equals (name))
      {
         return false;
      }

      throw new UnsupportedOperationException ("Cannot change AdornmentUpdater.umlAttrName from \"adornment\"");
   }


   /**
    * translate adornment string to JComponent for that adornment
    *
    * @param data  No description provided
    * @return      No description provided
    */
   public Object translateLogicToFsa (Object data)
   {
      if (data != null)
      {
         boolean visible = true;
         FDeclaration incr = (FDeclaration) getLogicObject();

         try
         {
            Short.parseShort (data.toString());
         }
         catch (NumberFormatException e)
         {
         }

         if (incr.getDisplayLevel() == FDeclaration.CODE_DISPLAY_LEVEL)
         {
            visible = false;
         } // end of if ()

         getFsaObject().setVisible (visible);
      }

      return getFsaObject();
   }


   /**
    * Access method for an one to n association.
    */
   protected void addListener()
   {
      if (! (getLogicObject() == null || getLogicAttrName() == null ||
         getFsaObject() == null || getFsaAttrName() == null))
      {
         if (getLogicListener() == null)
         {
            setLogicListener (this);
         }
          ((UMLIncrement) getLogicObject()).addPropertyChangeListener (getLogicAttrName(), (PropertyChangeListener) getLogicListener());
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void removeListener()
   {
      if (! (getLogicObject() == null || getLogicAttrName() == null ||
         getFsaObject() == null || getFsaAttrName() == null))
      {
         if (getLogicListener() != null)
         {
             ((UMLIncrement) getLogicObject()).removePropertyChangeListener (getLogicAttrName(), (PropertyChangeListener) getLogicListener());
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void initialize()
   {
      if (getLogicObject() == null || getLogicAttrName() == null ||
         getFsaObject() == null || getFsaAttrName() == null)
      {
         return;
      }

      Method getMethod = null;

      Method[] methods = FSADerivePropertyMethodsCache.get()
         .getPropertyMethods (getLogicAttrName(), getLogicObject());

      getMethod = methods[0];
      if (getMethod != null)
      {
         try
         {
            Object value = getMethod.invoke (getLogicObject(), null);
            translateLogicToFsa (value);
         }
         catch (Exception e)
         {
            e.printStackTrace();
            throw new RuntimeException ("Exception in " + this + ".initialize: " + e);
         }
      } // end of if ()

   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void propertyChange (PropertyChangeEvent e)
   {
      translateLogicToFsa (e.getNewValue());
   }
}

/*
 * $Log: UMLShowComponents.java,v $
 * Revision 1.1  2005/01/19 09:48:14  lowende
 * Bug in unparsing qualifier roles fixed.
 * Some updater for uml unparsing moved to uml.update
 *
 */
