/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.update;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;

import de.uni_paderborn.fujaba.fsa.FSADerivePropertyMethodsCache;
import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.fsa.update.LogicToFsaUpdater;
import de.uni_paderborn.fujaba.metamodel.FIncrement;
import de.uni_paderborn.fujaba.uml.*;


/**
 * update Component for Adornment on a Grab
 *
 * @author    $Author: mksoft $
 * @version   $Revision: 1.1.2.1 $
 */
public class UMLAbstractUpdater
    extends LogicToFsaUpdater implements PropertyChangeListener
{
   /**
    * Constructor for class UMLAbstractUpdater
    */
   public UMLAbstractUpdater()
   {
      super();
      super.setLogicAttrName ("umlAbstract");
      super.setFsaAttrName ("font");
   }


   /**
    * Constructor for class UMLAbstractUpdater
    *
    * @param field   No description provided
    * @param object  No description provided
    */
   public UMLAbstractUpdater (FSAObject field, LogicUnparseInterface object)
   {
      this();
      setLogicObject (object);
      setFsaObject (field);
   }


   /**
    * Sets the logicObject attribute of the UMLAbstractUpdater object
    *
    * @param object  The new logicObject value
    * @return        No description provided
    */
   public boolean setLogicObject (Object object)
   {
      if (object == null || object instanceof FIncrement)
      {
         return super.setLogicObject (object);
      }
      throw new IllegalArgumentException ("Object must be of instance UMLRole");
   }


   /**
    * Sets the fsaObject attribute of the UMLAbstractUpdater object
    *
    * @param object  The new fsaObject value
    * @return        No description provided
    */
   public boolean setFsaObject (FSAObject object)
   {
      return super.setFsaObject (object);
   }


   /**
    * Sets the logicAttrName attribute of the UMLAbstractUpdater object
    *
    * @param name  The new logicAttrName value
    * @return      No description provided
    */
   public boolean setLogicAttrName (String name)
   {
      if ("umlAbstract".equals (name))
      {
         return false;
      }

      throw new UnsupportedOperationException ("Cannot change AdornmentUpdater.umlAttrName from \"adornment\"");
   }


   /**
    * translate adornment string to JComponent for that adornment
    *
    * @param data  No description provided
    * @return      No description provided
    */
   public Object translateLogicToFsa (Object data)
   {
      boolean isAbstract = false;

      if (data != null &&
         data instanceof Boolean)
      {
         isAbstract =  ((Boolean) data).booleanValue();
      }

      getFsaObject().setItalic (isAbstract);

      return getFsaObject().getJComponent();
   }


   /**
    * Access method for an one to n association.
    */
   protected void addListener()
   {
      if (! (getLogicObject() == null || getLogicAttrName() == null ||
         getFsaObject() == null || getFsaAttrName() == null))
      {
         if (getLogicListener() == null)
         {
            setLogicListener (this);
         }

         UMLIncrement incr = (UMLIncrement) getLogicObject();
         incr.addPropertyChangeListener (getLogicAttrName(), (PropertyChangeListener) getLogicListener());

         if (incr instanceof UMLMethod)
         {
            incr.addPropertyChangeListener ("param", (PropertyChangeListener) getLogicListener());
            incr.addPropertyChangeListener ("resultType", (PropertyChangeListener) getLogicListener());
            incr.addPropertyChangeListener ("name", (PropertyChangeListener) getLogicListener());
         } // end of if ()

      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void removeListener()
   {
      if (! (getLogicObject() == null || getLogicAttrName() == null ||
         getFsaObject() == null || getFsaAttrName() == null))
      {
         if (getLogicListener() != null)
         {
            UMLIncrement incr = (UMLIncrement) getLogicObject();
            incr.removePropertyChangeListener (getLogicAttrName(), (PropertyChangeListener) getLogicListener());

            if (incr instanceof UMLMethod)
            {
               incr.removePropertyChangeListener ("param", (PropertyChangeListener) getLogicListener());
               incr.removePropertyChangeListener ("resultType", (PropertyChangeListener) getLogicListener());
               incr.removePropertyChangeListener ("name", (PropertyChangeListener) getLogicListener());
            } // end of if ()
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void initialize()
   {
      if (getLogicObject() == null || getLogicAttrName() == null ||
         getFsaObject() == null || getFsaAttrName() == null)
      {
         return;
      }

      Method getMethod = null;

      Method[] methods = FSADerivePropertyMethodsCache.get()
         .getPropertyMethods (getLogicAttrName(), getLogicObject());

      getMethod = methods[0];
      try
      {
         Object value = getMethod.invoke (getLogicObject(), null);
         getTranslator().translateLogicToFsa (value);
      }
      catch (Exception e)
      {
         e.printStackTrace();
         throw new RuntimeException ("Exception in " + this + ".initialize: " + e.getMessage());
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void propertyChange (PropertyChangeEvent e)
   {
      //if (log.isInfoEnabled()) log.info (e);

      Object newVal = e.getSource();
      if (newVal instanceof Boolean)
      {
         getTranslator().translateLogicToFsa (e.getNewValue());
      } // end of if ()
      else if (getLogicObject() instanceof UMLMethod)
      {
         UMLMethod method = (UMLMethod) getLogicObject();
         Boolean data = Boolean.valueOf (method.isUmlAbstract());
         getTranslator().translateLogicToFsa (data);
      } // end of if ()
      else if (getLogicObject() instanceof UMLClass)
      {
         UMLClass theClass = (UMLClass) getLogicObject();
         Boolean data = Boolean.valueOf (theClass.isUmlAbstract());
         getTranslator().translateLogicToFsa (data);
      } // end of if ()

   }
}

/*
 * $Log: UMLAbstractUpdater.java,v $
 * Revision 1.1.2.1  2005/09/30 18:57:02  mksoft
 * replacing many System.out.println with if (log.isInfoEnabled()) log.info ()
 *
 */
