/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.update;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;

import javax.swing.*;

import de.uni_paderborn.fujaba.fsa.*;
import de.uni_paderborn.fujaba.fsa.listener.ForegroundHighlighter;
import de.uni_paderborn.fujaba.fsa.listener.SelectionListenerHelper;
import de.uni_paderborn.fujaba.fsa.swing.*;
import de.uni_paderborn.fujaba.fsa.unparse.UnparseManager;
import de.uni_paderborn.fujaba.fsa.update.LogicToFsaUpdater;
import de.uni_paderborn.fujaba.metamodel.FRole;
import de.uni_paderborn.fujaba.uml.UMLQualifier;
import de.uni_paderborn.fujaba.uml.UMLRole;
import de.uni_paderborn.fujaba.uml.unparse.UMArrowHead;


/**
 * update Component for Adornment on a Grab
 *
 * @author    $Author: fklar $
 * @version   $Revision: 1.1.2.1 $
 */
public class AdornmentUpdater
    extends LogicToFsaUpdater implements PropertyChangeListener
{
   /**
    * Constructor for class AdornmentUpdater
    */
   public AdornmentUpdater()
   {
      super();
      super.setLogicAttrName ("adornment");
      super.setFsaAttrName ("adornment");
   }


   /**
    * Constructor for class AdornmentUpdater
    *
    * @param role  No description provided
    */
   public AdornmentUpdater (UMLRole role)
   {
      this();
      setLogicObject (role);
   }


   /**
    * Sets the logicObject attribute of the AdornmentUpdater object
    *
    * @param object  The new logicObject value
    * @return        No description provided
    */
   public boolean setLogicObject (Object object)
   {
      if (object == null || object instanceof UMLRole)
      {
         return super.setLogicObject (object);
      }
      throw new IllegalArgumentException ("Object must be of instance UMLRole");
   }


   /**
    * Sets the fsaObject attribute of the AdornmentUpdater object
    *
    * @param object  The new fsaObject value
    * @return        No description provided
    */
   public boolean setFsaObject (FSAObject object)
   {
      if (object == null || object instanceof FSABend)
      {
         return super.setFsaObject (object);
      }
      throw new IllegalArgumentException ("Object must be of instance FSABend");
   }


   /**
    * Sets the logicAttrName attribute of the AdornmentUpdater object
    *
    * @param name  The new logicAttrName value
    * @return      No description provided
    */
   public boolean setLogicAttrName (String name)
   {
      if ("adornment".equals (name))
      {
         return false;
      }

      throw new UnsupportedOperationException ("Cannot change AdornmentUpdater.umlAttrName from \"adornment\"");
   }


   /**
    * translate adornment string to JComponent for that adornment
    *
    * @param data  No description provided
    * @return      No description provided
    */
   public Object translateLogicToFsa (Object data)
   {
      int adornment = FRole.NONE;

      if (data != null)
      {
         try
         {
            adornment = Integer.parseInt (data.toString());
         }
         catch (NumberFormatException e)
         {
         }
      }
      boolean selected = SelectionListenerHelper.isSelected (FSAObject.getJComponent (getFsaObject()));

      JComponent result = null;
      if (adornment == FRole.AGGREGATION)
      {
         result = (JArrowHead) UMArrowHead.AGGREGATION.clone();
      }
      else if (adornment == FRole.COMPOSITION)
      {
         result = (JArrowHead) UMArrowHead.COMPOSITION.clone();
      }
      else if (adornment == FRole.QUALIFIED)
      {
         UMLQualifier qualifier =  ((UMLRole) getLogicObject()).getQualifier();
         if (qualifier != null)
         {
            FSAObject qualFsa = qualifier.getFromFsaObjects (getFsaObject().getID() + ".entry");

            if (qualFsa == null)
            {
               qualFsa = UnparseManager.get().unparse (qualifier, getFsaObject());
            }

            result = qualFsa.getJComponent();
         }
      }
      else if (adornment == FRole.REFERENCE)
      {
         result = (JArrowHead) UMArrowHead.REFERENCE.clone();
      }
      else
      {
         result = new JRectangle (DefaultBendUI.DEFAULT_SIZE, DefaultBendUI.DEFAULT_SIZE);
      }

      if (result != null)
      {
         SelectionListenerHelper.addSelectionListener (result, ForegroundHighlighter.get());
         SelectionListenerHelper.setSelected (result, selected);
      }

      return result;
   }


   /**
    * Access method for an one to n association.
    */
   protected void addListener()
   {
      if (! (getLogicObject() == null || getLogicAttrName() == null ||
         getFsaObject() == null || getFsaAttrName() == null))
      {
         if (getLogicListener() == null)
         {
            setLogicListener (this);
         }
          ((UMLRole) getLogicObject()).addPropertyChangeListener (getLogicAttrName(), (PropertyChangeListener) getLogicListener());
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void removeListener()
   {
      if (! (getLogicObject() == null || getLogicAttrName() == null ||
         getFsaObject() == null || getFsaAttrName() == null))
      {
         if (getLogicListener() != null)
         {
             ((UMLRole) getLogicObject()).removePropertyChangeListener (getLogicAttrName(), (PropertyChangeListener) getLogicListener());
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void initialize()
   {
      if (getLogicObject() == null || getLogicAttrName() == null ||
         getFsaObject() == null || getFsaAttrName() == null)
      {
         return;
      }

      Method getMethod = null;

      Method[] methods = FSADerivePropertyMethodsCache.get()
         .getPropertyMethods (getLogicAttrName(), getLogicObject());

      getMethod = methods[0];
      try
      {
         Object value = getMethod.invoke (getLogicObject(), null);
         JComponent comp = (JComponent) getTranslator().translateLogicToFsa (value);
         PanelGrabUI ui = (PanelGrabUI)  ((FSABend) getFsaObject()).getUI();
         JComponent grabComp = ui.getGrabComponent();

         if (grabComp == null)
         {
            ui.setGrabComponent (comp);
         }
         else
         {
            grabComp.removeAll();
            grabComp.add (comp);
         } // else
      }
      catch (Exception e)
      {
         e.printStackTrace();
         throw new RuntimeException ("Exception in " + this + ".initialize: " + e);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void propertyChange (PropertyChangeEvent e)
   {
      JComponent comp = (JComponent) getTranslator().translateLogicToFsa (e.getNewValue());
      PanelGrabUI ui = (PanelGrabUI)  ((FSABend) getFsaObject()).getUI();
      JComponent grabComp = ui.getGrabComponent();

      if (grabComp == null)
      {
         ui.setGrabComponent (comp);
      }
      else
      {
         grabComp.removeAll();
         if (comp != null)
         {
            grabComp.add (comp);
         }
      } // else
   }
}

/*
 * $Log: AdornmentUpdater.java,v $
 * Revision 1.1.2.1  2005/09/28 16:00:17  fklar
 * preventing NullPointerException
 *
 */
