/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.unparse;

import java.awt.*;

import de.uni_paderborn.fujaba.basic.FontContainer;
import de.uni_paderborn.fujaba.fsa.*;
import de.uni_paderborn.fujaba.fsa.unparse.AbstractUnparseModule;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.fsa.update.AbstractUpdater;
import de.uni_paderborn.fujaba.fsa.update.VisibilityUpdater;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: fklar $
 * @version   $Revision: 1.14.2.1 $
 */
public class UMTransitionGuard extends AbstractUnparseModule
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param parent  No description provided
    * @param incr    No description provided
    * @return        No description provided
    */
   public FSAObject create (FSAObject parent, LogicUnparseInterface incr)
   {
      if (parent != null)
      {
         FSAPanel panel = new FSAPanel (incr, getMainFsaName(), parent.getJComponent(), false);
//         panel.setTransientProperties (false);
         panel.setOpaque (false);
         AbstractUpdater updater = new VisibilityUpdater (incr, "boolExpr");
         panel.addToUpdater (updater);

         Font tmpFont = FontContainer.getFont (FontContainer.DEFAULT_FONT, -1);

         FSALabel tmpLabel = new FSALabel (incr, "[", panel.getJComponent());
         tmpLabel.setText ("[");
         tmpLabel.getJComponent().setFont (tmpFont);

         FSATextFieldLabel exprLabel = new FSATextFieldLabel (incr, "boolExpr", panel.getJComponent());
         exprLabel.setOpaque (false);
         exprLabel.addToUpdater (exprLabel.createDefaultUpdater());
         exprLabel.getJComponent().setFont (tmpFont);

         tmpLabel = new FSALabel (incr, "]", panel.getJComponent());
         tmpLabel.setText ("]");
         tmpLabel.getJComponent().setFont (tmpFont);

         return panel;
      }
      else
      {
         return null;
      }
   }
}

/*
 * $Log: UMTransitionGuard.java,v $
 * Revision 1.14.2.1  2005/05/30 15:33:45  fklar
 * adjusted to FSA-changes ... calling constructor, that takes transientProperties as argument to save initial-location
 *
 */
