/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.unparse;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;

import javax.swing.*;

import de.uni_paderborn.fujaba.fsa.*;
import de.uni_paderborn.fujaba.fsa.listener.*;
import de.uni_paderborn.fujaba.fsa.swing.ColumnRowLayout;
import de.uni_paderborn.fujaba.fsa.swing.border.ActivityBorder;
import de.uni_paderborn.fujaba.fsa.unparse.AbstractUnparseModule;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.fsa.update.VisibilityUpdater;
import de.uni_paderborn.fujaba.uml.UMLComplexState;
import de.uni_paderborn.fujaba.uml.UMLStoryActivity;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: fklar $
 * @version   $Revision: 1.30.2.1 $
 * @since     $Date: 2005/05/30 15:33:44 $
 */
public class UMStoryActivity extends AbstractUnparseModule
{
   /**
    * Get the childProperties attribute of the UMStoryActivity object
    *
    * @param props  No description provided
    */
   public void getChildProperties (Set props)
   {
      super.getChildProperties (props);
      props.add ("storyPattern");
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param parent  No description provided
    * @param incr    No description provided
    * @return        No description provided
    */
   public FSAObject create (FSAObject parent, LogicUnparseInterface incr)
   {
      UMLStoryActivity storyAct = (UMLStoryActivity) incr;

      FSAPanel storyPanel = new FSAPanel (incr, getMainFsaName(), parent.getJComponent(), false);
//      storyPanel.setTransientProperties (false);
      storyPanel.setLayout (new ColumnRowLayout (10, ColumnRowLayout.COLUMN));

      JComponent jPanel = storyPanel.getJComponent();

      FSATextComponent value = new FSATextComponent (incr, "textComment", jPanel);
      value.addToUpdater (value.createDefaultUpdater());
      value.addToUpdater (new VisibilityUpdater (incr, "textComment"));

      AscendDescendMouseHandler.addMouseInputListener (jPanel, SelectionMouseListener.get());
      AscendDescendMouseHandler.addMouseInputListener (jPanel, DragMouseListener.get());
      AscendDescendMouseHandler.addMouseInputListener (jPanel, AscendDescendMouseHandler.getDescendConsumer());
      AscendDescendMouseHandler.addMouseInputListener (jPanel, DoubleClickMouseListener.get());
      SelectionListenerHelper.addSelectionListener (jPanel, BorderHighlighter.get());

      LogicUnparseInterface parentInterface = parent.getFSAInterface().getLogic();
      if (! (parentInterface instanceof UMLComplexState))
      {
         setBorder (storyAct, storyPanel);
      }
      BorderUpdater bu = new BorderUpdater (storyPanel);
      storyAct.addPropertyChangeListener ("forEach", bu);

      return storyPanel;
   }


   /**
    * Sets the border attribute of the UMStoryActivity object
    *
    * @param storyAct    The new border value
    * @param storyPanel  The new border value
    */
   public void setBorder (UMLStoryActivity storyAct, FSAPanel storyPanel)
   {
      if ( (storyAct != null) &&  (storyPanel != null))
      {
         storyPanel.setBorder (new ActivityBorder (storyAct.isForEach()));
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: fklar $
    * @version   $Revision: 1.30.2.1 $
    */
   private class BorderUpdater implements PropertyChangeListener
   {

      /**
       * Constructor for class BorderUpdater
       *
       * @param storyPanel  No description provided
       */
      BorderUpdater (FSAPanel storyPanel)
      {
         this.storyPanel = storyPanel;
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      FSAPanel storyPanel;


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param event  No description provided
       */
      public void propertyChange (PropertyChangeEvent event)
      {
         String propertyName = event.getPropertyName();
         if ("forEach".equals (propertyName))
         {
            UMLStoryActivity storyAct = (UMLStoryActivity) event.getSource();
            setBorder (storyAct, storyPanel);
         }
      }
   }

}

/*
 * $Log: UMStoryActivity.java,v $
 * Revision 1.30.2.1  2005/05/30 15:33:44  fklar
 * adjusted to FSA-changes ... calling constructor, that takes transientProperties as argument to save initial-location
 *
 */
