/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.unparse;

import java.awt.*;

import javax.swing.*;

import de.uni_paderborn.fujaba.fsa.*;
import de.uni_paderborn.fujaba.fsa.listener.*;
import de.uni_paderborn.fujaba.fsa.swing.*;
import de.uni_paderborn.fujaba.fsa.unparse.AbstractUnparseModule;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.uml.UMLStopActivity;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: fklar $
 * @version   $Revision: 1.26.2.1 $
 */
public class UMStopActivity extends AbstractUnparseModule
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param parent  No description provided
    * @param incr    No description provided
    * @return        No description provided
    */
   public FSAObject create (FSAObject parent, LogicUnparseInterface incr)
   {
      UMLStopActivity stopActivity = (UMLStopActivity) incr;

      // the main panel for the activity
      FSAPanel panel = new FSAPanel (incr, getMainFsaName(), parent.getJComponent(), false);
//      panel.setTransientProperties (false);
      ColumnRowLayout layout = new ColumnRowLayout (1, ColumnRowLayout.COLUMN);

      panel.setOpaque (false);
      panel.setLayout (layout);

      JPanel circlePanel = new JPanel (new FlowLayout (FlowLayout.CENTER));
      circlePanel.setOpaque (false);

      JCircle circle = new JCircle (7);
      circle.setRadiusInset (5);
      circle.setFilled (true);

      // The grabs that are attached here should be layouted on the border of the circle
      // so register a special Layouter for that purpose to the circle
      CircleGrabLayouter.get().registerLayouterWithJComponent (circle);
      circlePanel.add (circle);

      JPanel jPanel = (JPanel) panel.getJComponent();
      jPanel.add (circlePanel);

      //The label for the method signature
      FSATextFieldLabel label = new FSATextFieldLabel (stopActivity, "returnValue", panel.getJComponent());
      label.setHorizontalAlignment (SwingConstants.CENTER);
      label.setBold (false);
      label.setOpaque (true);

      // to keep it up to date simply add the default updater.
      // it will listen for changes on property "qualifiedMethodDecl" and update the
      // label's default property ("text") accordingly.
      label.addToUpdater (label.createDefaultUpdater());

      AscendDescendMouseHandler.addMouseInputListener (jPanel, SelectionMouseListener.get());
      AscendDescendMouseHandler.addMouseInputListener (jPanel, DragMouseListener.get());
      AscendDescendMouseHandler.addMouseInputListener (jPanel, DoubleClickMouseListener.get());
      SelectionListenerHelper.addSelectionListener (jPanel,
         SelectionPropagationListener.get (SelectionPropagationListener.CHILDREN));
      SelectionListenerHelper.addSelectionListener (circlePanel,
         SelectionPropagationListener.get (SelectionPropagationListener.CHILDREN));
      SelectionListenerHelper.addSelectionListener (label.getJComponent(),
         ForegroundHighlighter.get());
      SelectionListenerHelper.addSelectionListener (circle,
         ForegroundHighlighter.get());

      return panel;
   }
}

/*
 * $Log: UMStopActivity.java,v $
 * Revision 1.26.2.1  2005/05/30 15:33:44  fklar
 * adjusted to FSA-changes ... calling constructor, that takes transientProperties as argument to save initial-location
 *
 */
