/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.unparse;

import java.awt.Font;

import javax.swing.border.LineBorder;

import de.uni_paderborn.fujaba.basic.FontContainer;
import de.uni_paderborn.fujaba.fsa.FSALabel;
import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.FSAPanel;
import de.uni_paderborn.fujaba.fsa.FSATextFieldLabel;
import de.uni_paderborn.fujaba.fsa.listener.BorderHighlighter;
import de.uni_paderborn.fujaba.fsa.listener.ForegroundHighlighter;
import de.uni_paderborn.fujaba.fsa.listener.SelectionListenerHelper;
import de.uni_paderborn.fujaba.fsa.unparse.AbstractUnparseModule;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.fsa.update.AbstractUpdater;
import de.uni_paderborn.fujaba.fsa.update.Translator;
import de.uni_paderborn.fujaba.fsa.update.TypeUpdater;
import de.uni_paderborn.fujaba.fsa.update.VisibilityUpdater;
import de.uni_paderborn.fujaba.preferences.ColorsPreferences;
import de.uni_paderborn.fujaba.uml.UMLQualifier;
import de.uni_paderborn.fujaba.uml.UMLType;


/**
 * No comment provided by developer, please add a comment to improve
 * documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.17.2.2 $
 */
public class UMQualifier extends AbstractUnparseModule
{
   /**
    * Constructor for class UMQualifier
    */
   public UMQualifier()
   {
      super ("name");
   }


   /**
    * No comment provided by developer, please add a comment to improve
    * documentation.
    *
    * @param parent  No description provided
    * @param incr    No description provided
    * @return        No description provided
    */
   public FSAObject create (FSAObject parent, LogicUnparseInterface incr)
   {
      UMLQualifier qual = (UMLQualifier) incr;

      // create role
      FSAPanel qualPanel = new FSAPanel (qual, getMainFsaName(), parent.getJComponent());
      qualPanel.setTransientProperties (false);
      qualPanel.setBorder (new LineBorder (FSAObject.COLOR_FOREGROUND));
      qualPanel.setBackground (ColorsPreferences.get().CLASS_BACKGROUND);

      SelectionListenerHelper.addSelectionListener (qualPanel.getJComponent(), BorderHighlighter.get());

      FSATextFieldLabel qualLabel = new FSATextFieldLabel (qual, "name", qualPanel.getJComponent());
      qualLabel.addToUpdater (qualLabel.createDefaultUpdater());

      //FSAPanel typePanel = new FSAPanel(qual, "typePanel", qualPanel.getJComponent());
      //typePanel.setLayout(new FlowLayout(FlowLayout.LEFT, 0, 0));
      //typePanel.setOpaque(false);


      FSALabel colon = new FSALabel (incr, "colon", qualPanel.getJComponent());
      colon.setText (":");
      FSALabel qualTypeLabel = new FSALabel (qual, "type", qualPanel.getJComponent());
      AbstractUpdater updater = new TypeUpdater (qual, "type", qualTypeLabel.getDefaultAttrName());
      updater.setTranslator (
         new Translator()
         {
            public Object translateFsaToLogic (Object value)
            {
               throw new RuntimeException ("This should never happen!!!");
            }


            public Object translateLogicToFsa (Object value)
            {
               Object result = null;
               if (value instanceof UMLType)
               {
                  result =  ((UMLType) value).getName();
               }
               return result;
            }
         });
      qualTypeLabel.addToUpdater (updater);

      updater = new VisibilityUpdater (qual, "externalQualifier");
      colon.addToUpdater (updater);
      updater = new VisibilityUpdater (qual, "externalQualifier");
      qualTypeLabel.addToUpdater (updater);

      Font tmpFont = FontContainer.getFont (FontContainer.DEFAULT_FONT, 0);
      qualLabel.setFont (tmpFont);

      qualLabel.getJComponent().setOpaque (false);
      // qualLabel.getJComponent().setBorder (new EmptyBorder (3, 3, 3, 3));
      SelectionListenerHelper.addSelectionListener (qualLabel.getJComponent(), ForegroundHighlighter.get());

      return qualPanel;
   }
}

/*
 * $Log: UMQualifier.java,v $
 * Revision 1.17.2.2  2006/06/07 08:42:01  lowende
 * Compile warnings removed.
 *
 */
