/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.unparse;

import java.awt.*;

import javax.swing.*;

import de.uni_paderborn.fujaba.fsa.*;
import de.uni_paderborn.fujaba.fsa.listener.*;
import de.uni_paderborn.fujaba.fsa.swing.*;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.fsa.update.*;
import de.uni_paderborn.fujaba.uml.UMLPath;



/**
 * This class displays path expressions.
 *
 * @author    $Author: trinet $
 * @version   $Revision: 1.3 $
 */

public class UMPath extends UMConnection
{

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param parent  No description provided
    * @param incr    No description provided
    * @return        No description provided
    */
   public FSAObject create (FSAObject parent, LogicUnparseInterface incr)
   {

      UMLPath path = (UMLPath) incr;

      //create line
      FSAPolyLine polyLine = (FSAPolyLine) super.create (parent, incr);
      polyLine.setTransientProperties (false);
      JBendLine bendLine = (JBendLine) polyLine.getJComponent();

      //display bendline as double line
      bendLine.setUI (DoubleLineUI.createUI (bendLine));

      SelectionListenerHelper.addSelectionListener (bendLine, SelectionPropagationListener.get (SelectionPropagationListener.CHILDREN));
      SelectionListenerHelper.addSelectionListener (bendLine, ForegroundHighlighter.get());
      SelectionListenerHelper.addSelectionListener (bendLine, LineBendHighlighter.get());
      AscendDescendMouseHandler.addMouseInputListener (bendLine, SelectionMouseListener.get());
      AscendDescendMouseHandler.addMouseInputListener (bendLine, DoubleClickMouseListener.get());

      FSABendLine line = polyLine;

      // create grab for source
      Container grabParent = bendLine.getParent();
      FSAGrab fsaGrab = new FSAGrab (incr, "entryGrab", (JComponent) grabParent);
      Translator translator = new LogicFsaTranslator (line, 1);
      AbstractUpdater updater = new LogicToFsaUpdater();
      updater.setTranslator (translator);
      updater.setLogicAttrName ("source");
      updater.setFsaAttrName ("target");
      updater.setLogicObject (path);
      fsaGrab.addToUpdater (updater);

      JGrab grab = (JGrab) fsaGrab.getJComponent();
      SelectionListenerHelper.addSelectionListener (grab, ForegroundHighlighter.get());
      AscendDescendMouseHandler.addMouseInputListener (grab, GrabMouseListener.get());
      bendLine.setStartBend (grab);

      // create grab for target
      fsaGrab = new FSAGrab (incr, "exitGrab", (JComponent) grabParent);
      updater = new LogicToFsaUpdater();
      updater.setTranslator (translator);
      updater.setLogicAttrName ("target");
      updater.setFsaAttrName ("target");
      updater.setLogicObject (path);
      fsaGrab.addToUpdater (updater);

      grab = (JGrab) fsaGrab.getJComponent();
      grab.setUI ((BendUI) ArrowGrabUI.createUI (grab));
       ((ArrowGrabUI) grab.getUI()).setArrow ((JArrowHead) UMArrowHead.PATH.clone());
      SelectionListenerHelper.addSelectionListener (grab, ForegroundHighlighter.get());
      AscendDescendMouseHandler.addMouseInputListener (grab, GrabMouseListener.get());
      bendLine.setEndBend (grab);

      FSAPanel textPanel = new FSAPanel (incr, "textPanel", bendLine);
      textPanel.setLayout (new FlowLayout (FlowLayout.LEFT, 0, 0));
      JComponent jTextPanel = textPanel.getJComponent();

      FSATextFieldLabel nametext = new FSATextFieldLabel (incr, "expression", jTextPanel);
      AbstractUpdater nameupdater = nametext.createDefaultUpdater();
      nametext.addToUpdater (nameupdater);
      nametext.addToUpdater (new VisibilityUpdater (incr, "expression"));
      nametext.setOpaque (false);

      if (bendLine.getLayout() instanceof LayoutManager2)
      {
          ((LayoutManager2) bendLine.getLayout()).addLayoutComponent (jTextPanel, new LineDecoratorConstraints (bendLine, 0.5, 8));
      }

      return line;
   }

}

/*
 * $Log: UMPath.java,v $
 * Revision 1.3  2004/11/20 15:55:07  trinet
 * added flag to avoid unnecessary saving of unparse information
 *
 */
