/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.unparse;

import de.uni_paderborn.fujaba.fsa.*;
import de.uni_paderborn.fujaba.fsa.swing.ColumnRowLayout;
import de.uni_paderborn.fujaba.fsa.swing.UMLTypeListComboBoxModel;
import de.uni_paderborn.fujaba.fsa.unparse.AbstractUnparseModule;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.fsa.update.TypeUpdater;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.23 $
 */
public class UMParam extends AbstractUnparseModule
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param parent  No description provided
    * @param incr    No description provided
    * @return        No description provided
    */
   public FSAObject create (FSAObject parent, LogicUnparseInterface incr)
   {
      FSAContainer container = (FSAContainer) parent;

      FSAPanel panel = new FSAPanel (incr, getMainFsaName(), container.getJComponent());
      panel.setLayout (new ColumnRowLayout (0, ColumnRowLayout.ROW));

      FSATextFieldLabel nameField = new FSATextFieldLabel (incr, "name", panel.getJComponent());
      nameField.addToUpdater (nameField.createDefaultUpdater());
      nameField.setBold (false);
      //nameField.setMouseReactable (false);

      FSALabel colonLabel = new FSALabel (incr, "colon", panel.getJComponent());
      colonLabel.setText (":");

      FSAComboBoxLabel typeLabel = new FSAComboBoxLabel (incr, "paramType", panel.getJComponent());
      typeLabel.setBold (false);
      typeLabel.setModel (UMLTypeListComboBoxModel.get());
      typeLabel.addToUpdater (typeLabel.createDefaultUpdater());
      typeLabel.addToUpdater (new TypeUpdater (incr, "paramType", typeLabel.getDefaultAttrName()));
      //typeLabel.setMouseReactable (false);

      panel.setOpaque (false);
      return panel;
   }
}

/*
 * $Log: UMParam.java,v $
 * Revision 1.23  2004/11/03 11:48:00  lowende
 * Javadoc warnings removed.
 *
 */
