/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.unparse;

import java.awt.*;

import javax.swing.*;

import de.uni_paderborn.fujaba.basic.FontContainer;
import de.uni_paderborn.fujaba.fsa.*;
import de.uni_paderborn.fujaba.fsa.listener.*;
import de.uni_paderborn.fujaba.fsa.swing.*;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.fsa.unparse.UnparseManager;
import de.uni_paderborn.fujaba.fsa.update.*;
import de.uni_paderborn.fujaba.preferences.ColorsPreferences;
import de.uni_paderborn.fujaba.uml.UMLLink;
import de.uni_paderborn.fujaba.uml.UMLMultiLink;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: trinet $
 * @version   $Revision: 1.19 $
 */
public class UMMultiLink extends UMConnection
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static Color multiLinkColor = ColorsPreferences.get().MULTILINK;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param parent  No description provided
    * @param incr    No description provided
    * @return        No description provided
    */
   public FSAObject create (FSAObject parent, LogicUnparseInterface incr)
   {
      UMLMultiLink mLink = (UMLMultiLink) incr;
      FSAContainer container = (FSAContainer) parent;
      container.setTransientProperties (false);

      //UMLMultiLink.FIRST then getSourceLink == null
      //UMLMultiLink.LAST then getTargetLink == null
      UMLLink sourceLink = mLink.getSourceLink();
      UMLLink targetLink = mLink.getTargetLink();

      if ( (mLink.getType() != UMLMultiLink.FIRST) &&
          (mLink.getType() != UMLMultiLink.LAST))
      {
         FSABendLine line = (FSAPolyLine) super.create (parent, incr);
         line.setTransientProperties (false);
         JBendLine bendLine = (JBendLine) line.getJComponent();
         bendLine.setForeground (multiLinkColor);

         Translator translator = new LogicFsaTranslator (line, 1);

         FSAObject sourceFsa = UnparseManager.get().unparse (sourceLink, container);
         FSAObject targetFsa = UnparseManager.get().unparse (targetLink, container);

         JBendLineGrabLayouter.get().registerLayouterWithJComponent (sourceFsa.getJComponent());
         JBendLineGrabLayouter.get().registerLayouterWithJComponent (targetFsa.getJComponent());

         JGrab grab = new JGrab (sourceFsa.getJComponent());
         SelectionListenerHelper.addSelectionListener (grab, ForegroundHighlighter.get());
         AscendDescendMouseHandler.addMouseInputListener (grab, GrabMouseListener.get());

         Container grabParent = null;
         if (sourceFsa.getJComponent().getParent() != null)
         {
            grabParent = sourceFsa.getJComponent().getParent();
         }
         else if (bendLine.getParent() != null)
         {
            grabParent = bendLine.getParent();
         }
         grabParent.add (grab);
         new FSAGrab (incr, "entryGrab", (JComponent) grabParent, grab);
         bendLine.setStartBend (grab);

         grab = new JGrab (targetFsa.getJComponent());
         SelectionListenerHelper.addSelectionListener (grab, ForegroundHighlighter.get());
         AscendDescendMouseHandler.addMouseInputListener (grab, GrabMouseListener.get());
         if (targetFsa.getJComponent().getParent() != null)
         {
            grabParent = targetFsa.getJComponent().getParent();
         }
         else if (bendLine.getParent() != null)
         {
            grabParent = bendLine.getParent();
         }
         grabParent.add (grab);
         new FSAGrab (incr, "exitGrab", (JComponent) grabParent, grab);
         bendLine.setEndBend (grab);

         FSAPanel textPanel = new FSAPanel (incr, "textPanel", bendLine);
         textPanel.setLayout (new FlowLayout (FlowLayout.LEFT, 0, 0));
         JComponent jTextPanel = textPanel.getJComponent();

         //for some strange reason, this is VERY necessary
         textPanel.addToComponents (new JLabel (" "));

         FSATextFieldLabel nametext = new FSATextFieldLabel (incr, "name", jTextPanel);
         AbstractUpdater nameupdater = nametext.createDefaultUpdater();
         nametext.addToUpdater (nameupdater);
         nametext.addToUpdater (new VisibilityUpdater (incr, "name"));
         nametext.setOpaque (false);

         JTextFieldLabel namefield = (JTextFieldLabel) nametext.getJComponent();
         namefield.setEditing (false);
         namefield.setFont (FontContainer.getFont (FontContainer.DEFAULT_FONT, -1));
         namefield.setForeground (multiLinkColor);

         if (bendLine.getLayout() instanceof LayoutManager2)
         {
             ((LayoutManager2) bendLine.getLayout()).addLayoutComponent (jTextPanel, new LineDecoratorConstraints (bendLine, 0.5, 8));
         }

         FSADirectionIndicator arrow = new FSADirectionIndicator (mLink, "arrow", jTextPanel);
         JDirectionIndicator jArrow = (JDirectionIndicator) arrow.getJComponent();
         jArrow.setForeground (multiLinkColor);

         AbstractUpdater updater = new LogicToFsaUpdater();
         updater.setTranslator (translator);
         updater.setLogicAttrName ("targetObject");
         updater.setFsaAttrName ("target");
         updater.setLogicObject (mLink);
         arrow.addToUpdater (updater);

         updater = new LogicToFsaUpdater();
         updater.setTranslator (translator);
         updater.setLogicAttrName ("sourceObject");
         updater.setFsaAttrName ("source");
         updater.setLogicObject (mLink);
         arrow.addToUpdater (updater);

         return line;
      }
      else
      {
         FSAPanel mLinkPanel = new FSAPanel (incr, getMainFsaName(), null);
         mLinkPanel.setLayout (new FlowLayout (FlowLayout.LEFT, 0, 0));
         return mLinkPanel;
      }
   }

}

/*
 * $Log: UMMultiLink.java,v $
 * Revision 1.19  2004/11/20 15:55:07  trinet
 * added flag to avoid unnecessary saving of unparse information
 *
 */
